//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+   
//#+     Mumps Compiler 
//#+     Copyright (C) 2000 by Kevin C. O'Kane  
//#+
//#+     Kevin C. O'Kane
//#+     Department of Computer Science
//#+     University of Northern Iowa
//#+     Cedar Falls, IA 50613-0507 USA
//#+
//#+     okane@cs.uni.edu
//#+     anamfianna@earthlink.net
//#+     http://www.cs.uni.edu/~okane
//#+
//#+
//#+ This program is free software; you can redistribute it and/or modify
//#+ it under the terms of the GNU General Public License as published by
//#+ the Free Software Foundation; either version 2 of the License, or
//#+ (at your option) any later version.
//#+ 
//#+ This program is distributed in the hope that it will be useful,
//#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
//#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//#+ GNU General Public License for more details.
//#+ 
//#+ You should have received a copy of the GNU General Public License
//#+ along with this program; if not, write to the Free Software
//#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ This software is covered by the GPL - Not the LGPL.
//#+
//#+ A consequence of this is that if this code is incorporated
//#+ into another work, it causes that work to become covered by
//#+ the GNU GPL license. 
//#+
//#+ Contact the author for other licensing arrangements.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+    Some of this code was originally written in Fortran
//#+    which will explain the odd array and label usage,
//#+    especially arrays beginning at index 1.
//#+
//#+    This was originally an interpreter.  It has been hacked
//#+    to be a compiler.  Some of the structure will, therefore,
//#+    seem strange.
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include "memsize.h"

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#if OS2==1
#include <os2.h>
#endif

#if UNIX==0
#include <string.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <time.h>
#include <bios.h>
#include <stdlib.h>
#include <dos.h>
#endif

#if UNIX==1
#include <sys/stat.h>
#endif

#define SymCheck if (ExecSym[ExecX]) { fprintf(Out,"\t_SymFree(1); // Remove symbol table layer\n"); ExecSym[ExecX]=0; }
#define Sysout(x) fprintf(Out,x)
#define Sysout_skip fprintf(Out,"\n")
#define SWAP 30
#define STORE 1
#define RETRIEVE 0
#define NEXT 2
#define XNEXT 8
#define GKILL 3
#define INIT 6
#define GOPEN 7
#define EMPTY 5
#define GCLOSE 4

#define JOB 'j'
#define SET 's'
#define GOTO 'g'
#define WRITE 'w'
#define IF 'i'
#define NEW 'n'
#define NEW1 'N'
#define OPEN 'o'
#define ZCMDS 'z'
#define READ 'r'
#define QUIT 'q'
#define XECUTE 'x'
#define TAB 9
#define FOR 'f'
#define HALT 'h'
#define ELSE 'e'
#define DO 'd'
#define KILL 'k'
#define CLOSE 'c'
#define CONTINUE 'b'
#define USE 'u'
#define LOCK 'l'
#define CMMNT ';'
#define BREAK 'b'
#define HTML '<'
#define KILL2 20
#define FCN 'D'
#define LBL 21
#define CLSQ '}'
#define OPSQ '{'

	short setpiece;
	unsigned char setname[64];
	short zerr;
	unsigned char bd[2048];
	short int tpx;
	short t2;
	short pd1len;
	short iorg;
	short xpx;
	short t0px;
	short ierr;
	short symlen;
	short symadr;
	char *symaddr;
	short sdlim;
	unsigned char symflg;
	unsigned char pd1[PS1];
	unsigned char xd[2048];
	unsigned char v1d[2048];
	short int ctrlc;
	int gpad;
	short ierr1;
	int kflg;
	int Tab;
	int mflag;
	struct nmes *nstart;
	short Jflg;
	FILE *cf;
	short Do;

struct nmes {
  char *name;
  struct nmes *next;
  };

int xindex (unsigned char *, unsigned char *, short);
void errmod_ (short msgnbr, unsigned char text[], FILE * opnfile[]);
int readf_ (unsigned char zd[], short pd1org);
void inout (unsigned char text[], short cmnd, unsigned char col[]);
int pindex (unsigned char source[], unsigned char ptrn[], short strt);
void add (char *a, char *b, char *c);
int numcomp (char aa[], char bb[]);
void cannon (char a[]);
void linepad (int, char *);
void fcninit ();
void epi ();
int getstr1 (FILE *, char[]);

FILE *Out;
short ExitCode = 0;
short MaxTmp = 15;

#if WEB==0

int main (int argc, char *argv[]) {

#else

int main () {
  char *argv[2] = { "xxx", "test.file" };
  int argc = 2;

#endif

  extern int errno;
  long int ilong, jlong;
  short pd1cur, i, j, k;
  short lines = 0, l, parse_ ();

  static short cmdx, forx, pd1Last, MAIN_flg = 0, POST_flg = 0;
  static short FCN_flg = 0, IF_flg = 0, HTML_flg = 0;
  static short GBL_flg = 0;
  static short ExecLevel = 0;
  static short ExecName = 0;
  static short ExecStack[25];
  static short ExecSym[25] = { 0 };
  static short ExecX = 0;
  static short CX;
  static short JOB_flg = 0;
  static short at_flg = 0, Set_flg = 0;
  int F_flg = 0;

  static char opnflg[6] = { 0, 0, 0, 0, 0, 0 }; //0: not open; 1: input; 2: output 
  FILE *opnfile[7];
  static unsigned char forv[20][256];
  int FOR_limit;
  static unsigned char dosave[64];
  char cur_line[512];

//#+++++++++++++++++++++
//#+ cod208=208 comma 
//#+ cod207=207 close 
//#+ cod209=209 comma
//#+ cod210=210 colon
//#+ cod206=206 open 
//#+++++++++++++++++++++

  static short retz, icmnd, p2px, ernbr;
  static unsigned char tmp2[1024], tmp3[1024], dirflg, vd[1024];
  static int pl;

  symlen = PS;

#if WEB==1
  if (readfile () == 1) return 0;
  printf ("<xmp>\n");
#endif

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#*
//#* Disclaimer to Console
//#*
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  printf ("\nMumps Compiler Release ");
  printf (RELEASE);
  printf ("\n");
  printf ("Copyright (c) 2000 by Kevin C. O'Kane, All Rights Reserved\n\n");
  printf ("IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,\n");
  printf ("INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING\n");
  printf ("LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS\n");
  printf ("DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE\n");
  printf ("POSSIBILITY OF SUCH DAMAGE.\n");
  printf ("\n");
  printf ("THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,\n");
  printf ("BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY\n");
  printf ("AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER\n");
  printf ("IS ON AN \"AS IS\" BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO\n");
  printf ("PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.\n");
  printf ("\n");

  if (argc == 1) {
      printf ("*** \a Name of program to compile must be given\n\n");
      ExitCode = 99;
      goto abrtx;
      }

  else {
      for (i = 0; argv[1][i] != 0 && argv[1][i] != '.'; i++) tmp2[i] = argv[1][i];

      if (tmp2[i] != '.') {
	  tmp2[i] = '.';
	  tmp2[i + 1] = 'c';
	  tmp2[i + 2] = 0;
	  }

#if WEB==0
      Out = fopen (tmp2, "w");
#else
      Out = stdout;
#endif

      if (readf_ (argv[1], 1) == 0) {
	  printf ("*** \a File %s not found.\n\n", argv[1]);
	  ExitCode = 99;
	  goto abrtx;
	  }
      printf ("Compiling %s\n", argv[1]);
      }

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#*
//#* Copyright and Disclaimer to Output File
//#*
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  Sysout ("// ==============================================================\n");
  ilong = time (&ilong);
  Sysout ("// This module generated by Mumps Compiler ");
  Sysout (RELEASE);
  Sysout ("\n");
  Sysout ("// This code is unverified - use at your own risk \n");
  Sysout ("// Portions of this code are Copyright (c) MM by\n");
  Sysout ("// Kevin C. O'Kane, All Rights Reserved.\n\n");
  Sysout ("// IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT,\n");
  Sysout ("// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING\n");
  Sysout ("// LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS\n");
  Sysout ("// DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE\n");
  Sysout ("// POSSIBILITY OF SUCH DAMAGE.\n");
  Sysout ("\n");
  Sysout ("// THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,\n");
  Sysout ("// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY\n");
  Sysout ("// AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER\n");
  Sysout ("// IS ON AN \"AS IS\" BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO\n");
  Sysout ("// PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.\n");
  Sysout ("\n");
  Sysout ("// ==============================================================\n");

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#*
//#* Include, Defines and Global Defs to Output File
//#*
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  Sysout ("#include <stdio.h>\n");
  Sysout ("#include <string.h>\n");
  Sysout ("#include <stdlib.h>\n");
  Sysout ("#include <unistd.h>\n");
  Sysout ("#include <setjmp.h>\n\n");
  linepad (Sysout ("#define STRING_SIZE 256"), "Max internal string length");
  linepad (Sysout ("#define SYM_MAX 100"), "Max Symbol Table Depth");
  Sysout ("#define STORE 1\n");
  Sysout ("#define RETRIEVE 0\n");
  Sysout ("#define NEXT 2\n");
  Sysout ("#define XNEXT 8\n");
  Sysout ("#define GKILL 3\n");
  Sysout ("#define INIT 6\n");
  Sysout ("#define GOPEN 7\n");
  Sysout ("#define EMPTY 5\n");
  Sysout ("#define GCLOSE 4\n\n");
  Sysout_skip;

  linepad ( Sysout("#ifndef SUB"), "Not a sub-function");
  Sysout_skip;

  linepad (Sysout ("char cfgdata[256];"), "Global array data file");
  linepad (Sysout ("char cfgkey[256];"), "Global array key file");
  linepad (Sysout ("long g;"), "Global array parameter");
  linepad (Sysout ("long io=5;"), "Current IO unit");
  linepad (Sysout ("long tpx=0;"), "$T value");

  Sysout_skip;
  linepad (Sysout ("FILE *in_file[10]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};"),
	   "File pointers");
  linepad (Sysout ("FILE *out_file[10]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};"),
	   "File pointers");

  Sysout_skip;
  linepad (Sysout ("int hor[10]={0,0,0,0,0,0,0,0,0,0};"), "Horizontal pointers");
  linepad (Sysout ("int ver[10]={1,1,1,1,1,1,1,1,1,1};"), "Vertical pointers");

  linepad (Sysout ("int _Sym=0;"), "symbol table");
  linepad (Sysout ("int LineNumber=0;"), "line number flag");
  linepad (Sysout ("jmp_buf _doStack[100];"), "DO-return stack");
  linepad (Sysout ("short   _doStackN[100]={0};"), "DO-New stack");
  linepad (Sysout ("int _doStx=0;"), "DO-return stack top");
  linepad (Sysout ("int gpad=0;"), "btree cannonical number flag");

  Sysout_skip;
  linepad (Sysout ("#else"), "Sub-function");
  Sysout_skip;
  linepad (fprintf (Out, "extern char cfgdata[256];"), "Global array data file");
  linepad (fprintf (Out, "extern char cfgkey[256];"), "Global array key file");
  Sysout_skip;
  linepad (fprintf (Out, "extern long g;"), "Global array parameter");
  linepad (fprintf (Out, "extern long io;"), "Current IO unit");
  linepad (fprintf (Out, "extern long tpx;"), "$T value");
  Sysout_skip;
  linepad (fprintf (Out, "extern FILE *in_file[10];"), "File pointers");
  linepad (fprintf (Out, "extern FILE *out_file[10];"), "File pointers");
  Sysout_skip;
  linepad (fprintf (Out, "extern int hor[10];"), "Horizontal pointers");
  linepad (fprintf (Out, "extern int ver[10];"), "Vertical pointers");
  Sysout_skip;
  linepad (fprintf (Out, "extern int _Sym;"), "symbol table");
  linepad (fprintf (Out, "extern int LineNumber;"), "line number flag");
  linepad (fprintf (Out, "extern jmp_buf _doStack[100];"), "DO-return stack");
  linepad (fprintf (Out, "extern short   _doStackN[100];"), "DO-New stack");
  linepad (fprintf (Out, "extern int _doStx;"), "DO-return stack top");
  linepad (fprintf (Out, "extern int gpad;"), "btree cannonical number flag");
  Sysout ("#endif\n");
  Sysout_skip;

  linepad (fprintf (Out, "void zfcn(unsigned char *, unsigned char *);"),
	   "Z function handler");
  linepad (fprintf
	   (Out, "char * sym_(int, unsigned char *, unsigned char *);"),
	   "symbol table");
  linepad (fprintf (Out, "void add(char *a,char *b,char *c);"),
	   "add strings");
  linepad (fprintf (Out, "void sub(char *a,char *b,char *c);"),
	   "subtract strings");
  linepad (fprintf (Out, "void mult(char *a,char *b,char *c);"),
	   "multiply strings");
  linepad (fprintf (Out, "void divx(char *a,char *b,char *c);"),
	   "divide strings");
  linepad (fprintf
	   (Out,
	    "void _fnumber(unsigned char *,unsigned char *,unsigned char *,unsigned char *);"),
	   "format number");

  Sysout_skip;

  linepad (fprintf (Out, "int global(short g, unsigned char key[],unsigned char bd[]);"),
	   "Global handler");

  linepad (0, "g = command");
  linepad (0, "key = key sought or stored");
  linepad (0, "bd = value returned or stored");

  Sysout ("\n");
  Sysout ("\n");
  Sysout ("#ifndef SUB\n");
  linepad (fprintf (Out, "#include \"fcns.h\""), "System support functions");
  Sysout ("#endif\n");
  Sysout ("\n");

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+*+++++++++ Compiler Start ++++++++++++++++++++++++++++++++++++++++++
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

pd1cur = 1;
pd1[pd1len + 1] = 0;
symlen = PS;
Tab = 0;
t0px = 0;
t2 = 0;
kflg = 0;
cmdx = 0;
setpiece = 0;
forx = 0;
kflg = 0;
pd1Last = 0;
Do = 0;
ExecLevel = 0;

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+*++++++++++ Next Line ++++++++++++++++++++++++++++++++++++++++++++++
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

next_line:

  lines++;
  while (IF_flg) {
      fprintf (Out, "\t}\n");
      IF_flg--;
      }

  if (pd1cur > pd1len) {
      if (ExecLevel > 0) {
	  for (; ExecLevel > 0; ExecLevel--) {
	      fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
	      fprintf (Out, "\tgoto _labz%d; ;// return \n", ExecStack[--ExecX]);
	      fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
	      }
	  ExecLevel = 0;
	  }
      goto abrtx;
      }

  if (pd1[pd1cur] == 0) {
      fprintf (Out, "\n");
      pd1cur++;
      goto next_line;
      }

  strcpy (cur_line, &pd1[pd1cur]);

  if (pd1[pd1cur] == '%') {                     //* inline C code 
      fprintf (Out, "%s\n", &pd1[pd1cur + 1]);
      while (pd1[pd1cur]) pd1cur++;             //* advance to line end
      pd1cur++;
      goto next_line;
      }

  if (pd1[pd1cur] == '#') {                     //* comment

      fprintf (Out, "// %s\n", &pd1[pd1cur + 1]);
      pd1cur++;
      while (pd1[pd1cur]) pd1cur++;
      pd1cur++;
      goto next_line;
      }

  i = pd1cur;
  while (pd1[pd1cur] && pd1[pd1cur] != TAB) pd1cur++;

  if (pd1[pd1cur] == 0) {  // has no TAB
      pd1cur = i;

#if SHOW_CODE==1
      fprintf (Out, "//%4d ===> %s\n", lines, &pd1[pd1cur]);
#endif

      fprintf (Out, "\tprintf(\"");

      while (pd1[pd1cur]) {

	  HTML_flg = 1;

	  if (pd1[pd1cur] == '&' && pd1[pd1cur + 1] == '~') {
	      pd1cur += 2;
	      for (i = 1; pd1[pd1cur] != '~' && pd1[pd1cur] != 0; i++)
		xd[i] = pd1[pd1cur++];
	      xd[i] = 0;
	      if (pd1[pd1cur] == '~') pd1cur++;
	      fprintf (Out, "\");\n");
	      t2 = 1;
	      xpx = 1;
	      if ((ierr = parse_ ())) goto parse_err;
	      fprintf (Out, "\tprintf(\"%%s\",%s);\n", &pd1[sdlim]);
	      fprintf (Out, "\tprintf(\"");
	      continue;
	      }

	  if (pd1[pd1cur] == '&' && pd1[pd1cur + 1] == '!') {
	      pd1cur += 2;
	      fprintf (Out, "\\n");
	      continue;
	      }

	  if (pd1[pd1cur] == '\"') fprintf (Out, "\\\"");
	  else if (pd1[pd1cur] == '\'') fprintf (Out, "\\\'");
	  else if (pd1[pd1cur] == '%') fprintf (Out, "%%%%");
	  else if (pd1[pd1cur] == '\\') fprintf (Out, "\\");
	  else fprintf (Out, "%c", pd1[pd1cur]);
	  pd1cur++;
	  }

      fprintf (Out, "\");\n");
      pd1cur++;
      goto next_line;
      }

//**************
// multiple TABs
//**************

  pd1cur = i;

  if (pd1[pd1cur] != TAB) {
      for (; pd1[pd1cur] != TAB && pd1[pd1cur] != 0; pd1cur++);
      pd1[pd1cur] = 0;

      {

	int flg = 1;
	int ii, j, k, kk = 0, n = 0;

	if (pd1[i] == '^') {
	    i++;
	    F_flg = 1;
	    if (MAIN_flg || FCN_flg) {
		epi ();
		MAIN_flg = 0;
	      }
	    FCN_flg = 1;
	    }

	ii = i;
	for (; pd1[i] != 0; i++) {
	    if (pd1[i] == '(') {

		if (flg) {
		    Sysout ( "//=================================================================================\n");
		    fprintf ( Out,  "// Entry Point %s\n", &pd1[ii]);
		    Sysout ( "//=================================================================================\n\n");
		    flg = 0;
		    }

		pd1[i] = 0;
		if (F_flg) {
                int ff=0;
		    fprintf (Out, "char * %s(", &pd1[ii]);
		    for (j = i + 1; pd1[j] != 0; j++) { // separately compiled extrinsic 
                  if (isalpha(pd1[j])) ff=1;
			if ( (pd1[j] == ',' || pd1[j] == ')') && ff ) {
			    fprintf (Out, "char * Arg%d%c", kk, pd1[j]);
			    kk++;
			    }
			if (pd1[j] == ')') {
                      if (!ff) fprintf(Out,") ");
			    fprintf (Out, "{\n\n");
			    fcninit ();
			    break;
			    }
		      }
		  }

		else fprintf (Out, "%s:\n", &pd1[ii]);

		fprintf (Out, "\t_Sym++; // push symbol table\n");
            fprintf (Out, "\t_doStackN[_doStx-1]=1;   //* flag to restore namespace\n");
		pd1[i] = '(';
		for (j = i + 1; pd1[j] != 0; j++) {
		    if (pd1[j] == ',' || pd1[j] == ')') {
			k = pd1[j];
			pd1[j] = 0;
			if (strlen(&pd1[i+1])==0) break;

			if (F_flg) fprintf (Out,
				   "\tif (Arg%d!=NULL) sym_(0,\"%s\",Arg%d); // Store Arguments\n",
				   n, &pd1[i + 1], n);

			else fprintf (Out,
				   "\tif (_Arg%d!=NULL) sym_(0,\"%s\",_Arg%d); // Store Arguments\n",
				   n, &pd1[i + 1], n);

			n++;
			pd1[j] = k;
			if (k == ')') break;
			i = j;
		      }
		  }
	      }
	  }

	if (!flg && !F_flg)
	  fprintf (Out, "\tif (_ArgCount<%d) {\n"
		   "\t\tprintf(\"***** Error - argument count in or near line %%d\\n\",LineNumber);\n"
		   "\t\tgoto _epilogue;}\n", n);

	if (flg) {
         int i;
         for (i=ii; pd1[i]!=0; i++) 
            if (pd1[i]!=' ') {
                fprintf (Out, "%s:\n\n", &pd1[ii]);
                break;
                }
            }

	pd1[pd1cur] = TAB;
      }
    }

  while (pd1[pd1cur] == TAB) pd1cur++;

//------------------------------------------------------------------------
//  Doty Indents
//------------------------------------------------------------------------

  if (pd1[pd1cur] == '.') {

      j = 0;
      for (i = pd1cur; pd1[i] == '.'; i++) j++;

      if (j>5) {
            printf("*** Too many block indents\n");
            ernbr=99;
            goto abrt1;
            }

      if (j > ExecLevel + 1) {  // skipped a level
	  printf ("*** Code level skip\n");
	  ernbr = 99;
	  goto abrt1;
	  }

      if (j == 1) {
	  if (ExecLevel == 0) {
	      fprintf (Out, "\n\tgoto _lab%d; // by pass indented group\n", ExecName);
	      fprintf (Out, "\n_labx%d: // entry point \n", ExecName);
	      ExecStack[ExecX++] = ExecName++;
	      fprintf (Out, "\n\tswitch (1) { case 1: // dotted indent \n");
	      ExecLevel = 1;
	      }

	  else if (ExecLevel > 1) {
	      for (; ExecLevel > 1; ExecLevel--) {
		  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
		  SymCheck
              fprintf (Out, "\tgoto _labz%d; // return \n", ExecStack[--ExecX]);
		  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
		  }
	      ExecLevel = 1;
	      }
	  pd1cur = i;
	  }

      else if (j == 2) {
	  if (ExecLevel == 1) {	// indenting
	      fprintf (Out, "\n\tgoto _lab%d; // by pass indented group\n", ExecName);
	      fprintf (Out, "\n_labx%d: // entry point \n", ExecName);
	      ExecStack[ExecX++] = ExecName++;
	      fprintf (Out, "\n\t switch (2) { case 2: // dotted indent \n");
	      ExecLevel = 2;
	      }

	  else if (ExecLevel > 2) { // un-indenting
	      for (; ExecLevel > 2; ExecLevel--) {
		  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
		  SymCheck
              fprintf (Out, "\tgoto _labz%d; // return \n",
			     ExecStack[--ExecX]);
		  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
		  }
	      ExecLevel = 2;
	    }
	  pd1cur = i;
	}

      else if (j == 3) {
	  if (ExecLevel == 2) {
	      fprintf (Out, "\n\tgoto _lab%d; // by pass indented group\n", ExecName);
	      fprintf (Out, "\n_labx%d: // entry point \n", ExecName);
	      ExecStack[ExecX++] = ExecName++;
	      fprintf (Out, "\n\t switch (3) { case 3: // dotted indent \n");
	      ExecLevel = 3;
	      }

	  else if (ExecLevel > 3) {
	      for (; ExecLevel > 3; ExecLevel--) {
		  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
		  SymCheck
              fprintf (Out, "\tgoto _labz%d; // return \n", ExecStack[--ExecX]);
		  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
		  }
	      ExecLevel = 3;
	      }
	  pd1cur = i;
        }

      else if (j == 4) {
	  if (ExecLevel == 3) {
	      fprintf (Out, "\n\tgoto _lab%d; // by pass indented group\n", ExecName);
	      fprintf (Out, "\n_labx%d: // entry point \n", ExecName);
	      ExecStack[ExecX++] = ExecName++;
	      fprintf (Out, "\n\t switch (4) { case 4: // dotted indent \n");
	      ExecLevel = 4;
	      }

	  else if (ExecLevel > 4) {
	      for (; ExecLevel > 4; ExecLevel--) {
		  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
		  SymCheck
              fprintf (Out, "\tgoto _labz%d; // return \n", ExecStack[--ExecX]);
		  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
		  }
	      ExecLevel = 4;
	      }
	  pd1cur = i;
        }

      else if (j == 5) {
	  if (ExecLevel == 4) {
	      fprintf (Out, "\n\tgoto _lab%d; // by pass indented group\n", ExecName);
	      fprintf (Out, "\n_labx%d: // entry point \n", ExecName);
	      ExecStack[ExecX++] = ExecName++;
	      fprintf (Out, "\n\t switch (5) { case 5: // dotted indent \n");
	      ExecLevel = 5;
	      }

	  else if (ExecLevel > 5) {
	      for (; ExecLevel > 5; ExecLevel--) {
		  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
		  SymCheck
              fprintf (Out, "\tgoto _labz%d; // return \n", ExecStack[--ExecX]);
		  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
		  }
	      ExecLevel = 5;
            }
	  pd1cur = i;
        }
    }

  else if (ExecLevel > 0) {
      for (; ExecLevel > 0; ExecLevel--) {
	  fprintf (Out, "\n\t} // dotted un-indent %d\n", ExecX - 1);
	  SymCheck
        fprintf (Out, "\tgoto _labz%d; // return \n", ExecStack[--ExecX]);
	  fprintf (Out, "\n_lab%d: \n", ExecStack[ExecX]);
	  }
      ExecLevel = 0;
      }

  if (ExecLevel == 0) forx = 0;


//------------------------------------------------------------------------

  xpx = j = 1;

//************************
// copy source line to xd
//************************

  pd1Last = pd1cur;

  while ((xd[j++] = pd1[pd1cur++]) != 0);

  Sysout ("//=================================================================================\n");

  if (MAIN_flg || FCN_flg) fprintf(Out, "LineNumber=%d;  // %s\n", lines, cur_line);

  else fprintf(Out,"// %s\n", cur_line);

  Sysout ("//=================================================================================\n");

  xd[j] = 0;

next_cmnd:  // continue line entry point 

  fprintf (Out, "\n");

  while (1) {
      if (xd[xpx] == 0 || xpx >= 1024) {
            if (IF_flg) {
                  for (i = 0; i < IF_flg; i++) fprintf (Out, "\t}\n");
                  IF_flg = 0;
                  }
            goto next_line;
            }

      if (xd[xpx] != ' ' && xd[xpx] != '\t')
	break;
      xpx++;
      }

//#++++++++++++++++++++++++
//#++++ decode command word 
//#++++++++++++++++++++++++

  p2px = xpx;
  t2 = t0px = 0;
  JOB_flg = 0;
  POST_flg = 0;
  icmnd = tolower (xd[xpx]);
  while (isalpha (xd[++xpx]));	//* scan thru rest of word

  if (xd[xpx] == ':') { // post conditionals 
      xpx++;
      if ((ierr = parse_ ())) goto parse_err;
      fprintf(Out, "\tif (atoi(%s)) { /* postconditional */\n", &pd1[sdlim]);
      POST_flg = 1;
      }


//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+ branch to correct command handler
//#+
//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

pstrtn:

  if (xd[xpx]) xpx++;

  switch (icmnd) {

case CLSQ:

      Sysout ( "\t} /* user close */\n");
      goto next_cmnd;

case OPSQ:

      goto next_cmnd;

case CMMNT:

      goto next_line;

case FCN:

      printf ("*** Not supported\n");
      printf ("*** %s\n", cur_line);
	ExitCode=99;
      goto abrtx;

case NEW:

      if (xd[xpx]==' '||xd[xpx]==0) { //* no argument form
            Sysout ( "\t_Sym++; // new symbol table\n");
            Sysout ( "\tif (_Sym>SYM_MAX) {\n");
            fprintf (Out, "\t\tprintf(\"*** Symbol Table Overflow in or near line %%d\\n\\n\",LineNumber);\n");
            fprintf (Out, "\t\tgoto _epilogue;\n");
            fprintf (Out, "\t\t}\n");
            ExecSym[ExecX] = 1;
            if (ExecX==0) fprintf(Out,"\t_doStackN[_doStx-1]=1;\n");
            if (POST_flg) {
	            fprintf (Out, "\t} /* post conditional */\n");
	            POST_flg = 0;
	            }
            xpx++;
            goto next_cmnd;
            }

//#++++++++++++++++++++++++++++++++
//#+    Push  all locals except... 
//#++++++++++++++++++++++++++++++++

      if (xd[xpx] == '(') {               //* specific 

            fprintf (Out, "\t{\n\tstruct nmes *p1,*p2;\n");
	      fprintf (Out, "\tnstart=NULL;\n");
	      xpx++;

new2:

            t0px = 1;
	      t2 = 1;
	      retz = NEW;
	      goto set;

new_return:

	      if (strcmp (vd, "atmp") == 0) fprintf (Out, "\tkeyfix(atmp);\n");
      
	      else {
                  char tmp[256];
                  strcpy (tmp, "\"");
                  strcat (tmp, vd);
                  strcat (tmp, "\"");
                  strcpy (vd, tmp);
                  }

            fprintf (Out, "\tp1=(struct nmes *) malloc(sizeof (struct nmes));\n");
            fprintf (Out, "\tif (p1==NULL) { printf(\"*** Out of memory\\n\"); goto _epilogue; }\n");
            fprintf (Out, "\tp1->name=(char *) malloc(strlen(atmp+1));\n");
            fprintf (Out, "\tif (p1->name==NULL) { printf(\"*** Out of memory\\n\"); goto _epilogue;}\n");
            fprintf (Out, "\tstrcpy(p1->name,%s);\n", vd);
            fprintf (Out, "\tp1->next=nstart;\n");
            fprintf (Out, "\tnstart=p1;\n");
      	xpx++;

	      if (xd[xpx] != ')' && xd[xpx]) {
	            xpx++;
	            goto new2;
	            }

            fprintf (Out, "\tsym_(7,\"\",\"\"); // new except (...) \n");
            fprintf (Out, "\t}\n");
            ExecSym[ExecX] = 1;
            if (ExecX==0) fprintf(Out,"\t_doStackN[_doStx-1]=1;\n");

            if (POST_flg) {
                  fprintf (Out, "\t} /* post conditional */\n");
                  POST_flg = 0;
                  }

            xpx++;
            goto next_cmnd;
            }

//#++++++++++++++++++++++++++++++++
//#+    Push locals inclusive  
//#++++++++++++++++++++++++++++++++


      fprintf (Out, "\tsym_(8,\"\",\"\"); // new inclusive \n");
      ExecSym[ExecX] = 1;
      if (ExecX==0) fprintf(Out,"\t_doStackN[_doStx-1]=1;\n");

      if (POST_flg) {
            fprintf (Out, "\t} /* post conditional */\n");
            POST_flg = 0;
            }

new3:

            t0px = 1;
	      t2 = 1;
	      retz = NEW1;
	      goto set;

new1_return:

	      if (strcmp (vd, "atmp") == 0) fprintf (Out, "\tkeyfix(atmp);\n");
      
	      else {
                  char tmp[256];
                  strcpy (tmp, "\"");
                  strcat (tmp, vd);
                  strcat (tmp, "\"");
                  strcpy (vd, tmp);
                  }

            fprintf (Out, "\tsym_(0,%s,\"\");   // create new variable at this level\n", vd);
            fprintf (Out, "\tsym_(9,%s,\"\");   // set copy flag to zero\n", vd);
      	xpx++;

	      if (xd[xpx] != ')' && xd[xpx]) {
	            xpx++;
	            goto new3;
	            }

      for( ; xd[xpx]!=' ' && xd[xpx]!=0; xpx++);
      goto next_cmnd;


case BREAK:

      fprintf (Out, "\tgoto _lab%d; // break\n", ExecStack[ExecX - 1]);
      if (POST_flg) {
            fprintf (Out, "\t} /* post conditional */\n");
            POST_flg = 0;
            }
      goto next_line;

case LOCK:

      printf ("*** Lock not supported\n");
      printf ("*** %s\n", cur_line);
	ExitCode=99;
      goto abrtx;

case READ:

      fprintf (Out, "\tif (in_file[io]==NULL) {\n");
        fprintf (Out,
          "\t\tprintf(\"\\n*** Read from input file in or near line %%d\\n\\n\",LineNumber);\n");
        fprintf (Out, "\t\tgoto _epilogue;\n");
        fprintf (Out, "\t\t}\n");

      while (1) {

	  dirflg = 0;

	  if (xd[xpx] == '!' || xd[xpx] == '#') { // carriage control 
	      if (xd[xpx] != '#') i = 2;
	      else i = 1;
	      inout (&pd1[sdlim], i, "");
	      goto cont_read;
	      }

	  if (xd[xpx] == '?') { //* tab format 
	      t2 = 1;
	      xpx++;
	      if ((ierr = parse_ ())) goto parse_err;
	      i = 3;
	      inout (&pd1[sdlim], i, &pd1[sdlim]);
	      goto cont_read;
	      }

	  if (xd[xpx] == '"') { // text to be printed first 
	      t2 = 1;
	      if ((ierr = parse_ ())) goto parse_err;
	      i = 4;
	      inout (&pd1[sdlim], i, "");
	      goto cont_read;
	      }

	  if (xd[xpx] == '*') { // direct mode 
	      xpx++;
	      dirflg = 1;
	      }

	  retz = READ;
	  goto set;  // process item to read

set_return:

#if UNIX!=0

	  if (xd[xpx + 1] == ':') { // timeout 
	      t2 = 1;
	      xpx += 2;
	      if ((ierr = parse_ ())) goto parse_err;
	      fprintf ( Out, "\t// TIMEOUT REQUESTED FOR %s SECONDS\n", &pd1[sdlim]);
	      //linepad(fprintf(Out,"\tfile[5]=stdin;"),"// unit ready for input");
            fprintf (Out,
		       "\ttpx=TimeOut_getstr1(in_file[io],gtmp,%s); // Read string into gtmp\n",
		       &pd1[sdlim]);

	      fprintf (Out, "\tif (tpx>=0) tpx=1; else tpx=0; // Set $Test\n");

	      strcpy (&pd1[sdlim], "gtmp");
	      xpx--;
	      goto store;
	      }
#endif

//#+*********** DOS Section *******

#if UNIX==0

	  if (xd[xpx + 1] == ':') { // timeout 
	      t2 = 1;
	      xpx += 2;
	      if ((ierr = parse_ ()))
		goto parse_err;
	      j = atoi (&pd1[sdlim]);

	      if (j <= 0) {
		  xpx--;
		  tpx = 0;
		  goto cont_read;
		  }

	      k = sdlim;
	      time ((time_t *) & ilong);
	      pd1[sdlim] = 0;

rdt:        if (kbhit ()) {
		  pd1[k] = getche ();

		  if (dirflg == 1) {
		      k++;
		      pd1[k] = 0;
		      goto store;
		      }

		  if (pd1[k] == 13) {
		      pd1[k] = 0;
		      goto store;
		      }

		  pd1[++k] = 0;
		  goto rdt;
		  }

	      i++;
	      if (time ((time_t *) & jlong) - ilong < j) goto rdt;

	      if (k > sdlim) {
		  xpx--;
		  tpx = 1;
		  goto store;
		  }

	      else {
		  xpx--;
		  tpx = 0;
		  goto cont_read;
		  }
	      }
#endif

	  if (dirflg == 1) {

#if UNIX==0

	      fprintf (Out, "\t_j=bioskey(0);\n");
	      fprintf (Out, "\tif (_j&0x00ff) _j=_j&0x00ff;\n");
	      fprintf (Out, "\telse _j=(_j>>8)+128;\n");
	      fprintf (Out, "\titoa(_j,%s,10);\n", &pd1[sdlim]);
#endif

#if UNIX==1

	      fprintf (Out, "\ttpx=DirectRead(gtmp); // Read Direct\n");
	      strcpy (&pd1[sdlim], "gtmp");
#endif

	      }

	  else {
	      //linepad(fprintf(Out,"\tfile[5]=stdin;"),"// unit ready for input");

	      fprintf (Out, "\ttpx=getstr1(in_file[io],gtmp); // Read string into gtmp\n");

	      fprintf (Out, "\tif (tpx>=0) tpx=1; else tpx=0; // Set $Test\n");

	      strcpy (&pd1[sdlim], "gtmp");
	      }

store:  retz = READ;
	  goto set_store;

cont_read:

	  xpx++;
	  dirflg = 0;
	  if (xd[xpx] == ',') xpx++;

	  if (xd[xpx] == 0 || xd[xpx] == ' ' || xd[xpx] == '\t') {

	      if (POST_flg) {
		  fprintf (Out, "\t} /* post conditional */\n");
		  POST_flg = 0;
		  }

	      goto next_cmnd;
	      }
	  }


case OPEN:

openf:

      t2 = 1;
      if ((ierr = parse_ ())) goto parse_err;
      fprintf (Out, "\ti=atoi(%s);\n", &pd1[sdlim]);
      if (xd[xpx] != ':') goto arg_list_error;
      xpx++;
      t2 = 1;
      if ((ierr = parse_ ())) goto parse_err;
      if (strcmp ("tmp0", &pd1[sdlim]) != 0)
	  fprintf (Out, "\tstrcpy(tmp0,%s);\n", &pd1[sdlim]);

      fprintf (Out, "\tfor(_j=0; tmp0[_j]!=0 && tmp0[_j]!=\',\';_j++);\n");

      fprintf (Out, "\tif (tmp0[_j]!=\',\') {\n");
      fprintf (Out, "\t\tprintf(\"\\n*** File open error in or near line %%d\\n\\n\",LineNumber);\n");
      fprintf (Out, "\t\tgoto _epilogue;\n");
      fprintf (Out, "\t\t}\n");

      fprintf (Out, "\ttmp0[_j++]=0;\n");
      fprintf (Out, "\tstrcpy(gtmp,tmp0);\n");

      fprintf (Out,
	       "\tif (strcmp(&tmp0[_j],\"old\")==0||"
	       "strcmp(&tmp0[_j],\"OLD\")==0) _new=0;\n");

      fprintf (Out,
	       "\telse if (strcmp(&tmp0[_j],\"new\")==0||"
	       "strcmp(&tmp0[_j],\"NEW\")==0) _new=1;\n");

      fprintf (Out,
	       "\telse if (strcmp(&tmp0[_j],\"append\")==0||"
	       "strcmp(&tmp0[_j],\"APPEND\")==2) _new=1;\n");

      fprintf (Out, "\telse {\n");
      fprintf (Out, "\t\tprintf(\"\\n*** File open error in or near line %%d\\n\\n\",LineNumber);\n");
      fprintf (Out, "\t\tgoto _epilogue;\n");
      fprintf (Out, "\t\t}\n");

      fprintf (Out, "\tif (out_file[i]!=NULL||in_file[i]!=NULL) {\n");
      fprintf (Out, "\t\tprintf(\"\\n*** File already open in or near line %%d\\n\\n\",LineNumber);\n");
      fprintf (Out, "\t\tgoto _epilogue;\n");
      fprintf (Out, "\t\t}\n");

      fprintf (Out, "\tif (_new==1) { /* output */\n");
      fprintf (Out, "\t\tout_file[i]=fopen(gtmp,\"w\");\n");
      fprintf (Out, "\t\tif(out_file[i]==NULL) tpx=0;\n");
      fprintf (Out, "\t\telse tpx=1;\n");
      fprintf (Out, "\t}\n");
      fprintf (Out, "\telse if (_new==2) { /* append */\n");
      fprintf (Out, "\t\tout_file[i]=fopen(gtmp,\"a\");\n");
      fprintf (Out, "\t\tif(out_file[i]==NULL) tpx=0;\n");
      fprintf (Out, "\t\telse tpx=1;\n");
      fprintf (Out, "\t}\n");
      fprintf (Out, "\telse { /* input */\n");
      fprintf (Out, "\t\tin_file[i]=fopen(gtmp,\"r\");\n");
      fprintf (Out, "\t\tif(in_file[i]==NULL) tpx=0;\n");
      fprintf (Out, "\t\telse tpx=1;\n");
      fprintf (Out, "\t}\n");

      if (xd[++xpx] != ',') {

	  if (POST_flg) {
	      fprintf (Out, "\t} /* post conditional */\n");
	      POST_flg = 0;
	      }
	  goto next_cmnd;
	  }

      xpx++;
      goto openf;


case ZCMDS:

      p2px++;
      if (xd[p2px] <= 90)
	xd[p2px] += 32;  //lower case 

      if (xd[p2px] == 'n') {
	  fprintf (Out, "\tgpad=1; // pad btree numeric subscript to the left\n");
	  goto next_line;
	  }

      if (xd[p2px] == 'm') {  // zmain subroutine 

	  if (MAIN_flg) {
	      printf ("*** in line %d Multiple Main programs\n", lines);
	      ExitCode = 99;
	      goto abrtx;
	      }

	  else if (FCN_flg) {
	      fprintf (Out, "\n\n/********************** Function Epilogue ********************/\n");
	      fprintf (Out, "\t_epilogue: return \"\";\n}\n");
	      F_flg = 0;
	      FCN_flg = 0;
	      }

	  Sysout ( "\nint main(int argc, char *argv[]) {\n\n");

        fcninit();

        Sysout_skip;
	  fprintf (Out, "in_file[5]=stdin;\n");
	  fprintf (Out, "out_file[5]=stdout;\n");

	  MAIN_flg = 1;
	  goto next_line;
	  }

      if (xd[p2px] == 'f') { // function subroutine

	  if (MAIN_flg) {
	      epi ();
	      MAIN_flg = 0;
	      }

	  else if (FCN_flg) {
	      fprintf (Out, "\n\n");
	      linepad (fprintf (Out, "\treturn 0; }"), "Terminate Function");
	      FCN_flg = 0;
	      F_flg = 0;
	      Sysout ( "//=================================================================================\n\n");
	      }

	  fprintf (Out, "char * %s() {\n\n", &xd[xpx]);
	  Sysout ("//*** This module generated by Mumps Compiler ");
        Sysout (RELEASE);
        Sysout ("\n");
	  Sysout ("/*** This code is unverified - use at your own risk */\n\n");

        fcninit();

	  FCN_flg = 1;
	  goto next_line;
	  }

      if (xd[p2px] == 'd') { // write remainder of line to output 
	  fprintf (Out, "\t%s\n", &xd[xpx]);
	  goto next_line;
	  }

      if (xd[p2px] == 'r') { // zreturn 
	  fprintf (Out, "\treturn %s;\n", &xd[xpx]);
	  goto next_line;
	  }

      if (xd[p2px] == 's') { // zseek 
	  long i;
	  t2 = 1;
	  if ((ierr = parse_ ())) goto parse_err;
	  i = atol (&pd1[sdlim]);
	  goto next_cmnd;
	  }

      if (xd[p2px] == 'c') { // zclose 
	  linepad (fprintf (Out, "\ttmp0[0]=0; tmp1[0]=0;"), "Function Epilogue");
	  linepad (fprintf (Out, "\tglobal(GCLOSE,tmp0,tmp1);"), "Close Globals");
	  goto next_cmnd;
	  }

      if (xd[p2px] == 'e') {

abrtx:

	  if (MAIN_flg == 0 && FCN_flg == 0) {
	      printf ("\n*** No Zmain or Zfunction\n");
	      ExitCode = 99;
	      }

	  if (MAIN_flg) {
	      epi ();
	      MAIN_flg = 0;
	      }

	  else {
	      fprintf (Out, "\n\n/********************** Function Epilogue ********************/\n");
	      F_flg = 0;
	      fprintf (Out, "\t_epilogue: return \"\";\n}\n");
	      MAIN_flg = 0;
	      }

	  fclose (Out);

	  {
	    long timex;
	    timex = time (&timex);
	    printf ("%d lines compiled %s\n", lines, ctime (&timex));
	  }

	  return ExitCode;
	}

      printf ("*** n line %d: Unrecognized command \n", lines);
      goto next_line;


case IF:

      if (xd[xpx] == ' ') { /* no argument form */

	  xpx++;
	  fprintf (Out, "\tif (tpx) {\n");
	  IF_flg++;
	  goto next_cmnd;
	  }

      at_flg = 0;
      for (k = xpx; xd[k] != 0 && xd[k] != ' '; k++) {
	  if (xd[k] == '@') at_flg = 1;;
	  if (xd[k] == '"') {
	      while (k++) {
		  if (xd[k] == 0) {
		      printf ("*** Imbalanced quotes\n");
		      printf ("*** In or near line %d\n", lines);
		      printf ("*** %s\n", &pd1[pd1Last]);
		      ExitCode = 99;
		      goto abrtx;
		      }
		  if (xd[k] == '\"' && xd[k + 1] == '\"') {
		      k++;
		      continue;
		      }
		  if (xd[k] == '\"') break;
		  }
	      }
	  }

      if (at_flg) {
	  {
	    char tmp[512];
	    int i, j;
	    strcpy (tmp, "i ");
	    for (i = xpx, j = 2; xd[i] != 0 && i < k; i++) {
		if (xd[i] != '\"' && xd[i] != '\\') tmp[j++] = xd[i];
		else if (xd[i] == '\"') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\"';
		    }
		else if (xd[i] == '\\') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\\';
		    }
	      }
	    tmp[j] = 0;

	    fprintf (Out, "\tif (Interpret(\"%s\")!=0) {;\n", tmp);
	       fprintf (Out,
		   "\t\tprintf(\"\\n*** Indirection error in or near line %%d\\n\\n\",LineNumber);\n");
	       fprintf (Out, "\t\tgoto _epilogue;\n");
	       fprintf (Out, "\t\t}\n");

	    xpx = k;
	    if (POST_flg) {
		fprintf (Out, "\t} /* post conditional */\n");
		POST_flg = 0;
	      }
	    linepad (fprintf (Out, "\tif (tpx) {"), "Test expression for True");
	    goto if_structure;
	    }
	  }

if_again:

      t2 = 1;
      if ((ierr = parse_ ()))
	goto parse_err;
      linepad (fprintf (Out, "\ttpx=0;"), "Default $Test indicator");
      linepad (fprintf (Out, "\tif (numcomp(%s,\"1\")==0) {", &pd1[sdlim]),
	       "Test expression for True");
      pl = fprintf (Out, "\ttpx=1;");
      linepad (pl, "Set $Test indicator True");

if_structure:

      tpx = 1;
      if (xd[xpx + 1] != '{')
	IF_flg++;
      if (xd[xpx] == ',') {
	  xpx++;
	  goto if_again;
	  }
      goto next_cmnd;


case WRITE:

      fprintf (Out, "\tif (out_file[io]==NULL) {\n");
      fprintf (Out,
        "\t\tprintf(\"\\n*** Write to input file in or near line %%d\\n\\n\",LineNumber);\n");
      fprintf (Out, "\t\tgoto _epilogue;\n");
      fprintf (Out, "\t\t}\n");

      at_flg = 0;
      for (k = xpx; xd[k] != 0 && xd[k] != ' '; k++) {
	  if (xd[k] == '@') at_flg = 1;;
	  if (xd[k] == '"') {
	      while (k++) {
		  if (xd[k] == 0) {
		      printf ("*** Imbalanced quotes\n");
		      printf ("*** In or near line %d\n", lines);
		      printf ("*** %s\n", &pd1[pd1Last]);
		      ExitCode = 99;
		      goto abrtx;
		      }
		  if (xd[k] == '\"' && xd[k + 1] == '\"') {
		      k++;
		      continue;
		      }
		  if (xd[k] == '\"') break;
		  }
	      }
	  }

	if (at_flg) goto indirect_err;

      t0px = 0;

      while (1) {

	  if (xd[xpx] == '!' || xd[xpx] == '#') { /*new line or page */
	      i = 1;
	      if (xd[xpx] != '#')
		i = 2;
	      xpx++;
	      goto iosub;
	      }

	  if (xd[xpx] == '*') { //  "*" output*/
	      xpx++;
	      t2 = 1;
	      if ((ierr = parse_ ()))
		goto parse_err;
	      linepad (fprintf (Out, "\ti=atoi(%s);", &pd1[sdlim]),
		       "Convert to integer");

#if UNIX==0
	      linepad (fprintf (Out, "\tputch(i);"), "Direct output");
#endif

#if UNIX==1
	      linepad (fprintf (Out, "\tputchar(i);"), "Direct output");
#endif

	      i = 4;
	      goto iosub1;
	    }

	  if (xd[xpx] == '?') { /*tab */
	      t2 = 1;
	      xpx++;
	      if ((ierr = parse_ ()))
		goto parse_err;
	      i = 3;
	      goto iosub;
	      }

	  t2 = 1;
	  if ((ierr = parse_ ())) goto parse_err;
	  i = 4;

iosub:  inout (&pd1[sdlim], i, &pd1[sdlim]);

iosub1: if (xd[xpx] == ',') {
	      xpx++;
	      continue;
	      }

	  if (xd[xpx] == 0 || xd[xpx] == ' ' || xd[xpx] == '\t') {
	      if (POST_flg) {
		  fprintf (Out, "\t} /* post conditional */\n");
		  POST_flg = 0;
		  }
	      fprintf (Out, "\n");
	      goto next_cmnd;
	      }
	  }


case JOB:

      linepad (fprintf (Out, "\tglobal(GCLOSE,tmp0,tmp1);"),
	       "Close Globals before fork");
      linepad (fprintf (Out, "\tif (fork()!=0) {"),
	       "I am child process if zero");
      JOB_flg = 1;
      goto do_entry;

job_return:

      fprintf (Out, "\t}");
      goto next_line;

case SET:

      retz = 0;

set:

      Set_flg = 0;
      at_flg = 0;
      for (k = xpx; xd[k] != 0 && xd[k] != ' '; k++) {

	  if (xd[k] == '@') {
	      at_flg = 1;
	      if (retz == READ) {
		  printf ("*** Indirection not permitted in READ\n");
		  printf ("*** In or near line %d\n", lines);
		  printf ("*** %s\n", &pd1[pd1Last]);
		  ExitCode = 99;
		  goto abrtx;
		  }
	      }

	  if (xd[k] == '"') {
	      while (k++) {
		  if (xd[k] == 0) {
		      printf ("*** Imbalanced quotes\n");
		      printf ("*** In or near line %d\n", lines);
		      printf ("*** %s\n", &pd1[pd1Last]);
		      ExitCode = 99;
		      goto abrtx;
		      }
		  if (xd[k] == '\"' && xd[k + 1] == '\"') {
		      k++;
		      continue;
		      }
		  if (xd[k] == '\"') break;
		  }
	      }
	  }

      if (at_flg) {
	  {
	    char tmp[512];
	    int i, j;
	    strcpy (tmp, "s ");
	    for (i = xpx, j = 2; xd[i] != 0 && i < k; i++) {
		if (xd[i] != '\"' && xd[i] != '\\') tmp[j++] = xd[i];
		else if (xd[i] == '\"') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\"';
		    }
		else if (xd[i] == '\\') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\\';
		    }
	        }
	    tmp[j] = 0;
	    fprintf (Out, "\tif (Interpret(\"%s\")!=0) {;\n", tmp);
	       fprintf (Out,
		   "\t\tprintf(\"\\n*** Indirection error in or near line %%d\\n\\n\",LineNumber);\n");
	       fprintf (Out, "\t\tgoto _epilogue;\n");
	       fprintf (Out, "\t\t}\n");

	    xpx = k;
	    if (POST_flg) {
		fprintf (Out, "\t} /* post conditional */\n");
		POST_flg = 0;
	      }
	    goto next_cmnd;
	    }
	  }

      t0px = 1;
      t2 = 1;
      setname[0] = 0;
      if ((ierr = parse_ ())) goto parse_err;
      strcpy (vd, &v1d[1]);

      {
	int i, k, j;		// Process array reference
	char tmp[1024];
	if (v1d[1] == '^' || v1d[1] == '$')
	  goto no_array;
	for (i = 0; vd[i] != 0; i++)
	  if (vd[i] > 127) goto has_array;
	goto no_array;

has_array:		// Process LHS local array reference

	fprintf (Out,
		 "\t{\tchar tmp[1024];  // expand lhs array reference\n\t\tint i;\n");
	for (i = 0; vd[i] != 0; i++)
	  if (vd[i] == 206) {//Open
	      vd[i] = 0;
	      fprintf (Out, "\t\tstrcpy(tmp,\"%s\");\t// array name\n", vd);
	      fprintf (Out, "\t\ti=strlen(tmp);\n");
	      fprintf (Out, "\t\ttmp[i]=206;\t// coded open paren\n");
	      fprintf (Out, "\t\ttmp[i+1]=0;\n");
	      vd[i] = 206;
	      for (j = i + 1; vd[j] != 0; j++)
              if (vd[j] == 207 || vd[j] == 208) break;
	      k = vd[j];
	      vd[j] = 0;
	      fprintf (Out, "\t\tstrcat(tmp,%s);\t// index\n", &vd[i + 1]);
	      fprintf (Out, "\t\ti=strlen(tmp);\n");
	      fprintf (Out, "\t\ttmp[i]=%d;\t// coded comma or close paren\n", k);
	      fprintf (Out, "\t\ttmp[i+1]=0;\n");
	      vd[j] = k;
	      i = j - 1;
	      }
	  else if (vd[i] == 207) {			// Close
	      fprintf (Out, "\t\tstrcpy(atmp,tmp); // preserve expanded array reference\n");
	      Set_flg = 1;
	      fprintf (Out, "\t\t}\n");
	      strcpy (vd, "atmp");
	      break;
	      }
	  else if (vd[i] == 208) {			/* comma */
	      for (j = i + 1; vd[j] != 0; j++)
		if (vd[j] == 207 || vd[j] == 208) break;
	      k = vd[j];
	      vd[j] = 0;
	      fprintf (Out, "\t\tstrcat(tmp,%s);\n", &vd[i + 1]);
	      fprintf (Out, "\t\ti=strlen(tmp);\n");
	      fprintf (Out, "\t\ttmp[i]=%d;\n // coded comma or close paren\n", k);
	      fprintf (Out, "\t\ttmp[i+1]=0;\n");
	      vd[j] = k;
	      i = j - 1;
	      }
        }

no_array:

/*############
 Global Array
##############*/

      if (v1d[1] == '^') {			// Process LHS global array reference
	  char t[1024], h[6];
	  int i, j = 0;
	  for (i = 1; v1d[i] != 0; i++)
	    {
	      if (v1d[i] >= 32 && v1d[i] <= 127)
		t[j++] = v1d[i];
	      else
		break;
	    }
	  GBL_flg = 1;
	  sprintf (h, "%2x", v1d[i]);
	  t[j++] = '\\';
	  t[j++] = 'x';
	  t[j++] = h[0];
	  t[j++] = h[1];
	  t[j] = 0;
	  fprintf (Out, "\tstrcpy(gtmpL,\"%s\");\n", t);
	  i++;
	  while (1)
	    {
	      j = 0;
	      while (v1d[i] <= 127 && v1d[i] >= 32)
		t[j++] = v1d[i++];
	      t[j] = 0;
	      fprintf (Out, "\tstrcat(gtmpL,%s);\n", t);
	      j = 0;
	      sprintf (h, "%2x", v1d[i]);
	      t[j++] = '\\';
	      t[j++] = 'x';
	      t[j++] = h[0];
	      t[j++] = h[1];
	      t[j] = 0;
	      fprintf (Out, "\tstrcat(gtmpL,\"%s\");\n", t);
	      if (v1d[++i] != 0)
		continue;
	      else
		break;
	    }
	}

      else
	GBL_flg = 0;

rhs:

      if (retz == KILL) goto kill_return;
      if (retz == NEW) goto new_return;
      if (retz == NEW1) goto new1_return;
      if (retz == READ) goto set_return;

      xpx += 2;

      t0px = 0;
      t2 = 1;
      if ((ierr = parse_ ()))
	goto parse_err;		// process RHS

set_store:

      if (GBL_flg)
	fprintf (Out, "\tf=global(STORE,gtmpL,%s);\n", &pd1[sdlim]);

      else if (vd[0] == '$' && (tolower (vd[1]) == 'p')) { // Process LHS $PEICE

	  unsigned char var[256];
	  unsigned char pat[256];
	  unsigned char strt[256];
	  unsigned char end[256];

	  for (i = 0; vd[i] < 128; i++); strcpy (var, &vd[i + 1]);
	  for (j = 0; var[j] < 128; j++); var[j] = 0;

	  for (i++; vd[i] < 128; i++); strcpy (pat, &vd[i + 1]);
	  for (j = 0; pat[j] < 128; j++); pat[j] = 0;

	  for (i++; vd[i] < 128 && vd[i] != 0; i++); strcpy (strt, &vd[i + 1]);
	  for (j = 0; strt[j] < 128; j++); strt[j] = 0;

	  for (i++; vd[i] < 128 && vd[i] != 0; i++);

	  if (vd[++i] == 0) strcpy (end, "\"-1\"");

	  else {
	      strcpy (end, &vd[i]);
	      for (j = 0; end[j] < 128; j++);
	      end[j] = 0;
            }

	  fprintf (Out,
            "\t_piece(%s,%s,%s,%s,%s,1,%s);\n",
            setname, var, pat, strt, end, &pd1[sdlim]);
	  }

      else {

	  if (Set_flg) fprintf (Out, "\tsym_(0,%s,%s); // Store result\n", vd, &pd1[sdlim]);

	  else fprintf (Out, "\tsym_(0,\"%s\",%s); // Store result\n", vd, &pd1[sdlim]);

	}

rhs1:

      if (retz == READ) goto cont_read;

      if (xd[xpx] == ',') {
            xpx++;
            goto set;
            }

      if (POST_flg) {
            fprintf (Out, "\t} /* post conditional */\n");
            POST_flg = 0;
            }

      goto next_cmnd;

// CONTINUE (form of QUIT)

cntnue:
case QUIT:

      if (ExecLevel == 0 && forx == 0) {

	  fprintf (Out, "\tif(_ReturnVal==NULL) _ReturnVal=(unsigned char *)malloc(1024);\n");

	  fprintf (Out,
		   "\tif(_ReturnVal==NULL) {\n\t\tprintf(\"******* Error - Out of Memory in"
		   " or near line %%d\\n\",LineNumber);\n"
		   "\t\tgoto _epilogue;}\n");

	  fprintf (Out, "\tstrcpy(_ReturnVal,\"\");\n");

	  if (xd[xpx] != ' ' && xd[xpx] != 0) {
	      t2 = 1;
	      if ((ierr = parse_ ()))
		goto parse_err;
	      fprintf (Out, "\tstrcpy(_ReturnVal,%s);\n", &pd1[sdlim]);
	      }

	  if (F_flg) {
	      fprintf (Out, "\treturn _ReturnVal;\n");
	      }
	  else {
            fprintf (Out, "\tif (_doStackN[_doStx-1]) { _doStackN[_doStx-1]=0; _SymFree(1); }\n");
	      fprintf (Out, "\tif (_doStx>0) { longjmp(_doStack[--_doStx],99); }\n");
	      fprintf (Out,
		       "\telse {\n\t\tprintf(\"******** Error - Too many Quits in or near"
		       " line number %%d\\n\",LineNumber);\n");
	      fprintf (Out, "\t\tgoto _epilogue; }\n");
	      }
	}

      else fprintf (Out, "\tbreak;\n");

      if (POST_flg) {
	  fprintf (Out, "\t} /* post conditional */\n");
	  POST_flg = 0;
	  }
      goto next_cmnd;


case XECUTE:

      printf ("*** In line %d Xecute not supported\n", lines);

      goto command;


case FOR:

      if (xd[xpx] == ' ') {			// argumentless form
	  forx++;
	  linepad (fprintf (Out, "\twhile(1) {"), "Argumentless FOR");
	  if (xd[xpx + 1] != '{') IF_flg++;
	  goto next_cmnd;
	  }

      t0px = 1;
      if ((ierr = parse_ ()))
	goto parse_err;
      forx++;
      fprintf (Out, "\tif (for%d_init==NULL) {\n", forx);
      fprintf (Out, "\t\tfor%d_init=(unsigned char *)malloc(256);\n", forx);
      fprintf (Out, "\t\tfor%d_incr=(unsigned char *)malloc(256);\n", forx);
      fprintf (Out, "\t\tfor%d_lim=(unsigned char *)malloc(256);\n", forx);
      fprintf (Out, "\t\tif(for%d_incr==NULL||for%d_init==NULL||"
	       "for%d_lim==NULL) {\n\t\tprintf(\"******* Error - Out of Memory in"
	       " or near line %%d\\n\",LineNumber);\n"
	       "\t\tgoto _epilogue;\n\t\t}\n\t}\n", forx, forx, forx);
      xpx += 2;
      strcpy (&forv[forx][0], &v1d[1]);	// loop index 

      t2 = 1;
      if ((ierr = parse_ ()))
	goto parse_err;
      fprintf (Out, "\tstrcpy(for%d_init,%s);\n", forx, &pd1[sdlim]);	// initial value
      fprintf (Out, "\tcannon(for%d_init);\n", forx);

      if (xd[xpx] != ':')
	goto arg_list_error;

      t2 = 1;
      xpx++;
      if ((ierr = parse_ ()))
	goto parse_err;
      fprintf (Out, "\tstrcpy(for%d_incr,%s);\n", forx, &pd1[sdlim]);	// increment 
      fprintf (Out, "\tcannon(for%d_incr);\n", forx);

      if (xd[xpx] != ':')
	FOR_limit = 0;		/* no limit */
      else {
	  t2 = 1;
	  xpx++;
	  if ((ierr = parse_ ()))
	    goto parse_err;
	  fprintf (Out, "\tstrcpy(for%d_lim,%s);\n", forx, &pd1[sdlim]);	/* limit */
	  fprintf (Out, "\tcannon(for%d_lim);\n", forx);
	  FOR_limit = 1;
	  }

      fprintf (Out, "\tfor(sym_(0,\"%s\",for%d_init);\n",
	       &forv[forx][0], forx);

      if (FOR_limit) fprintf (Out,
		 "\t\tnumcomp(sym_(1,\"%s\",_dummy),for%d_lim)<=0;\n",
		 &forv[forx][0], forx);
      else fprintf (Out, "\t\t1; /* limit expression - no limit */\n");

      fprintf (Out,
	       "\t\tadd(for%d_incr,sym_(1,\"%s\",_dummy),_dummy),sym_(0,\"%s\",_dummy)) {\n",
	       forx, &forv[forx][0], &forv[forx][0]);

      if (xd[xpx + 1] != '{') IF_flg++;

      if (xd[xpx] == ',' || xd[xpx] == ' ' || xd[xpx] == 0 || xd[xpx] == '\t')
	goto next_cmnd;
      goto arg_list_error;


case HALT:

      if (xd[xpx] == ' ' || xd[xpx] == 0) {
	  if (MAIN_flg) fprintf (Out, "\tgoto _epilogue;\n");
	  if (FCN_flg) fprintf (Out, "\treturn NULL;\n");
	  goto next_cmnd;
	  }

      while (1) { /* Hang */
	  t2 = 1;
	  if ((ierr = parse_ ())) goto parse_err;
	  fprintf (Out, "\ti=atoi(%s);\n", &pd1[sdlim]);
	  fprintf (Out, "\tif (i>0) sleep(i);\n");

	  if (xd[xpx] == ',') {
	      xpx++;
	      continue;
	      }

	  if (POST_flg) {
	      fprintf (Out, "\t} /* post conditional */\n");
	      POST_flg = 0;
	      }

	  goto next_cmnd;
	}


case ELSE:

      if (xd[xpx] == ' ') xpx++;
      fprintf (Out, "\tif (tpx==0) {\n");
      IF_flg++;
      goto next_cmnd;

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+* DO
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

case DO:

do_entry:

//#++++++++++++++++++
//#+ Argumentless DO
//#++++++++++++++++++

      if (xd[xpx] == 0 || xd[xpx] == ' ') {

	  if (JOB_flg) { // is this really a JOB command?
	      printf ("*** JOB requires argument\n");
	      goto arg_list_error;
	      }

	  fprintf (Out, "\tgoto _labx%d; // argumentless DO \n", ExecName);
	  fprintf (Out, "_labz%d: ;// return \n", ExecName);
	  if (POST_flg) {
	      fprintf (Out, "\t} /* post conditional */\n");
	      POST_flg = 0;
	      }
	  goto next_cmnd;
	  }

//#++++++++++++++++++
//#+ Argumented DO
//#++++++++++++++++++

      fprintf (Out, "\t_ArgCount=0;\n");

            xd[xpx-2]='$';
            xd[xpx-1]='$';
            xpx=xpx-2;
            t2 = 1;
            // Do = 1;
            if ((ierr = parse_ ())) goto parse_err;

            if (xd[xpx]==':') goto do_error;


      if (POST_flg) {
            fprintf (Out, "\t} /* post conditional */\n");
            POST_flg = 0;
            }

      if (JOB_flg) goto job_return;

      goto next_cmnd;

      while (1) {
	  t2 = 1;
	  Do = 1;
	  if ((ierr = parse_ ())) goto parse_err;
	  Do = 0;
	  if (xd[xpx] != ',') {
	      if (POST_flg) {
		  fprintf (Out, "\t} /* post conditional */\n");
		  POST_flg = 0;
		  }
	      if (JOB_flg) goto job_return;
	      goto next_cmnd;
	      }
	  xpx++;
	  }

//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+* KILL
//#+*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

case KILL:

      if (xd[xpx] == ' ' || xd[xpx] == 0 || xd[xpx] == '\t') {  // Kill all locals
	  fprintf (Out, "\t_SymFree(0);\n");
	  goto k001;
	  }

//#+++++++++++++++++++++++++++++++++++++++
//# Check for indirection in statement
//#+++++++++++++++++++++++++++++++++++++++

      at_flg = 0;
      for (k = xpx; xd[k] != 0 && xd[k] != ' '; k++) {

	  if (xd[k] == '@') at_flg = 1;

	  if (xd[k] == '"') {

	      while (k++) {

		  if (xd[k] == 0) {
		      printf ("*** Imbalanced quotes\n");
		      printf ("*** In or near line %d\n", lines);
		      printf ("*** %s\n", &pd1[pd1Last]);
		      ExitCode = 99;
		      goto abrtx;
		      }

		  if (xd[k] == '\"' && xd[k + 1] == '\"') {
		      k++;
		      continue;
		      }

		  if (xd[k] == '\"') break;
		  }
	    }
	}

      if (at_flg) {
	  {
	    char tmp[512];
	    int i, j;
	    strcpy (tmp, "k ");

	    for (i = xpx, j = 2; xd[i] != 0 && i < k; i++) {

		if (xd[i] != '\"' && xd[i] != '\\') tmp[j++] = xd[i];

		else if (xd[i] == '\"') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\"';
		    }

		else if (xd[i] == '\\') {
		    tmp[j++] = '\\';
		    tmp[j++] = '\\';
		    }
	      }

	    tmp[j] = 0;

	    fprintf (Out, "\tif (Interpret(\"%s\")!=0) {;\n", tmp);
	       fprintf (Out,
		   "\t\tprintf(\"\\n*** Indirection error in or near line %%d\\n\\n\",LineNumber);\n");
	       fprintf (Out, "\t\tgoto _epilogue;\n");
	       fprintf (Out, "\t\t}\n");

	    xpx = k;
	    if (POST_flg) {
		fprintf (Out, "\t} /* post conditional */\n");
		POST_flg = 0;
	      }
	    goto next_cmnd;
	  }
	}

k003:

      if (xd[xpx] == '^') goto k004;      //* kill globals

      if (xd[xpx] != '(') {               //* Kill specific 
	  t0px = 1;
	  if ((ierr = parse_ ())) goto parse_err;
	  fprintf (Out, "\tsym_(2,\"%s\",\"\"); //... kill specific\n", &v1d[1]);
	  goto k002;
	  }

//#++++++++++++++++++++++++++++++++
//#+    Kill all locals except... 
//#++++++++++++++++++++++++++++++++

	fprintf (Out, "\t{\n\tstruct nmes *p1,*p2;\n");
	fprintf (Out, "\tnstart=NULL;\n");
	xpx++;

kill2:

      t0px = 1;
	t2 = 1;
	retz = KILL;
	goto set;

kill_return:

	if (strcmp (vd, "atmp") == 0) fprintf (Out, "\tkeyfix(atmp);\n");

	else {
	    char tmp[256];
	    strcpy (tmp, "\"");
	    strcat (tmp, vd);
	    strcat (tmp, "\"");
	    strcpy (vd, tmp);
	    }

	fprintf (Out, "\tp1=(struct nmes *) malloc(sizeof (struct nmes));\n");
	fprintf (Out, "\tif (p1==NULL) { printf(\"*** Out of memory\\n\"); goto _epilogue; }\n");
	fprintf (Out, "\tp1->name=(char *) malloc(strlen(atmp+1));\n");
	fprintf (Out, "\tif (p1->name==NULL) { printf(\"*** Out of memory\\n\"); goto _epilogue;}\n");
	fprintf (Out, "\tstrcpy(p1->name,%s);\n", vd);
	fprintf (Out, "\tp1->next=nstart;\n");
	fprintf (Out, "\tnstart=p1;\n");
	xpx++;

	if (xd[xpx] != ')' && xd[xpx]) {
	    xpx++;
	    goto kill2;
	    }

	fprintf (Out, "\tsym_(5,\"\",\"\"); // kill selected\n");
	fprintf (Out, "\t}\n");
	goto k002;

//#++++++++++++++++++++++++++++++++++++++++++++
//# Kill globals
//#++++++++++++++++++++++++++++++++++++++++++++

k004:  

      while (1) {
	  t0px = 1;
	  if ((ierr = parse_ ())) goto parse_err;

	  fprintf (Out, "\tstrcpy(gtmp,\"\");\n");

	  {
	    char t[1024];
	    int i, j = 0;

	    for (i = 1; v1d[i] != 0; i++) {
		if (v1d[i] >= 32 && v1d[i] <= 127) t[j++] = v1d[i];
		else break;
	      }

	    t[j++] = '\x01';
	    t[j] = 0;
	    fprintf (Out, "\tstrcat(gtmp,\"%s\");\n", t);

	    if (v1d[i] != 0) {
		i++;
		while (1) {
		    j = 0;
		    while (v1d[i] <= 127 && v1d[i] >= 32) t[j++] = v1d[i++];
		    t[j] = 0;
		    fprintf (Out, "\tstrcat(gtmp,%s);\n", t);	//???
		    j = 0;
		    t[j++] = '\x01';
		    t[j] = 0;
		    fprintf (Out, "\tstrcat(gtmp,\"%s\");\n", t);
		    if (v1d[++i] != 0) continue;
		    else break;
		    }
	        }
	    }

	  fprintf (Out, "\t{\tunsigned char tmp14[1024],tmp15[1024];\n\t\tkeyfix(gtmp);\n");
	  fprintf (Out, "\t\t_k=strlen(gtmp);\n");	/* original length */
	  fprintf (Out, "\t\tstrcpy(tmp14,gtmp);\n");
	  fprintf (Out, "\t\tglobal(GKILL,gtmp,tmp15);\n");	/* kill first */
	  fprintf (Out, "\t\twhile(1) {\n");
	  fprintf (Out, "\t\t_j=global(XNEXT,gtmp,tmp15);\n");	/* kill others like it */
	  fprintf (Out, "\t\tif (_j&&strncmp(tmp14,gtmp,_k)==0) {\n");
	  fprintf (Out, "\t\t\tglobal(GKILL,gtmp,tmp15);\n");
	  fprintf (Out, "\t\t\tcontinue;\n");
	  fprintf (Out, "\t\t\t}\n");
	  fprintf (Out, "\t\tbreak;\n\t\t}\n\t}\n");

k002:

        if (xd[++xpx] == ',') {
	      xpx++;
	      goto k003;
	      }

k001:

        if (POST_flg) {
	      fprintf (Out, "\t} /* post conditional */\n");
	      POST_flg = 0;
	      }
	  goto next_cmnd;
	}

case CLOSE:

      p2px++;
      if (xd[p2px] <= 90)
	xd[p2px] += 32;		/*lower case */
      if (xd[p2px] == 'o')
	goto cntnue;		// continue

      while (1)
	{
	  t2 = 1;
	  if ((ierr = parse_ ()))
	    goto parse_err;
	  fprintf (Out, "\ti=atoi(%s);\n", &pd1[sdlim]);
        fprintf(Out, "\tif (in_file[i]==NULL&&out_file[i]==NULL) {\n");
	  fprintf (Out,
		   "\t\tprintf(\"\\n*** Attempt to close unopened file in or near line %%d\\n\\n\",LineNumber);\n");
	  fprintf (Out, "\t\tgoto _epilogue;\n");
	  fprintf (Out, "\t\t}\n");
	  fprintf (Out,
		   "\tif (in_file[i]!=NULL) { fclose(in_file[i]); in_file[i]=NULL; }\n");
	  fprintf (Out,
		   "\telse { fclose(out_file[i]); out_file[i]=NULL; }\n");
	  if (xd[xpx] != ',')
	    {
	      if (POST_flg)
		{
		  fprintf (Out, "\t} /* post conditional */\n");
		  POST_flg = 0;
		}
	      goto next_cmnd;
	    }
	  xpx++;
	}

case USE:

      t2 = 1;
      if ((ierr = parse_ ()))
	goto parse_err;
      fprintf (Out, "\tio=atoi(%s);\n", &pd1[sdlim]);

      if (POST_flg) {
	  fprintf (Out, "\t} /* post conditional */\n");
	  POST_flg = 0;
	  }

      goto next_cmnd;

/****************************************************************************
*******
******* remote block to proces lhs type references
*******
****************************************************************************/

lhsref:

      if (vd[1] == '^') {
	  strcpy (v1d, &vd[1]);
	  strcpy (bd, &pd1[sdlim]);
	  fprintf (Out, "\t_f=global*(STORE,%s,%s);\n", v1d, bd);
	  }

      else if (vd[1] == '$' && (vd[2] == 'p' || vd[2] == 'P')) { // $Piece
	  strcpy (tmp3, &pd1[sdlim]);
	  strcpy (&v1d[1], &vd[1]);
	  setpiece = 1;
	  /* fcn();  */
	  setpiece = 0;
	  for (i = 1; bd[i] != 0 && bd[i] != 1; i++);
	  if (bd[i] == 0) goto ref_err;
	  sdlim = pd1len + 2;
	  l = 1;
	  j = sdlim;
	  while (l < i) pd1[j++] = bd[l++];
	  pd1[j] = 0;
	  strcat (&pd1[sdlim], tmp3);
	  strcat (&pd1[sdlim], &bd[i + 1]);
	  strcpy (&vd[1], setname);
	  goto lhsref;
	  }

      else {  // Ordinary variable
	  strcpy (vd, &vd[1]);

	  {
	    int i, k, j;	// Process array reference
	    char tmp[1024];

	    if (v1d[1] == '^') goto no_array1;

	    for (i = 0; vd[i] != 0; i++)
	      if (vd[i] > 127) goto has_array1;

	    goto no_array1;

has_array1:

	    fprintf (Out,
		     "// Expand LHS Array Reference\n{\tchar tmp[1024];\n\tint i;\n");
	    for (i = 0; vd[i] != 0; i++)
	      if (vd[i] == 206)
		{		//Open
		  vd[i] = 0;
		  fprintf (Out, "\tstrcpy(tmp,\"%s\");\t// array name\n", vd);
		  fprintf (Out, "\ti=strlen(tmp);\n");
		  fprintf (Out, "\ttmp[i]=206;\t// coded open paren\n");
		  fprintf (Out, "\ttmp[i+1]=0;\n");
		  vd[i] = 206;
		  for (j = i + 1; vd[j] != 0; j++)
		    if (vd[j] == 207 || vd[j] == 208)
		      break;
		  k = vd[j];
		  vd[j] = 0;
		  fprintf (Out, "\tstrcat(tmp,%s);\t// index\n", &vd[i + 1]);
		  fprintf (Out, "\ti=strlen(tmp);\n");
		  fprintf (Out,
			   "\ttmp[i]=%d;\t// coded comma or close paren\n",
			   k);
		  fprintf (Out, "\ttmp[i+1]=0;\n");
		  vd[j] = k;
		  i = j - 1;
		}
	      else if (vd[i] == 207)
		{		// Close
		  fprintf (Out,
			   "\tstrcpy(atmp,tmp); // preserve expanded array reference\n");
		  fprintf (Out, "\t}\n");
		  strcpy (vd, "atmp");
		  break;
		}
	      else if (vd[i] == 208)
		{		/* comma */
		  for (j = i + 1; vd[j] != 0; j++)
		    if (vd[j] == 207 || vd[j] == 208)
		      break;
		  k = vd[j];
		  vd[j] = 0;
		  fprintf (Out, "\tstrcat(tmp,%s);\n", &vd[i + 1]);
		  fprintf (Out, "\ti=strlen(tmp);\n");
		  fprintf (Out,
			   "\ttmp[i]=%d;\n // coded comma or close paren", k);
		  fprintf (Out, "\ttmp[i]=0;\n");
		  vd[j] = k;
		  i = j - 1;
		}
	  }

	no_array1:

	  fprintf (Out, "\tsym_(0,\"%s\",%s);  // Store value\n", vd,
		   &pd1[sdlim]);
	}

      goto cont_read;

/****************************************************************************
*******
******* remote block to process DO and GOTO arguments.
*******
****************************************************************************/

case GOTO:

      if (xd[xpx] == 0) goto lbl_error;

      i = 0;
      while (xd[xpx]) {
	  if (xd[xpx] == ',' || xd[xpx] == ' ' || xd[xpx] == 0 ||
	      xd[xpx] == '+' || xd[xpx] == '^' || xd[xpx] == ':')
	    break;
	  dosave[i++] = xd[xpx++];
	  }
      dosave[i] = 0;
      if (strlen (dosave) == 0)
	goto lbl_error;
      if (dosave[0] == '^')
	goto Ext_file;
      fprintf (Out, "\tgoto %s;\n\n", dosave);

      if (POST_flg) {
	  fprintf (Out, "\t} /* post conditional */\n");
	  POST_flg = 0;
	  }

      goto next_cmnd;

/****************************************************************************
*******
******* error
*******
****************************************************************************/

parse_err:

      ernbr = ierr;
      printf ("\n*** %d Expression error\n", ernbr);
      goto abrt1;

indirect_err:

      ernbr = 72;
      printf ("\n*** Indirection not permitted here\n");
      goto abrt1;

lbl_error:

      ernbr = 8;
      printf ("\n*** 8 Label or file not found\n");
      goto abrt1;

do_error:

      ernbr = 8;
      printf ("\n*** Post-conditional not permitted here\n");
      goto abrt1;

Ext_file:

      ernbr = 8;
      printf ("\n*** Attempt to branch to external file\n");
      goto abrt1;

default:
command:

      ernbr = 13;
      printf ("\n*** 13 Command Error\n");
      goto abrt1;

arg_list_error:

      ernbr = 14;
      printf ("\n*** 14 Argument list error\n");
      goto abrt1;

ref_err:

      ernbr = 18;
      printf ("\n*** 18 Reference error\n");
      goto abrt1;

abrt1:

      printf ("*** In or near line %d\n", lines);
      printf ("*** %s\n", &pd1[pd1Last]);
      ExitCode = ernbr;
      goto abrtx;

    }				/* command switch */

}

void fcninit () {

  Sysout ( "// Intermediate temporary variables used during execution of string expressions\n");
  Sysout ( "// Experience indicates that typical programs use at one time as many as 16 temps\n");
  Sysout ( "// Temporaries in excess of 16 are allocated dynamically.\n\n");

  Sysout ( "char tmp0[1024],  tmp1[1024],  tmp2[1024],  tmp3[1024],  tmp4[1024],  tmp5[1024];\n");
  Sysout ( "char tmp6[1024],  tmp7[1024],  tmp8[1024],  tmp9[1024],  tmp10[1024], tmp11[1024];\n");
  Sysout ( "char tmp12[1024], tmp13[1024], tmp14[1024], tmp15[1024], *tmp16,      *tmp17,  *tmp18,  *tmp19;\n");
  Sysout ( "char *tmp20,      *tmp21,      *tmp22,      *tmp23,      *tmp24,      *tmp25,  *tmp26,  *tmp27;\n");
  Sysout ( "char *tmp28,      *tmp29,      *tmp30,      *tmp31,      *tmp32,      *tmp33,  *tmp34,  *tmp35;\n");
  Sysout_skip;

  linepad (Sysout ( "char _ftmp[1024];"), "Special purpose temporary");
  Sysout_skip;

  linepad ( Sysout ( "char *for1_incr=NULL,  *for1_lim=NULL,  *for1_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for2_incr=NULL,  *for2_lim=NULL,  *for2_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for3_incr=NULL,  *for3_lim=NULL,  *for3_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for4_incr=NULL,  *for4_lim=NULL,  *for4_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for5_incr=NULL,  *for5_lim=NULL,  *for5_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for6_incr=NULL,  *for6_lim=NULL,  *for6_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for7_incr=NULL,  *for7_lim=NULL,  *for7_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for8_incr=NULL,  *for8_lim=NULL,  *for8_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for9_incr=NULL,  *for9_lim=NULL,  *for9_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for10_incr=NULL, *for10_lim=NULL, *for10_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for11_incr=NULL, *for11_lim=NULL, *for11_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for12_incr=NULL, *for12_lim=NULL, *for12_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for13_incr=NULL, *for13_lim=NULL, *for13_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for14_incr=NULL, *for14_lim=NULL, *for14_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for15_incr=NULL, *for15_lim=NULL, *for15_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for16_incr=NULL, *for16_lim=NULL, *for16_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for17_incr=NULL, *for17_lim=NULL, *for17_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for18_incr=NULL, *for18_lim=NULL, *for18_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for19_incr=NULL, *for19_lim=NULL, *for19_init=NULL;"), "Temps for nested FORs");
  linepad ( Sysout ( "char *for20_incr=NULL, *for20_lim=NULL, *for20_init=NULL;"), "Temps for nested FORs");
  Sysout_skip;

  Sysout ( "char _dummy[1024];\n");
  fprintf (Out, "unsigned char atmp[1024];\n");
  fprintf (Out, "unsigned char gtmp[1024];\n");
  fprintf (Out, "unsigned char gtmpL[1024];\n");
  fprintf (Out, "unsigned char tmp[1024];\n");
  Sysout_skip;
  fprintf (Out, "unsigned char *_Arg0=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg1=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg2=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg3=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg4=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg5=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg6=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg7=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg8=NULL; // Argument list\n");
  fprintf (Out, "unsigned char *_Arg9=NULL; // Argument list\n");
  Sysout_skip;
  fprintf (Out, "unsigned char *_ReturnVal=NULL; // functio returns\n");
  fprintf (Out, "int _ArgCount=0; //Number of arguments to extrinsic\n");
  fprintf (Out, "long i,_j,_k,_new;\n");
  fprintf (Out, "int f=0;\n\n");

  Sysout_skip;
  fprintf (Out, "in_file[5]=stdin;\n");
  fprintf (Out, "out_file[5]=stdout;\n");

  return;
}

void epi () {
  fprintf (Out, "\n");
  fprintf (Out,
	   "//=================================================================================\n");
  linepad (fprintf (Out, "_epilogue:   tmp0[0]=0; tmp1[0]=0;"),
	   "Function Epilogue");
  linepad (fprintf (Out, "             global(GCLOSE,tmp0,tmp1);"),
	   "Close Globals");
  linepad (fprintf (Out, "             return 0; }"), "Terminate");
  fprintf (Out,
	   "//=================================================================================\n\n");
}
