//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+   
//#+     Mumps Compiler Support Library
//#+     Copyright (C) 2000 by Kevin C. O'Kane  
//#+
//#+     Kevin C. O'Kane
//#+     okane@cs.uni.edu
//#+     anamfianna@earthlink.net
//#+     http://www.cs.uni.edu/~okane
//#+
//#+
//#+ This program is free software; you can redistribute it and/or modify
//#+ it under the terms of the GNU General Public License as published by
//#+ the Free Software Foundation; either version 2 of the License, or
//#+ (at your option) any later version.
//#+ 
//#+ This program is distributed in the hope that it will be useful,
//#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
//#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//#+ GNU General Public License for more details.
//#+ 
//#+ You should have received a copy of the GNU General Public License
//#+ along with this program; if not, write to the Free Software
//#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ This software is covered by the GPL - Not the LGPL.
//#+
//#+ A consequence of this is that if this code is incorporated
//#+ into another work, it causes that work to become covered by
//#+ the GNU GPL license. 
//#+
//#+ Contact the author for other licensing arrangements.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+    Some of this code was originally written in Fortran
//#+    which will explain the odd array and label usage,
//#+    especially arrays beginning at index 1.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+    Not all functions work at present.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//#+...............................................................
//#+    modify these file depending on your OS and desired features
//#+...............................................................

// #define SQL       //*** Permits SQL
// #define POSTGRES  //*** Permits PostgreSQL
#define INDIRECTION  //*** Permits indirection
// #define GCVT
// #define NEW_TREE
#define DELIM "\\"
#define BUF_PARSE
#define STEM
#define NORMAL

//#+............................................................................
//#+
//#+   **** READ THIS ****
//#+
//#+   unix:  set UNIX to 1 and set SYSTEM to UNIX, USYSTEM=UNIX
//#+   linux: set UNIX to 1,  SYSTEM to UNIX, USYSTEM=LINUX
//#+   DOS:   set UNIX to 0, SYSTEM to DOS, OS2 to 0, USYSTEM=DOS
//#+   OS/2:  set UNIX to 0; SYSTEM to DOS and OS2 to 1
//#+   use OS2 settings for DOS GNU compiler
//#+
//#+   BUF_PARSE    enables $ZWN, $ZWI and $ZWP functions
//#+   NORMAL       enable $ZA and $ZN functions
//#+   INDIRECTION  enables indirection - (uses about 50kb).
//#+   POSTGRES     enables postgreSQL (Linux only - untested with Unix)
//#+   SQL          enables ODBC SQL interface (DOS only)
//#+   STEM         enables word stemming
//#+   GCVT         enables gcvt if your library lacks gcvt()
//#+
//#+   NEW_TREE     enables temporary global array files (suitable if
//#+       your main data base is SQL.  Do not define for permanent globals. If 
//#+       defined, globals will be created and deleted for each run.  This is
//#+       suitable if you are using a SQL server for data base storage.
//#+
//#+   DELIM is the delimiter that separates columns in results retrieved
//#+       from PostgreSQL and stored in a global array.
//#+
//#+   SUB is defined if the routine being compiled is a subfunction.  Definition
//#+       of SUB prevents duplication of global symbols and reinclusion of
//#+       fcns.h
//#+
//#+   GBLPERMIT file access permissions for the two global array files.  Default
//#+       is rw-rw-rw
//#+
//#+   GBLBUF is the number of internal btree buffers.  Set small for quick
//#+       transactions, larger for longer global array file use.  Each page
//#+       is 1024 bytes.
//#+
//#+   UDAT and UKEY are the names to be used for the global array files.  They
//#+       may be set to any values accepted by your system in "open" functions.
//#+..............................................................................

#define OS2 0
#define UNIX 1
#define USYSTEM LINUX
#define DOS 2
#define SYSTEM UNIX

#define GBLPERMIT 0666
#define GBLBUF 20
#define UDAT "data.dat"
#define UKEY "key.dat"

//#+........................................................................

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>

#if SYSTEM==DOS
#include <mem.h>
#include <stdlib.h>
#include <unistd.h>
#include <io.h>
#include <dos.h>
#endif

#if SYSTEM==UNIX||SYSTEM==OS2
#include <sys/file.h>
#endif

#ifdef SQL
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#endif

#ifdef POSTGRES
#include <pgsql/libpq-fe.h>
#define _XOPEN_SOURCE
#include <unistd.h>
static PGconn *PG1;
PGresult *PR1;
#endif

#define LINEFEED '\012'
#define RETRIEVE 0
#define NEXT 2
#define KILL 3
#define INIT 6
#define OPEN 206
#define CLOSE 207
#define COMMA 208
#define COLON 210
#define STORE 1
#define XNEXT 8

#if USYSTEM==LINUX
long tell(int);
#endif

void lpad(unsigned char strin[], unsigned char strout[], short l);
void cannon(unsigned char a[]);
int  xindex(unsigned char source[], unsigned char ptrn[], short strt);
void keyfix(unsigned char *);

extern FILE *Out;
unsigned char v1d[1024], bd[1024], xd[1024];
int xpx, ierr, ierr1, cf;
int global (short g, unsigned char key[], unsigned char bd[]);
void Terminate();

unsigned char pd1[2048];
unsigned char setname[256];
int pd1len = 0;
int sdlim;
int t2 = 0;
int t0px = 0;
int symflg;
int kflg = 0;
int setpiece = 0;

void _select(unsigned char out[],
	     unsigned char *in1,
	     unsigned char *in2,
	     unsigned char *in3,
	     unsigned char *in4,
	     unsigned char *in5,
	     unsigned char *in6,
	     unsigned char *in7,
	     unsigned char *in8,
	     unsigned char *in9,
	     unsigned char *in10,
	     unsigned char *in11,
	     unsigned char *in12,
	     unsigned char *in13,
	     unsigned char *in14,
	     unsigned char *in15,
	     unsigned char *in16,
	     unsigned char *in17,
	     unsigned char *in18,
	     unsigned char *in19, unsigned char *in20);

void strcatx(unsigned char out[], unsigned char in[]) {
    strcat(out, in);
    strcat(out, "\x01");
    return;
    }

void _extract(unsigned char out[], unsigned char in[],
	      unsigned char start[], unsigned char len[]) {

    int i, j, k, n;

    i = atoi(start);
    j = atoi(len);

    if (i < 0) i = 0; else i--;

    if (j < 0) j = i; else j--;

    if (j < i) {
	strcpy(out, "");
	return;
      }

    if (i == 0 && j == 0) {
	out[0] = in[0];
	out[1] = '\0';
	return;
      }

    n = strlen(in);

    if (i > n) {
	strcpy(out, "");
	return;
      }

    if (j > n) j = n;
    for (k = 0; i <= j; i++) out[k++] = in[i];
    out[k] = 0;
    return;
    }

void _find(unsigned char out[], unsigned char in[],
	   unsigned char key[], unsigned char begin[]) {

    int i;
    i = atoi(begin);
    if (i < 0) i = 0;

    if (key[0] != 0) {
	if ((i = xindex(in, key, i)) > 0) i += strlen(key);
      }

    if (i > strlen(in) + 1) i = 0;

    sprintf(out, "%d", i);
    return;
    }

void _ascii(unsigned char out[], unsigned char in[], unsigned char begin[]) {

    int i;
    i = atoi(begin);
    if (i < 1) i = 1;

    if (i > strlen(in)) {
	strcpy(out, "-1");
	return;
      }

    i = in[i - 1];
    sprintf(out, "%d", i);
    return;
}

void _justify(unsigned char out[], unsigned char in[],
	      unsigned char w[], unsigned char p[]) {

    int l, k;
    char bd[1024], tmp2[32];
    double t1;
    l = atoi(w);
    strcpy(bd, in);

    if (strcmp(p, "-1") == 0) {
	k = strlen(bd);

	if (k >= l) {
	    strcpy(out, in);
	    return;
	    }

	if (l > 255) l = 255;
	lpad(bd, bd, l);
	strcpy(out, bd);
	return;
      }

    k = atoi(p);		/* arg 3 */
    sprintf(tmp2, "%c%d%c%dlf", '%', l, '.', k);
    t1 = atof(in);
    sprintf(bd, tmp2, t1);
    strcpy(out, bd);
    return;
}

void lpad(unsigned char strin[], unsigned char strout[], short l) {

    short int j, i, k;
    j = strlen(strin) - 1;
    k = (l - j - 1);
    if (k <= 0) return;
    for (i = j; i >= 0; i--) strout[i + k] = strin[i];
    strout[j + k + 1] = 0;
    for (i = 0; i < k; i++) strout[i] = ' ';
    return;
}

int xindex(unsigned char source[], unsigned char ptrn[], short strt) {

    short int flg = 0, i, j, k, l, istrt;

    for (i = 0; ptrn[i] != 0; i++); --i;
    for (j = 0; source[j] != 0; j++); --j;
    istrt = strt - 1;
    if (strt <= 1) istrt = 0;

    for (k = istrt; k <= j; k++) {
	for (l = 0; l <= i; l++) {
	    if (ptrn[l] != source[k + l]) {
		flg = 1;
		break;
	      }
	    }

	if (flg) {
	    flg = 0;
	    continue;
	    }

	return (k + 1);
      }
    return (0);
}

#ifdef GCVT

void gcvt(double x, int i, unsigned char a[]) {
    sprintf(a, "%g", x);
    return;
}

#endif

void cannon(unsigned char a[]) {

    int i, j, k;
    char tmp[25];

    i = 0;
    j = 0;

    while (a[i] == '+' || a[i] == '-') {
	if (a[i] == '-')
	    if (j == 0) j = 1;
	       else j = 0;
	i++;
      }

    if (i > 0) {
	if (j == 0) strcpy(a, &a[i]);
	else {
	    a[0] = '-';
	    if (i > 1) strcpy(&a[1], &a[i]);
	    }
      }

    j = -1;

    while (a[i] == '.' || (a[i] >= '0' && a[i] <= '9')) {
	if (a[i] == '.') j = i;
	i++;
      }

    if (i == 0) {
	a[0] = '0';
	a[1] = 0;
	return;
      }

    if (a[i] != 'E' && a[i] != 'e') a[i] = 0;

    if (a[i] == 0) {
	if (j >= 0) {
	    for (i--; a[i] == '0'; i--) a[i] = 0;
	    if (a[i] == '.') a[i] = 0;

	    if (i == 0) {
		a[0] = '0';
		a[1] = 0;
	      }
	    }

	if (a[0] == '-') j = 1;
	else j = 0;

	while (a[j] == '0') strcpy(&a[j], &a[j + 1]);

	if (a[j] == 0) {
	    a[0] = '0';
	    a[1] = 0;
	    }

	if (a[j] == '.' && a[j + 1] == 0) a[j] = '0';
	return;
    }

    if (a[i] != 'e' && a[i] != 'E') return;

    a[i] = 0;
    i++;

    if (a[i] == '-') {
	i++;
	j = 1;
      } 
    else {
	j = 0;
	if (a[i] == '+') i++;
      }

    for (k = 0; (tmp[k] = a[i]) != 0 && (tmp[k] >= '0' && tmp[k] <= '9');
	 (k++, i++));

    tmp[k] = 0;
    i = atoi(tmp);

    if (i > 0)
	if (j == 0) for (j = 1; j <= i; j++) mult(a, "10", a);
	else for (j = 1; j <= i; j++) mult(a, ".1", a);

    return;
}

int getstr1(FILE * opnfile, unsigned char area[]) {

    short int i, chr;

    for (i = 0; i < 1000; i++) {
	chr = fgetc(opnfile);

	if (chr == EOF) {
	    area[0] = 0;
	    return (-1);
	    }

	area[i] = chr;

	if (area[i] == LINEFEED) {
	    area[i] = 0;
	    return (i);
	    }

	if (area[i] > 127) area[i] = ' ';
	if (area[i] == '\n') i--;
	else if (area[i] == '\r') i--;
	else if (area[i] == '\t') area[i] = '\t';
	else if (area[i] < 32) area[i] = ' ';
      }

    area[1000] = 0;
    return (-1);
    }

struct stab {
    char *name;
    struct stab *next;
    char *data;
    int size;
    int copy;
    };

static struct stab *start[SYM_MAX] = { NULL };

struct nmes {
    char *name;
    struct nmes *next;
    } *nstart;

char *sym_(int symflg, unsigned char *a, unsigned char *b) {

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+                                                            
//#+  Run Time Symbol Table.  All mumps local variables
//#+  are created and stored here.  First argument is the
//#+  operation code, second is the variable name (including
//#+  array marker information) and the third is the incoming
//#+  value to be stored or a result being sent back.
//#+                                                            
//#+    symflg= 1 retrieve                                              
//#+    symflg= 0 store/create                                  
//#+    symflg= 2 delete explicit                                       
//#+    symflg= 3 $next on last argument                                
//#+    symflg= 4 kill all                                              
//#+    symflg= 5 kill all except...                            
//#+    symflg= 6 $data
//#+    symflg= 7 New except (...)
//#+    symflg= 8 New inclusive
//#+    symflg= 9 No copy flag
//#+                                                            
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    char key[1024];
    struct stab *p1, *p2, *p3;
    int i;

    if (a == NULL) return NULL;

    strcpy(key, a);
    keyfix(key);

    if (symflg == 0) {		/* store */
	p2 = NULL;
	p3 = start[_Sym];

	while (p3 != NULL) {
	    if (strcmp(p3->name, key) >= 0) break;
	    p2 = p3;
	    p3 = p3->next;
	    }

	if (p3 == NULL && p2 == NULL) {	/* empty list */
	    p1 = (struct stab *) malloc(sizeof(struct stab));
	    if (p1 == NULL) {
		printf("*** Out of memory in or near %d\n\n",LineNumber);
		exit(1);
	      }

	    p1->name = (char *) malloc(strlen(key) + 1);
	    if (p1->name == NULL) {
		printf("*** Out of memory in or near %d\n\n",LineNumber);
		exit(1);
	      }

	    strcpy(p1->name, key);
	    p1->size = strlen(key);
	    p1->next = NULL;
	    start[_Sym] = p1;
	    p1->data = (char *) malloc(strlen(b) + 1);

	    if (p1->data == NULL) {
		printf("*** Out of memory in or near %d\n\n",LineNumber);
		exit(1);
	      }

	    strcpy(p1->data, b);
	    p1->copy = 0;
	    symflg = 1;
	    return (char *) p1;
	    }

	if (p3 != NULL && strcmp(p3->name, key) == 0) {
	    if (p3->size >= strlen(b)) strcpy(p3->data, b);

	    else {
            free(p3->data);
            p3->data = (char *) malloc(strlen(b) + 1);

            if (p3->data == NULL) {
      		printf("*** Out of memory in or near %d\n\n",LineNumber);
                  exit(1);
                  }

		strcpy(p3->data, b);
		p3->size = strlen(b);
	      }
	    symflg = 1;
	    return (char *) p3;
	    }

	p1 = (struct stab *) malloc(sizeof(struct stab));

	if (p1 == NULL) {
            printf("*** Out of memory in or near %d\n\n",LineNumber);
            exit(1);
            }

	p1->name = (char *) malloc(strlen(key) + 1);

	if (p1->name == NULL) {
            printf("*** Out of memory in or near %d\n\n",LineNumber);
            exit(1);
            }

	strcpy(p1->name, key);
	p1->size = strlen(key);
	p1->next = p3;
	if (p2 != NULL) p2->next = p1;
	else start[_Sym] = p1;
	p1->data = (char *) malloc(strlen(b) + 1);

	if (p1->data == NULL) {
            printf("*** Out of memory in or near %d\n\n",LineNumber);
            exit(1);
            }

	strcpy(p1->data, b);
	p1->copy = 0;
	symflg = 1;
	return (char *) p1;
      }

    if (symflg == 1 || symflg==9) { //* retrieve or zero copy flag
	p1 = start[_Sym];

	while (p1 != NULL) {
	    if (strcmp(p1->name, key) == 0) break;
	    p1 = p1->next;
	    }

	if (p1 == NULL) {
            if (symflg==9) { 
                  symflg=0;
                  return NULL;
                  }
            symflg = 0;
            b[0] = 0;
            return NULL;
            }

      if (symflg==9) {
	      symflg = 1;
            p1->copy=0;
            return NULL;
            }
	symflg = 1;
	strcpy(b, p1->data);
	return p1->data;
      }

    if (symflg == 3) {		/* next */
	p1 = start[_Sym];
	p2 = NULL;
	i = strlen(key);

	if (key[i - 3] == '-' && key[i - 2] == '1' && key[i - 1] == 1) {
	    key[i - 3] = 1;
	    key[i - 2] = 0;
	    i = i - 2;
	    }

	while (p1 != NULL) {
	    if (strncmp(p1->name, key, i) >= 0) break;
	    p2 = p1;
	    p1 = p1->next;
	    }

	if (p1 == NULL) {
	    strcpy(b, "-1");
	    symflg = 1;
	    return bd;
	    }

	if (strncmp(p1->name, key, i) > 0) goto end;

	p1 = p1->next;
	while (p1 != NULL) {
	    if (strncmp(p1->name, key, i) != 0) break;
	    p1 = p1->next;
	    }

	if (p1 == NULL) {
	    strcpy(b, "-1");
	    symflg = 1;
	    return bd;
	    }

end:  

      i = strlen(p1->name) - 2;
	for (; p1->name[i] != 1; i--);
	strcpy(b, p1->name + i + 1);
	b[strlen(b) - 1] = 0;
	while (b[0] == ' ') strcpy(b, &b[1]);
	symflg = 1;
	return bd;
      }

    if (symflg == 2) {		/* kill selected */

repeat:

	p1 = start[_Sym];
	p2 = NULL;
	i = 0;

	i = strlen(key);

	while (p1 != NULL) {
	    if (strncmp(p1->name, key, i) == 0 && p1->name[i] == 1) break;
	    else if (strcmp(p1->name, key) == 0) break;
	    p2 = p1;
	    p1 = p1->next;
	    }

	if (p1 == NULL) {
	    symflg = 1;
	    return NULL;
	    }

	if (p2 == NULL) start[_Sym] = p1->next;
	else p2->next = p1->next;
	free(p1->data);
	free(p1->name);
	free(p1);
	goto repeat;
      }

    if (symflg == 4) {		/* kill all */
	p1 = start[_Sym];
	while (p1 != NULL) {
	    p2 = p1->next;
	    free(p1->data);
	    free(p1->name);
	    free(p1);
	    p1 = p2;
	    }
	start[_Sym] = NULL;
	symflg = 1;
	return NULL;
      }

    if (symflg == 5) {		/* kill all except... */

	struct nmes *np1;
	int flg;

	p1 = start[_Sym];
	p3 = NULL;
	while (p1 != NULL) {
            np1 = nstart;
            flg = 0;
            while (np1 != NULL) {

                  i=strlen(np1->name)-1;

      		if ( (strncmp(np1->name, p1->name,i) == 0 && p1->name[i]==1) 
                       ||
                       (strcmp(np1->name, p1->name)==0) ) {
                        p3 = p1;
                        p1 = p1->next;
                        flg = 1;                //* don't delete p1
                        break;
                        }
      		np1 = np1->next;
                  }
        
            if (flg) continue;
            free(p1->data);
            free(p1->name);
            p2 = p1->next;
            free(p1);
            if (p3 == NULL) start[_Sym] = p2;
            else p3->next = p2;
            p1 = p2;
            }

  np1=nstart; 
  while (np1!=NULL) {
      struct nmes * np2;
      np2=np1->next; 
      free (np1->name);       //* cleanup
      free (np1); 
      np1=np2;
      }

  symflg = 1;
  return NULL;
  }

    if (symflg == 6) {  //* $data */

	p1 = start[_Sym];

	while (p1 != NULL) {
	    if (strcmp(p1->name, key) == 0) break;
	    p1 = p1->next;
	    }

	if (p1 == NULL) {	/* search fail */

	    i = strlen(key);

	    p1 = start[_Sym];
	    while (p1 != NULL) {
		if (strncmp(p1->name, key, i) == 0) break;
		p1 = p1->next;
	      }

	    if (p1 != NULL) {
		b[0] = '1';
		b[1] = '0';
		b[2] = 0;
		return bd;
	      }

	    b[0] = '0';
	    b[1] = 0;
	    return bd;
          }

	b[0] = '1';		/* exists */

	p1 = p1->next;

	if (p1 == NULL) {	/* no possible descendants */
	    b[1] = 0;
	    return bd;
	    }

	i = strlen(key);

	if (strncmp(key, p1->name, i) == 0) {
	    b[1] = '1';
	    b[2] = 0;
	    return bd;
	    }

	b[1] = 0;
	return bd;

      }

    if (symflg == 7) {        //* New except (...)

	struct nmes *np1;
	int flg;

	p1 = start[_Sym];
      _Sym++;
      start[_Sym]=NULL;
	p3 = NULL;
	while (p1 != NULL) {
            np1 = nstart;
            flg = 1;
            while (np1 != NULL) {

                  i=strlen(np1->name)-1;

      		if ( (strncmp(np1->name, p1->name,i) == 0 && p1->name[i]==1) 
                       ||
                       (strcmp(np1->name, p1->name)==0) ) {
                        p3 = p1;
                        p1 = p1->next;
                        flg = 0;                //* copy p1 to new symtab
                        break;
                        }
      		np1 = np1->next;
                  }
        
            if (flg) {
                  p1 = p1 -> next;
                  continue;
                  }

            p2= (struct stab *) sym_(0,p3->name,p3->data);
            if (p2!=NULL) p2->copy=1;
            }

  np1=nstart; 
  while (np1!=NULL) {
      struct nmes * np2;
      np2=np1->next; 
      free (np1->name);       //* cleanup
      free (np1); 
      np1=np2;
      }

  symflg = 1;
  return NULL;
  }

    if (symflg == 8) {        //* New inclusive

	p1 = start[_Sym];
      _Sym++;
      start[_Sym]=NULL;

	while (p1 != NULL) {
            p2 = (struct stab *) sym_(0,p1->name,p1->data);
            if (p2!=NULL) p2->copy=1;
            p1 = p1 -> next;
            }

  symflg = 1;
  return NULL;
  }

}

int _SymFree(int i) {

      struct stab *p1, *p2;

      p1 = start[_Sym];
      start[_Sym] = NULL;
      if (i) _Sym--;
      while (p1 != NULL) {
            if (p1->copy) sym_(0, p1->name, p1->data);	// copy to prior layer
            free(p1->name);
            free(p1->data);
            p2 = p1->next;
            free(p1);
            p1 = p2;
            }
      return 0;
      }

#if UNIX==1

void ltoa(long i, char *s, int x) {
    sprintf(s, "%d", i);
    return;
    }

#endif

//#+=====================================
//#+ add numeric contents of two strings.
//#+=====================================

void add(char *a, char *b, char *c) {

    double aa, bb, cc;
    char *p;
    int i;

    for (p = a; *p != 0; *p++)
	if (*p == '.') goto flt;

    for (p = b; *p != 0; *p++)
	if (*p == '.') goto flt;

    sprintf(c, "%ld", atol(a) + atol(b));
    return;

flt:

    aa = atof(a);
    bb = atof(b);
    cc = aa + bb;
    gcvt(cc, 7, c);
    return;
    }

//#+=====================================
//#+ sub numeric contents of two strings.
//#+=====================================

void sub(char *a, char *b, char *c) {

    double aa, bb, cc;
    char *p;
    int i;

    for (p = a; *p != 0; *p++)
	if (*p == '.') goto flt;

    for (p = b; *p != 0; *p++)
	if (*p == '.') goto flt;

    sprintf(c, "%ld", atol(a) - atol(b));
    return;

flt: 

      aa = atof(a);
      bb = atof(b);
      cc = aa - bb;
      gcvt(cc, 7, c);
      return;
      }

//#+=====================================
//#+ mult numeric contents of two strings.
//#+=====================================

void mult(char *a, char *b, char *c) {
    double aa, bb, cc;

    aa = atof(a);
    bb = atof(b);
    cc = aa * bb;
    gcvt(cc, 7, c);
    return;
}

//#+=====================================
//#+ div numeric contents of two strings.
//#+=====================================

void divx(char *a, char *b, char *c)
{

    double aa, bb, cc;

    aa = atof(a);
    bb = atof(b);
    cc = aa / bb;
    gcvt(cc, 7, c);
    return;
}

//#+=====================================
//#+ exp numeric contents of two strings.
//#+=====================================

void expx(char *a, char *b, char *c)
{

    double aa, bb, cc;

    aa = atof(a);
    bb = atof(b);
    cc = pow(aa, bb);
    gcvt(cc, 7, c);
    return;
}

//#+=========================================
//#+ compare numeric contents of two strings.
//#+=========================================

int numcomp(unsigned char *aa, unsigned char *bb)
{

    double a, b;
    char *p;
    long i, j;

    for (p = aa; *p != 0; *p++)
	if (*p == '.') goto flt;

    for (p = bb; *p != 0; *p++)
	if (*p == '.') goto flt;

    i = atol(aa);
    j = atol(bb);
    if (i < j) return (-1);
    if (i > j) return (1);
    return (0);

flt:

    a = atof(aa);
    b = atof(bb);
    if (a < b) return (-1);
    if (a > b) return (1);
    return (0);
}

void substr(unsigned char in[], unsigned char out[], int start, int len) {

    short i;

    if (len == 0) {
	out[0] = 0;
	return;
      }

    if (len < 0) len = 255;
    else if (len > 255) len = 255;
    start--;
    len--;
    for (i = 0; i <= len; i++) out[i] = in[start++];
    out[len + 1] = 0;
    return;
}

#if UNIX==1

void itoa(int val, unsigned char *str, int rad) {
    sprintf(str, "%d", val);
    return;
    }

#endif

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+ Data Base Interface
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

int sql(char *DataSourceName,
	char *User, char *Password, char *Command, char *MumpsArray)
{

#ifdef SQL

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ WindowsXX SQL ODBC Section - 
//#+ See below for PostgreSQL Interface.
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    HENV env;
    HDBC dbc;
    HSTMT stmt;
    UCHAR *x[90];
    SWORD cb1;
    UCHAR err[160];
    SWORD cols = 0;

    int r, i, j, tpl;
    unsigned char gbl[512];

    SQLAllocEnv(&env);

    i = SQLAllocConnect(env, &dbc);

    if (i != SQL_SUCCESS) {

	printf("\n*** SQLAllocConnect error in or near line %d\n",LineNumber);

	if (i == SQL_ERROR) {
	    SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err, sizeof(err), NULL);
	    printf("\n*** Error: %s\n", err);
	}

	return -1;
    }

    i = SQLConnect(dbc,
		   DataSourceName, SQL_NTS,
		   User, SQL_NTS, Password, SQL_NTS);

    if (i != SQL_SUCCESS) {
	printf("\n*** SQLConnect Error in or near line %d\n",LineNumber);
	printf("\n*** DataSourceName %s\n", DataSourceName);
	printf("\n*** User %s\n", User);
	printf("\n*** Password %s\n", Password);

	if (i == SQL_ERROR) {
	    SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err, sizeof(err), NULL);
	    printf("\n*** Error: %s\n", err);
	    }
	return -1;
      }

    i = SQLSetConnectOption(dbc, SQL_AUTOCOMMIT, FALSE);

    if (i != SQL_SUCCESS) {
	printf("\n*** SQLSetConnect Error in or near line %d\n",LineNumber);
	if (i == SQL_ERROR) {
	    SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err,
		     sizeof(err), NULL);
	    printf("\n*** Error: %s\n", err);
	    }
	return -1;
      }

    i = SQLAllocStmt(dbc, &stmt);

    if (i != SQL_SUCCESS) {
	printf("\n*** SQLAllocStmt Error in or near line %d\n",LineNumber);
	if (i == SQL_ERROR) {
	    SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err,
		     sizeof(err), NULL);
	    printf("\n*** Error: %s\n", err);
	    }
	return -1;
      }

    i = SQLExecDirect(stmt, Command, SQL_NTS);

    if (i != SQL_SUCCESS && i != SQL_SUCCESS_WITH_INFO) {
	unsigned char err1[128];
	SDWORD err2;
	printf("\n*** SQLExecDirect Error");
	SQLError(env, dbc, stmt, err1, &err2, err, sizeof(err), NULL);
	printf("\n*** Error: %s\n", err);
	return -1;
      }

    if (strlen(MumpsArray) == 0) {	//#+ No array name passed
	i = SQLTransact(env, dbc, SQL_COMMIT);
	if (i != SQL_SUCCESS) {
	    printf("\n*** SQLExecDirect Error in or near line %d\n",LineNumber);
	    if (i == SQL_ERROR) {
		SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err, sizeof(err), NULL);
		printf("\n*** Error: %s\n", err);
	      }
	    return -1;
	    }
	goto exit;
    }

//#+ 
//#+ Retrieve number of colomns
//#+

    i = SQLNumResultCols(stmt, &cols);

    if (i != SQL_SUCCESS) {
	printf("\n*** SQLNumResultCols Error\n");
	if (i == SQL_ERROR) {
	    SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err,
		     sizeof(err), NULL);
	    printf("\n*** Error: %s\n", err);
	    }
	return -1;
      }

//#+ 
//#+ Allocate and bind memory for column data
//#+ 

    for (j = 0; j < cols; j++) {
	x[j] = (UCHAR *) malloc(512);
	i = SQLBindCol(stmt, j + 1, SQL_C_CHAR, x[j], 50, &cb1);

	if (i != SQL_SUCCESS) {
	    printf("\n*** SQLBindCol Error\n");
	    if (i == SQL_ERROR) {
		SQLError(env, dbc, SQL_NULL_HSTMT, NULL, NULL, err,
			 sizeof(err), NULL);
		printf("\n*** Error: %s\n", err);
	      }
	    return -1;
	    }
      }

//#+ 
//#+ Retrieve rows and store in global
//#+ 

    r = 0;
    tpl = 0;
    while (1) {

	char ct[32];
	char val[1024];
	unsigned char *item;
	int ii;

//#+ 
//#+ Build global array name
//#+ 

	strcpy(gbl, MumpsArray);
	tpl++;
	sprintf(ct, "%d\x00", tpl);
	for (ii = 0; gbl[ii] != 0; ii++);
	gbl[ii] = 1;
	gbl[ii + 1] = 0;	//#+ Coded delimiters
	strcat(gbl, ct);
	for (ii = 0; gbl[ii] != 0; ii++);
	gbl[ii] = 1;
	gbl[ii + 1] = 0;	//#+ Coded delimiters

//#+ 
//#+ Fetch next row
//#+ 

	i = SQLFetch(stmt);
	if (i != SQL_SUCCESS) break;
	i = 0;

	for (j = 0; j < cols; j++) i = strlen(x[j]) + i;

	if (i + strlen(gbl + j) > 500) {
	    printf("\n*** SQL Overflow\n");
	    printf("\n*** Row too long\n");
	    return -1;
	    }

	strcpy(val, "");

	for (j = 0; j < cols; j++) {
	    strcat(val, x[j]);
	    strcat(val, DELIM);
	    }

	r++;
	global (1, gbl, val);
      }

/* SQLTransact( env, dbc, SQL_ROLLBACK ); */
/* SQLTransact( env, dbc, SQL_COMMIT ); */

  exit:

    SQLFreeStmt(stmt, SQL_DROP);
    SQLDisconnect(dbc);
    SQLFreeConnect(dbc);
    SQLFreeEnv(env);

    if (cols > 0)
	for (j = 0; j < cols; j++) free(x[j]);

    bd[1] = 0;
    return r;			//#+ Number of rows

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+++++++++++++ End of ODBC Interface ++++++++++++++++++++++++++++++++++
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#elifdef POSTGRES

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ PostgreSQL Interface Section
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include <pgsql/libpq-fe.h>
#define _XOPEN_SOURCE
#include <unistd.h>

    unsigned char gbl[512];
    PGconn *p1;
    PGresult *p2;
    int i, j, nt, nf;

    p1 = PQsetdbLogin(NULL,	//pghost
		      NULL,	//pgport
		      NULL,	//pgoptions
		      NULL,	//pgtty
		      DataSourceName,	//dbname
		      NULL,	//login
		      NULL);	//pwd

    if (p1 == NULL) {
	printf("*** Null connect\n");
	return -1;
      }

    p2 = PQexec(p1, Command);

    if (p2 == NULL) {
	printf("*** Null result\n");
	printf("%s\n", PQerrorMessage(p1));
	return -1;
      }

    if (strlen(MumpsArray) > 0 && PQresultStatus(p2) == PGRES_TUPLES_OK) {

//#+===================================================================
//#+ The following section copies the PostgreSQL results to a Mumps
//#+ global array (MumspArray).  By default, it places successive
//#+ rows retrieved from the server into successive array elements.
//#+ Thus, if MumpsArray="Test", the results will be in ^Test(1),
//#+ ^Test(2), ... ^Test(n) where "n" is the returned value from
//#+ $zodbc.  Columns form the server concatenated with one another
//#+ with an intervening delimiter.  Use $piece to separate.
//#+===================================================================

	nt = PQntuples(p2);
	nf = PQnfields(p2);
	for (i = 0; i < nt; i++) {
	    char ct[32];
	    char val[1024];
	    unsigned char *item;
	    int ii;
	    strcpy(gbl, MumpsArray);
	    sprintf(ct, "%d\x00", i + 1);
	    for (ii = 0; gbl[ii] != 0; ii++);
	    gbl[ii] = 1;
	    gbl[ii + 1] = 0;
	    strcat(gbl, ct);
	    for (ii = 0; gbl[ii] != 0; ii++);
	    gbl[ii] = 1;
	    gbl[ii + 1] = 0;

	    strcpy(val, "");
	    for (j = 0; j < nf; j++) {
		item = PQgetvalue(p2, i, j);
		strcat(val, item);
		strcat(val, DELIM);
	      }
	    global (1, gbl, val);
	    }
      }

    PQfinish(p1);
    ierr = 0;
    return nt;

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#++++++++++++ End of PostgreSQL Interface +++++++++++++++++++++++++++++
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#else
    return 0; // Function is empty and returns 0 if both SQL and POSTGRES are 0
#endif
}


int pm(unsigned char s[], unsigned char p[]) {
    strcpy(&bd[1], p);
    bd[0] = 0;
    return (patrn(s));
}

match(pts, lx, ct, ad, rslt)

short *rslt, pts[3][20], ct[], lx;
unsigned char ad[];

{
    unsigned char tmp[2], tmp1[1024], tmp2[1024];
    short ptr, i, j;
    ptr = (-1);
    *rslt = 0;
    tmp[1] = 0;
    for (i = 1; i <= lx; i++) {
      if (ct[i] == 0) continue;
	switch (bd[pts[1][i]]) {

case 'C':
case 'c':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] < 32) continue;
		if (ad[ptr] == 127) continue;
		return;
	      }
	    break;

case 'N':
case 'n':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] >= '0' && ad[ptr] <= '9') continue;
		return;
	      }			/* for j=... */
	    break;

case 'P':
case 'p':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		tmp[0] = ad[ptr];
		if (xindex(" !\"#$%&''()*+,-./:;<=>?@[\\]^_`{|}~", tmp, 1) > 0) continue;
		return;
	      }			/* for j=... */
	    break;

case 'A':
case 'a':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] >= 65 && ad[ptr] <= 90) continue;
		if (ad[ptr] >= 97 && ad[ptr] <= 122) continue;
		return;
	      }			/* for j... */
	    break;

case 'L':
case 'l':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] >= 97 && ad[ptr] <= 122) continue;
		return;
	      }			/*for j=... */
	    break;

case 'U':
case 'u':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] >= 65 && ad[ptr] <= 90) continue;
		return;
	      }			/* for j=... */
	    break;

case 'E':
case 'e':

	    for (j = 1; j <= ct[i]; j++) {
		ptr++;
		if (ptr > strlen(ad)) return;
		if (ad[ptr] > 127) return;
	      }
	    break;

case '"':

	    for (j = 1; j <= ct[i]; j++) {
		if (pts[2][i] == 0) continue;
		if (ptr + pts[2][i] - 1 > strlen(ad)) return;
		ptr++;
		substr(&ad[ptr], tmp1, 1, pts[2][i] - 1);
		substr(&bd[1], tmp2, pts[1][i] + 1, pts[2][i] - 1);
		if (strcmp(tmp2, tmp1) != 0) return;
		ptr = ptr + strlen(tmp1) - 1;
	      }
	    break;

default:

	    return;
	    }
    }				/* for i=... */

    if (ptr + 1 != strlen(ad)) return;
    *rslt = 1;
    return;
}				/* match() */

int patrn(unsigned char ad[]) {

    unsigned char indef, tmp[10];
    short iptr, k, j, i, m, pts[3][20], lx, count[20], ct2[20], stk[20], stx;
    short high[20], low[20], lad;

    indef = 0;
    lx = 0;
    lad = strlen(ad);
    for (i = 0; i < 20; i++) {
	high[i] = lad;
	low[i] = 0;
      }

    for (i = 1; i <= strlen(&bd[1]); i++) {

	lx++;
	if (bd[i] < '0' || bd[i] > '9') {
	    if (bd[i] != '.') i--;
	    count[lx] = (-1);
	    indef = 1;
	    i++;
	    if (bd[i] >= '0' && bd[i] <= '9') {
		j = i;
		while (bd[i] >= '0' && bd[i] <= '9') i++;
		substr(&bd[1], tmp, j, i - j);
		cannon((char *) tmp);
		high[lx] = atoi(tmp);
	      }
	}

	else {
	    j = i;
	    while (bd[i] >= '0' && bd[i] <= '9')
		i++;
	    substr(&bd[1], tmp, j, i - j);
	    cannon(tmp);
	    count[lx] = atoi(tmp);
	    if (bd[i] == '.') {
		low[lx] = count[lx];
		count[lx] = -1;
		indef = 1;
		i++;
		if (bd[i] >= '0' && bd[i] <= '9') {
		    j = i;
		    while (bd[i] >= '0' && bd[i] <= '9')
			i++;
		    substr(&bd[1], tmp, j, i - j);
		    cannon(tmp);
		    high[lx] = atoi(tmp);
		}
	    }
	}

	if (bd[i] != '"') {
	    tmp[0] = bd[i];
	    tmp[1] = 0;
	    if (xindex("cnpalue", tmp, 1) == 0 &&
		xindex("CNPALUE", tmp, 1) == 0)
		goto err;
	    pts[1][lx] = i;
	    pts[2][lx] = 1;
	    continue;
	}
	j = i;
	if (bd[j + 1] == '"') {
	    j++;
	    pts[1][lx] = i;
	    pts[2][lx] = 0;
	    i = j;
	    continue;
	}

      a108:if (bd[++j] == 0)
	    goto err;
	if (bd[j] != '"') {
	    if (bd[j] == 210)
		bd[j] = '"';
	    goto a108;
	}
	pts[1][lx] = i;
	pts[2][lx] = j - i;
	i = j;
    }

    if (indef != 1) {
	match(pts, lx, count, ad, &j);
	if (j == 0)
	    return (0);
	if (j == 1)
	    return (1);
	printf("*** Pattern match error\n");
      Terminate();
    }

    stx = 0;
    for (i = 1; i <= lx; i++) {
	if (count[i] < 0)
	    stk[++stx] = i;
    }
    for (i = 1; i <= lx; i++) {
	if (count[i] >= 0)
	    ct2[i] = count[i];
	else
	    ct2[i] = low[i];
    }
    iptr = stx;
    goto retry1;

retry:

      ct2[stk[1]]++;

retry1:

      if (ct2[stk[1]] > lad || ct2[stk[1]] > high[stk[1]]) {
	ct2[stk[1]] = low[stk[1]];
	m = 2;
	if (stx == 1) return (0);
	ct2[stk[m]]++;
      recount:if (ct2[stk[m]] > lad || ct2[stk[m]] > high[stk[m]]) {
	    if (m >= stx) return (0);
	    ct2[stk[m]] = low[stk[m]];
	    m++;
	    ct2[stk[m]]++;
	    goto recount;
	}
    }
    k = 0;
    for (j = 1; j <= lx; j++)
	k = k + ct2[j];
    if (k > lad) goto retry;
    match(pts, lx, ct2, ad, &j);
    if ((ierr1 = j) == 1) return (1);
    goto retry;

err:

    ierr1 = 99;
    printf("*** Pattern match error\n");
    Terminate();
}

void _length(unsigned char out[], unsigned char in[], unsigned char key[]) {

    int i, j, k;
    if (strlen(key)) {
	i = 1;
	j = 0;
	k = strlen(key);
	while ((i = xindex(in, key, i)) != 0) {
	    j++;
	    i += k;
	}
	sprintf(out, "%d", j + 1);
	return;
      }
    sprintf(out, "%d", strlen(in));
    return;
}

void _horolog(unsigned char in[]) {

    long day, timex, fd;
    char tmp2[64];

#if UNIX==0
    timezone = 0;
    daylight = 0;
#endif

    timex = time(&timex);
    day = timex / 86400;
    timex = timex - (day * 86400);
    day = 47118 + day;
    fd = day;
    sprintf(in, "%ld", fd);
    strcat(in, ",");
    fd = timex;
    sprintf(tmp2, "%ld", fd);
    strcat(in, tmp2);
    return;
}

void _select(unsigned char out[],
	     unsigned char *in1,
	     unsigned char *in2,
	     unsigned char *in3,
	     unsigned char *in4,
	     unsigned char *in5,
	     unsigned char *in6,
	     unsigned char *in7,
	     unsigned char *in8,
	     unsigned char *in9,
	     unsigned char *in10,
	     unsigned char *in11,
	     unsigned char *in12,
	     unsigned char *in13,
	     unsigned char *in14,
	     unsigned char *in15,
	     unsigned char *in16,
	     unsigned char *in17,
	     unsigned char *in18, 
           unsigned char *in19, 
           unsigned char *in20) {

    if (atol(in1) != 0) {
	strcpy(out, in2);
	return;
      }

    if (in3 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in3) != 0) {
	strcpy(out, in4);
	return;
      }

    if (in5 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in5) != 0) {
	strcpy(out, in6);
	return;
      }

    if (in7 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in7) != 0) {
	strcpy(out, in8);
	return;
      }

    if (in9 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in9) != 0) {
	strcpy(out, in10);
	return;
      }

    if (in11 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in11) != 0) {
	strcpy(out, in12);
	return;
      }

    if (in13 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in13) != 0) {
	strcpy(out, in14);
	return;
      }

    if (in15 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in15) != 0) {
	strcpy(out, in16);
	return;
      }

    if (in17 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in17) != 0) {
	strcpy(out, in18);
	return;
      }

    if (in19 == NULL) {
	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
      }

    if (atol(in19) != 0) {
	strcpy(out, in20);
	return;
      }

	printf("*** Error M4 - Select in or near line %d\n",LineNumber);
      Terminate();
}

void _piece (

          unsigned char out[],
	    unsigned char in[],
	    unsigned char key[],
	    unsigned char start[],
	    unsigned char end[], 
          int setpiece, 
          unsigned char lhs[]) {

    unsigned char tmp2[512], tmp3[512];
    int i, j, k, l, m, n;

    if (strcmp(start, "-1") == 0) {	/* no start or end */
	k = 1;
	l = 1;
	goto p1;
      }

    strcpy(tmp2, start);
    k = atoi(tmp2);		/*start */

    l = k;			/* default end is same as start */

    if (strcmp(end, "-1") != 0) {	/* end? */
	strcpy(tmp2, end);
	l = atoi(tmp2);
      }

    if (k < 0 || l < k) {	/* check */
	printf("** $Piece error\n");
      Terminate();
      }

p1:

    strcpy(tmp2, in);
    strcpy(tmp3, key);

    if (tmp2[0] == 0 || tmp3[0] == 0 || k > l || l <= 0) {
	if (setpiece==0) strcpy(out, "");
	return;
      }

    m = 0;
    n = 0;

    while (n < k - 1) {
	m = xindex(tmp2, tmp3, m) + 1;

	if (m == 1) {
	    if (setpiece==0) strcpy(out, "");
	    return;
	    }

	n++;
      }

    if (k != 1) k = m + strlen(tmp3) - 1;

    while (n != l) {
	m = xindex(tmp2, tmp3, m + 1);

	if (m <= 0) {
	    m = strlen(tmp2) + 1;
	    goto piece1;
	    } 

      else n++;
      }

    m = m - k;

piece1:

      if (m == 0 && setpiece == 0) {
	  if (setpiece==0) strcpy(out, "");
	  return;
        }

    if (setpiece == 1) {
      char tmp[1024];
      strcpy(tmp,in);
	substr(tmp2, tmp, 1, k - 1);
	tmp[k] = 1;
	tmp[k + 1] = 0;
	strcat(tmp, lhs);
	if (k + m - 1 < strlen(tmp2)) strcat(tmp, &tmp2[k + m - 1]);
      if (out[0]!='^') sym_(0,out,tmp);
      else global ( STORE, out, tmp );
	return;
      }

    substr(tmp2, out, k, m);
    return;
}

void _random(unsigned char out[], unsigned char in[]) {

    int rslt, j;
    static int first = 1;
    long timex;

    if (first) {
	j = (int) time(&timex);
	srand(j);
	first = 0;
      }

    j = atoi(in);
    if (j < 2) {
	strcpy(out, "0");
	return;
      }

    rslt = rand();
    rslt = rslt / (RAND_MAX / (j));
    sprintf(out, "%d", rslt);
    return;
}

patrn1(jpx, ernbr)

    /* pattern argument [right side) set up */

short *jpx, *ernbr;

{
    static unsigned char tmp1[2], cod210[2] = { 210, 0 };
    tmp1[0] = 0;
    tmp1[1] = 0;

a1285:

    if (xd[*jpx] == '"') {
	strcat(&bd[0], "\"");

a1283:

	*jpx = (*jpx + 1);

	if (xd[*jpx] == 0) {
	    *ernbr = 2;
	    return;
	    }

	if (xd[*jpx] == '"') {
	    if (xd[*jpx + 1] != '"')
		goto a1281;
	    strcat(&bd[0], cod210);
	    *jpx = (*jpx + 1);
	    } 

      else {
	    tmp1[0] = xd[*jpx];
	    strcat(&bd[0], tmp1);
	    }

	goto a1283;
    }

a1281:

    tmp1[0] = xd[*jpx];
    if (xd[*jpx] != 0) {
	if (xindex(" ,&:!''><=[)+-*/#_", tmp1, 1) == 0) {
	    strcat(&bd[0], tmp1);
	    *jpx = (*jpx + 1);
	    goto a1285;
	    }
      }

    xpx = (*jpx - 1);
    *ernbr = 0;
    return;
}


void zfcn(unsigned char v1d[], unsigned char bd[]) {

#ifdef POSTGRES
#include <pgsql/libpq-fe.h>
#define _XOPEN_SOURCE
#include <unistd.h>
#endif

    long int atol(), timex, fd;
    time_t dtime;
    char *ctime();
    static char linebuf[1024];
    static int linebufx;
    int rand();
    FILE *dump;
    char zcode, zcode1, zcode2, zcode3;
    float sq;
    unsigned char tmp2[1024], tmp3[1024], tmp4[1024], gbltbl[128], gblstr[1024];
    int j, k, x;
    short int iargs[10], nargs;
    long i;
    short g;
    double rt;

    ierr = nargs = 0;
    iargs[0] = 1;
    zcode = tolower(v1d[3]);
    zcode1 = tolower(v1d[4]);
    zcode2 = tolower(v1d[5]);
    zcode3 = tolower(v1d[6]);

    while (v1d[1] != OPEN && v1d[1] != 0)
	strcpy(&v1d[1], &v1d[2]);

    if (zcode == 'g' && (zcode1 == 'a' || zcode1 == 'c' || zcode1 == 's')) {	/* zglobal */
	strcpy(&v1d[1], &v1d[2]);
	for (i = 1; v1d[i] != 0; i++);
	if (v1d[i - 1] != CLOSE || v1d[i - 2] != CLOSE) goto err;
	v1d[i - 1] = 0;
      }

    else {
	if (v1d[1] == OPEN) strcpy(&v1d[1], &v1d[2]);

	for (i = 1; v1d[i] != 0; i++)	/* locate arguments */
	    if (v1d[i] == CLOSE || v1d[i] == COMMA) {
		v1d[i] = 0;
		iargs[++nargs] = i + 1;
	      }
          }

// Branch table - go to appropriate fcn handler 

    ierr = 0;
    if (zcode == 'a') {
	if (zcode1 == 'b') goto zabs;
	goto zalter;
      }

    if (zcode == 'c') goto zcondense;
    if (zcode == 'd') goto zdate;
    if (zcode == 'v') goto z_variable;
    if (zcode == 'n') goto znormal;
    if (zcode == 'b') goto zblnks;
    if (zcode == 'p') goto zpad;
    if (zcode == 'h') goto zhtml;
    if (zcode == 'f') goto zfile;
    if (zcode == 'g') goto zglobal;
    if (zcode == 'l') goto zlog;
    if (zcode == 'm') goto znxtrow;
    if (zcode == 'r') goto zroot;
    if (zcode == 'w') goto zword;
    if (zcode == 't') goto ztell;
    if (zcode == 'o') goto zodbc;

    if (zcode == 's') {
	if (zcode1 == 'q' && zcode2 == 'r') goto square;
	goto zsystem;
      }

    goto err;


//#+--------------------------------------------------------------
//#+      $ZALTER(string) 
//#+      $ZNORMAL(string) 
//#+      Remove punctuation, make upper case, and remove suffixes
//#+      Used for text processing applications.
//#+--------------------------------------------------------------

zalter:
znormal:

#ifdef NORMAL

    if (nargs != 1) goto err;
    j = 0;

    for (i = 1; v1d[i] != 0; i++) {
	if (v1d[i] >= 'A' && v1d[i] <= 'Z') bd[j++] = v1d[i];
	else if (v1d[i] >= 'a' && v1d[i] <= 'z') bd[j++] = v1d[i] - 32;
	else if ((v1d[i] >= '0' && v1d[i] <= '9') || v1d[i] == '/') bd[j++] = v1d[i];
	else if (v1d[i] == '-') bd[j++] = '_';
      }

    bd[j] = 0;
    if (bd[0] == 0) return;

#ifdef STEM
    stem(bd, strlen(bd));	// remove English language suffixes.
#endif

    return;

#else
    goto err;
#endif

//------------------------------------------
//      $ztell 
//      Return byte offset in current file
//------------------------------------------

ztell:

    if (io < 0 || io > 4) {
	bd[0] = 0;
	return;
      }
    i = ftell(in_file[io]);
    sprintf(bd, "%ld", i);
    return;

//*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+									
//#+	$zodbc								
//#+									
//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

zodbc:

    if (nargs != 5) goto err;

    i = sql(&v1d[1],		// DataSourceName
	    &v1d[iargs[1]],	// User
	    &v1d[iargs[2]],	// Password
	    &v1d[iargs[3]],	// Command
	    &v1d[iargs[4]]);	// MumpsArray

    if (i < 0) goto err;
    sprintf(bd, "%d", i); //#+ Number rows retrieved
    return;


//#+--------------------------------------------------------------------
//#+      This function is used with IS&R experiments.
//#+      It loads a buffer (linebuf) with a line of text
//#+      then parses and returns words one by one.
//#+
//#+      $ZWI(string) - initialize line buffer with "string"
//#+      $ZWN - extract next word from line buffer - return "" if none
//#+             remain. Remove punctuation.
//#+      #ZP - extract next token from buffer - "" if done.
//#+--------------------------------------------------------------------

zword:

#ifdef BUF_PARSE

      if (zcode1 == 'i') {	/* initialize */
	strcpy(linebuf, &v1d[1]);
	linebufx = 0;
	bd[0] = 0;
	return;
      }

    if (tolower(zcode1) == 'n') {
	if (linebuf[linebufx] == 0) {	/* empty */
	    bd[0] = 0;
	    return;
	    }

	while (linebuf[linebufx] != 0 && linebuf[linebufx] == ' ') linebufx++;

	if (linebuf[linebufx] == 0) {	/* end of buffer */
	    bd[0] = 0;
	    return;
	    }

	i = 0;
	while (1) {		/* extract next word */
	    bd[i] = linebuf[linebufx];
	    if (linebuf[linebufx] == 0 || linebuf[linebufx] == ' ') {
		bd[i] = 0;
		return;
	      }

	    i++;
	    linebufx++;
	    }
      }

    if (zcode1 == 'p') {	//#+++  parse

	if (linebuf[linebufx] == 0) {	//#+++ empty 
	    bd[1] = 0;
	    return;
          }

	while (linebuf[linebufx] != 0 && linebuf[linebufx] == ' ')
	    linebufx++;

	if (linebuf[linebufx] == 0) {	//#+++ end of buffer */
	    bd[1] = 0;
	    return;
          }

	if (ispunct(linebuf[linebufx])) {
	    bd[1] = linebuf[linebufx];
	    bd[2] = 0;
	    linebufx++;
	    return;
          }

	i = 1;
	while (1) {	 //#+++ extract next word 
	    bd[i] = linebuf[linebufx];
	    if (linebuf[linebufx] == 0 ||
		ispunct(linebuf[linebufx]) || linebuf[linebufx] == ' ') {
		bd[i] = 0;
		return;
	      }
	    i++;
	    linebufx++;
	    }
       }

#endif

    goto err;


//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+									
//#+	$ZBLANKS(string) - remove leading and double blanks		
//#+									
//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zblnks:

    if (nargs != 1) goto err;
    k = 0;
    for (i = 1; v1d[i] != 0; i++)
	if (v1d[i] != ' ') goto zbl1;
    bd[0] = 0;
    return;

zbl1:

    for (; v1d[i] != 0; i++) {
	bd[k++] = v1d[i];
	if (bd[k - 2] == ' ' && bd[k - 1] == ' ' && k > 2) k--; // double blank
      }
    bd[k] = 0;
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+									+
+	$ZHTML(string) - convert codes for html transmission
+									+
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zhtml:

    if (nargs != 1) goto err;
    k = 1;
    for (i = 1; v1d[i] != 0; i++) {
	if (v1d[i] == ' ') v1d[i] = '+';
	else if (!isalnum(v1d[i])) {
	    char t1[10], t2[512];
	    sprintf(t1, "%%%2X\0", v1d[i]);
	    v1d[i] = 0;
	    strcpy(t2, &v1d[1]);
	    strcat(t2, t1);
	    strcat(t2, &v1d[i + 1]);
	    strcpy(&v1d[1], t2);
	    i = i + 2;
	    }
      }
    strcpy(bd, &v1d[1]);
    return;


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZCONDENSE - Dump Global Arrays to Disk                         +
+                                                                       +
+       $ZCD[(start)] - dump to file ``dump''                           +
+       $ZCL - load from file ``dump''                                  +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zcondense:

    if (nargs > 1) goto err;

    if (zcode1 != 'd') goto zc1;

    dtime = time(NULL);
    sprintf(tmp2, "%lu", dtime);
    if (strlen(tmp2) > 8) tmp2[8] = 0;
    strcat(tmp2, ".dmp");

    dump = fopen(tmp2, "w+");
    if (dump == NULL) {
	printf("dump err1\n");
	goto err;
      }

    if (nargs == 1) {		/* argument prvides starting point */
	strcpy(tmp2, &v1d[1]);
      } 
    else {			/* default starting point */
	tmp2[0] = ' ';		/* lowest printable */
	tmp2[1] = 1;
	tmp2[2] = 1;
	tmp2[3] = 0;
      }

    while (1) {			/* dump global arrays */
	g = XNEXT;
	i = global (g, tmp2, tmp3);
	if (i == 0) break;
	g = RETRIEVE;
	global (g, tmp2, tmp4);
	for (i = 0; tmp2[i] != 0; i++) {
	    if (tmp2[i] < ' ') tmp3[i] = '~';
	    else tmp3[i] = tmp2[i];
	    }
	tmp3[i] = 0;
	fputs(tmp3, dump);
	fputs("\n", dump);	/* key */
	fputs(tmp4, dump);
	fputs("\n", dump);	/* data */
      }
    fclose(dump);
    bd[0] = '1';
    bd[1] = 0;
    return;

zc1:

    if (zcode1 != 'l') goto err; // load global arrays

    dump = fopen("dump", "r");
    if (dump == NULL) {
	printf("dump err2\n");
	goto err;
      }

    while (1) {			/* load */
	if (fgets(tmp2, 255, dump) == NULL)
	    break;
	fgets(tmp3, 255, dump);
	for (i = 0; tmp3[i] != 0; i++)
	    if (tmp3[i] < 32)
		tmp3[i] = 0;
	for (i = 0; tmp2[i] != 0; i++)
	    if (tmp2[i] == '~')
		tmp2[i] = 1;
	    else if (tmp2[i] < 32)
		tmp2[i] = 0;
	g = STORE;
	global (g, tmp2, tmp3);
    }
    fclose(dump);
    bd[0] = '1';
    bd[1] = 0;
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       
+       $ZM(Global) - 							
+                                                                       
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  znxtrow:

    if (nargs == 1) {		/* argument prvides starting point */
	strcpy(gblstr, &v1d[1]);
	strcpy(gbltbl, &v1d[1]);
      }

    strcpy(tmp2, gblstr);

    g = XNEXT;
    i = global (g, tmp2, tmp3);
    if (i == 0) {
	bd[0] = 0;
	return;
      }

    g = RETRIEVE;
    global (g, tmp2, tmp4);

    for (i = 0; tmp2[i] != 0; i++) {
	if (tmp2[i] < ' ')
	    tmp3[i] = '~';

	else tmp3[i] = tmp2[i];
      }

    tmp3[i] = 0;
    for (i = 0; gbltbl[i] == tmp3[i] && gbltbl[i] != 0 && tmp3[i] != '~'; i++);

    if (gbltbl[i] == 0 && tmp3[i] == '~') {
	for (i = 0; (gblstr[i] = tmp2[i]) != 0; i++);
	strcpy(bd, tmp3);
	return;
      }

    bd[0] = 0;
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZABS(nbr) - absolute value fcn                                 +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zabs:

    if (nargs != 1) goto err;
    sscanf(&v1d[1], "%f", &sq);
    sprintf(bd, "%f", fabs(sq));
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZPAD(str,len) - pad a string with blanks
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zpad:

    if (nargs != 2) goto err;
    i = atol(&v1d[iargs[1]]);
    j = strlen(&v1d[1]);
    strcpy(bd, &v1d[1]);
    for (j; j < i; j++) bd[j] = ' ';
    bd[j] = 0;
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $Zvariable(str) - get of html passed variable from environment
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

z_variable:

    if (nargs != 1) goto err;
    if (sym_(1, &v1d[1], bd) == NULL) bd[0] = 0;
    return;


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZSQR(nbr) - square value fcn                                   +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

square:

    if (nargs != 1) goto err;
    sq = atof(&v1d[1]);
    gcvt(sq * sq, 7, bd);
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZLOG(nbr) - natural log                                        +
+       $ZLengthen(string,nbr)
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zlog:

    if (nargs > 1) goto zlog1;
    sq = atof(&v1d[1]);
    sq = log((double) sq);
    if (sprintf(bd, "%f", sq) != EOF) return;
    goto err;

zlog1:

    if (nargs > 2) goto err;
    sscanf(&v1d[iargs[1]], "%d", &i);
    strcpy(bd, &v1d[1]);

zlog2:

    if (strlen(bd) > i) return;
    strcat(bd, " ");
    goto zlog2;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZDATE - date and time of day (Wed Jan 01, 1992 14:36:00)       +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  zdate:

    timex = time(&timex);

    if (zcode1 == '1')
	sprintf(bd, "%ld", timex);	/* internal code */

    else if (zcode1 == '2') {	/* internal -> printable */
	timex = atol(&v1d[1]);
	strcpy(bd, ctime(&timex));
	bd[24] = 0;
    }

    else if (zcode1 == '3') {	/* $zd3(year,month,day) -> DayOfYear */

	struct tm date;
	int year, d, m;

	if (nargs != 3)
	    goto err;

	year = atol(&v1d[1]);
	m = atol(&v1d[iargs[1]]);
	d = atol(&v1d[iargs[2]]);

	if (year > 1900)
	    date.tm_year = year - 1900;
	else
	    date.tm_year = year;
	date.tm_mon = m - 1;	/* range is 0 to 11 */
	date.tm_mday = d;
	date.tm_hour = 0;
	date.tm_min = 0;
	date.tm_sec = 0;
	date.tm_yday = 0;
	date.tm_isdst = 1;

	mktime(&date);

	sprintf(bd, "%d", date.tm_yday + 1);	/* range is 0-365 */
    }

    else if (zcode1 == '4') {	/* $zd4(year,dayofyear) -> gregorian */

	struct tm date;
	int year, d, m, dd;

	if (nargs != 2)
	    goto err;

	year = atol(&v1d[1]);
	if (year > 1900)
	    year = year - 1900;
	d = atol(&v1d[iargs[1]]);
	d--;
	m = 0;
	dd = 1;
	while (1) {
	    date.tm_year = year;
	    date.tm_mon = m;
	    date.tm_mday = dd;
	    date.tm_hour = 0;
	    date.tm_min = 0;
	    date.tm_sec = 0;
	    date.tm_yday = 0;
	    date.tm_isdst = 1;
	    mktime(&date);
	    if (date.tm_yday == d)
		break;
	    dd++;
	    if (m == 0 && dd > 31) {
		m++;
		dd = 1;
	    } /* jan */
	    else if (m == 1 && (year % 4) == 0) {
		if (dd > 29) {
		    m++;
		    dd = 1;
		}		/* feb */
	    } else if (m == 1 && (year % 4) != 0) {
		if (dd > 28) {
		    m++;
		    dd = 1;
		}		/* feb */
	    } else if (m == 2 && dd > 31) {
		m++;
		dd = 1;
	    } /* mar */
	    else if (m == 3 && dd > 30) {
		m++;
		dd = 1;
	    } /* apr */
	    else if (m == 4 && dd > 31) {
		m++;
		dd = 1;
	    } /* may */
	    else if (m == 5 && dd > 30) {
		m++;
		dd = 1;
	    } /* jun */
	    else if (m == 6 && dd > 31) {
		m++;
		dd = 1;
	    } /* jul */
	    else if (m == 7 && dd > 31) {
		m++;
		dd = 1;
	    } /* aug */
	    else if (m == 8 && dd > 30) {
		m++;
		dd = 1;
	    } /* sep */
	    else if (m == 9 && dd > 31) {
		m++;
		dd = 1;
	    } /* oct */
	    else if (m == 10 && dd > 30) {
		m++;
		dd = 1;
	    } /* nov */
	    else if (m == 11 && dd > 31)
		goto err;	/* dec */
	}

	if (date.tm_year < 100)
	    sprintf(bd, "19%d %d %d",
		    date.tm_year, date.tm_mon + 1, date.tm_mday);
	else
	    sprintf(bd, "20%02d %d %d",
		    date.tm_year - 100, date.tm_mon + 1, date.tm_mday);
    }

    else if (zcode1 == '5') {
	/* $zd5(year,mn,dy) -> yr,dy,dw (days since sunday) */

	struct tm date;
	int year, d, m;

	if (nargs != 3)
	    goto err;

	year = atol(&v1d[1]);
	m = atol(&v1d[iargs[1]]);
	d = atol(&v1d[iargs[2]]);

	if (year > 1900)
	    date.tm_year = year - 1900;
	else
	    date.tm_year = year;
	date.tm_mon = m - 1;	/* range is 0 to 11 */
	date.tm_mday = d;
	date.tm_hour = 0;
	date.tm_min = 0;
	date.tm_sec = 0;
	date.tm_yday = 0;
	date.tm_isdst = 1;

	mktime(&date);

	if (date.tm_year < 100)
	    sprintf(bd, "19%d,%d,%d",
		    date.tm_year, date.tm_yday + 1, date.tm_wday);
	else
	    sprintf(bd, "20%02d,%d,%d",
		    date.tm_year - 100, date.tm_yday + 1, date.tm_wday);
    }

    else if (zcode1 == '6') {	/* $zd6 -> HH:SS */
	strcpy(bd, ctime(&timex) + 11);
	bd[5] = 0;
    }

    else if (zcode1 == '7' || zcode1 == '8') {	/* current as year,month,day */
	if (nargs == 1)
	    timex = atol(&v1d[1]);
	strcpy(tmp2, ctime(&timex));
	bd[1] = tmp2[20];
	bd[2] = tmp2[21];
	bd[3] = tmp2[22];
	bd[4] = tmp2[23];
	bd[5] = '-';
	tmp2[7] = 0;
	if (strcmp(&tmp2[4], "Jan") == 0) {
	    bd[6] = '0';
	    bd[7] = '1';
	} else if (strcmp(&tmp2[4], "Feb") == 0) {
	    bd[6] = '0';
	    bd[7] = '2';
	} else if (strcmp(&tmp2[4], "Mar") == 0) {
	    bd[6] = '0';
	    bd[7] = '3';
	} else if (strcmp(&tmp2[4], "Apr") == 0) {
	    bd[6] = '0';
	    bd[7] = '4';
	} else if (strcmp(&tmp2[4], "May") == 0) {
	    bd[6] = '0';
	    bd[7] = '5';
	} else if (strcmp(&tmp2[4], "Jun") == 0) {
	    bd[6] = '0';
	    bd[7] = '6';
	} else if (strcmp(&tmp2[4], "Jul") == 0) {
	    bd[6] = '0';
	    bd[7] = '7';
	} else if (strcmp(&tmp2[4], "Aug") == 0) {
	    bd[6] = '0';
	    bd[7] = '8';
	} else if (strcmp(&tmp2[4], "Sep") == 0) {
	    bd[6] = '0';
	    bd[7] = '9';
	} else if (strcmp(&tmp2[4], "Oct") == 0) {
	    bd[6] = '1';
	    bd[7] = '0';
	} else if (strcmp(&tmp2[4], "Nov") == 0) {
	    bd[6] = '1';
	    bd[7] = '1';
	} else if (strcmp(&tmp2[4], "Dec") == 0) {
	    bd[6] = '1';
	    bd[7] = '2';
	}
	bd[8] = '-';
	bd[9] = tmp2[8];
	bd[10] = tmp2[9];
	bd[11] = 0;

	for (j = 0; j < 11; j++)

	    if (bd[j] == ' ') bd[j] = '0';

	if (zcode1 == '8') {
	    bd[11] = ',';
	    strcpy(&bd[12], ctime(&timex) + 11);
	    bd[17] = 0;
	}

	strcpy(bd, &bd[1]);
    }

    else {
	if (nargs != 0) goto err;
	strcpy(bd, ctime(&timex));
	bd[24] = 0;
    }
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZFILE(filename) - does file exist?                             +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


zfile:

    fd = open(&v1d[1], 0);
    x = fd;
    close(fd);
    if (x == -1) {
	bd[0] = '0';
	bd[1] = 0;
	return;
      }
    bd[0] = '0';
    bd[1] = 0;
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZGLOBAL - file system status                                   +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  zglobal:

    g = 5;			/* count empties */
    global (g, v1d, bd);
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZROOT(nbr) - square root                                       +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zroot:

    if (nargs != 1) goto err;
    sscanf(&v1d[1], "%lf", &rt);
    rt = sqrt(rt);
    sprintf(bd, "%f", rt);
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       $ZSYSTEM(command) - spawn shell and exec command                +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

zsystem:

    if (nargs != 1) goto err;
    x = system(&v1d[1]);
    sprintf(bd, "%d", x);
    return;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                       +
+       Error exit                                                      +
+                                                                       +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

err:

    printf("\n*** Function error in or near line %d\n", LineNumber);
    Terminate();

}


//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+  Word Stemming Procedure Interface
//#+
//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


#ifdef STEM

#define LT -1
#define EQ 0
#define GT 1

int slteqgt(unsigned char *s1, unsigned char *s2) {

/* compares two strings */
    while (1) {
	if (*s1 < *s2) return (LT);
	if (*s1 > *s2) return (GT);
	if (*s1 == *s2 && !*s1) return (EQ);
	s1++; s2++;
    }
}

//#+ The following are locations in the conflation table 

#define FIN 1

struct Endings {
    char *prefix;             //* ending string 
    int offset;               //* length */
    char *replace;            //* replacement */
};

struct Endings prefix[] = {

    {"PRE",  3, "",},
    {"POST", 4, "",},
    {"NON",  3, "",},
    {"",     0, ""},
    };

struct Ends {
    char *ending;		/*ending string */
    int offset;			/*length */
    char *replace;		/*replacement */
    int replen;			/*length */
    int next;			/*goto */
    } 

D_endings[] = {

    { "NNED",  4, "N",    1, FIN,}, 
    { "RATED", 5, "RATE", 4, FIN,}, 
    { "CATED", 5, "CATE", 4, FIN,},	/* sophisticated */
    { "IATED", 5, "IATE", 4, FIN,},	/* associated */
    { "MATED", 5, "MATE", 4, FIN,},	/* animated automated */
    { "GATED", 5, "GATE", 4, FIN,},	/* aggregated */
    { "ATED",  4, "TE",   2, FIN,}, 
    { "ETED",  4, "TE",   2, FIN,},	/* competed */
    { "ATED",  4, "TE",   2, FIN,},	/* alternated */
    { "OTED",  4, "TE",   2, FIN,},	/* promoted */
    { "UTED",  4, "TE",   2, FIN,},	/* distributed */
    { "STED",  4, "STE",  3, FIN,},	/* wasted */
    { "TED",   3, "T",    1, FIN,}, 
    { "ERED",  4, "ER",   2, FIN,},	/* offered */
    { "DDED",  4, "DD",   2, FIN,},	/* added */
    { "RED",   3, "RE",   2, FIN,}, 
    { "ZED",   3, "ZE",   2, FIN,}, 
    { "ODED",  4, "DE",   2, FIN,},	/* coded */
    { "OVED",  4, "VE",   2, FIN,}, 
    { "EVED",  4, "EVE",  3, FIN,}, 
    { "IED",   3, "Y",    1, FIN,}, 
    { "CED",   3, "CE",   2, FIN,}, 
    { "OLLED", 4, "OL",   2, FIN,},	/* controlled */
    { "ALLED", 4, "AL",   2, FIN,},	/* called */
    { "OOLED", 5, "00L",  3, FIN,},	/* cooled */
    { "OLED",  4, "L",    1, FIN,},	/* cooled */
    { "LED",   3, "LE",   2, FIN,},	/* scheduled */
    { "EED",   3, "EED",  3, FIN,},	/* speed */
    { "ASED",  4, "ASED", 4, FIN,},	/* based */
    { "SSED",  4, "SS",   2, FIN,},	/* addressed */
    { "USED",  4, "US",   2, FIN,},	/* focus */
    { "SED",   3, "SE",   2, FIN,},	/* closed */
    { "VED",   3, "VE",   2, FIN,},	/* archived */
    { "NED",   3, "N",    1, FIN,},	/* assign */
    { "ACHED", 6, "ACHE", 4, FIN,},	/* cached */
    { "HED",   3, "H",    1, FIN,},	/* attached */
    { "GED",   3, "GE",   2, FIN,},	/* charged */
    { "MMED",  4, "M",    1, FIN,},	/* programmed */
    { "UED",   3, "UE",   2, FIN,},	/* queued */
    { "BED",   3, "BE",   2, FIN,},	/* described */
    { "DED",   3, "DE",   2, FIN,},	/* included */
    { "ORED",  4, "OR",   2, FIN,},	/* author */
    { "ED",    2, "",     0, FIN,}, 
    { "",      0, "",     0, FIN},
    }, 

S_endings[] = {

    { "TIVENESS", 5, "TIVE",  4, FIN,},	/* competitiveness */
    { "INESS",    5, "INESS", 0, FIN,}, 
    { "NESS",     4, "",      0, FIN,}, 
    { "SS",       2, "SS",    1, FIN,}, 
    { "SSES",     4, "SS",    2, FIN,}, 
    { "XES",      3, "X",     1, FIN,}, 
    { "XAS",      3, "XAS",   3, FIN,},	/* Texas */
    { "IOUS",     4, "IOUS",  4, FIN,}, 
    { "NOUS",     4, "NOUS",  4, FIN,},	/* asynchronous */
    { "UOUS",     4, "E",     1, FIN,},	/* continuous */
    { "OUS",      3, "",      0, FIN,}, 
    { "ARIES",    5, "ARY",   3, FIN,}, 
    { "ERIES",    5, "ERY",   3, FIN,}, 
    { "ORIES",    5, "ORY",   3, FIN,},	/* accessories */
    { "TRIES",    5, "TRY",   4, FIN,},	/* countries */
    { "RIES",     4, "RIES",  4, FIN,}, 
    { "IES",      3, "Y",     1, FIN,}, 
    { "BIOS",     4, "BIOS",  4, FIN,},	/* netbios */
    { "DUS",      3, "DUS",   3, FIN,},	/* Aldus */
    { "VES",      3, "VE",    2, FIN,}, 
    { "RES",      3, "RE",    2, FIN,}, 
    { "SIS",      3, "SIS",   3, FIN,}, 
    { "CES",      3, "CE",    2, FIN,}, 
    { "DOS",      3, "DOS",   3, FIN,}, 
    { "CUS",      3, "CUS",   3, FIN,},	/* focus */
    { "TUS",      3, "TUS",   3, FIN,},	/* Lotus */
    { "AYS",      3, "AY",    2, FIN,},	/* gateways */
    { "NYS",      3, "NY",    2, FIN,},	/* companys */
    { "YS",       2, "YS",    2, FIN,},	/* Unisys */
    { "IUS",      3, "IUS",   3, FIN,},	/* radius */
    { "IS",       2, "",      0, FIN,}, 
    { "HES",      3, "H",     1, FIN,},	/* approach */
    { "VES",      3, "VE",    2, FIN,},	/* archives */
    { "TES",      3, "TE",    2, FIN,},	/* competes */
    { "US",       2, "US",    2, FIN,},	/* virus */
    { "S",        1, "",      0, 0,}, 
    { "",         0, "",      0, 0},
    }, 

G_endings[] = {

    { "ZING",     4, "ZE",    2, FIN,}, 
    { "OLLING",   5, "L",     2, FIN,}, 
    { "LLING",    5, "LL",    2, FIN,},	/* calling */
    { "ALING",    5, "AL",    2, FIN,},	/* appealing */
    { "LING",     4, "LE",    2, FIN,}, 
    { "WRITTING", 7, "WRITE", 5, FIN,}, 
    { "ITING",    5, "IT",    2, FIN,}, 
    { "IPTING",   6, "IPT",   3, FIN,}, 
    { "PTING",    5, "T",     1, FIN,}, 
    { "MMING",    5, "M",     1, FIN,}, 
    { "CTING",    5, "CT",    2, FIN,}, 
    { "INTING",   6, "INT",   3, FIN,}, 
    { "NTING",    5, "NT",    2, FIN,}, 
    { "FTING",    5, "FT",    2, FIN,}, 
    { "RTING",    5, "RT",    2, FIN,}, 
    { "ATTING",   6, "AT",    2, FIN,}, 
    { "RATING",   6, "RATE",  4, FIN,},	/* operating */
    { "CATING",   6, "CATE",  4, FIN,},	/* communicating */
    { "DATING",   6, "DATE",  4, FIN,},	/* accomodating */
    { "NATING",   6, "NATE",  4, FIN,},	/* alternating */
    { "MATING",   6, "MATE",  4, FIN,},	/* automating */
    { "EATING",   6, "EATE",  4, FIN,},	/* automating */
    { "ATING",    5, "AT",    2, FIN,}, 
    { "STING",    5, "ST",    2, FIN,},	/* testing */
    { "ETING",    5, "ET",    2, FIN,},	/* meeting */
    { "TING",     4, "TE",    2, FIN,}, 
    { "STING",    5, "ST",    2, FIN,}, 
    { "RMING",    5, "RM",    2, FIN,},	/* alarming */
    { "MMING",    5, "M",     1, FIN,},	/* programming */
    { "MING",     4, "ME",    2, FIN,}, 
    { "ERING",    5, "ER",    2, FIN,},	/* offering */
    { "ORING",    5, "OR",    2, FIN,},	/* monitoring mirroring */
    { "RING",     4, "RE",    2, FIN,}, 
    { "RNING",    5, "RN",    2, FIN,}, 
    { "NNING",    5, "N",     1, FIN,}, 
    { "ONING",    5, "ON",    2, FIN,}, 
    { "GNING",    5, "GN",    2, FIN,},	/* designing */
    { "INING",    5, "N",     1, FIN,},	/* training */
    { "NING",     4, "NE",    2, FIN,}, 
    { "CING",     4, "CE",    2, FIN,}, 
    { "VING",     4, "VE",    2, FIN,}, 
    { "SSING",    5, "SS",    2, FIN,},	/* processing */
    { "SING",     4, "SE",    2, FIN,},	/* licensing */
    { "GING",     4, "GE",    2, FIN,},	/* charging */
    { "BING",     4, "BE",    2, FIN,},	/* describing */
    { "ING",      3, "",      0, FIN,}, 
    { "",         0, "",      0, FIN},}, 

N_endings[] = {

    { "ATURATION", 9, "ATURATE", 7, FIN,}, 
    { "ERATION",   7, "ERATE",   5, FIN,},	/* operation */
    { "TRATION",   7, "TER",     3, FIN,},	/* administration */
    { "RATION",    6, "RE",      2, FIN,}, 
    { "TITION",    6, "TE",      2, FIN,},	/* competition */
    { "ECTION",    6, "ECT",     3, FIN,},	/* connection */
    { "ERSION",    6, "ERT",     3, FIN,},	/* conversion */
    { "MATION",    6, "MATE",    4, FIN,},	/* animation */
    { "OTATION",   7, "OTATE",   5, FIN,},	/* annotation */
    { "CATION",    6, "CATE",    4, FIN,},	/* communication */
    { "ICTION",    6, "ICTION",  6, FIN,},	/* jurisdiction */
    { "NCTION",    6, "NCTION",  6, FIN,},	/* function */
    { "CTION",     5, "CT",      2, FIN,},	/* abstraction */
    { "LATION",    6, "LATE",    4, FIN,},	/* demodulation */
    { "TATION",    6, "T",       1, FIN,}, 
    { "NICIAN",    6, "NICAL",   5, FIN,},	/* technician */
    { "ICAN",      4, "ICA",     3, FIN,},	/* American */
    { "",          0, "",        0, FIN},}, 

E_endings[] = {

    { "RABLE",  5, "ARE",   3, FIN,},	/* comparable */
    { "EABLE",  5, "E",     1, FIN,},	/* aggreeable */
    { "ABLE",   4, "",      0, FIN,}, 
    { "TIBLE",  5, "TIBLE", 5, FIN,}, 
    { "IBLE",   4, "",      0, FIN,},
    { "TITIVE", 6, "TE",    2, FIN,},	/* competitive */
    { "ECTIVE", 6, "ECT",   3, FIN,},	/* connective */
    { "NATIVE", 6, "NATE",  4, FIN,},	/* alternative */
    { "LYZE",   4, "LYSIS", 5, FIN,},	/* analyze */
    { "",       0, "",      0, FIN},}, 

L_endings[] = {

    { "TIONAL", 6, "TION", 4, FIN,},	/* additional */
    { "TIAL",   4, "TIAL", 4, FIN,},
    { "IAL",    3, "IAL",  3, FIN,},
    { "ERAL",   4, "ERAL", 4, FIN,},	/* general */
    { "RAL",    3, "RE",   2, FIN,},
    { "UAL",    3, "UAL",  3, FIN,},
    { "MAL",    3, "MAL",  3, FIN,},
    { "ONAL",   4, "ON",   2, FIN,},	/* traditional */
    { "NAL",    3, "NAL",  3, FIN,},	/* journal */
    { "HICAL",  5, "IC",   2, FIN,},	/* graphical */
    { "CAL",    3, "CAL",  3, FIN,},	/* technical */
    { "EAL",    3, "EAL",  3, FIN,},	/* appeal */
    { "BAL",    3, "BAL",  3, FIN,},	/* global */
    { "SAL",    3, "SAL",  3, FIN,},	/* universal */
    { "AL",     2, "",     0, FIN,}, 
    { "",       0, "",     0, FIN},}, 

C_endings[] = {

    { "ISTIC", 5, "",     0, FIN,}, 
    { "IFIC",  4, "",     0, FIN,}, 
    { "THMIC", 5, "THM",  3, FIN,},	/* algorithmic */
    { "MATIC", 5, "MATE", 4, FIN,},	/* automatic */
    { "",      0, "",     0, FIN},}, 

Y_endings[] = {

    { "RABLY",    5, "RE",     2, FIN,},	/* comparably */
    { "ABLY",     4, "",       0, FIN,}, 
    { "IBLY",     4, "",       0, FIN,}, 
    { "ILY",      3, "",       0, FIN,}, 
    { "TICALLY",  7, "TE",     2, FIN,},	/* automatically */
    { "ICALLY",   6, "ICAL",   4, FIN,},	/* techincally */
    { "CALLY",    5, "C",      1, FIN,}, 
    { "TITIVELY", 6, "TE",     2, FIN,},	/* competitively */
    { "BLY",      3, "BLY",    3, FIN,},	/* assembly */
    { "LY",       2, "",       0, FIN,}, 
    { "TARY",     4, "TARY",   4, FIN,}, 
    { "SARY",     4, "SARY",   4, FIN,},	/* necessary */
    { "RARY",     4, "RARY",   4, FIN,},	/* library */
    { "ARY",      3, "",       0, FIN,}, 
    { "ABILITY",  7, "",       0, FIN,}, 
    { "TIBILITY", 8, "TIBLE",  5, FIN,}, 
    { "IBILITY",  7, "",       0, FIN,}, 
    { "TIVITY",   6, "T",      1, FIN,},	/* connectivity */
    { "VITY",     4, "VE",     2, FIN,}, 
    { "SITY",     4, "SITY",   4, FIN,}, 
    { "RITY",     4, "RE",     2, FIN,}, 
    { "CILITY",   6, "CILITY", 6, FIN,}, 
    { "ALITY",    5, "",       0, FIN,}, 
    { "NITY",     4, "NITY",   4, FIN,},	/* community */
    { "CITY",     4, "CITY",   4, FIN,},	/* capacity */
    { "ITY",      3, "",       0, FIN,}, 
    { "IFY",      3, "",       0, FIN,}, 
    { "UITRY",    5, "UIT",    3, FIN,},	/* circuitry */
    { "",         0, "",       0, FIN},}, 

V_endings[] = {

    { "IV",  2, "",     0, FIN,}, 
    { "OLV", 3, "OLUT", 4, FIN,}, 
    { "",    0, "",     0, FIN},}, 

T_endings[] = {

    { "EEMENT", 6, "EE",    2, FIN,},	/* agreement */
    { "RMENT",  5, "RMENT", 5, FIN,},	/* deferment */
    { "EMENT",  5, "E",     1, FIN,},	/* announcement */
    { "AT",     2, "",      0, FIN,}, 
    { "ANTT",   4, "ANTT",  4, -1,}, 
    { "LYST",   4, "LYSIS", 5, FIN,},	/* analyst */
    { "",       0, "",      0, FIN},}, 

R_endings[] = {

    { "ECTOR",    5, "ECT",    3, FIN,},	/* connector */
    { "TITOR",    5, "TE",     2, FIN,},	/* competitor */
    { "RATOR",    5, "TE",     2, FIN,},	/* accelerator */
    { "MATOR",    5, "MATE",   4, FIN,},	/* animator */
    { "SUPER",    5, "SUPER",  5, FIN,},	/* super */
    { "SUPPLIER", 8, "SUPPLY", 6, FIN,},	/* supplier */
    { "LATOR",    5, "LATE",   4, FIN,},	/* demodulator */
    { "IFIER",    5, "IFY",    3, FIN,},	/* amplifier */
    { "LYSER",    5, "LYZE",   4, FIN,},	/* analyser */
    { "LYZER",    5, "LYZE",   4, FIN,},	/* analyzer */
    { "DER",      3, "D",      1, FIN,},	/* loader */
    { "ERTER",    5, "ERT",    3, FIN,},	/* converter */
    { "PILER",    5, "PILE",   4, FIN,},	/* compiler */
    { "ZER",      3, "ZE",     2, FIN,},	/* compiler */
    { "NNER",     4, "N",      1, FIN,}, 
    { "",         0, "",       0, FIN},};



//#+========================================================================
//#+
//#+	STEM
//#+
//#+========================================================================

int stem(char *word, int wl) {


//#+*********************************************************************
//#+	if the ending of word[] is in endings.ending, it is removed and any
//#+	replacement string is tacked on the end; search and replacement
//#+	is controlled by endings.next.
//#+**********************************************************************

    int i;

//#+ check against possible endings

    i = wl - 1;

switch (word[i]) {
case 'D': return escan(word, wl, D_endings);
case 'S': return escan(word, wl, S_endings);
case 'G': return escan(word, wl, G_endings);
case 'N': return escan(word, wl, N_endings);
case 'E': return escan(word, wl, E_endings);
case 'L': return escan(word, wl, L_endings);
case 'Y': return escan(word, wl, Y_endings);
case 'V': return escan(word, wl, V_endings);
case 'T': return escan(word, wl, T_endings);
case 'R': return escan(word, wl, R_endings);
default: return wl;
}

}

int escan(char word[], int wl, struct Ends endings[]) {

    int i = 0;

    while (endings[i].ending[0]) {

	if (strcmp(&word[wl - endings[i].offset], endings[i].ending) == 0) {

	    strcpy(&word[wl - endings[i].offset], endings[i].replace);
	    wl += endings[i].replen - endings[i].offset;
	    if (endings[i].next) break;
	    i = 0;
          }

	else i++;

    }

    if (endings[i].next < 0) return (wl);
    if (word[wl - 2] != 'P' && word[wl - 2] != 'T' && word[wl - 2] != 'D') return (wl);

    if (strcmp(&word[wl - 2], "PP") == 0) {
	word[wl - 1] = 0;
	return wl - 1;
      }

    if (strcmp(&word[wl - 2], "TT") == 0) {
	word[wl - 1] = 0;
	return wl - 1;
      }

    if (strcmp(&word[wl - 2], "DD") == 0) {
	word[wl - 1] = 0;
	return wl - 1;
      }

    return (wl);

}

#endif

//................................................
// Global Btree
// Number of global array btree buffers.
// This should be large for DOS and small for Unix
//................................................


#define MARK 0xff

#ifndef LOCK_EX
#include <unistd.h>
#endif

#define TRXLIMIT 60
#define NEXTMARK 1

struct buffers {
    char *gblbf;
    long gblbfx;
    int gblmod;
    struct buffers *next;
};

static struct buffers bfr[GBLBUF];
static struct buffers *gp0;
static struct buffers *gp1;
static struct buffers *gp3;
static struct buffers *gp4;
static struct buffers *gp5;
static struct buffers *gproot;

static int gblfd = -1, gbldat = -1;
static gblmax, gblroot;
static int trx;
static int ReadOnly = 1;

void freadx(unsigned char **buf, long r, int flag);

extern char cfgdata[];
extern char cfgkey[];
extern int gpad;

int global (short g, unsigned char key[], unsigned char bd[]) {

    extern int errno;
    long allocblk();
    char *calloc();
    static long trace[TRXLIMIT], ilong, zero = 0, i, k, m, datptr;
    static long *root, *lastrec, *RDFlg;
    static short rtf, datlen, nxtln, tmp1, j, is, ks, ls, kk, ii;
    static short opnflg = 0;
    static short tracep[TRXLIMIT];
    static unsigned char *block, *block1, *ptr1;
    static unsigned char bufblk[2048];
    FILE *cfg;

    rtf = 1;			/* retry flag - prevents nxtln from being reset */

    keyfix(key);

    if (g == NEXT || g == XNEXT) {	/* prepare NEXT cases */

	for (j = 0; key[j] != 0; j++);

	if (key[j - 1] == 1	/* $next -1 case */
	    && key[j - 2] == '1' && key[j - 3] == '-' && key[j - 4] == 1) {

	    key[j - 3] = 2;
	    key[j - 2] = 1;
	    key[j - 1] = 0;
	    j--;
	    } 

      else if (g == NEXT) {
	    key[j - 1] = 2;
	    key[j] = 1;
	    key[j + 1] = 0;
	    }

	if (rtf) {
	    for (nxtln = j - 2; nxtln > 0 && key[nxtln] != NEXTMARK; nxtln--);
	    if (nxtln > 0) nxtln++;
	    }

	rtf = 0;
      }

    if (opnflg == 0) {		/* auto open */

	opnflg = 1;

	for (i = 0; i < GBLBUF; i++) {	/* allocate buffers */
	    bfr[i].gblbf = (char *) malloc(1024);

	    if (bfr[i].gblbf == NULL) {
		printf("System memory error - buffers\n");
            Terminate();
	      }

	    bfr[i].gblbfx = -1L;
	    bfr[i].gblmod = 0;
	    }

	gblmax = i - 1;
	gblroot = gblmax;	/* buffer assignment */
	gp0 = &bfr[0];

	for (i = 0; i <= gblmax - 2; i++)
	    bfr[i].next = &bfr[i + 1];

	bfr[gblmax - 1].next = NULL;
	gproot = &bfr[gblroot];

#ifdef NEW_TREE
	sprintf(cfgkey, "key%d.tmp", getpid());
	sprintf(cfgdata, "dat%d.tmp", getpid());
#endif

reopen:

#if SYSTEM==UNIX
	strcpy(cfgkey,UKEY);
	strcpy(cfgdata,UDAT);
	gblfd = open(cfgkey, O_RDWR | O_EXCL);
	gbldat = open(cfgdata, O_RDWR | O_EXCL);
#else
	strcpy(cfgkey,UKEY);
	strcpy(cfgdata,UDAT);
	gblfd = open(cfgkey, O_RDWR | O_EXCL | O_BINARY);
	gbldat = open(cfgdata, O_RDWR | O_EXCL | O_BINARY);

	if (gblfd != -1)
	    while (lock(gblfd, 0UL, 1000UL))
		sleep(1);
#endif

/*-----------------------------------------------
	unix file locking
-----------------------------------------------*/

#if SYSTEM!=DOS

#ifdef LOCK_EX
	flock(gblfd, LOCK_EX);	/* do not proceed until locked */
#endif
#ifndef LOCK_EX
	lockf(gblfd, F_LOCK, 0L);
#endif
#endif

/*-----------------------------------------------
	end unix file locking
-----------------------------------------------*/

	if (gblfd == -1) {	/* Does not exist - create and initialize */

#if SYSTEM==UNIX
          strcpy(cfgkey,UKEY);
          strcpy(cfgdata,UDAT);
	    gblfd = open(cfgkey, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
	    gbldat = open(cfgdata, O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
#endif
#if SYSTEM==OS2||SYSTEM==DOS

	strcpy(cfgkey,UKEY);
	strcpy(cfgdata,UDAT);

      gblfd = open(cfgkey, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, GBLPERMIT);
      gbldat = open(cfgdata, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, GBLPERMIT);

#endif


	    freadx(&block, 0L, 1);	/* get a buffer address */

	    {
		int i;
		for (i = 0; i < 1024; i++) block[i] = 0;
	      }

	    for (is = 0; is <= 4; is++) {	/* init to zeros */
		lseek(gblfd, is * 1024L, SEEK_SET);
		write(gblfd, block, 1024);
	      }

	    lseek(gbldat, 0L, SEEK_SET);	/* move to origin */
	    write(gbldat, block, 2);	/* init data file */

	    freadx((unsigned char **) &root, 12L, 1);
	    *root = 777L;	/* integrity flg */

	    freadx((unsigned char **) &root, 0L, 1);
	    *root = 0L;		/* root */

	    freadx((unsigned char **) &root, 4L, 1);
	    *root = 0L;		/* no meaning */

	    freadx((unsigned char **) &lastrec, 8L, 1);
	    *lastrec = 1024L;	/* extent */

	    lseek(gblfd, 0L, SEEK_SET);
	    write(gblfd, bfr[gblroot].gblbf, 1024);	/* root block */

#if SYSTEM==OS2||SYSTEM==DOS
	    unlock(gblfd, 0UL, 1000UL);
#endif

	    close(gblfd);
	    close(gbldat);
	    chmod(cfgdata, GBLPERMIT);
	    chmod(cfgkey, GBLPERMIT);

	    goto reopen;
	    }

	freadx((unsigned char **) &root, 12L, 1);	/* integrity flag */

	if (*root != 777L) {
	    printf("\nFile system error\n");
          Terminate();
	    }

	/*..........................................
	   now done only when file system altered .....
	   *root=0L; 
	   lseek(gblfd,0L,SEEK_SET);
	   write(gblfd,bfr[gblroot].gblbf,1024); 
	   ............................................ */

	if (g == INIT) return (1);
      }

    if (g == OPEN)
	return (1);

    if (g == INIT)
	return (1);

    if (g == GCLOSE) {

#ifdef NEW_TREE
	remove(cfgdata);
	remove(cfgkey);
	return 1;
#endif

	if (opnflg == 0) return (1);

	for (is = 0; is < gblmax; is++) {	/* dump global buffers */
	    if (bfr[is].gblmod > 0) {
		lseek(gblfd, bfr[is].gblbfx, SEEK_SET);
		write(gblfd, bfr[is].gblbf, 1024);
	      }
	    }

	freadx((unsigned char **) &root, 12L, 1);
	*root = 777L;		/* mark as proper close */

	lseek(gblfd, 0L, SEEK_SET);
	write(gblfd, bfr[gblroot].gblbf, 1024);	/* dump super block */
	close(gblfd);
	close(gbldat);
	chmod(cfgdata, GBLPERMIT);
	chmod(cfgkey, GBLPERMIT);
	opnflg = 0;

#if SYSTEM==OS2||SYSTEM==DOS
	unlock(gblfd, 0UL, 1000UL);
#endif

	close(gblfd);
	close(gbldat);
	chmod(cfgdata, GBLPERMIT);
	chmod(cfgkey, GBLPERMIT);

	return (1);
      }

    if (g == EMPTY) {		/* count the empties */
	/* count empties */
	freadx((unsigned char **) &root, 8L, 0);
	lseek(gbldat, 0L, SEEK_END);
	datptr = tell(gbldat);
	lseek(gblfd, 0L, SEEK_END);
	k = tell(gblfd);
	i = (*root);
	is = 0;
	for (j = 0; j < GBLBUF; j++) if (bfr[j].gblbfx > 0L) is++;

	sprintf(bd,
		" root=%ld data=%ld key=%ld buffers=%d "
		"mask=%lx Ver=99.01.04", i, datptr, k, is);

	return (1);
      }

srch:

    freadx((unsigned char **) &root, 0L, 0);

    if (*root == 0) {		/*no tree */

	if (g == RETRIEVE) {
	    bd[0] = 0;
	    return (0);
	    }

	if (g != STORE) {
	    bd[0] = 0;
	    return (0);
	    }

	if (g == STORE) {	/*insert case */

	    if (ReadOnly) {
		freadx((unsigned char **) &RDFlg, 12L, 1);	/* integrity flag */
		*RDFlg = 0L;	/* mark as open - reset at close */
		lseek(gblfd, 0L, SEEK_SET);
		write(gblfd, bfr[gblroot].gblbf, 1024);	/* dump super block */
		ReadOnly = 0;
	      }

	    k = allocblk();
	    freadx(&block, 0L, 1);
	    memcpy(block, &k, 4);
	    freadx(&block, k, 1);	/* k block */
	    for (j = 0; j < 1024; j++) block[j] = 0;
	    j = 4;
	    strcpy(&block[j], key);	/*key */
	    j += strlen(key) + 1;

	    if (strlen(bd) == 0) {
		datptr = 0L;
	      } 

          else {
		datptr = lseek(gbldat, 0L, SEEK_END);
		datlen = strlen(bd) + 1;
		write(gbldat, &datlen, 2);	/* length code */
		write(gbldat, bd, datlen);	/* data */
	     }

	    memcpy(&block[j], &datptr, 4);	/* data address */
	    j += 4;
	    block[j++] = 0;
	    memcpy(&block[j], &zero, 4);
	    block[j + 4] = MARK;
	    block[j + 5] = 0;
	    return (1);
          }
    }

    /* search for key */

    i = *root;
    trx = -1;

nxtblk:

    trace[++trx] = i;
    freadx(&block, i, 0);
    ptr1 = block;

nxtkey:

    ptr1 += 4;

#if SYSTEM==DOS
    while ((is = _fstrcmp(key, ptr1)) > 0)
#else
    while ((is = strcmp(key, ptr1)) > 0)
#endif
	ptr1 = ptr1 + strlen(ptr1) + 10;	/*key & data */

    tracep[trx] = (short) (ptr1 - block) - 4;

    if (is < 0) {
	memcpy(&ilong, ptr1 - 4, 4);
	if (ilong <= 0L) {
	    j = (short) (ptr1 - block);
	    goto fail;
	    }
	i = ilong;
	goto nxtblk;
      }

    /* found */

    if (g == RETRIEVE) {	/*search operation */

	ptr1 += strlen(ptr1) + 1;
	memcpy(&datptr, ptr1, 4);

	if (datptr < 0L) {
	    bd[0] = 0;
	    return (0);		/* deleted */
	    }

	if (datptr == 0L) {
	    bd[0] = 0;
	    return (1);
	    } 

      else {
	    lseek(gbldat, datptr, SEEK_SET);
	    read(gbldat, &datlen, 2);	/* length of data */
	    read(gbldat, bd, datlen);	/* data */
	    }

	return (1);
    }

    if (g == STORE) {		/* store */

	if (ReadOnly) {
	    freadx((unsigned char **) &RDFlg, 12L, 1);	/* integrity flag */
	    *RDFlg = 0L;	/* mark as open - reset at close */
	    lseek(gblfd, 0L, SEEK_SET);
	    write(gblfd, bfr[gblroot].gblbf, 1024);	/* dump super block */
	    ReadOnly = 0;
	    }

	freadx(&block, i, 1);
	ptr1 += strlen(ptr1) + 1;

/*------------------------------*/
/* add new record - reuse old   */
/*------------------------------*/

	memcpy(&datptr, ptr1, 4);

	is = strlen(bd);

	if (datptr <= 0L) goto newrec;

	lseek(gbldat, datptr, SEEK_SET);
	read(gbldat, &datlen, 2);	/* length code */

	if (datlen > is) {
	    lseek(gbldat, datptr, SEEK_SET);
	    goto save;
	    }

/*------------------------*/
/* delete old data record */
/* add new record at EOF  */
/*------------------------*/

      newrec:if (is == 0) {
	    datptr = 0L;
	    goto save1;
	    }

	datptr = lseek(gbldat, 0L, SEEK_END);
	datlen = is + 1;

      save:write(gbldat, &datlen, 2);	/* length code */
	write(gbldat, bd, datlen);	/* data */
      save1:memcpy(ptr1, &datptr, 4);	/* data address */
	return (1);
      }

    j = (short) (ptr1 - block);

    if (g == KILL) {		/* delete */

	if (ReadOnly) {
	    freadx((unsigned char **) &RDFlg, 12L, 1);	/* integrity flag */
	    *RDFlg = 0L;	/* mark as open - reset at close */
	    lseek(gblfd, 0L, SEEK_SET);
	    write(gblfd, bfr[gblroot].gblbf, 1024);	/* dump super block */
	    ReadOnly = 0;
	    }

	freadx(&block, i, 1);
	strcpy(key, ptr1);	/* actual key deleted */
	ptr1 += strlen(ptr1) + 1;
	datptr = -1L;		/* mark as deleted - negative datptr */
	memcpy(ptr1, &datptr, 4);
	return (1);
      }

    if (g == NEXT || g == XNEXT) {	/* found next */
	j += strlen(&block[j]) + 10;	/* next key */
	memcpy(&ilong, &block[j - 4], 4);	/* look for lessthan childrn */
	if (ilong <= 0L) {
	    goto fail;
	    }
	i = ilong;
	tracep[trx] = j - 4;	/* new parent */
	goto nxtblk;
      }

    /*end found */

fail:

      if (g == NEXT || g == XNEXT) {

	if (block[j] != MARK) {

	    if (g == XNEXT) { /* modify key */
		is = 0;
		ls = j;

		while (block[j] != 0) {
		    key[is] = block[j];
		    is++;
		    j++;
		    }

		key[is] = 0;
		j++;
		memcpy(&datptr, &block[j], 4);	/* data ptr */

		if (datptr < 0L) {
		    j = ls - 4;
		    ptr1 = block + j;
		    goto nxtkey;	/* dltd key */
		    }

		is = 1;
		ks = 0;
		bd[0] = '^';

		for (; block[ls] != 0; ls++) {

		    if (block[ls] != 1) bd[is++] = block[ls];

		    else if (ks) {
			bd[is++] = '"';
			bd[is++] = ',';
			bd[is++] = '"';
		      } 

                else {
			ks = 1;
			bd[is++] = '(';
			bd[is++] = '"';
		      }
		    }
		bd[is - 1] = 0;
		bd[is - 2] = ')';
		return (1);
	      }

/*-----------------
NEXT  case
------------------*/

	    if (strncmp(&block[j], key, nxtln) == 0) { /* modify key */
		is = 0;
		ls = j;

		while (block[j] != 0) {
		    key[is] = block[j];
		    is++;
		    j++;
		    }

		key[is] = 0;
		j++;
		memcpy(&datptr, &block[j], 4);

		if (datptr < 0L) {
		    j = ls - 4;
		    ptr1 = block + j;
		    goto nxtkey;	/* dltd key */
		    }

		for (is = nxtln; key[is] != NEXTMARK; is++);
		key[is] = 0;
		strcpy(bd, &key[nxtln]);
		while (bd[0] == ' ') strcpy(bd, &bd[1]);
		return (1);
	      } 

          else {
		strcpy(bd, "-1");
		return (0);
	      }
	}

/*----------------------
end of block mark found
----------------------*/

      upblock:trx--;

	if (trx < 0) {
	    strcpy(bd, "-1");
	    return (0);
	    }

	i = trace[trx];
	j = tracep[trx] + 4;	/* key */
	freadx(&block, i, 0);
	if (block[j] == MARK) goto upblock;
	goto fail;		/* must be parent */
      }

    if (g == STORE) {

	/* store new key */

	k = 0L;
	if (!bd[0]) datptr = 0L;	/* zero length data field */

	else {
	    datptr = lseek(gbldat, 0L, SEEK_END);
	    datlen = strlen(bd) + 1;
	    write(gbldat, &datlen, 2);	/* length code */
	    write(gbldat, bd, datlen);	/* data */
	    }

f1:

      freadx(&block, i, 1);	/* marked for write */

	ls = j;

	while (block[ls] != MARK) ls += strlen(&block[ls]) + 10;

	ks = strlen(key);
	if (ks + ls > 1000) goto split;		/*no room */

	/* simple insert */

	ii = (j - 4) + ks + 10;
	ls++;
	memmove(&block[(j - 4) + ks + 10], &block[j - 4], ls - (j - 4));
	memcpy(&block[j - 4], &k, 4);
	strcpy(&block[j], key);
	j += ks + 1;
	memcpy(&block[j], &datptr, 4);
	block[j + 4] = 0;

	return (1);

	/* split insert */
	/* insert prior to j-4 */

split:

      ii = j - 4;

	for (kk = 0; kk < ii; kk++) bufblk[kk] = block[kk];

	memcpy(&bufblk[j - 4], &k, 4);	/* child */
	strcpy(&bufblk[j], key);	/* key */
	j += ks + 1;
	memcpy(&bufblk[j], &datptr, 4);	/* data address */
	bufblk[j + 4] = 0;

	for (kk = j + 5; ii < 1024; kk++, ii++) bufblk[kk] = block[ii];

	for (; kk < 2048; kk++) bufblk[kk] = 0;

	/* make j forward new block and other things */

	j = 0;			/* find break point */
	while (j < 500) {
	    j += 4;
	    j += strlen(&bufblk[j]) + 6;
	    }

	j += 4;
	tmp1 = j;
	strcpy(key, &bufblk[j]);	/* extract key to be sent up */
	j += strlen(&bufblk[j]) + 1;	/* advance to data pointer */
	memcpy(&datptr, &bufblk[j], 4);	/* extract data to be sent up */
	j += 5;			/* advance past data pointer */

	freadx(&block, i, 1);	/* make memory resident */
	memcpy(block, &bufblk[j], 1024);	/* right block */

	for (kk = tmp1; kk < 2048; kk++)
	    bufblk[kk] = 0;	/* zap old right block
				   but hold child ptr */

	bufblk[tmp1] = MARK;
	bufblk[tmp1 + 1] = 0;	/* new end of block */

	k = allocblk();		/* allocate new left block */
	freadx(&block1, k, 1);	/* make memory resident */
	memcpy(block1, bufblk, 1024);	/* left part of block */

	/* fix parent */

	trx--;
	if (trx < 0) goto rootfix;
	i = trace[trx];
	j = tracep[trx] + 4;
	goto f1;

      rootfix:
	m = allocblk();
	freadx(&block, 0L, 1);
	memcpy(block, &m, 4);
	freadx(&block, m, 1);
	for (kk = 0; kk < 1024; kk++) block[kk] = 0;
	memcpy(block, &k, 4);
	strcpy(&block[4], key);
	j = 5 + strlen(key);
	memcpy(&block[j], &datptr, 4);
	block[j + 4] = 0;
	j += 5;
	memcpy(&block[j], &trace[0], 4);
	block[j + 4] = MARK;
	block[j + 5] = 0;
	return (1);

      }

    bd[0] = 0;
    return (0);			/* default failure */

}

long allocblk() {

    long *lastrec;
    long rec;
    unsigned char *block;

    freadx((unsigned char **) &lastrec, 8L, 1);
    rec = *lastrec;
    *lastrec += 1024L;
    freadx(&block, (*lastrec), 1);
    return (rec);
}

void freadx(unsigned char **buf, long r, int flag) {

    if (r < 1024L) {		/* root block */

	if (gproot->gblbfx < 0L) {	/* load root */
	    lseek(gblfd, 0L, SEEK_SET);
	    read(gblfd, gproot->gblbf, 1024);
	    gproot->gblbfx = 0L;
	    *buf = gproot->gblbf + r;
	    return;
	    }

	*buf = gproot->gblbf + r;
	return;
      }

    gp1 = gp0;
    gp3 = NULL;
    while (gp1 != NULL) {

	if (gp1->gblbfx == r) {
	    if (flag)
		gp1->gblmod = 1;
	    *buf = gp1->gblbf;
	    if (gp1 == gp0)
		return;
	    gp4 = gp1->next;
	    gp1->next = gp0;
	    gp0 = gp1;
	    gp3->next = gp4;
	    return;
	    }

	gp5 = gp3;
	gp3 = gp1;
	gp1 = gp1->next;
      }

    if (gp3->gblmod) {		/* write modified block out */
	lseek(gblfd, (long) gp3->gblbfx, SEEK_SET);
	write(gblfd, gp3->gblbf, 1024);
      }

    lseek(gblfd, r, SEEK_SET);
    read(gblfd, gp3->gblbf, 1024);
    *buf = gp3->gblbf;
    gp3->gblbfx = r;
    gp3->gblmod = flag;
    gp3->next = gp0;
    gp0 = gp3;
    gp5->next = NULL;
    return;
}

void keyfix(unsigned char *vxd) {

    int ls, is, ks, js, ms, ns;
    char *p1;

    p1 = vxd;

/************************************************************************
*                                                                       *
*       remove leading ^.  insert current default directory.            *
*                                                                       *
************************************************************************/

    if (*vxd == '^') strcpy(vxd, vxd + 1);

/************************************************************************
*                                                                       *
*       convert markers to 1's                                          *
*                                                                       *
************************************************************************/

    is = 0;
    while (*vxd != 0) {
	if (*vxd > 127)
	    *vxd = 1;
	vxd++;
	is++;
      }

/************************************************************************
*                                                                       *
*       pad numeric subscripts for collating sequence compatibility     *
*									*
*	can be disabled with gpad setting				*
*                                                                       *
************************************************************************/

    if (gpad) {
	ls = is;
	for (is = 0; p1[is] != 0; is++) {
	  next_arg:if (p1[is] != 1)
		continue;	/* find next index */
	    is++;
	    if (p1[is] == 0)
		break;
	    ks = 0;
	    for (js = is; p1[js] != 0; js++) {
		if (p1[js] == 1)
		    break;
		ks++;
		if (ks > 8)
		    goto next_arg;
		if (p1[js] >= '0' && p1[js] <= '9')
		    continue;
		else
		    goto next_arg;
	    }
	    for (ms = ls + (8 - ks); ms > is; ms--)
		p1[ms] = p1[ms - (8 - ks)];
	    ls = ls + (8 - ks);
	    for (ns = 0; ns <= (7 - ks); ns++)
		p1[is + ns] = ' ';
	    is = is + (8 - ks);
	}
    }
    return;
}

#if USYSTEM==LINUX
long tell(int i) {

    FILE *p;
    long j;
    p = fdopen(i, "r");
    j = ftell(p);
    fclose(p);
    return j;
}

int TimeOut_getstr1(FILE * opnfile, unsigned char area[], char *timeout) {

    // insert code here for timeout read
    printf("************************** time out read not implemented \n");
    return 0;
}

int DirectRead(char *to) {
    printf("************************** direct read not implemented \n");
    return 0;
}

#endif

void _fnumber(unsigned char *a, unsigned char *b, unsigned char *c,
	      unsigned char *d) {

strcpy(a, "Fnumber not implemented ");
return;
}

//#+------------------------------------------------------------------------------------------
//#+------------------------------------------------------------------------------------------
//#+
//#+ Indirection Interface
//#+
//#+------------------------------------------------------------------------------------------
//#+------------------------------------------------------------------------------------------

#ifdef INDIRECTION

#if UNIX==0
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <bios.h>
#endif

#define SymStore 0
#define SymRetrieve 1
#define SymDeleteExplicit 2
#define SymNext 3
#define SymDeleteAll 4
#define SymDeleteAllExcept 5
#define SymData 6

#define RETRIEVE 0
#define STORE 1
#define NEXT 2
#define XNEXT 8
#define NEXTX 20
#define KILL1 30
#define PREVIOUS 9

#define TAB 9
#define QUOTE '\''
#define POPEN 0
#define DIVIDE 1
#define MULTIPLY 2
#define MINUS 3
#define PLUS 4
#define OPERAND 5
#define OPENC 6
#define CONCAT 7
#define EQUALS 8
#define GREATER 9
#define PEMPTY 10
#define LESSTHAN 11
#define NOT 12
#define INTDIVIDE 13
#define MODULO 14
#define CONTAINS 15
#define FOLLOWS 16
#define PATTERN 17
#define NOTEQ 18
#define NOTGREATER 19
#define NOTLESS 20
#define NOTCONTAINS 21
#define NOTFOLLOWS 22
#define NOTPATTERN 23
#define AND 24
#define OR 25
#define NOTAND 26
#define NOTOR 27
#define INDIRECT 28
#define PREDICATEVAR '~'
#define CodedOpen 206
#define CodedClose 207
#define CodedComma 208
#define CodedColon 209

void fcn();

parse_() {

//#+ 206 = open; 207 = close; 208 = comma; 209 = colon

short ernbr, f, spx, adx, jpx, j, i, g;
static unsigned char cod209[2] = { 209, 0 };
static unsigned char s1p[40];
unsigned char bbtyp, tmp2[4], tmp1[25], tmp3[1024], nxtchr;
unsigned char *bp = &bd[1];
unsigned char *v1dp = &v1d[1];

static unsigned char code[26] = {

/*0*/  99, 99, 99, 99, 99, 99, 99, 99, 18, 19,
/*10*/ 99, 20, 18, 99, 99, 21, 22, 23, 99, 99,
/*20*/ 99, 99, 99, 99, 26, 27 };

static unsigned char opcode[256] = {

/*0*/   99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*10*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*20*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*30*/  99, 99, 99, 25, 99, 14, 99, 99, 24, 12,
/*40*/   0, 99,  2,  4, 99,  3, 99,  1, 99, 99,
/*50*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*60*/  11,  8,  9, 17, 28, 99, 99, 99, 99, 99,
/*70*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*80*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*90*/  99, 15, 13, 16, 99,  7, 99, 99, 99, 99,
/*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*120*/ 99, 99, 99, 99, 99, 99, 99, 99 };

static unsigned char ncode[256] = {

/*0*/   99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*10*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*20*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*30*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*40*/  99, 99, 99, 99, 99, 99, 10, 99, 10, 10,
/*50*/  10, 10, 10, 10, 10, 10, 10, 10, 99, 99,
/*60*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*70*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*80*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*90*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*120*/ 99, 99, 99, 99, 99, 99, 99, 99 };


static unsigned char dcode[256] = {

/*0*/   10, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*10*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*20*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*30*/  99, 99, 10, 10, 99, 10, 99, 99, 10, 10,
/*40*/  99, 10, 10, 10, 10, 10, 99, 10, 99, 99,
/*50*/  99, 99, 99, 99, 99, 99, 99, 99, 10, 99,
/*60*/  10, 10, 10, 10, 10, 99, 99, 99, 99, 99,
/*70*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*80*/  99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*90*/  99, 10, 10, 10, 10, 10, 99, 99, 99, 99,
/*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*120*/ 99, 99, 99, 99, 99, 99, 99, 99 };

static unsigned char operand[256] = {

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 1, 1, 2, 0,
	0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
	2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 1, 0, 0, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 0, 0, 0, 0, 0 };

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       initialization                                          +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    xpx--;
    spx = 0;
    pd1[pd1len + 2] = 0;
    pd1[pd1len + 3] = 0;
    sdlim = pd1len + 3;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       main recursive internal entry point                     +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  start:spx++;
    s1p[spx] = PEMPTY;		/*stack foundation */

nchar:

    if ((nxtchr = xd[++xpx]) == 0) goto finish;

    if (operand[nxtchr] == 1) goto scan_operand;

    if (nxtchr == CodedOpen) {
	unsigned char *p1, *p2;
	spx++;
	while (pd1[sdlim++]);
	p1 = &v1d[1];
	p2 = &pd1[sdlim];
	while (*p2++ = *p1++);
	*p2 = 0;
	p2--;
	*p2 = CodedOpen;
	s1p[spx] = OPENC;
	goto nchar;
      }

    if (nxtchr == ',') {
	if (s1p[spx - 1] != OPENC) {
	    if (t2 > 0) goto finish;
	    return (16);
	    }

// concatenate stack tops and add coded comma 

	for (i = --sdlim; (pd1[i] = pd1[i + 1]); i++);	/* join tops */
	pd1[i] = CodedComma;
	pd1[i + 1] = 0;		/* coded comma */
	sdlim--;
	while (pd1[sdlim--]);	/* find new stack top start */
	sdlim += 2;
	spx--;			/* stack pointer */
	goto nchar;
      }

    if (nxtchr == ')') {

	if (s1p[spx - 1] != POPEN) {
	    if (s1p[spx - 1] != OPENC) return (16);

// fcn/array return section 

	    sdlim--;
	    for (i = sdlim; (pd1[i] = pd1[i + 1]); i++);	/*join tops */
	    pd1[i] = CodedClose;
	    pd1[i + 1] = 0;	/* coded close */
	    sdlim--;
	    while (pd1[sdlim--]);	/* find new stack top start */
	    sdlim += 2;
	    spx--;		/* stack pointer */
	    goto un_nest;
	    }

// precedence close paren 

	if (s1p[spx] != OPERAND) return (12);

// extract value from stack top

	strcpy(bp, &pd1[sdlim]);

	do sdlim--; while (pd1[sdlim - 1]);	/*compress stack */
	goto dec_stk;
      }

    if (nxtchr == ':') {
	i = sdlim;
	do i--; while (pd1[i - 1]);
	if (pd1[i] != '$' || (pd1[i + 1] != 's' && pd1[i + 1] != 'S')) goto finish;
	sdlim--;
	strcpy(&pd1[sdlim], &pd1[sdlim + 1]);
	while (pd1[sdlim--]);
	sdlim += 2;
	strcat(&pd1[sdlim], cod209);
	spx--;
	goto nchar;
      }

    if (nxtchr == ' ' || nxtchr == '\t') goto finish;

    if (nxtchr == '^' && t2 == 2 && s1p[spx] == OPERAND) goto finish;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       check for delimiters in list                            +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    spx++;
    if (nxtchr == QUOTE) {	/* insert not based operator code */
	xpx++;
	s1p[spx] = opcode[xd[xpx]];
      if (s1p[spx]!=99) {
	      s1p[spx] = code[opcode[xd[xpx]]];
	      if (s1p[spx] != 99) goto nchar;
            }
	xpx--;
      }

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       insert code                                             +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    s1p[spx] = opcode[nxtchr];
    if (s1p[spx] != 99) goto nchar;
    return (12);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       scan for operand                                        +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  scan_operand:

    jpx = xpx;
    if (s1p[spx] == NOTPATTERN || s1p[spx] == PATTERN) {
	bd[1] = 0;
	patrn1(&jpx, &ernbr);
	if (ernbr) return (ernbr);
	goto exec;
      }

/***************************
    numeric operand
***************************/

    if (ncode[xd[xpx]] == 10) {

	for (i = 1; (bd[i] = xd[xpx]) && ncode[bd[i]] == 10; (i++, xpx++));

	if (i == 1 && bd[1] == '.')
	    return (9);
	bd[i] = 0;
	cannon(bp);
	xpx--;
	goto exec;
      }

/***************************
    literal operand
***************************/

    if (xd[xpx] == '"') {
	j = 0;
	while (1) {
	    while (xd[++xpx] != '"') {
		if ((bd[++j] = xd[xpx]) == 0)
		    return (2);
	      }
	    if (xd[xpx + 1] != '"') {
		bd[++j] = 0;
		goto exec;
	      }
	    xpx++;
	    bd[++j] = '"';
	    }
      }

/***************************
    variable name
***************************/

    v1d[1] = xd[xpx++];
    j = 2;
    while (1) {
	if (dcode[xd[xpx]] == 10) {
	    v1d[j] = 0;
	    xpx--;
	    goto var1;
	    }

	v1d[j++] = xd[xpx];

	if (xd[xpx] == '(') {
	    v1d[--j] = 0;
	    xd[xpx--] = CodedOpen;
	    goto start;		/* recurse */
	    }
	xpx++;
      }

un_nest:			/* copy answer from stack */

    while (pd1[--sdlim]);
    strcpy(v1dp, &pd1[sdlim + 1]);
    while (pd1[--sdlim]);
    sdlim++;
    spx -= 2;

  var1:if (t0px == 1 && spx == 1) {
	spx--;
	t0px = 0;
	return (0);
      }

    if (pd1[sdlim] == '$' && t0px == 1 &&
	(pd1[sdlim + 1] == 'P' || pd1[sdlim + 1] == 'p'))

	if (setname[0] == 0) strcpy(setname, v1dp);

    if (v1d[1] == '^') {	/* global var */

	g = RETRIEVE;

	if (pd1[sdlim] == '$' && s1p[spx] != INDIRECT) {

	    if (toupper(pd1[sdlim + 1]) == 'N' ||
		toupper(pd1[sdlim + 1]) == 'O')
		g = NEXT;

	    if (toupper(pd1[sdlim + 1]) == 'B')
		g = PREVIOUS;

	    }

	f = global (g, v1dp, bp);

/*******************************
    fix $order end string 
*******************************/

	if (toupper(pd1[sdlim + 1]) == 'O')
	    if (strcmp(bp, "-1") == 0) bd[1] = 0;	/* empty */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       check for $data                                         +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

	if (pd1[sdlim] == '$' && s1p[spx] != INDIRECT &&
	    (pd1[sdlim + 1] == 'D' || pd1[sdlim + 1] == 'd')) {

	    if (pd1[sdlim + 2] == 'x') {	/* special $d */
		if (f == 0) bd[1] = '0';
		else bd[1] = '1';
		bd[2] = 0;
		goto exec;
	      }

	    if (f == 0) bbtyp = '0';
	    else bbtyp = '1';

	    i = strlen(v1dp);
	    v1d[i + 1] = 2;
	    v1d[i + 2] = 0;
	    f = global (NEXT, v1dp, bd);
	    bd[2] = bbtyp;

	    if (f == 1) bd[1] = '1';
	    else bd[1] = '0';

	    if (bd[1] == '0') {
		bd[1] = bd[2];
		bd[2] = 0;
	      }

	    bd[3] = 0;
	    goto exec;
	    }

	tpx = f;
	goto exec;
      }


/* normal global */

       /*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       +                                                               +
       +       built-in variables/fcns                                 +
       +                                                               +
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    if (v1d[1] == '$') {

	if (v1d[2] == 'd' || v1d[2] == 'n' ||
	    v1d[2] == 'o' || v1d[2] == 'O' ||
	    v1d[2] == 'b' || v1d[2] == 'B' ||
	    v1d[2] == 'D' || v1d[2] == 'N') {

	    for (i = 1; v1d[i] != CodedOpen; i++);	/* open */
	    j = 0;
	    while ((bd[++j] = v1d[++i]) != CodedClose);	/* close */
	    bd[j] = 0;
	    goto exec;
	}

	if (v1d[2] == 'z' || v1d[2] == 'Z') zfcn(v1d, &bd[1]);
	else fcn();

	if (ierr == 0) goto exec;
	return (ierr);
      }

    if (pd1[sdlim] == '$' && s1p[spx] == OPENC &&
	(pd1[sdlim + 1] == 'N' || pd1[sdlim + 1] == 'n' ||
	 pd1[sdlim + 1] == 'B' || pd1[sdlim + 1] == 'b' ||
	 pd1[sdlim + 1] == 'O' || pd1[sdlim + 1] == 'o')) {

	symflg = SymNext;
	sym_(symflg, v1dp, bp);

	if (pd1[sdlim + 1] == 'N' || pd1[sdlim + 1] == 'n' && bd[1] == 0)
	    strcpy(bp, "-1");

	if (symflg && s1p[spx] != INDIRECT)
	    goto exec;

	return (27);
    }

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       retrieve look-up                                        +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    if (v1d[1] == PREDICATEVAR) {
	strcpy(bp, v1dp);
	goto exec;
      }

    symflg = SymRetrieve;
    sym_(symflg, v1dp, bp);
    if (pd1[sdlim] != '$') goto sym1;

/*...........................*/
/*    local variable $DATA */
/*...........................*/

    if (s1p[spx] == OPENC
	&& (pd1[sdlim + 1] == 'd' || pd1[sdlim + 1] == 'D')) {
	symflg = SymData;
	sym_(symflg, v1dp, bp);
	goto exec;
      }

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       check for variable not found                            +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

sym1:

    if (symflg == 0) {
	int i = 1, j, k = 1;
	while (1) {		/* look for a label of the same name */
	    for (j = i; pd1[j] != TAB; j++);
	    if (strncmp(&pd1[i], v1dp, j - i) == 0 &&
		strlen(v1dp) == j - i) {
		sprintf(bp, "%d", k);
		goto exec;
	      }
	    i = i + strlen(&pd1[i]) + 1;
	    if (i > pd1len)
		break;
	    k++;
	  }
	return (17);
      }

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       process value in bb or bd                               +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

exec:

    if (s1p[spx] != PEMPTY && s1p[spx] != POPEN
	&& s1p[spx] != OPENC) goto nxt_expr;

    spx++;
    while (pd1[sdlim++]);
    strcpy(&pd1[sdlim], bp);
    s1p[spx] = OPERAND;
    goto nchar;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       process expression - check  for operator on stack top   +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

nxt_expr:

    if (s1p[spx] == POPEN || s1p[spx] == OPERAND) return (11);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       check for number under operator                         +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    if (s1p[spx - 1] != OPERAND) {

	switch (s1p[spx]) {

default:

	    return (1);

case INDIRECT:

	    strcat(bp, &xd[xpx + 1]);
	    strcpy(&xd[1], bp);
	    spx--;
	    xpx = 0;
	    if (kflg && spx <= 1) {
		xpx = 1;
		return (0);
	      }
	    goto nchar;

case MINUS:		/* unary minus */

	    strcpy(tmp3, "-1");
	    mult(bp, tmp3, bp);
	    break;

case NOT:		/* unary not */

	    if (numcomp(bp, "0") == 0) bd[1] = '1';
	    else bd[1] = '0';
	    bd[2] = 0;
	    break;

case PLUS:		/* unary plus */

	    strcpy(tmp3, "0");
	    add(bp, tmp3, bp);

	}			/* switch */

	spx--;
	goto nxt_operator;
    }

    /* extract value under operator */

    for (adx = sdlim--; pd1[sdlim - 1]; sdlim--);

    /* branch depending upon operator */

switch (s1p[spx]) {

case OPERAND:
case PEMPTY:
case NOT:
default:

	return (12);

case DIVIDE:

	if (numcomp(bp, "0") == 0) {
	    return (15);
          }

	divx(&pd1[adx], bp, bp);
	break;

case MULTIPLY:

	mult(&pd1[adx], bp, bp);
	break;

case MINUS:

	sub(&pd1[adx], bp, bp);
	break;

case PLUS:

	add(&pd1[adx], bp, bp);
	break;

case CONCAT:

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */
	strcat(&pd1[adx], bp);
	strcpy(bp, &pd1[adx]);
	break;

case EQUALS:
case NOTEQ:

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */

	if (s1p[spx] != NOTEQ) {
	    if (strcmp(&pd1[adx], bp) == 0)
		bd[1] = '1';
	    else
		bd[1] = '0';
	    bd[2] = 0;
	    break;
	    }

	if (strcmp(&pd1[adx], bp)) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case GREATER:

	if (numcomp(&pd1[adx], bp) > 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case LESSTHAN:

	if (numcomp(&pd1[adx], bp) < 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case INTDIVIDE:

	strcpy(tmp3, bp);

	if (numcomp(tmp3, "0") == 0) {
	    return (15);
	    }

	divx(&pd1[adx], bp, bp);

	for (i = 1; bd[i]; i++)
	    if (bd[i] == '.') {
		bd[i] = 0;
		break;
	      }

	if (bd[1] == 0) {
	    bd[1] = '0';
	    bd[2] = 0;
	    }

	break;

case MODULO:

	strcpy(tmp3, bp);
	if (numcomp(tmp3, "0") == 0) {
	    return (15);
	    }

	strcpy(tmp3, bp);
	strcpy(tmp1, &pd1[adx]);
	divx(&pd1[adx], bp, bp);

	for (i = 1; bd[i]; i++)
	    if (bd[i] == '.') {
		bd[i] = 0;

		if (bd[1] != '-') break;
		else {
		    strcpy(tmp2, "-1");
		    add(bp, tmp2, bp);
		    break;
		    }
	      }

	if (bd[1] == 0) {
	    bd[1] = '0';
	    bd[2] = 0;
	    }

	mult(tmp3, bp, bp);
	sub(tmp1, bp, bp);
	break;

case CONTAINS:

	if (pd1[adx] == 0 && bp == 0) {
	    bd[1] = '1';
	    bd[2] = 0;
	    break;
	    }

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */

	if (xindex(&pd1[adx], bp, 1) == 0) bd[1] = '0';
	else bd[1] = '1';

	bd[2] = 0;
	break;

case FOLLOWS:

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */

	if (strcmp(&pd1[adx], bp) <= 0) bd[1] = '0';
	else bd[1] = '1';

	bd[2] = 0;
	break;

case PATTERN:

	patrn(&pd1[adx]);
	if (ierr1 != 1 && ierr1) {
	    return (16);
	    }

	if (ierr1 == 0) bd[1] = '0';
	else bd[1] = '1';

	bd[2] = 0;
	break;

case NOTGREATER:

	if (numcomp(&pd1[adx], bp) <= 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case NOTLESS:

	if (numcomp(&pd1[adx], bp) >= 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case NOTCONTAINS:

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */

	if (xindex(&pd1[adx], bp, 1) == 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case NOTFOLLOWS:

	/* if (number(&pd1[adx])) cannon(&pd1[adx]);
	   if (number(bp)) cannon(bp); */

	if (strcmp(&pd1[adx], bp) <= 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case NOTPATTERN:

	patrn(&pd1[adx]);
	if (ierr1 != 1 && ierr1) {
	    return (16);
	    }

	if (ierr1 == 0) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case AND:

	if (numcomp(bp, "0") && numcomp(&pd1[adx], "0")) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case OR:

	if (numcomp(bp, "0") || numcomp(&pd1[adx], "0")) bd[1] = '1';
	else bd[1] = '0';

	bd[2] = 0;
	break;

case NOTAND:

	if (numcomp(bp, "0") && numcomp(&pd1[adx], "0")) bd[1] = '0';
	else bd[1] = '1';

	bd[2] = 0;
	break;

case NOTOR:

	if (numcomp(bp, "0") || numcomp(&pd1[adx], "0")) bd[1] = '0';
	else bd[1] = '1';

	bd[2] = 0;

    }

dec_stk:

    spx -= 2;

nxt_operator:

    if (s1p[spx] != POPEN && s1p[spx] != OPENC && s1p[spx] != PEMPTY)
	goto nxt_expr;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       push answer                                             +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

    spx++;
    sdlim += strlen(&pd1[sdlim]) + 1;
    strcpy(&pd1[sdlim], bp);
    s1p[spx] = OPERAND;
    goto nchar;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                               +
+       exit sequence                                           +
+                                                               +
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

finish:

    if (s1p[spx - 1] != PEMPTY || s1p[spx] != OPERAND) return (16);
    else return (0);

}


//----------------------------------------------------------------------------

void fcn() {

    static unsigned char tmp1[2] = { 0, 0 };
    long int atol(), timex, day, fd;
    double t1;
    char *ctime();
    int rand();
    unsigned char tmp2[1024];
    unsigned char tmp3[1024];
    int rslt;
    static unsigned char cod209[2] = { 209, 0 };

    static unsigned char opcode[256] = {
/*0*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*10*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*20*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*30*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*40*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*50*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*60*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*70*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*80*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
/*90*/ 99, 99, 99, 99, 99, 99, 99, 2, 99, 3,
/*100*/ 99, 1, 4, 99, 14, 13, 5, 99, 6, 99,
/*110*/ 99, 99, 7, 99, 10, 8, 9, 99, 99, 99,
/*120*/ 11, 12, 99, 99, 99, 99, 99, 99
    };

#if UNIX==0
    short int iargs[10], j, nargs, m, n, k, l, i;
#endif
#if UNIX==1
    short int iargs[10], nargs, m, n, k, l;
    long i, j;
#endif

    ierr = 0;
    nargs = 0;
    iargs[0] = 1;
    j = v1d[2];			/* hold function id */
    while (v1d[1] != 206 && v1d[1] != 0)
	strcpy(&v1d[1], &v1d[2]);
    if (v1d[1] == 206)
	strcpy(&v1d[1], &v1d[2]);
    for (i = 1; v1d[i] != 0; i++)
	if (v1d[i] == 207 || v1d[i] == 208) {
	    v1d[i] = 0;
	    iargs[++nargs] = i + 1;
	}

    if (j <= 90)
	j += 32;		/*lower case conversion */
    if ((i = opcode[j]) == 99) {
	ierr = 30;
	return;
    }

    switch (i) {

    case 1:			/* $extract */

	if (nargs == 1) {
	    bd[1] = v1d[1];
	    bd[2] = 0;
	    goto ex2;
	}
	if (nargs != 2 && nargs != 3)
	    goto err;
	sscanf(&v1d[iargs[1]], "%d", &i);
	if (nargs != 3)
	    j = i;
	else
	    sscanf(&v1d[iargs[2]], "%d", &j);
	if (i >= iargs[1] || j < i) {
	    bd[1] = 0;
	    goto ex2;
	}
	if (j > iargs[1])
	    j = iargs[1];
	if (i < 1)
	    i = 1;
	k = 1;
	for (i = i; i <= j; i++)
	    bd[k++] = v1d[i];
	bd[k] = 0;
	goto ex2;

    case 2:			/* $ascii */

	if (nargs > 2)
	    goto err;
	if (nargs == 2)
	    sscanf(&v1d[iargs[1]], "%d", &i);
	else
	    i = 1;
	if (i >= iargs[1] || i <= 0) {
	    bd[1] = '-';
	    bd[2] = '1';
	    bd[3] = 0;
	    return;
	}
	rslt = v1d[i];
	if (rslt == 0)
	    rslt = -1;
	goto ex1;

    case 3:			/* $char        */

	bd[1] = 0;
	j = 1;
	for (i = 1; i <= nargs; i++) {
	    strcpy(tmp2, &v1d[j]);
	    cannon(tmp2);
	    day = atol(tmp2);
	    if (day <= 0)
		day = 0;
	    tmp1[0] = day;
	    tmp1[1] = 0;
	    strcat(&bd[1], tmp1);
	    j = iargs[i];
	}
	return;

    case 4:			/* $find */

	if (nargs != 2 && nargs != 3)
	    goto err;
	strcpy(tmp2, &v1d[1]);
	strcpy(tmp3, &v1d[iargs[1]]);
	if (nargs == 2)
	    i = 1;
	else
	    sscanf(&v1d[iargs[2]], "%d", &i);
	if (tmp3[0] != 0) {
	    if ((i = xindex(tmp2, tmp3, i)) > 0)
		i += strlen(tmp3);
	}
	if (i > strlen(tmp2) + 1)
	    i = 0;
	rslt = i;
	goto ex1;

    case 5:			/* $justify */

	if (nargs == 0) {	/* $job */
	    sprintf(&bd[1], "%X", getpid());
	    goto ex2;
	}

	if (nargs < 2 || nargs > 3)
	    goto err;
	l = atoi(&v1d[iargs[1]]);

	strcpy(&bd[1], &v1d[1]);
	if (nargs != 3) {
	    k = strlen(&bd[1]);
	    if (k >= l)
		goto ex2;
	    if (l > 255)
		l = 255;
	    lpad(&bd[1], &bd[1], l);
	    goto ex2;
	}

	k = atoi(&v1d[iargs[2]]);	/* arg 3 */
	sprintf(tmp2, "%c%d%c%df", '%', l, '.', k);
	t1 = atof(&v1d[1]);
	sprintf(&bd[1], tmp2, t1);
	goto ex2;


    case 6:			/* $len */

	if (nargs == 0) {
	    bd[1] = '0';
	    bd[2] = 0;
	    return;
	};
	strcpy(tmp2, &v1d[1]);
	if (nargs == 2) {
	    i = 1;
	    j = 0;
	    if ((k = strlen(&v1d[iargs[1]])) == 0) {
		rslt = 0;
		goto ex1;
	    }
	    while ((i = xindex(tmp2, &v1d[iargs[1]], i)) != 0) {
		j++;
		i += k;
	    }
	    rslt = j + 1;
	    goto ex1;
	}
	if (nargs > 1)
	    goto err;
	rslt = strlen(tmp2);
      ex1:sprintf(&bd[1], "%d", rslt);
	return;

    case 7:			/* $piece */

	if (nargs == 2) {
	    k = 1;
	    l = 1;
	    goto p1;
	}
	if (nargs < 2 || nargs > 4)
	    goto err;
	if (nargs == 2) {
	    k = 1;
	    l = 1;
	} else {
	    strcpy(tmp2, &v1d[iargs[2]]);
	    k = atoi(tmp2);
	    l = k;
	    if (nargs == 4) {
		strcpy(tmp2, &v1d[iargs[3]]);
		l = atoi(tmp2);
	    }
	}
	if (k < 0)
	    k = 1;
      p1:strcpy(tmp3, &v1d[iargs[1]]);
	strcpy(tmp2, &v1d[1]);
	if (tmp2[0] == 0 || tmp3[0] == 0 || k > l || l <= 0) {
	    bd[1] = 0;
	    goto ex2;
	}
	m = 0;
	n = 0;
	while (n < k - 1) {
	    m = xindex(tmp2, tmp3, m) + 1;
	    if (m == 1) {
		bd[1] = 0;
		goto ex2;
	    }
	    n++;
	}
	if (k != 1)
	    k = m + strlen(tmp3) - 1;
	while (n != l) {
	    m = xindex(tmp2, tmp3, m) + 1;
	    if (m <= 0) {
		m = strlen(tmp2) + 1;
		goto piece1;
	    } else
		n++;
	}
	m = m - k - 1;
      piece1:if (m == 0 && setpiece == 0) {
	    bd[1] = 0;
	    goto ex2;
	}
	if (setpiece == 1) {
	    substr(tmp2, &bd[1], 1, k - 1);
	    bd[k] = 1;
	    bd[k + 1] = 0;
	    if (k + m - 1 < strlen(tmp2))
		strcat(&bd[1], &tmp2[k + m - 1]);
	    goto ex2;
	}
	substr(tmp2, &bd[1], k, m);
	goto ex2;

    case 8:			/* $select */

	if (nargs == 0) {	/* $storage */

	    rslt = 999;
	    sprintf(&bd[1], "%d", rslt);
	    goto ex2;
	}

	i = 0;
      sel1:strcpy(tmp2, &v1d[iargs[i]]);
	j = xindex(tmp2, cod209, 1) - 1;
	if (j <= 0)
	    goto err;
	if (tmp2[j - 1] == '0') {
	    i++;
	    if (i >= nargs)
		goto err;
	    else
		goto sel1;
	}
	strcpy(&bd[1], &tmp2[j + 1]);
	goto ex2;

    case 9:			/* $text */

	if (nargs == 0) {	/* $test */

	    if (tpx == 1)
		bd[1] = '1';
	    else
		bd[1] = '0';
	    bd[2] = 0;
	    goto ex2;
	}

	if (nargs != 1)
	    goto err;

	i = atoi(&v1d[1]);
	if (i <= 0) {
	    bd[1] = 0;
	    goto ex2;
	}
	j = 1;
	k = 1;
	while (k != i) {
	    j = j + strlen(&pd1[j]) + 1;
	    if (j > pd1len) {
		bd[1] = 0;
		goto ex2;
	    }
	    k++;
	}
	i = 1;
	while (pd1[j] != 0)
	    if (pd1[j] != TAB)
		bd[i++] = pd1[j++];
	    else {
		bd[i++] = '\t';
		j++;
	    }
	bd[i] = 0;
	goto ex2;

    case 10:			/* random */

	if (nargs != 1)
	    goto err;
	j = atoi(&v1d[1]);
	if (j < 2) {
	    bd[1] = '0';
	    bd[2] = 0;
	    return;
	}
	rslt = rand();
	rslt = rslt / (RAND_MAX / (j));
	sprintf(&bd[1], "%d", rslt);
	return;

    case 11:			/* $x */

	sprintf(&bd[1], "%d", hor[io]);
	goto ex2;

    case 12:			/* $y */

	sprintf(&bd[1], "%d", ver[io]);
	goto ex2;

    case 13:			/* $io */

	sprintf(&bd[1], "%d", io);
	goto ex2;

    case 14:			/* $horolog */

#if UNIX==0
	timezone = 0;
	daylight = 0;
#endif
	timex = time(&timex);
	day = timex / 86400;
	timex = timex - (day * 86400);
	day = 47118 + day;
	fd = day;
	sprintf(&bd[1], "%ld", fd);
	strcat(&bd[1], ",");
	fd = timex;
	sprintf(tmp2, "%ld", fd);
	strcat(&bd[1], tmp2);
	return;

    }

  ex2:ierr = 0;
    return;

  err:ierr = 9;
    return;
}


#ifdef POSTGRES
#include <pgsql/libpq-fe.h>
#define _XOPEN_SOURCE
#include <unistd.h>
static PGconn *PG1;
PGresult *PR1;
static char DataBaseHost[256];
#endif

//----------------------------------------------------------------------------


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+
//+     System Interpreter for Indirection
//+
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define STORE 1
#define RETRIEVE 0
#define NEXT 2
#define XNEXT 8
#define GKILL 3
#define INIT 6
#define GOPEN 7
#define EMPTY 5
#define GCLOSE 4

#define SET 's'
#define CMDKILL 'k'
#define WRITE 'w'
#define IF 'i'
#define READ 'r'
#define TAB 9

short zerr;
int kflg;
int Tab;
int mflag;
int cgi_flag = 0;

int xindex(unsigned char *, unsigned char *, short);
void errmod_(short msgnbr, unsigned char text[], FILE * opnfile[]);
void fcn();
int global (short g, unsigned char key[], unsigned char bd[]);
void add(char *a, char *b, char *c);
void prnterr(int);

int Interpret(char *parm1) {

    extern int errno;
    long int ilong, jlong;
    short pd1hold1, pd1hold2, ibr, pd1cur, i, mti = 0, j, k;
    short l, new, pd1Last;

    unsigned char ftmp[512];

    static char opnflg[6] = { 0, 0, 0, 0, 0, 0 };	//* 0: not open; 1: input; 2: output 
    FILE *opnfile[7];
    static int popn[7][4] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    static unsigned short swapextent, shold;
    short ExecLevel = 1;
    short BreakFlag = 0;
    static unsigned char cod206[2] = { 206, 0 };	/* open */
    static unsigned char cod208 = 208;	/* comma */
    static unsigned char cod207 = 207;	/* close */
    static unsigned char cod209 = 209;	/* comma */
    static unsigned char cod210 = 210;	/* colon */
    short retz, icmnd, ernbr, fileflg;
    unsigned char tmp2[1024], tmp3[1024], dirflg, vd[1024];
    unsigned char *pd1p = &pd1[1];

    mflag = 0;			/* window enabled */
    pd1cur = 1;
    pd1len = 0;
    srand(1);

    pd1cur = 1;
    pd1[pd1len + 1] = 0;

//===========================================================================

  restart:

//===========================================================================

    BreakFlag = 0;
    ExecLevel = 1;
    zerr = ernbr;
    ierr = 0;
    Tab = 0;
    t0px = 0;
    t2 = 0;
    kflg = 0;

restore:

    BreakFlag = 0;
    pd1cur = 1;
    setpiece = 0;
    mti = 1;
    kflg = 0;
    pd1Last = 0;


//===========================================================================

  next_line:

//===========================================================================

    strcpy(&pd1[1], parm1);
    pd1len = strlen(parm1) + 1;

    pd1Last = pd1cur;
    xpx = j = 1;
    while ((xd[j++] = pd1[pd1cur++]) != 0);
    xd[j] = 0;

//===========================================================================

next_cmnd:

//===========================================================================

//        while (1) {
//if (xd[xpx]==0||xpx>=1024)
//if (xd[xpx]!=' '&&xd[xpx]!='\t') break;
//xpx++;
//}

    t2 = t0px = 0;
    icmnd = tolower(xd[xpx]);
    while (isalpha(xd[++xpx]));

//===========================================================================

    if (xd[xpx])
	xpx++;

    switch (icmnd) {

//===========================================================================

case IF:

	if (xd[xpx] == ' ') {
	    xpx++;
	    if (tpx) return 0;
	    xpx = 1024;
	    return 0;
	    }


	while (1) {

	    t2 = 1;
	    if ((ierr = parse_())) goto parse_err;

	    if (numcomp(&pd1[sdlim], "0") == 0) {
		tpx = 0;
		xpx = 1024;
		return 0;
	      }

	    tpx = 1;
	    if (xd[xpx] != ',') return 0;
	    xpx++;
	    }

//===========================================================================

case SET:

      set:
	if (xd[xpx] == '@') {
	    kflg = 1;
	    t0px = 1;
	    if ((ierr = parse_()))
		goto parse_err;
	    kflg = 0;
	}

	ftmp[0] = 0;
	if (xd[xpx] == '(') {
	    xpx++;
	    vd[1] = 0;
s1:

            t0px = 1;
	    if ((ierr = parse_())) goto parse_err;
	    strcat(ftmp, &v1d[1]);
	    strcat(ftmp, " ");
	    xpx++;
	    if (xd[xpx] != ')' && xd[xpx]) {
		xpx++;
		goto s1;
	      }
	} else {
	    t0px = 1;
	    setname[0] = 0;
	    if ((ierr = parse_()))
		goto parse_err;
	    strcpy(&vd[1], &v1d[1]);
          }

	xpx += 2;
	t0px = 0;
	t2 = 1;

	if ((ierr = parse_())) {
	    goto parse_err;
	    }

	retz = SET;
	k = 0;
	if (vd[1]) goto lhsref;

s2:
      j = 1;
	while ((vd[j++] = ftmp[k++]) != ' ');
	vd[j - 1] = 0;
	goto lhsref;

      set_return:

	if (ftmp[k]) goto s2;

	if (xd[xpx] == ',') {
	    xpx++;
	    goto set;
          }
	return 0;

//===========================================================================

case CMDKILL:

/*    Kill all local variables */

      kill_again:

	if (xd[xpx] == ' ' || xd[xpx] == 0 || xd[xpx] == '\t') {
	    symflg = 4;
	    // sym_("","");
	    return 0;
	}

/*    Kill indirect */

	if (xd[xpx] == '@') {
	    kflg = 1;
	    t0px = 1;
	    if ((ierr = parse_())) goto parse_err;
	    kflg = 0;
          }

/*    Kill specific */

	if (xd[xpx] != '(') {

	    t0px = 1;
	    if ((ierr = parse_()))
		goto parse_err;

	    if (v1d[1] != '^') {	/* kill a local */
		symflg = 2;	/* kill */
		// sym_(&v1d[1],""); 
	    }

	    else {		/* globals */
		keyfix(&v1d[1]);
		k = strlen(&v1d[1]);	/* original lngth */
		strcpy(tmp2, &v1d[1]);
		global (GKILL, &v1d[1], bd);	/* kill first */
	      k1:j = global (XNEXT, &v1d[1], bd);	/* kill others like it */
		if (j && strncmp(tmp2, &v1d[1], k) == 0) {
		    global (GKILL, &v1d[1], bd);
		    goto k1;
		}
	    }
	}

/*    Kill all locals except... */

	else {

	    struct nmes *p1, *p2;

	    nstart = NULL;
	    xpx++;

kill2:

          t0px = 1;
	    if ((ierr = parse_())) goto parse_err;
	    p1 = (struct nmes *) malloc(sizeof(struct nmes));

	    if (p1 == NULL) {
		printf("\n*** Out of memory\n");
		return 99;
	      }

	    p1->name = (char *) malloc(strlen(&v1d[1]) + 1);

	    if (p1->name == NULL) {
		printf("\n*** Out of memory\n");
		return 99;
	      }

	    keyfix(&v1d[1]);	/* in case its an array */
	    strcpy(p1->name, &v1d[1]);
	    p1->next = nstart;
	    nstart = p1;
	    xpx++;

	    if (xd[xpx] != ')' && xd[xpx]) {
		xpx++;
		goto kill2;
	      }

	    symflg = 5;
	    // sym_("","");
	    p1 = nstart;

	    while (p1 != NULL) {
		p2 = p1->next;
		free(p1->name);
		free(p1);
		p1 = p2;
	      }
	    nstart = NULL;
	}

	if (xd[++xpx] == ',') {
	    xpx++;
	    goto kill_again;
	    }

	return 0;

/*-------------------------------------------------------------------------*/

// remote block to proces lhs type references

lhsref:

      if (vd[1] == '^') {
            strcpy(v1d, &vd[1]);
            strcpy(bd, &pd1[sdlim]);
            global (STORE, v1d, bd);
            } 
      else {
	    if (vd[1] == '$' && (vd[2] == 'p' || vd[2] == 'P')) {
		strcpy(tmp3, &pd1[sdlim]);
		strcpy(&v1d[1], &vd[1]);
		setpiece = 1;
		fcn();
		setpiece = 0;
		for (i = 1; bd[i] != 0 && bd[i] != 1; i++);
		if (bd[i] == 0) goto ref_err;
		sdlim = pd1len + 2;
		l = 1;
		j = sdlim;
		while (l < i) pd1[j++] = bd[l++];
		pd1[j] = 0;
		strcat(&pd1[sdlim], tmp3);
		strcat(&pd1[sdlim], &bd[i + 1]);
		strcpy(&vd[1], setname);
		goto lhsref;
	      } 
          else {
		symflg = 0;	/* store */
		sym_(symflg, &vd[1], &pd1[sdlim]);
	      }
	}

	goto set_return;

/*-------------------------------------------------------------------------*/

      err_call:ernbr = 0;
	printf("\n*** %d Control-C\n", ernbr);
	goto abrt1;

parse_err:
      
      ernbr = ierr;
	prnterr(ernbr);
	printf("\n*** %d Expression error\n", ernbr);
	goto abrt1;

post_cond_error:
      
      ernbr = 6;
	prnterr(ernbr);
	goto abrt1;

lbl_error:
      
      ernbr = 8;
	prnterr(ernbr);
	goto abrt1;

default:

	ernbr = 13;
	prnterr(ernbr);
	goto abrt1;

arg_list_error:

      ernbr = 14;
	prnterr(ernbr);
	goto abrt1;

ref_err:

      ernbr = 18;
	prnterr(ernbr);
	goto abrt1;

symtab_err:

      ernbr = 23;
	prnterr(ernbr);
	goto abrt1;

file_error:

      ernbr = 26;
	prnterr(ernbr);
	goto abrt1;

io_error:

      ernbr = 20;
	prnterr(ernbr);
	goto abrt1;

program_size:

      ernbr = 31;
	prnterr(ernbr);
	goto abrt1;

stack_overflow:

      ernbr = 32;
	prnterr(ernbr);

abrt1:
      
      printf("*** %s\n", &pd1[pd1Last]);
	return ernbr;

    } //* command switch 

} //* main function

/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/

void prnterr(int i) {

    printf("\n*** in or near line %d ", LineNumber);

    switch (i) {

case 1:
	printf("Multiple adjacent operators");
	break;

case 2:
	printf("Unmatched quotes");
	break;

case 3:
	printf("Global not found");
	break;

case 4:
	printf("Missing comma");
	break;

case 5:
	printf("Argument not permitted");
	break;

case 6:
	printf("Bad character after post-conditional");
	break;

case 7:
	printf("Invalid quote");
	break;

case 8:
	printf("Label not found");
	break;

case 9:
	printf("Too many/few fcn arguments");
	break;

case 10:
	printf("Invalid number");
	break;

case 11:
	printf("Missing operator");
	break;

case 12:
	printf("Unrecognized operator");
	break;

case 13:
	printf("Keyword");
	break;

case 14:
	printf("Argument list");
	break;

case 15:
	printf("Divide by zero");
	break;

case 16:
	printf("Invalid expression");
	break;

case 17:
	printf("Variable not found");
	break;

case 18:
	printf("Invalid reference");
	break;

case 19:
	printf("Logical table space overflow");
	break;

case 20:
	printf("I/O error");
	break;

case 23:
	printf("Symbol table full");
	break;

case 24:
	printf("Function argument error");
	break;

case 25:
	printf("Global not permitted");
	break;

case 26:
	printf("File error");
	break;

case 27:
	printf("$N error");
	break;

case 29:
	printf("<break> at line:");
	break;

case 30:
	printf("Function not found");
	break;

case 31:
	printf("Program space exceeded");
	break;

case 32:
	printf("Stack overflow");
	break;

default:
	printf("Unknown error");
    }
    return;
}
#endif

void Terminate() {

      char tmp0[32],tmp1[32];

      tmp0[0]=0; 
      tmp1[0]=0;                                                 //+++ Function Epilogue
      global (GCLOSE,tmp0,tmp1);                                 //+++ Close Globals
      exit (1);                                                  //+++ Terminate
      } 


/*********************************************************************************************
Here is a copy of the GNU GPL.  It is Copyright of the Free Software Foundation.  The
preceeding code is Copyright Kevin C. O'Kane.
*********************************************************************************************

		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 19yy  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) 19yy name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.

*******************************************************************************/
