/* portable.h -- UMB Scheme, general portability definitions 

UMB Scheme Interpreter  				$Revision: 2.5 $
Copyright (C) 1988, 1991 William R Campbell

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

UMB Scheme was written by Bill Campbell with help from Karl Berry,
Barbara Dixey, Ira Gerstein, Mary Glaser, Kathy Hargreaves, Bill McCabe,
Long Nguyen, Susan Quina, Jeyashree Sivasubram, Bela Sohoni and Thang Quoc Tran.

For additional information about UMB Scheme, contact the author:

	Bill Campbell
	Department of Mathematics and Computer Science
	University of Massachusetts at Boston
	Harbor Campus
	Boston, MA 02125

	Telephone: 617-287-6449		Internet: bill@cs.umb.edu

*/

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#ifndef u3b2
#include <strings.h>
#endif

#define	TRUE	1
#define	FALSE	0

#define MAX_TOKEN_SIZE 1000
#define RADIX 0x8000

#define	Private	static
#define	Public
#define Import extern

typedef unsigned char Byte;
typedef	char	Character ;
typedef	char *	String ;
typedef	int	Boolean ;
typedef	int	Integer ;
typedef short	Short ;
typedef double  Double ;
typedef unsigned short Unsigned_Short;

#define Integer_Format "%d"
#define Short_Format "%d"
#define Double_Format "%.16g"

typedef enum
{
   LESS_THAN, GREATER_THAN, EQUAL_TO
} Compare_Type;

/* Type definitions for library functions. */
Import Byte *malloc();
Import Integer system(), memcmp(), _filbuf(), _flsbuf() /*,setjmp()*/; 
Import Integer abs();
Import String getenv(), strchr(), strrchr(), realloc();
Import Boolean isatty();

/* A usually nicer way to call |strcmp|. */
#define Eq_Strs(s1,s2) (strcmp((s1),(s2)) == 0)
#define Is_Terminal(stream) (isatty(fileno(stream)))


#ifdef sun
Import	void	memcpy(), free(), exit(), longjmp() ;
Import	void	fclose(), fprintf(), printf(); 
Import	int	ungetc();
Import	char*	sprintf() ; 
#endif


#ifdef vax
Import	void	memcpy(), free(), exit(), longjmp() ;
Import	void	fclose(), fprintf(), printf(); 
Import	int	ungetc();
Import	int	errno;
#endif

/* Alignment */

#ifdef vax
#define	NEGATIVE_ADDRESSES	0
#define ALIGNMENT		1
#endif

#ifdef mc68000
#define	NEGATIVE_ADDRESSES	0
#define ALIGNMENT		1
#endif

#ifdef sparc
#define	NEGATIVE_ADDRESSES	0
#define ALIGNMENT		8
#endif

#ifdef  sun386
#define	NEGATIVE_ADDRESSES	0
#define ALIGNMENT		1
#endif

#ifdef  linux
#define	NEGATIVE_ADDRESSES	0
#define ALIGNMENT		1
#endif

#ifdef u3b2
#define	NEGATIVE_ADDRESSES	1
#define ALIGNMENT		8
#endif
