/*	$Id: main.c,v 1.14 2001/08/10 15:18:08 sandro Exp $	*/

/*
 * Copyright (c) 1997-2001 Sandro Sigala.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <err.h>

#include "slisp.h"
#include "extern.h"
#include "version.h"

/* Be verbose. */
int opt_verbose = 0;
/* Show warnings. */
int opt_lint = 0;

static void process_input(void)
{
	objectp p, p1;
	int onatty = input_file == stdin && isatty(STDIN_FILENO);

	init_lex();

	for (;;) {
		if (onatty) {
			printf("%d/%d >> ", used_objs, free_objs);
			fflush(stdout);
		}

		if ((p = parse_object(0)) == NULL)
			break;

		if (opt_verbose) {
			printf("<<= ");
			princ_object(stdout, p);
			printf("\n");
		}

		p1 = eval(p);

		if (onatty || opt_verbose) {
			printf("==> ");
			princ_object(stdout, p1);
			printf("\n");
		}

#ifdef DEBUG
		warnx(":: objects before collection");
		print_obj_lists();
#endif
		garbage_collect();
#ifdef DEBUG
		warnx(":: objects after collection");
		print_obj_lists();
#endif
	}

	done_lex();
}

static void process_file(char *filename)
{
	if (filename != NULL && strcmp(filename, "-") != 0) {
		if ((input_file = fopen(filename, "r")) == NULL)
			err(1, "%s", filename);
	} else
		input_file = stdin;

	process_input();

	if (input_file != stdin)
		fclose(input_file);
}

static void usage(void)
{
	fprintf(stderr, "usage: slisp [-vVW] [file...]\n");
	exit(1);
}

/*
 * Used by the err() functions.
 */
char *progname;

int main(int argc, char **argv)
{
	int c;

	progname = argv[0];

	while ((c = getopt(argc, argv, "vVW")) != -1)
		switch (c) {
		case 'v':
			opt_verbose = 1;
			break;
		case 'V':
			fprintf(stderr, "%s\n", SLISP_VERSION);
			exit(0);
		case 'W':
			opt_lint = 1;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	argc -= optind;
	argv += optind;

	init_objects();

	if (argc < 1)
		process_file(NULL);
	else
		while (*argv)
			process_file(*argv++);

	return 0;
}
