/*	$Id: extern.h,v 1.9 2001/08/10 15:18:08 sandro Exp $	*/

/*
 * Copyright (c) 1997-2001 Sandro Sigala.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* main.c */

extern int opt_verbose;
extern int opt_lint;

/* object.c */

extern objectp nil;
extern objectp t;

extern int free_objs;
extern int used_objs;
extern void init_objects(void);
extern objectp new_object(int type);
extern objectp search_object_identifier(char *s);
extern objectp search_object_string(char *s);
extern objectp search_object_integer(int in);
extern void set_object(objectp name, objectp value);
extern objectp get_object(objectp name);
extern void dump_objects(char *fname);
extern void print_obj_lists(void);
extern void garbage_collect(void);

/* parser.c */

extern objectp parse_object(int);

/* lexer.c */

extern FILE *input_file;
extern char *token_buffer;
extern int lineno;

extern void init_lex(void);
extern void done_lex(void);
extern int gettoken(void);

/* funcs.c */

extern void princ_object(FILE *, objectp);
extern objectp eval(objectp);
