(defclass top () ())

(setf **generic-stream** (make-generic-stream (make-instance 'top)))

;; This works
(defmethod generic-stream-read-char ((c top))
  (read-char *standard-input*)) 

;; This does not work
;;(defmethod generic-stream-read-char ((c top))
;;  (loop
;;    (when (listen *standard-input*)
;;      (return)))
;;  (read-char *standard-input*))


(defmethod generic-stream-read-byte ((c top))
  (loop
    (when (listen *standard-input*)
      (return)))
  (read-byte *standard-input))

(defmethod generic-stream-peek-char ((c top))
  (loop
    (when (listen *standard-input*)
      (return)))
  (values (peek-char nil *standard-input*) nil))

(defmethod generic-stream-read-char-will-hang-p ((c top))
  (read-char-will-hang-p *standard-input*))

(defmethod generic-stream-write-char ((c top) ch)
  (write-char ch *standard-input*))

(defmethod generic-stream-write-byte ((c top) by)
  (write-byte by *standard-input*))

(defmethod generic-stream-write-string ((c top) string start len)
  (write-string string *standard-input* :start start :end (+ start len)))

(defmethod generic-stream-clear-input ((c top))
  (clear-input *standard-input*))

(defmethod generic-stream-clear-output ((c top))
  (clear-output *standard-input*))

(defmethod generic-stream-finish-output ((c top))
  (finish-output *standard-input*))

(defmethod generic-stream-force-output ((c top))
  (force-output *standard-input*))

(defmethod generic-stream-close ((c top))
  (close *standard-input*))



