
(defun test01 (a b c)
  (princ a)
  (princ b)
  (princ c))

(defun test02 (a b c)
  (block name 
	 (princ a)
	 (princ b)
	 (princ c)
	 (return-from name 20)))

(defun test03 (a b c)
  (catch 'begin 
    (princ a)
    (princ b)
    (princ c)))

(defun test04 (a b c)
  (compiler-let ((a1 a) (b1 b) c1)
		(princ a)
		(princ b)
		(princ c)
		(princ a1)
		(princ b1)
		(princ c1)))

(defun test05 (a b c)
  (eval-when (compile load eval) (princ a) (princ b))
  (eval-when () (princ a) (princ b)))


(defun test06 ( a b c)
  (flet ((fun1 (x) (princ x)) (fun2 (x) (princ x)))
	(princ a)
	(fun1 b)
	(fun2 c)))


(defun test07 (a b c)
  (funcall #'(lambda (x) (princ x)) a)
  (funcall #'princ b)
  (princ c))


(defun test08 (a b c)
  (if a (princ 10) (princ 20))
  (if (eq a b) (princ 30))
  (if (eq a c) (princ 40) (princ 50)))



(defun test09 ( a b c)
  (labels ((fun1 (x) (princ x)) (fun2 (x) (princ x)))
	  (princ a)
	  (fun1 b)
	  (fun2 c)))


(defun test10 (a b c)
  (let ((a1 (+ a b)) (a2) c1 (c c)) (princ a1) (princ a2) (princ c1) (princ c)))

(defun test11 (a b c)
  (let* ((a1 a) (a2 (+ a b c)) c1) (princ a1) (princ a2) (princ c1)))


(defun test12 (a b c)
  (macrolet ((proef (n) `(list ,n))) (princ a) (princ b) (princ (proef c))))

(defun test13 (a b c)
  (cond ((eq a #\)) (princ "Test character read"))
	    ((eq a ")dd)ddd") (princ "OK"))))

(defun test14 (a b c)
  (multiple-value-call #'test11 (+ a 1) (+ a 2) (+ a 3)))

(defun test15 (a b c) 
  (multiple-value-call #'(lambda (x y z) (list x y z)) (+ a b) (+ b c) (+ a c))
  #\a)


(defun test16 (a b c)
  (multiple-value-prog1 (values a b c) (princ a) (princ b) (princ c)))


(defun test17 (a b c)
  (progn (princ a) (princ b) (princ c)))


(defun test19 (a b c)
  (progv (list 'a1 'b1 'c1) (list a b c)  (princ a1) (princ b1) (princ c1)))


(defun test20 (a b c)
  (setq a1 a b1 b c1 (+ a b c))
  (princ a1)
  (princ b1)
  (princ c1))


(defun test20 (a b c)
  (princ a)
  (princ b)
  (return-from test20 (+ a b c))
  (princ c))


(defun test21 (a b c)
  (tagbody (princ a) label (when (< b 0) (return-from test21)) (setf b (1- b)) (princ b) (go label) (princ c)))

(defun test22 (a b c)
  (the integer (princ a))
  (the integer (princ b))
  (the integer (princ c)))


(defun test23 (a b c)
  (catch 'error (princ a) (princ b) (throw 'error (princ c)) (princ (+ a b c))))


(defun test24 (a b c)
  (unwind-protect (progn (princ a) (return-from test24)) (princ b) (princ c)))

(defun test25 (a b c)
  (and (princ a) (princ b) NIL (princ c)))


(defun test26 (a b c)
  (case (+ a b c) (1 (princ 'a)) (2 (princ 'b)) ((3 4 5 6 7) (princ 'c))))

(defun test27 (a b c)
  (cond ((= a 1) (princ 'a))
	    (b (princ 'b))
	    ((= c 10) (princ 'c))
	    (T (princ 'T))))


(defun test28 (a b c)
  (princ (decf a))
  (princ (decf a (+ a b c))))


(defun test29 (a b c)
  (do ((n a (1+ n)) (m b) (k))
        ((> n c) (princ c))
	(setf k c)
	(princ k)))


(defun test30 (a b c)
  (do* ((n a (1+ n)) (m b) (k))
          ((> n c) (princ c))
	  (setf k c)
	  (princ k)))



(defun test31 (a b c)
  (dolist (var (list a b c)) (princ var))
  (dolist (var (list a b c) (list a b c)) (princ var)))

(defun test32 (a b c)
  (dotimes (var c (list a b c)) (princ var))
  (dotimes (var 10) (princ var)))


(defun test33 (a b c)
  (princ (incf a))
  (princ (incf a (+ a b c))))

(defun test34 (a b c)
  (locally (princ a) (princ b) (princ c)))

(defun test35 (a b c)
  (loop (when (> a c) (return 10))
	   (setf a (1+ a))
	   (princ a)))


(defun test36 (a b c)
  (multiple-value-bind (a1 b1 c1) (values a b c) (princ a) (princ b) (princ c)))

(defun test37 (a b c)
  (multiple-value-list (values a b c)))

(defun test38 (a b c)
  (multiple-value-setq (a1 b1 c1) (values a b c))
  (princ a1)
  (princ b1)
  (princ c1))

(defun test39 (a b c)
  (unless (= a 2) (princ 'a))
  (unless (= a c) (princ (+ a b c))))

(defun test40 (a b c)
  (when (= a 2) (princ 'a))
  (when (= 6 c) (princ (+ a b c))))


(defun test41 (a b c)
  (prog ((a1 a) b1 (c1) (d1 (+ a b c))) (princ a1) (princ b1) (princ c1) (princ d1))
  (prog* ((a1 a) b1 (c1) (d1 (+ a b c))) (princ a1) (princ b1) (princ c1) (princ d1)))


(defun test42 (a b c)
  (list (prog1 (princ a) (princ b) (princ c)) (prog2 (princ a) (princ b) (princ c))))

(defun test43 (a b c)
  (psetq a1 (+ a b) a2 (+ a b c))
  (princ a1)
  (princ a2))


(defun test44 (a b c)
  (setf a '(1 2 3 4 5))
  (push (list b c) (rest a))
  a)


(defun test45 (a b c)
  (loop (when (> a c) (return))
	   (setf a (1+ a)))
  (loop (when (> b c) (return (+ a b c)))
	   (setf b (1+ b))))


(defun test46 (a b c)
  (setf a1 (+ a b) a2 (+ a b c))
  (princ a1)
  (princ a2))


(defun test47 (a b c)
  (setf b "Een twee drie vier")
  (with-input-from-string (v b :start a)
			  (princ (read v))
			  (princ (read v))
			  (terpri)))

(defun test48 (a b c)
  (setf c "Begin of the string")
  (setf c (with-output-to-string (v)
				 (format v "Dit is een test ~A" a)
				 (format v "Dit is een test ~A" b)))
  (princ c)
  (terpri))


(defun test49 (a b c)
  (setf a "log")
  (with-open-file (h a :direction :input)
		  (princ (read h))
		  (princ (read h))
		  (terpri)))


(defun test50 (a b c)
  (setf a (open "log" :direction :input))
  (with-open-stream (v a)
		    (princ (read v))
		    (princ (read v))
		    (terpri)))


#+:CMU
(defgeneric fac (n)
  (:method ((n integer)) (if (< n 2) 1 (* n (fac (1- n)))))
  (:method ((n string)) (concatenate 'string n "!"))
  (:documentation "Computes the factorial"))


(defmethod sum ((a integer) (b integer))
  (+ a b))

(defmethod sum ((a string) (b string))
  (concatenate 'string a "+" b))


(defclass testclass ()
  ((field1 :accessor field1)
   (field2 :accessor field2)))

(defun test51 ()
  (let ((a (make-instance 'testclass)))
    (setf (field1 a) 10)
    (setf (field2 a) 20)
    (with-accessors ((v1 field1) (v2 field2)) a
		    (princ v1)
		    (princ v2)
		    (terpri))))


(defun test52 ()
  (let ((a (make-instance 'testclass)))
    (setf (field1 a) 10)
    (setf (field2 a) 20)
    (with-slots ((v1 field1) (v2 field2)) a
		(princ v1)
		(princ v2)
		(terpri))))

(defmacro test53 (exp)
  `(do ((i 1 (1+ i))) ((= i 100) i) ,exp))

(defun test54 ()
  (test53 (cos i)))



(defun test55 (x y z)
  (symbol-macrolet ((x 'foo))
    "Test of symbol-macrolet "
    (list x (let ((x 'bar)) x))))

(defun test56 (n)
  (if (zerop n) 1 (* n (test56 (1- n)))))

(defun test ()
  (test01 1 2 3)
  (test02 1 2 3)
  (test03 1 2 3)
;; not in cmucl  (test04 1 2 3)
;; not in cmucl  (test05 1 2 3)
  (test06 1 2 3)
  (test07 1 2 3)
  (test08 1 2 3)
  (test09 1 2 3)
  (test10 1 2 3)
  (test11 1 2 3)
  (test12 1 2 3)
  (test13 1 2 3)
  (test14 1 2 3)
  (test15 1 2 3)
  (test16 1 2 3)
  (test17 1 2 3)
  (test19 1 2 3)
  (test20 1 2 3)
  (test21 1 2 3)
  (test22 1 2 3)
  (test23 1 2 3)
  (test24 1 2 3)
  (test25 1 2 3)
  (test26 1 2 3)
  (test27 1 2 3)
  (test28 1 2 3)
  (test29 1 2 3)
  (test30 1 2 3)
  (test31 1 2 3)
  (test32 1 2 3)
  (test33 1 2 3)
  (test34 1 2 3)
  (test35 1 2 3)
  (test36 1 2 3)
  (test37 1 2 3)
  (test38 1 2 3)
  (test39 1 2 3)
  (test40 1 2 3)
  (test41 1 2 3)
  (test42 1 2 3)
  (test43 1 2 3)
  (test44 1 2 3)
  (test45 1 2 3)
  (test46 1 2 3)
  (test47 1 2 3)
  (test48 1 2 3)
  (test48 1 2 3)
  (test49 1 2 3)
  (test50 1 2 3)
#+cmucl
  (fac 3)
#+cmucl
  (fac "Drie")
  (sum 1 2)
  (sum "een" "twee")
  (test51)
  (test52))


  



(defun test100 (x y z)
  ;; Dit is een test of problems with comments ( ddd
  (princ x) (princ y) (princ z))

(defun test101 (x y)
  ;; Dit is een test of problems with comments ) ddd
  (list x y))

(defun test102 (x y z)
  " Dit is een test of problems with comments ( ddd"
  (princ x) (princ y) (princ z))

(defun test103 (x y)
  " Dit is een test of problems with comments ) ddd"
  (list x y))



;; Test of features

(push 'een *features*)

#+een
(defun test104 (x y)
  (list x y))

#-een
(defun test105 (x y)
  (list x y))

#+twee
(defun test106 (x y)
  (list x y))

#-twee
(defun test107 (x y)
  (list x y))

#+(and een (not twee))
(defun test108 (x y)
  (list x y))


