/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_wi1.c */
/* codice non ansi per Windows 3.1 */

#include "clos.h"
#pragma hdrstop
#include <mmsystem.h>
#include <dos.h>
#include <sys\timeb.h>
#include <signal.h>

int ctrl_brk_handler(void);
void c_stack_overflow(void);


int ctrl_brk_handler(void)
{
 Throw((LPCATCHBUF)&critical_jmp,LONGJMP_CONTROLC);
 return 0;
}


HGLOBAL hg;
#define PlayResSound(n){\
 hg=LoadResource(hInst,FindResource(hInst,n,"SOUND"));\
 if(hg){\
   sndPlaySound(LockResource(hg),SND_SYNC|SND_MEMORY);\
   UnlockResource(hg);\
   FreeResource(hg);\
 }\
}


#pragma option -N-   /* disattiva il controllo dello stack */
	      /* altrimenti questa funzione richiamerebbe se stessa */
	      /* fino a bloccare tutto */
void c_stack_overflow(void)
{
 PlayResSound("SOUND_1");
 Throw((LPCATCHBUF)&critical_jmp,LONGJMP_STACK);
}
#pragma option -N  /* riattiva il controllo dello stack */

void into(int,int,int* reglist);
void into(int a,int b,int *c)
{
 signal(SIGFPE,into);
 error(E_OVERFLOW,ERR_MERROR|ERR_PVOID|ERR_TBLVL,NULL);
}

int clos_non_ansi_init()
{
 char buffer[100];

 signal(SIGFPE,into);

 lisp_print_string("\n\n\n",stdout);
 sprintf(buffer,
"  ------------------>   Common Lisp Object System   V%s <------------------\n",CLOS_VERSION);
						/*   05  */
 lisp_print_string(buffer,stdout);
 sprintf(buffer,
" ---------------> (c) 1991--1994 By Andrea Michele Zoia <----------------------\n");
 lisp_print_string(buffer,stdout);

 sprintf(buffer,
" ----------------------------->  For Windows  <--------------------------------\n");
  lisp_print_string(buffer,stdout);

 sprintf(buffer,
"  ------------------->Date %s Time %s <------------------------ \n",__DATE__,__TIME__);
		/*          11      08  */
  lisp_print_string(buffer,stdout);
 return OK;
}

void clos_non_ansi_exit()
{
 extern CATCHBUF ExitAddress;
 Throw((LPCATCHBUF)&ExitAddress,1);
}

int cl_beep(int freq)
{
 if(freq)MessageBeep(0);
 return OK;
}

int cl_getch(void)
{
 return WindowsGetChar();
}

long na_millitime(void)
{
 /* ritorna il timer in millisecondi */
 struct timeb t;
 long tmp;

 ftime(&t);

 tmp=t.time;
 tmp*=1000;
 tmp+=(long)t.millitm;
 return tmp;
}

char *matherr_names[6]={
	"DOMAIN",
	"SINGgularity",
	"OVERFLOW",
	"UNDERFLOW",
	"Total LOSS of precision",
	"Partial LOSS of precision" /* non usato da turboc */
};
int matherr(struct exception *e)
{
 char buffer[200];
 sprintf(buffer,
		"type<%s>,function name<%s>,argument1<%f>,argument2(zero if nonexistent)<%f>",
	matherr_names[e->type-1],e->name,e->arg1,e->arg2
 );
 error(E_MATH,ERR_MERROR|ERR_PSTRING|ERR_TBLVL,buffer);
 return 1;
}


void stack_backtrace(void)
{

 /*
 WINDOWS STACK
 ADDRESSES   STACK            BYTES
	 | ecc... 	         |
  low    | 0x12345678 magic	4|    eval stack-frame
	 | bp+1			2|
	 | return address 	4|
	 | nin			4|    eval parameters
	 | nout		        4|
	 | genv			4|
	 | lenv			4|
  high	 | flags		2|

*/


 char far *s;
 char far *p;
 node nin;
 /* node_p *nout; */
 node genv;
 node lenv;
 /* unsigned fl; */
 int printed=FALSE;

 s=MK_FP(_SS,_SP);
 for(;;){
   while(*(unsigned long far *)s!=0x12345678L){
     if(*(unsigned long far *)s==0x87654321L){
       if(printed)lisp_print_string("***End Of Stack***\n",stderr);
       return;
     }
     s++;
   }
   p=s;
   p++;p++;p++;p++;	/* skip magic */

//   if (_DS!=*(unsigned far*)p){
//    lisp_print_string("------Window Stack Error Detected---------\n",stdout);*/
//    Windows creava sullo stack delle zone ''fantasma,, con i parametri
//    delle funzioni in apparente disordine
//    Ora non pi
//     s++;
//     continue;
//   }
   p++;p++;		/* skip BP */

   p++;p++;p++;p++;	/* skip Ret Address */

   nin=*(node far*)p;
   p++;p++;p++;p++;	/* skip nin */

// nout=*(node_p *)p;
   p++;p++;p++;p++;	/* skip *nout */
     
   genv=*(node far *)p;
   p++;p++;p++;p++;     /* skip genv */

   lenv=*(node far *)p;
// p++;p++;p++;p++;     /* skip lenv */

// fl=*(unsigned far*)p;

   if(IS_CONS(nin)){
     printed=TRUE;
     lisp_print_string(  "Function ",stderr);
     fprint_func(CONSLEFT(nin),stderr);
     lisp_print_string("\nParList  ",stderr);
     fprint_func(CONSRIGHT(nin),stderr);
     lisp_print_string("\nL-Env    ",stderr);
     fprint_func(lenv,stderr);
     lisp_print_string("\nG-Env    ",stderr);
     fprint_func(genv,stderr);
     lisp_print_string("\nMore?\n",stderr);
     if(cl_getch()=='n') return;
   }
   s++;
 }

}

/*
   nb: usata solo da windows per caricare un file in modo ''asincrono,,
   rispetto al ciclo di valutazione corrente, che viene interrotto
   tramite ResetFlag
   Ovviamente se si riesce a leggere un file in mezzo al ciclo di valutazione
   si  in modalit self-preemptive, e quindi il loop dei messaggi
   gira sempre, proprio l si va a testare ResetFlag
*/
node eval_lisp_file_async(filename)
char *filename;
{
 node n;
 n=eval_lisp_file(filename,NIL,NIL);
 ResetFlag=TRUE; // appena si torna in modo interattivo
 		 // salta al main - loop
 return n;
}




/* NB: WindowsGetChar ritorna 13 alla pressione di ENTER  */


#define LGC_LEN 100
#define LGC_READ 1
#define LGC_EMIT 2


int lisp_curpos(x,y)
int x;
int y;
{
 TextCursorXY(x,y);
}

int lisp_charcolor(f,b,a)
n_int f;
n_int b;
n_int a;
{
 static int high=127;
 static int blink=127;
 switch(a){
   case 1:
     high=127;
     blink=127;
     CurrentColor=RGB(127,127,127);
     CurrentBackground=0;
     break;
   case 2:
     if(high==127){
     high=255;
     CurrentColor=RGB(
       GetRValue(CurrentColor)*2,
       GetGValue(CurrentColor)*2,
       GetBValue(CurrentColor)*2);
     if(!CurrentColor)CurrentColor=RGB(127,127,127);
     }
     break;
   case 6:
     if(blink==127){
     blink=255;
     CurrentBackground=RGB(
       GetRValue(CurrentBackground)*2,
       GetGValue(CurrentBackground)*2,
       GetBValue(CurrentBackground)*2);
     }
     break;
   case 8:
     CurrentColor=0;
     CurrentBackground=RGB(127,127,127);
     break;
 }
 if(f){
   if(f>=1 && f<=8){
     f--;
     CurrentColor=
       RGB( (f&1) * high , ( (f>>1)&1)*high , ((f>>2)&1)*high);
   }else{
     CurrentColor=f;
   }
 }
 if(b){
   if(b>=1 && b<=8){
     b--;
     CurrentBackground=
       RGB( (b&1)*blink , ( (b>>1)&1)*blink, ((b>>2)&1)*blink);
   }else{
     CurrentBackground=b;
   }
 }
}

int lisp_cls(void)
{
 TextClearWindow();
 InvalidateRect(hClosWindow,NULL,TRUE);
}

/* usare queste funzioni per stampare qualcosa su di un file di I/O utente*/
/* stampa la stessa stringa anche sul dribble file */
/* se il file di I/O non e' NULL */
/* tramite queste funzioni si possono intercettare tutte le chiamate */
/* allo stream e ridirigerle altrove ad.es. su di una finestra di windows */

int lisp_put_char(int c,FILE *f)
{
 /* ritorna c oppure EOF se c'e' qualche errore */
 if(f==stdout || f==stderr){
   TextPutChar(c);
   if(dribble_file)
     fputc(c,dribble_file);
   return c;
 }
 return f?fputc(c,f):EOF;
}

int lisp_print_string(char *s,FILE *f)
{
 /* ritorna l'ultimo carattere della stringa oppure EOF se c'e' un errore */
 int ret;
 while(*s)ret=lisp_put_char(*s++,f);
 return ret;
}


int lisp_get_char(f)
FILE *f;
{
 static unsigned char buffer[MAX_ID_LENGHT];
 static int  counter=0;

 if(f==stdin){
   if(counter==0){
     buffer[0]=0;
     input_string(TextWhereX(),TextWhereY(),buffer,MAX_ID_LENGHT);
     if(dribble_file)
       fputs(buffer,dribble_file);
     lisp_put_char('\n',stdout);
   }
   return buffer[counter]?buffer[counter++]:(counter=0,'\n');
 }
 return f?getc(f):EOF;
}

int lisp_get_string(char *c,int len,FILE *f)
{
 /* len e' la lunghezza massima della stringa senza lo zero finale */
 /* ritorna una stringa senza il newline finale */
 int ret=len;

 if(f==stdin){
   input_string(TextWhereX(),TextWhereY(),c,len);
   if(dribble_file)fputs(c,dribble_file);
 }else{
   if(f){
     if(!fgets(c,len+1,f))ret=EOF;
   }else{
     ret=EOF;
   }
 }
 return ret;
}



#define UP	VK_UP
#define DOWN	VK_DOWN
#define RIGHT	VK_RIGHT
#define LEFT	VK_LEFT
#define HOME	VK_HOME
#define END	VK_END
#define INS	VK_INSERT
#define DEL	VK_DELETE
#define ESC	0x1B
#define BACKSP	0x08
#define TAB	0x09
#define ENTER	0x0D
#define SPACE	0x20

#define CHAR_PER_LINE 80   
int input_string(int x,int y,unsigned char *s,int maxlen)
{
 /* maxlen non tiene conto dello 0 finale */
 int delete_flag=1;
 int curpos=0;
 int len=strlen(s);
 static int insert_flag=1;
 int i;
 unsigned char c;
 unsigned char *d=s;

 //TextSolidCursor(FALSE);
 x--;
 s[maxlen]=0;
 lisp_curpos(x+1,y);
 d=s;
 while(*d)TextPutChar(*d++);
 lisp_curpos(x+1,y);
 do{
   c=WindowsGetChar();
   if(!c){
     switch(WindowsGetChar()){
       case UP:
	 curpos-=CHAR_PER_LINE;
	 if(curpos<0)curpos+=CHAR_PER_LINE;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case DOWN:
	 curpos+=CHAR_PER_LINE;
	 if(curpos>len)curpos-=CHAR_PER_LINE;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case RIGHT:
	 curpos++;
	 if(curpos>len)curpos=len;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case LEFT:
	 curpos--;
	 if(curpos<0)curpos=0;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case END:
	 curpos=len;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case HOME:
	 curpos=0;
	 lisp_curpos(x+1,y);
	 delete_flag=0;
	 break;
       case DEL:
	 if(curpos<len){
	   for(i=curpos;i<len;i++){
	     s[i]=s[i+1];
	     TextPutChar(s[i]?s[i]:' ');
	   }
	   lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	   len--;
	 }
	 delete_flag=0;
	 break;
       case INS:
	 insert_flag^=1;
	 delete_flag=0;
	 TextSolidCursor(!insert_flag);
	 break;
     }
   }
   if(c==BACKSP){
     if(curpos>0){
       lisp_curpos((x+curpos-1)%CHAR_PER_LINE+1,y-(x+curpos-1)/CHAR_PER_LINE);
       for(i=curpos;i<=len;i++){
	 s[i-1]=s[i];
	 TextPutChar(s[i]?s[i]:' ');
       }
       curpos--;
       len--;
       lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
       delete_flag=0;
     }
   }
   if(c>=32){
     if(delete_flag){
       s[0]=0;
       curpos=0;
       len=0;
       lisp_curpos(x+1,y);
       for(i=0;i<len;i++)
	 TextPutChar(' ');
       lisp_curpos(x+1,y);
       delete_flag=0;
     }
     if(insert_flag){
       if(len<maxlen){
	 for(i=len;i>=curpos;i--){
	   s[i+1]=s[i];
	 }
	 for(i=curpos;i<=len;i++){
	   TextPutChar(s[i]);
	   if(y-(x+i+1)/CHAR_PER_LINE==0){
	     y++;
	   }
	 }
	 len++;
	 s[curpos]=c;
	 lisp_curpos((x+curpos)%CHAR_PER_LINE+1,y-(x+curpos)/CHAR_PER_LINE);
	 TextPutChar(c);
	 curpos++;

       }
     }
     else{ /* overwrite */
       if(curpos<len){
	 s[curpos++]=c;
	 TextPutChar(c);
       }
       else{ /* curpos==len */
	 if(len<maxlen){
	   s[curpos++]=c;
	   TextPutChar(c);
	   s[curpos]=0;
	   len++;
	   if(y-(len-1)/CHAR_PER_LINE==0){
	     y++;
	   }
	 }
       }
     }
   }
 }while(c!=ENTER);/* && c!=ESC);*/
 lisp_curpos((x+len+1)%CHAR_PER_LINE,y-(x+len+1)/CHAR_PER_LINE);
 return c;
}



