
(defun create-n (n)
  (do ((n n (1- n))
       (a () (push () a)))
      ((= n 0) a)))

(defvar ll (create-n 200))  

(defun iterative-div2 (l &AUX (I 0))
  (do (( l l (cddr l))
       ( a () (push (car l) a)))
      ((null l) a)))

(defun recursive-div2 (l)
  (cond ((null l) ())
        (t (cons (car l) (recursive-div2 (cddr l))))))

(defun test-2 (l)
  (do ((i 300 (1- i)))
      ((= i 0))
;  (DOTIMES (I 300)
     (recursive-div2 l)
     (recursive-div2 l)
     (recursive-div2 l)
     (recursive-div2 l))) 

(defun test-1 (l)
  (do ((i 300 (1- i)))
      ((= i 0))
;  (DOTIMES ( I 300)
     (iterative-div2 l)
     (iterative-div2 l)
     (iterative-div2 l)
     (iterative-div2 l))) 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun cddr (l)
  (cdr (cdr l))
)



(defun test-iterative-div2(&aux time test1r)
  (setf time (get-time))
  (setf test1r (test-1 ll))
  (print 
    "TEST-iterative ha ritornato " test1r
    "\nTempo impiegato (in millisecondi) <" (- (get-time) time) ">\n"
  )
  'ok
)

(defun test-recursive-div2(&aux time test2r)
  (setf time (get-time))
  (setf test2r (test-2 ll))
  (print 
    "TEST-recursive ha ritornato " test2r
    "\nTempo impiegato (in millisecondi) <" (- (get-time) time) ">\n"
  )
  'ok
)


(print "DIV2 test\n")
(print "Uso: (test-recursive-div2)\n")
(print "Uso: (test-iterative-div2)\n")

