; Graphic Lisp --- Frattali By Zoia Andrea

(setf pi/2 (asin 1.0))
(setf -pi/2 (- pi/2))
(setf pi (* 2 pi/2))


(defun atanyx ( y x &aux r)
 (cond
  ((=0 x)
   (if (> y 0) pi/2 -pi/2 )
  )
  ( t
   (setf r (atan (abs (/ y x) )))
   (if (> x 0)
     (if (< y 0)
       (- r)		;y<0
        r		;y>=0
     )
     (if (< y 0)     
       (- r pi)		;y<0
       (- pi r)         ;y>=0
     )
   )
  )
 )
)

(defun rround (r) (round (+ r .5)))

(defun +list ( list mul )
 (cond
  ( (null list) nil )
  ( t (cons (+ mul (car list)) (+list (cdr list) mul)))
 )
)

(defun *list ( list mul )
 (cond
  ( (null list) nil )
  ( t (cons (* mul (car list)) (*list (cdr list) mul)))
 )
)

(defvar cosa)
(defvar sina)
(defun rotfx ( x y ) (+ (* x cosa) (* y sina ) ) )
(defun rotfy ( x y ) (- (* x sina) (* y cosa ) ) )
(defun rot   ( f vx vy a &aux cosa sina )
 (setf cosa (cos a) )
 (setf sina (sin a) )
 (mapcar f vx vy )
)


(defun base-line ( lptx lpty xs ys xe ye ord )
 (gmoveto (rround xs) (rround ys))
 (glineto (rround xe) (rround ye))
)

(defun indu-line ( lptx lpty xs ys xe ye ord
		      &aux modulo angolo mlptx mlpty rmlptx rmlpty trmlpty trmlptx func )

 (setf modulo  (sqrt (float (+ (* (- xs xe) (- xs xe) ) (* (- ys ye) (- ys ye ) ) ) ) ) )
 (setf angolo  (atanyx  (float (- ye ys)) (float (- xe xs) ) ) )
 ;(print angolo " " modulo)(break)
 (setf mlptx   (*list lptx modulo) )
 (setf mlpty   (*list lpty modulo) )

 (setf rmlptx  (rot #'rotfx mlptx mlpty angolo ) )
 (setf rmlpty  (rot #'rotfy mlptx mlpty angolo ) )

 (setf trmlptx (+list rmlptx xs ) )
 (setf trmlpty (+list rmlpty ys ) )


 (setf func (if (=0 ord) #'base-line #'indu-line ) )
 (do
  (
   ( x trmlptx (cdr x) )
   ( y trmlpty (cdr y) )
  )
  ( (null (cdr x)) nil )
  ( funcall func lptx lpty (car x) (car y) (car(cdr x))(car(cdr y))(1- ord) )
 )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 


;non usata
(defun print-grid (&optional (n 3))
 (dotimes (i n nil)
   (gmoveto (round (* (1+ i) (/ *scrnx* n)))     0        )
   (glineto (round (* (1+ i) (/ *scrnx* n))) (1- *scrny*) )

   (gmoveto       0      (round (* (1+ i) (/ *scrnx* n))) )
   (glineto (1- *scrnx*) (round (* (1+ i) (/ *scrnx* n))) )

 )
)

;non usata
(defun print-fracts (&optional (n 3) &aux xs ys xe ye j)
  (setf j 1)
  (setf xs 0)
  (setf ys (round (/ *scrnx* n 2)))
  (setf xe (round (/ *scrnx* n  )))
  (setf ye (round (/ *scrnx* n 2)))
  (dolist ( i *fractlist* nil)
    (indu-line (car i) (car(cdr i)) xs ys xe ye 0)
    (setf j (1+ j))
    (setf xs xe ys ye)
    (setf xe (* j (round (/ *scrnx* n  ))))
;    (return)
  )
)


(defun input-int ( x y inf sup digits &aux i )
 (loop
  (curpos x y)
  (dotimes (i digits) (print " "))
  (curpos x y)
  (setf i (str2int (read-line digits)))
  (when (intp i)
    (unless (or (> i sup) (< i inf) ) (return i) )
  )
 )
)

; le coordinate devono andare da 0 a 1.
; la prima lista rappresenta X
; la seconda Y
; il terzo elemento la stringa del nome del frattale
(setf *fractlist* '( 
 (
   ( 0.00 0.25 0.25 0.50 0.50 0.50 0.75 0.75 1.00 ) 
   ( 0.00 0.00 -.25 -.25 0.00 +.25 +.25 0.00 0.00 )
   "Fract 1" 
 )
 (
   ( 0.00 0.3333 0.5000 0.6666 1.00 )
   ( 0.00 0.0000 0.3333 0.0000 0.00 )
   "Fract 2"
 )
 (
   ( 0.00 0.25 0.25 0.50 0.75 0.75 1.00 )
   ( 0.00 0.00 0.25 0.00 0.25 0.00 0.00 )
   "Fract 3"
 )
 (
   ( 0.00 0.3333 0.6666 0.6666 1.00 )
   ( 0.00 0.0000 0.3333 0.0000 0.00 )
   "Fract 4"
 )
 (
   ( 0.00 0.3333 0.3333 0.6666 0.6666 1.00 )
   ( 0.00 0.0000 0.3333 0.3333 0.0000 0.00 )
   "Fract 5"
 )  
))



(defun frattali()
(loop
  (cls)
  (curpos 1 15)
  (print   "---------------- FRATTALI -----------------")
  (print "\n  Immetti il tipo e l'ordine")
  (print "\n  Alla fine premi un tasto per continuare")
  (print "\n    oppure ESC per terminare.")
  (curpos 1 10)
  (print "Tipo   [1-5]?")
  (setf *type* (input-int 14 10 1 5 1))
  (curpos 1 9)
  (print "Ordine [0-5]?")
  (setf *ord* (input-int 14 9 0 5 1))

  (setf *scrnx* (gmode 2))
  (setf *scrny* (car(cdr *scrnx*)))
  (setf *scrnx* (car *scrnx*))

  (gpencolor (1- (* 256 256 256)))
  (gouttext 0 0 (car(cdr(cdr(elt *fractlist* *type*)))))

  (gpentick 1)
  (gpencolor 255)
  (gpentype 1)
  (indu-line
    (car     (elt *fractlist* *type*))
    (car(cdr (elt *fractlist* *type*)))
    0 (/ *scrny* 2) *scrnx* (/ *scrny* 2)
    *ord*
  )

;  (gpentick 1)
;  (gpencolor (* 256 255))
;  (gpentype 3)
;  (indu-line
;    (car     (elt *fractlist* *type*))
;    (car(cdr (elt *fractlist* *type*)))
;    0 (/ *scrny* 2) *scrnx* (/ *scrny* 2)
;    0
;  )
  (when (= (readchar) 27) (return) )
  (gmode 0)
)
(gmode 0)
(cls)
(print "Per ripartire digita (frattali)\n")
t
)


;(frattali)
(print "Per partire digita (frattali)\n")



