/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closstr2.c */

#include "clos.h"

/* MEMORIA-STRINGHE

     namebuf	              		        namepunt (nameidx)
       |                                          |
       nnnnnnnnssssss ... ss0nnnnnnnnsssss ... ss00000000000000000 ...
	 |        |         |                      |
	 |      Stringa    Zero finale            Primo byte libero
	 |
       puntatore del nodo di appartenenza

nameidx  il numero di bytes allocati
maxname  il numero dell' ultimo byte (max 65535)
*/

/* NB: non si deve MAI passare NULL ad una funzione */


#define CHAR_GARBAGE	((char)-1)
#define SH(x)		((str_t)(x))
#define SP(x)		((char *)(x))

char  *namebuf=NULL;
char  *namepunt;
unsigned long int  nameidx;
unsigned long int  maxname;

#ifdef LISPMEM_DEBUG
 int look_namebuf();
#endif



str_t	string_put(s,h)
char	*s;
node	h;
{
 /* alloca la stringa s associata al nodo n 				*/
 /* ritorna l'handler della stringa allocata 				*/
 /* insieme alla stringa si mette anche il nodo a cui appartiene:       */
 /* questo per il garbage collection					*/

 char         *tmp;
 unsigned int i;
 unsigned int len_s;
 int          len_n;

 if(string_isallocable(s))
	error(E_NOMEMSTRINGS,ERR_TCRIT|ERR_MERROR|ERR_PVOID,NULL);


 len_s=(unsigned int)strlen(s)+1;/* lunghezza della stringa */
 len_n=(int)sizeof(node);	/* lunghezza del puntatore */


 *(node *)namepunt=h;		/* mette l'handler del nodo prima della stringa */
				/* NOTA: ovunque si suppone che node sia un tipo di dato
					direttamente maneggiabile dall' op '='
					(int)(unsigned)(long)ecc... cioe' un tipo semplice */
 for(i=0;i<len_n;i++){		/* incrementa il puntatore ed il contatore */
	namepunt++;
	nameidx++;
 }
 tmp=namepunt;			/* salva il puntatore alla stringa */
 strcpy(namepunt,s);		/* mette in memoria la stringa */
 for(i=0;i<len_s;i++){		/* incrementa il puntatore ed il contatore */
	namepunt++;
	nameidx++;
 }
 return SH(tmp);
}

char *string_get(s,b)
str_t s;
char  *b;
{
 /* preleva la stringa s e la mette nel buffer b */
 return strcpy((char*)b,SP(s));
}

int string_del(st)
str_t st;
{
 /* cancella la stringa st e rende il suo spazio disponibile al gc */
 int  i;
 char *s;

 s=SP(st);
 if(s==NULL)
   error(E_CLOSSTR2ERR,ERR_TCRIT|ERR_MINTERNAL|ERR_PSTRING,"FROM:string_del");
 for(i=0;i<sizeof(node);i++){
   s--;
 }				/* s punta al puntatore del nodo */
 *(node *)s=VOID;		/* mette l'handler del nodo speciale VOID */
				/* prima della stringa in modo da segnalare */
				/* che questa  cancellata */
 return OK;
}


int     string_gc()
{
 /* compatta lo spazio delle stringhe togliendo quelle il cui nodo  = VOID */
 unsigned int i;
 unsigned long newnidx,nidx;
 char *nptr,*newnptr;
 node n;

 newnidx=0L;
 nidx   =0L;
 nptr   =namebuf;
 newnptr=namebuf;




 while(nidx<nameidx){
   if( *(node*)nptr==VOID ){	/* salta questa stringa cancellata */
     for(i=0;i<sizeof(node);i++){/* salta il puntatore del nodo */
       nidx++;
       nptr++;
     }
     while(nidx++,*nptr++);	 /* salta la stringa */
   }else{			/* recupera la stringa */
     n=*(node*)newnptr=*(node*)nptr; /* copia il puntatore del nodo */
     for(i=0;i<sizeof(node);i++){/* salta il puntatore del nodo */
       nidx++;
       nptr++;
       newnidx++;
       newnptr++;
     }
     switch(GET_NTYPE(n)){	/* modifica il puntatore del nodo */
       case NT_IS_NAME:
	 if(SP(NAME(n))==nptr){
	   NAME(n)=SH(newnptr);
	 }else
	   error(E_GCS1,ERR_MINTERNAL|ERR_TNORM|ERR_PSTRING,nptr);
	 break;
       case NT_IS_VALUE:
	 if(SP(STRING(n))==nptr){
	   STRING(n)=SH(newnptr);
	 }else
	   error(E_GCS2,ERR_MINTERNAL|ERR_TNORM|ERR_PSTRING,nptr);
	 break;
       default:
	 error(E_GCS3,ERR_MINTERNAL|ERR_TNORM|ERR_PSTRING,nptr);
     }
     /* copia e salta la stringa */
     while(*newnptr=*nptr, newnidx++, newnptr++, nidx++, *nptr++);
   }
 }
 if(namepunt!=nptr)
   error(E_CLOSSTR2ERR,ERR_TNORM|ERR_MINTERNAL|ERR_PSTRING,"FROM:string_gc namepunt!=nptr");
 namepunt=newnptr;
 nameidx =newnidx;

#ifdef LISPMEM_DEBUG
  look_namebuf();
#endif
 return OK;
}

int string_isallocable(s)
char *s;
{
 if(nameidx+(unsigned long int)strlen(s)+(unsigned long int)sizeof(node)+1L>maxname){
   string_gc();
   if(nameidx+(unsigned long int)strlen(s)+(unsigned long int)sizeof(node)+1L>maxname){
      node_gc();
      string_gc();
      if(nameidx+(unsigned long int)strlen(s)+(unsigned long int)sizeof(node)+1L>maxname){
	return ERROR;
      }
   }
 }
 return OK;
}

int string_free()
{
 if(namebuf)
   free(namebuf);
 namebuf=NULL;
 return OK;
}

int string_malloc(s)
lsiz_t s;
{
 char  *tmp;
 if(s>0xffffL)return ERROR;
 if((tmp=(char  *)malloc((unsigned)s))==NULL){
   namebuf=namepunt=NULL;
   nameidx=maxname=0L;
   return ERROR;
 }
 namebuf=namepunt=tmp;
 nameidx=0L;
 maxname=s;
 return OK;
}


char	*string_getconv(s_i,s_o)
str_t	s_i;
char	*s_o;
{
 char	 *p=SP(s_i);
 char	 *buf=s_o;

 while(*p){
	if(*p=='\\'){
		switch(*++p){

			case '"':
			case '\\':
				*buf++=*p;
				break;

			case 'a':
				*buf++='\a';
				break;
			case 'b':
				*buf++='\b';
				break;
			case 'f':
				*buf++='\f';
				break;
			case 'n':
				*buf++='\n';
				break;
			case 't':
				*buf++='\t';
				break;
			case 'v':
				*buf++='\v';
				break;
			case  0 :
				*buf++='\\';
				*buf=0;
				return s_o;
			default:
				*buf++='\\';
				*buf++=*p;
		}
	}
	else
		*buf++=*p;

	p++;
 }
 *buf=0;
 return s_o;
}





#ifdef LISPMEM_DEBUG
int look_namebuf()
{
 /* e' una vecchia versione ... modificare !!! */
 char  *p;
 int i;

 p=namebuf;

 while(p<namepunt){
	if(*p==CHAR_GARBAGE){
		printf("GARBAGE\n");
		p++;
	}
	else{
	printf("%s",p);
	while(*p++);
	printf(" node %p\n",*(node *)p);
	for(i=0;i<sizeof(node);i++)
		p++;
	}
 }
}
#endif
