/* GCL-1.0 configuration for Linux running on i386/i486.
 * Written by Bruno Haible <haible@ma2s2.mathematik.uni-karlsruhe.de>,
 * using previous versions by Matteo Frigo <Matteo.Frigo@dei.unipd.it>
 * and Reginald S. Perry <reggie@miles.phys.washington.edu>.
 */

/* use mainly BSD style Unix calls */
#include "bsd.h"

/* use 386 assembly language optimizations */
#include "386.h"

/* <sys/types> already contains a type `ulong' */
#define USE_ULONG_

/* have sigaction, but not sigvec */
#define HAVE_SIGACTION
#undef HAVE_SIGVEC
/* no signal stack */
#define SETUP_SIG_STACK
#define SV_ONSTACK 0
/* we don't have these signals */
/* #define SIGBUS SIGSEGV */ /* already have "#define SIGBUS SIGUNUSED" */
#define SIGEMT SIGSEGV
#define SIGSYS SIGSEGV

/* mprotect not implemented yet in kernel --> SGC not usable */
#if 0
#define SGC
#define SIGPROTV SIGSEGV
#define GET_FAULT_ADDR(sig,code,sv,a) ((char *) code)
#endif

/* put some more things into *features* */
#define ADDITIONAL_FEATURES \
  ADD_FEATURE("I386"); ADD_FEATURE("LINUX"); ADD_FEATURE("PC386");

/* processor and its endianness */
#define I386
#define LITTLE_ENDIAN

/* kind of floats we have */
#define	IEEEFLOAT

/* executable file format, world save */
/* used by macro READ_HEADER in h/bsd.h */
#define DATA_BEGIN (char *)N_DATADDR(header)
#define UNIXSAVE "unexlin.c"
#define NO_REMAP

/* object file format, dynamic loading */
/* no need to include debugging symbols for dynamic loading -> add -S */
#undef LD_COMMAND
#define LD_COMMAND(command,main,start,input,ldarg,output) \
  sprintf(command, "ld -d -S -N -x -A %s -T %x %s %s -o %s", \
          main,start,input,ldarg,output)
/* relocations like on many a.out systems */
#define RELOC_FILE "rel_sun3.c"

/* other FILE internals */
#define FCLOSE_SETBUF_OK
#undef  LISTEN_FOR_INPUT
#if 0 /* this was for libc-2.2.2 to libc-4.4.4 */
#define LISTEN_FOR_INPUT(fp) \
  if((fp)->_gptr >= (fp)->_egptr && (c=0,ioctl(fileno(fp), FIONREAD, &c),c<=0)) \
     return 0
#else /* this is for libc-4.5.8 and newer */
#define LISTEN_FOR_INPUT(fp) \
  if((fp)->_IO_read_ptr >= (fp)->_IO_read_end && (c=0,ioctl(fileno(fp), FIONREAD, &c),c<=0)) \
     return 0
#endif

/* no need for old GNU malloc, we are already using a new GNU malloc */
/* #define GNU_MALLOC */
/* avoid assumptions about free(3) */
#define NOFREE_ERR

/* add support for punimax */
#define CMAC


/* Begin for cmpinclude */

/* gcc has alloca() built-in */
#define HAVE_ALLOCA

/* End for cmpinclude */
