/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/tools/if_mach.c                      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Aug  8 08:17:21 1995                          */
/*    Last change :  Fri Aug 23 09:16:22 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Execute a command on specific architecture.                      */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    Sparc ...                                                        */
/*---------------------------------------------------------------------*/
#if( defined( sparc ) )
#   define MACH_TYPE "sparc"
#   include <errno.h>
#   if( defined( ECHRNG ) )
#      define OS_TYPE "sunos5"
#   else
#      define OS_TYPE "sunos4"
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Alpha                                                            */
/*---------------------------------------------------------------------*/
#if( defined( __alpha ) )
#  define MACH_TYPE "alpha"
#  if( defined( __osf__ ) )
#     define OS_TYPE "osf"
#  endif
#endif

#if( !defined( MACH_TYPE ) )
#   define MACH_TYPE ""
#endif

#if( !defined( OS_TYPE ) )
#   define OS_TYPE ""
#endif

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    usage ...                                                        */
/*---------------------------------------------------------------------*/
void
usage()
{
   fputs( "Usage: if_mach <mach-type> <os-type> <command>" );
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    main ...                                                         */
/*---------------------------------------------------------------------*/
int
main( int argc, char **argv )
{
   if( argc < 4 )
   {
      usage();
      exit( -1 );
   }
   else
   {
      if( strcmp( MACH_TYPE, argv[1] ) )
         exit( 0 );
      else
      if( strcmp( OS_TYPE, "" ) &&
	  strcmp( argv[2], "" ) &&
	  strcmp( OS_TYPE, argv[2] ) )
         exit( 0 );
      else
      {
	 execvp( argv[3], argv+3 );
	 perror( "Couldn't execute" );
      }
   }
}

