;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Rgc/rgc.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 13 10:56:28 1998                          */
;*    Last change :  Mon Sep 21 17:59:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The runtime module of the Bigloo regular expression system.      */
;*    -------------------------------------------------------------    */
;*    For this module we have to use Scheme wrapper otherwise regular  */
;*    grammar may not be used within EVAL.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc
   
   (import  (__error                   "Llib/error.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r5_control_features_6_4 "Ieee/control5.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm"))
 
   (extern  (macro _rgc-buffer-get-char::int  (::input-port)
					      "RGC_BUFFER_GET_CHAR")
	    (macro _rgc-buffer-length::long   (::input-port)
					      "RGC_BUFFER_LENGTH")
	    (macro _rgc-start-match!::int     (::input-port)
					      "RGC_START_MATCH")
	    (macro _rgc-stop-match!::int      (::input-port)
					      "RGC_STOP_MATCH")
	    (macro _rgc-buffer-empty?::bool   (::input-port)
					      "RGC_BUFFER_EMPTY")
	    (macro _rgc-failing-char::int     (::input-port)
		                              "RGC_FAILING_CHAR")
	    (macro _rgc-match-fail::int       (::input-port)
		                              "RGC_MATCH_FAIL")
	    (macro _rgc-buffer-position::long (::input-port)
                                              "RGC_BUFFER_POSITION")
	    (macro _rgc-matchstop::long       (::input-port)
                                              "RGC_MATCHSTOP")
	    (_rgc-buffer-unget-char::int      (::input-port ::int)
					      "rgc_buffer_unget_char")
	    (_rgc-buffer-substring::bstring   (::input-port ::int ::int)
					      "rgc_buffer_substring")
	    (_rgc-buffer-fixnum::long         (::input-port)
					      "rgc_buffer_fixnum")
	    (_rgc-buffer-flonum::double       (::input-port)
					      "rgc_buffer_flonum")
	    (_rgc-buffer-symbol::symbol       (::input-port)
					      "rgc_buffer_symbol")
	    (_rgc-buffer-keyword::keyword     (::input-port)
					      "rgc_buffer_keyword")
	    (_rgc-fill-buffer::bool           (::input-port)
					      "rgc_fill_buffer")
	    (_rgc-buffer-bol?::bool           (::input-port)
					      "rgc_buffer_bol_p")
	    (_rgc-buffer-eol?::bool           (::input-port)
					      "rgc_buffer_eol_p")
	    (_rgc-buffer-bof?::bool           (::input-port)
					      "rgc_buffer_bof_p")
	    (_rgc-buffer-eof?::bool           (::input-port)
					      "rgc_buffer_eof_p"))
 
   (export  (inline rgc-buffer-get-char::int       ::input-port)
	    (inline rgc-buffer-unget-char::int     ::input-port ::int)
	    (inline rgc-buffer-substring::bstring  ::input-port ::int ::int)
	    (inline rgc-buffer-length::long        ::input-port)
	    (inline rgc-buffer-fixnum::long        ::input-port)
	    (inline rgc-buffer-flonum::double      ::input-port)
	    (inline rgc-buffer-symbol::symbol      ::input-port)
	    (inline rgc-buffer-keyword::keyword    ::input-port)
	    (inline rgc-buffer-position::long      ::input-port)
	    (inline rgc-matchstop::long            ::input-port)
	    (inline rgc-failing-char::int          ::input-port)
	    (inline rgc-match-fail::int            ::input-port)
	    (inline rgc-start-match!::int          ::input-port)
	    (inline rgc-stop-match!::int           ::input-port)
	    (inline rgc-buffer-empty?::bool        ::input-port)
	    (inline rgc-fill-buffer::bool          ::input-port)
	    (inline rgc-fill-buffer-if-empty::bool ::input-port)
	    (inline rgc-buffer-bol?::bool          ::input-port)
	    (inline rgc-buffer-eol?::bool          ::input-port)
	    (inline rgc-buffer-bof?::bool          ::input-port)
	    (inline rgc-buffer-eof?::bool          ::input-port)
	    (rgc-the-submatch                      ::obj ::int ::int ::int)))
 
;*---------------------------------------------------------------------*/
;*    rgc-buffer-get-char ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-get-char::int input-port::input-port)
   (_rgc-buffer-get-char input-port)) 

;*---------------------------------------------------------------------*/
;*    rgc-buffer-unget-char ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-unget-char::int input-port::input-port char::int)
   (_rgc-buffer-unget-char input-port char))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-substring ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-substring input-port start stop)
   (_rgc-buffer-substring input-port start stop))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-length ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-length::long input-port::input-port)
   (_rgc-buffer-length input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-fixnum ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-fixnum::long input-port::input-port)
   (_rgc-buffer-fixnum input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-flonum ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-flonum::double input-port::input-port)
   (_rgc-buffer-flonum input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-symbol ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-symbol::symbol input-port::input-port)
   (_rgc-buffer-symbol input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-keyword ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-keyword::keyword input-port::input-port)
   (_rgc-buffer-keyword input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-position ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-position::long input-port::input-port)
   (_rgc-buffer-position input-port))

;*---------------------------------------------------------------------*/
;*    rgc-matchstop ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (rgc-matchstop::long input-port::input-port)
   (_rgc-matchstop input-port))

;*---------------------------------------------------------------------*/
;*    rgc-match-fail ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (rgc-match-fail::int input-port::input-port)
   (_rgc-match-fail input-port))

;*---------------------------------------------------------------------*/
;*    rgc-failing-char ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (rgc-failing-char::int input-port::input-port)
   (_rgc-failing-char input-port))

;*---------------------------------------------------------------------*/
;*    rgc-start-match! ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (rgc-start-match!::int input-port::input-port)
   (_rgc-start-match! input-port))

;*---------------------------------------------------------------------*/
;*    rgc-stop-match! ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-stop-match!::int input-port::input-port)
   (_rgc-stop-match! input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-empty? ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-empty?::bool input-port::input-port)
   (_rgc-buffer-empty? input-port))

;*---------------------------------------------------------------------*/
;*    rgc-fill-buffer ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-fill-buffer::bool input-port::input-port)
   (_rgc-fill-buffer input-port))

;*---------------------------------------------------------------------*/
;*    rgc-fill-buffer-if-empty ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (rgc-fill-buffer-if-empty::bool input-port::input-port)
   (and (rgc-buffer-empty? input-port) (rgc-fill-buffer input-port)))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-bol? ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-bol?::bool input-port::input-port)
   (_rgc-buffer-bol? input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-eol? ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-eol?::bool input-port::input-port)
   (_rgc-buffer-eol? input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-bof? ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-bof?::bool input-port::input-port)
   (_rgc-buffer-bof? input-port))

;*---------------------------------------------------------------------*/
;*    rgc-buffer-eof? ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (rgc-buffer-eof?::bool input-port::input-port)
   (_rgc-buffer-eof? input-port))

;*---------------------------------------------------------------------*/
;*    rgc-the-submatch ...                                             */
;*---------------------------------------------------------------------*/
(define (rgc-the-submatch rgc-submatches pos match submatch)
;*    (print "rgc-the-submatch: " rgc-submatches)                      */
;*    (print "             pos: " pos)                                 */
;*    (print "           match: " match)                               */
;*    (print "        submatch: " submatch)                            */
   (let loop ((submatches rgc-submatches)
	      (start      -1)
	      (stop       -1))
      ;; we search for the first submatch stop
      (if (null? submatches)
	  (values start stop)
	  (let* ((mv   (car submatches))
		 (ru   (vector-ref mv 0))
		 (sm   (vector-ref mv 1))
		 (sp   (vector-ref mv 2))
		 (what (vector-ref mv 3)))
	     (if (and (=fx ru match) (=fx sm submatch) (<=fx sp pos))
		 (case what
		    ((stop)
		     (if (<fx stop 0)
			 (loop (cdr submatches) start sp)
			 (loop (cdr submatches) start stop)))
		    ((start)
		     (values sp stop))
		    ((start*)
		     (loop (cdr submatches) sp stop)))
		 (loop (cdr submatches) start stop))))))
			       
   
