;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Rgc/rgc-expand.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep  9 09:21:29 1998                          */
;*    Last change :  Tue Nov 10 08:54:44 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The expanders that implements the RGC user forms.                */
;*    -------------------------------------------------------------    */
;*    This module implements the expanders for:                        */
;*       - regular-grammar                                             */
;*       - string-case                                                 */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/rgc.texi@                                 */
;*       @node Regular Parsing@                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_expand

   (import  (__rgc_rules               "Rgc/rgc-rules.scm")
	    (__rgc_tree                "Rgc/rgc-tree.scm")
	    (__rgc_dfa                 "Rgc/rgc-dfa.scm")
	    (__rgc_compile             "Rgc/rgc-compile.scm")
	    (__rgc_config              "Rgc/rgc-config.scm")
	    (__error                   "Llib/error.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r5_control_features_6_4 "Ieee/control5.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm"))

   (export  (expand-string-case x e)
	    (expand-regular-grammar x e)))

;*---------------------------------------------------------------------*/
;*    expand-string-case ...                                           */
;*    -------------------------------------------------------------    */
;*    This function expands the @deffn string-case@ form               */
;*    -------------------------------------------------------------    */
;*    This expander expands form like:                                 */
;*       (string-case s                                                */
;*          (("toto") 'match1)                                         */
;*          ((+ (in "abcde")) 'match2)                                 */
;*          (else 'else))                                              */
;*---------------------------------------------------------------------*/
(define (expand-string-case x e)
   (match-case x
      ((?- ?str . ?clauses)
       (let ((port-id (gensym 'port)))
	  (let ((new `(let ((,port-id (open-input-string ,str)))
			 (unwind-protect
			    (read/rp (regular-grammar ()
					,@clauses)
				     ,port-id)
			    (close-input-port ,port-id)))))
	     (set-car! x (car new))
	     (set-cdr! x (cdr new))
	     (e x e))))
      (else
       (error "string-case" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-regular-grammar ...                                       */
;*    -------------------------------------------------------------    */
;*    This function expands the @deffn regular-grammar@ form           */
;*---------------------------------------------------------------------*/
(define (expand-regular-grammar x e)
   (match-case x
      ((?- ?user-env . ?clauses)
       (multiple-value-bind (tree actions else-num submatch?)
	  ;; we normalize the grammar. that is we build one uniq
	  ;; regular expression from the grammar
	  (rules->regular-tree user-env clauses)
	  (multiple-value-bind (node followpos positions submatches)
	     ;; we build the tree, that is we translate a list into
	     ;; a data structure that suits the algorithm for building
	     ;; the dfa
	     (regular-tree->node tree)
	     ;; We now build the dfa transitions.
	     (begin
		(let* ((dfa (node->dfa node followpos positions))
		       (sexp (make-regular-parser (compile-dfa submatches dfa)
						  actions
						  else-num
						  submatch?)))
		   (reset-special-match-char!)
		   (reset-tree!)
		   (reset-dfa!)
		   (e sexp e))))))
      (else
       (error "regular-grammar" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    make-regular-parser ...                                          */
;*---------------------------------------------------------------------*/
(define (make-regular-parser states actions else-num submatch?)
   `(let ((the-rgc-context #unspecified))
       (lambda (input-port)
	  ;; compiled states
	  ,@states
	  ;; rgc library functions
	  ;; @deffn the-port@
	  (define (the-port::input-port)
	     input-port)
	  ;; @deffn the-string@
	  (define (the-string::bstring)
	     (rgc-buffer-substring input-port 0 (the-length)))
	  ;; @deffn the-substring@
	  (define (the-substring::bstring min max)
	     (if (and (>=fx min 0) (<=fx max (the-length)) (>=fx max min))
		 (rgc-buffer-substring input-port min max)
		 (error "the-substring" "Illegal range" (cons min max))))
	  ;; @deffn the-length@
	  (define (the-length::int)
	     (rgc-buffer-length input-port))
	  ;; @deffn the-fixnum@
	  (define (the-fixnum::int)
	     (rgc-buffer-fixnum input-port))
	  ;; @deffn the-flonum@
	  (define (the-flonum::real)
	     (rgc-buffer-flonum input-port))
	  ;; @deffn the-symbol@
	  (define (the-symbol::symbol)
	     (rgc-buffer-symbol input-port))
	  ;; @deffn the-keyword@
	  (define (the-keyword::keyword)
	     (rgc-buffer-keyword input-port))
	  ;; @deffn the-failure@
	  (define (the-failure)
	     (if (=fx (the-length) 0)
		 ;; this is the end-of-file object
		 #<0100>
		 (string-ref (the-string) 0)))
	  ;; @deffn the-context@
	  (define (the-context)
	     the-rgc-context)
	  ;; @deffn rgc-context?@
	  (define (rgc-context?::bool context)
	     (eq? the-rgc-context context))
	  ;; @deffn rgc-context@
	  (define (rgc-context . context)
	     (if (pair? context)
		 (set! the-rgc-context (car context))
		 (set! the-rgc-context #unspecified)))
	  ,@(if submatch?
		(list
		 '(define rgc-submatches '())
		 '(define (rgc-submatch-start! match::int submatch::int)
		     (set! rgc-submatches
			   (cons (vector match
					 submatch
					 (rgc-buffer-position input-port)
					 'start)
				 rgc-submatches)))
		 '(define (rgc-submatch-start*! match::int submatch::int)
		     (set! rgc-submatches
			   (cons (vector match
					 submatch
					 (rgc-buffer-position input-port)
					 'start*)
				 rgc-submatches)))
		 '(define (rgc-submatch-stop! match::int submatch::int)
		     (set! rgc-submatches
			   (cons (vector match
					 submatch
					 (rgc-buffer-position input-port)
					 'stop)
				 rgc-submatches))))
		'())
	  ;; main function
	  (define (ignore)
	     (rgc-start-match! input-port)
	     ,@(if submatch?
		   (list '(set! rgc-submatches '()))
		   '())
	     (let ((match::int (,(state-name (get-initial-state)) ,else-num)))
		,@(if submatch?
		      ;; @deffn the-submatch@
		      '((define (the-submatch num)
			   (if (=fx num 0)
			       (the-string)
			       (multiple-value-bind (start stop)
				  (rgc-the-submatch rgc-submatches
						    (rgc-buffer-position
						     input-port)
						    match
						    num)
				  (if (and (>=fx start 0) (>=fx stop start))
				      (the-substring start stop)
				      (error "the-submatch"
					     "No such match"
					     num))))))
		      '())
		(case match
		   ,@(let loop ((actions actions)
				(num     0)
				(res     '()))
			(if (null? actions)
			    res
			    (loop (cdr actions)
				  (+fx num 1)
				  (cons `((,num) ,(car actions)) res))))
		   (else
		    (error "regular-grammar" "Illegal match" match)))))
	  ;; we start parsing
	  (ignore))))
