;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Rgc/rgc-config.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep  9 09:10:07 1998                          */
;*    Last change :  Sun Sep 20 15:06:24 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The configuration file for the new regular expression package.   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_config

   (import  (__error                   "Llib/error.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r5_control_features_6_4 "Ieee/control5.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm"))

   (export *rgc-optim*
	   (rgc-max-char)
	   (rgc-char?::bool char)
	   (rgc-alphabetic?::bool char)
	   (rgc-upcase char)
	   (rgc-downcase char)
	   (rgc-env)))

;*---------------------------------------------------------------------*/
;*    Rgc optimization level (mostly used by rgc-compile).             */
;*---------------------------------------------------------------------*/
(define *rgc-optim* #f)

;*---------------------------------------------------------------------*/
;*    The config structure                                             */
;*---------------------------------------------------------------------*/
(define-struct rgc-config
   name        ;; a string, the name of the configuration
   max-char    ;; a number, the maximum number of char
   char?       ;; a procedure, the predicate that returns true for characters
   alphabetic? ;; a procedure, the predicate for letters
   upcase      ;; a procedure that processes -> upcase
   downcase    ;; a procedure that processes -> downcase
   env)        ;; the default rgc environment 

;*---------------------------------------------------------------------*/
;*    rgc-max-char ...                                                 */
;*    -------------------------------------------------------------    */
;*    The number of chars that rgc is able to handle.                  */
;*---------------------------------------------------------------------*/
(define (rgc-max-char)
   (rgc-config-max-char *rgc-config*))

;*---------------------------------------------------------------------*/
;*    rgc-char? ...                                                    */
;*---------------------------------------------------------------------*/
(define (rgc-char?::bool char)
   ((rgc-config-char? *rgc-config*) char))

;*---------------------------------------------------------------------*/
;*    rgc-alphabetic? ...                                              */
;*---------------------------------------------------------------------*/
(define (rgc-alphabetic?::bool char)
   ((rgc-config-alphabetic? *rgc-config*) char))

;*---------------------------------------------------------------------*/
;*    rgc-upcase ...                                                   */
;*---------------------------------------------------------------------*/
(define (rgc-upcase char)
   ((rgc-config-upcase *rgc-config*) char))

;*---------------------------------------------------------------------*/
;*    rgc-downcase ...                                                 */
;*---------------------------------------------------------------------*/
(define (rgc-downcase char)
   ((rgc-config-downcase *rgc-config*) char))

;*---------------------------------------------------------------------*/
;*    rgc-env ...                                                      */
;*---------------------------------------------------------------------*/
(define (rgc-env)
   (rgc-config-env *rgc-config*))

;*---------------------------------------------------------------------*/
;*    *ascii-config* ...                                               */
;*    -------------------------------------------------------------    */
;*    The configuration for ascii characters                           */
;*---------------------------------------------------------------------*/
(define *ascii-config*
   (rgc-config "ascii"
	       256
	       (lambda (x)
		  (and (> x 0) (< x 256) (char? x)))
	       (lambda (x)
		  (and (> x 0) (< x 256) (char-alphabetic? (integer->char x))))
	       (lambda (x)
		  (char->integer (char-upcase (integer->char x))))
	       (lambda (x)
		  (char->integer (char-downcase (integer->char x))))
	       '((all     (out #\Newline))
		 (lower   (in ("az")))
		 (upper   (in ("AZ")))
		 (alpha   (or lower upper))
		 (digit   (in ("09")))
		 (xdigit  (uncase (in ("af09"))))
		 (alnum   (uncase (in ("az09"))))
		 (punct   (in ".,;!?"))
		 (blank   (in #" \t\n"))
		 (space   #\Space))))

;*---------------------------------------------------------------------*/
;*    *rgc-config* ...                                                 */
;*---------------------------------------------------------------------*/
(define *rgc-config* *ascii-config*)

