;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/R5rs/prefs5.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  William Clinger                                   */
;*    Creation    :  Sat Mar 21 17:21:26 1998                          */
;*    Last change :  Fri Sep 18 17:28:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*  Copyright 1992 William Clinger                                     */
;*                                                                     */
;*  Permission to copy this software, in whole or in part, to use this */
;*  software for any lawful purpose, and to redistribute this software */
;*  is granted subject to the restriction that all copies made of this */
;*  software must include this copyright notice in full.               */
;*                                                                     */
;*  I also request that you send me a copy of any improvements that you*/
;*  make to this software so that they may be incorporated within it to*/
;*  the benefit of the Scheme community.                               */
;*                                                                     */
;*  Implementation-dependent parameters and preferences that determine */
;*  how identifiers are represented in the output of the macro         */
;*  expander.                                                          */
;*                                                                     */
;*  The basic problem is that there are no reserved words, so the      */
;*  syntactic keywords of core Scheme that are used to express the     */
;*  output need to be represented by data that cannot appear in the    */
;*  input.  This file defines those data.                              */
;*  The following definitions assume that identifiers of mixed case    */
;*  cannot appear in the input.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_syntax_prefs
   
   (use    (__type                       "Llib/type.scm")
           (__error                      "Llib/error.scm")
           (__bigloo                     "Llib/bigloo.scm")
           (__tvector                    "Llib/tvector.scm")
           (__structure                  "Llib/struct.scm")
           (__tvector                    "Llib/tvector.scm")
           (__bexit                      "Llib/bexit.scm")
            
           (__r4_numbers_6_5             "Ieee/number.scm")
           (__r4_numbers_6_5_fixnum      "Ieee/fixnum.scm")
           (__r4_numbers_6_5_flonum      "Ieee/flonum.scm")
           (__r4_characters_6_6          "Ieee/char.scm")
           (__r4_equivalence_6_2         "Ieee/equiv.scm")
           (__r4_booleans_6_1            "Ieee/boolean.scm")
           (__r4_symbols_6_4             "Ieee/symbol.scm")
           (__r4_strings_6_7             "Ieee/string.scm")
           (__r4_pairs_and_lists_6_3     "Ieee/pair-list.scm")
           (__r4_input_6_10_2            "Ieee/input.scm")
           (__r4_control_features_6_9    "Ieee/control.scm")
           (__r4_vectors_6_8             "Ieee/vector.scm")
           (__r4_ports_6_10_1            "Ieee/port.scm")
           (__r4_output_6_10_3           "Ieee/output.scm"))
   
   (export begin1
	   define1
	   quote1
	   lambda1
	   if1
	   set!1
	   undefined1
	   suffix-character))

(define begin1  (string->symbol "BEGIN"))
(define define1 (string->symbol "DEFINE"))
(define quote1  (string->symbol "QUOTE"))
(define lambda1 (string->symbol "LAMBDA"))
(define if1     (string->symbol "IF"))
(define set!1   (string->symbol "SET!"))

; The following defines an implementation-dependent expression
; that evaluates to an undefined (not unspecified!) value, for
; use in expanding the (define x) syntax.

(define undefined1 (list #unspecified))

; A variable is renamed by suffixing a vertical bar followed by a unique
; integer.  In IEEE and R4RS Scheme, a vertical bar cannot appear as part
; of an identifier, but presumably this is enforced by the reader and not
; by the compiler.  Any other character that cannot appear as part of an
; identifier may be used instead of the vertical bar.

(define suffix-character #\|)
