;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/ucs2.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 18 10:24:03 1997                          */
;*    Last change :  Fri Feb  6 16:57:14 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    UCS-2 Characters Scheme management.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ucs2
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))
  
   (extern  (macro c-ucs2?::bool            (::obj)  "UCS2P")
	    (macro c-ucs2-letter?::bool     (::ucs2) "ucs2_letterp")
	    (macro c-ucs2-digit?::bool      (::ucs2) "ucs2_digitp")
	    (macro c-ucs2-whitespace?::bool (::ucs2) "ucs2_whitespacep")
	    (macro c-ucs2-upperp::bool      (::ucs2) "ucs2_upperp")
	    (macro c-ucs2-lowerp::bool      (::ucs2) "ucs2_lowerp")
	    (macro c-ucs2-upcase::ucs2      (::ucs2) "ucs2_toupper")
	    (macro c-ucs2-downcase::ucs2    (::ucs2) "ucs2_tolower")
	    (macro c-ucs2-defined?::bool    (::ucs2) "ucs2_definedp")
	    (macro c-integer->ucs2::ucs2    (::long) "BUCS2"))
   
   (export  (inline ucs2?::bool             ::obj)
	    (inline ucs2=?::bool            ::ucs2 ::ucs2)
	    (inline ucs2<?::bool            ::ucs2 ::ucs2)
	    (inline ucs2>?::bool            ::ucs2 ::ucs2)
	    (inline ucs2<=?::bool           ::ucs2 ::ucs2)
	    (inline ucs2>=?::bool           ::ucs2 ::ucs2) 
	    (inline ucs2-ci=?::bool         ::ucs2 ::ucs2)
	    (inline ucs2-ci<?::bool         ::ucs2 ::ucs2)
	    (inline ucs2-ci>?::bool         ::ucs2 ::ucs2)
	    (inline ucs2-ci<=?::bool        ::ucs2 ::ucs2)
	    (inline ucs2-ci>=?::bool        ::ucs2 ::ucs2)
	    (inline ucs2-alphabetic?::bool  ::ucs2)
	    (inline ucs2-numeric?::bool     ::ucs2)
	    (inline ucs2-whitespace?::bool  ::ucs2)
	    (inline ucs2-upper-case?::bool  ::ucs2)
	    (inline ucs2-lower-case?::bool  ::ucs2)
	    (inline ucs2->integer::long     ::ucs2)
	    (integer->ucs2::ucs2            ::long)
	    (ucs2->char::char               ::ucs2)
	    (inline char->ucs2::ucs2        ::char)
	    (inline ucs2-upcase::ucs2       ::ucs2)
	    (inline ucs2-downcase::ucs2     ::ucs2))
   
   (pragma  (c-ucs2? (predicate-of bucs2) no-cfa-top)
	    (ucs2? side-effect-free no-cfa-top)
	    (c-ucs2-upcase side-effect-free)
	    (c-ucs2-downcase side-effect-free)
	    (ucs2=? side-effect-free)
	    (ucs2<? side-effect-free)
	    (ucs2>? side-effect-free)
	    (ucs2<=? side-effect-free)
	    (ucs2>=? side-effect-free)
	    (ucs2-ci=? side-effect-free)
	    (ucs2-ci<? side-effect-free)
	    (ucs2-ci>? side-effect-free)
	    (ucs2-ci<=? side-effect-free)
	    (ucs2-ci>=? side-effect-free)
	    (ucs2-alphabetic? side-effect-free)
	    (ucs2-numeric? side-effect-free)
	    (ucs2-whitespace? side-effect-free)
	    (ucs2-upper-case? side-effect-free)
	    (ucs2-lower-case? side-effect-free)
	    (ucs2->integer side-effect-free)
	    (integer->ucs2 side-effect-free)
	    (c-integer->ucs2 side-effect-free)
	    (ucs2->char side-effect-free)
	    (char->ucs2 side-effect-free)
	    (ucs2-upcase side-effect-free)
	    (ucs2-downcase side-effect-free)))
 
;*---------------------------------------------------------------------*/
;*    ucs2? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (ucs2? obj)
   (c-ucs2? obj))

;*---------------------------------------------------------------------*/
;*    ucs2=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (ucs2=? ucs2a ucs2b)
   (pragma::bool "($1) == ($2)" ucs2a ucs2b))

;*---------------------------------------------------------------------*/
;*    ucs2<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (ucs2<? ucs2a ucs2b)
   (pragma::bool "($1) < ($2)" ucs2a ucs2b))

;*---------------------------------------------------------------------*/
;*    ucs2>? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline  (ucs2>? ucs2a ucs2b)
   (pragma::bool "($1) > ($2)" ucs2a ucs2b))

;*---------------------------------------------------------------------*/
;*    ucs2<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (ucs2<=? ucs2a ucs2b)
   (pragma::bool "($1) <= ($2)" ucs2a ucs2b))

;*---------------------------------------------------------------------*/
;*    ucs2>=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline  (ucs2>=? ucs2a ucs2b)
   (pragma::bool "($1) >= ($2)" ucs2a ucs2b))

;*---------------------------------------------------------------------*/
;*    ucs2-ci=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-ci=? ucs2a ucs2b)
   (ucs2=? (ucs2-upcase ucs2a) (ucs2-upcase ucs2b)))

;*---------------------------------------------------------------------*/
;*    ucs2-ci<? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-ci<? ucs2a ucs2b)
   (ucs2<? (ucs2-upcase ucs2a) (ucs2-upcase ucs2b))) 

;*---------------------------------------------------------------------*/
;*    ucs2-ci>? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline  (ucs2-ci>? ucs2a ucs2b)
   (ucs2>? (ucs2-upcase ucs2a) (ucs2-upcase ucs2b)))

;*---------------------------------------------------------------------*/
;*    ucs2-ci<=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-ci<=? ucs2a ucs2b)
   (ucs2<=? (ucs2-upcase ucs2a) (ucs2-upcase ucs2b)))

;*---------------------------------------------------------------------*/
;*    ucs2-ci>=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-ci>=? ucs2a ucs2b)
   (ucs2>=? (ucs2-upcase ucs2a) (ucs2-upcase ucs2b)))

;*---------------------------------------------------------------------*/
;*    ucs2-alphabetic? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-alphabetic? ucs2)
   (c-ucs2-letter? ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-numeric? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-numeric? ucs2)
   (c-ucs2-digit? ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-withespace? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-whitespace? ucs2)
   (c-ucs2-whitespace? ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-upper-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-upper-case? ucs2)
   (c-ucs2-upperp ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-lower-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-lower-case? ucs2)
   (c-ucs2-lowerp ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-upcase ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-upcase ucs2)
   (c-ucs2-upcase ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-downcase ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-downcase ucs2)
   (c-ucs2-downcase ucs2))
		     
;*---------------------------------------------------------------------*/
;*    integer->ucs2 ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->ucs2::ucs2 int::long)
   (if (and (>fx int 0)
	    (<fx int 65536))
       (if (c-ucs2-defined? (pragma::ucs2 "(ucs2_t)($1)" int))
	   (pragma::ucs2 "(ucs2_t)($1)" int)
	   (error "integer->ucs2" "Undefined UCS-2 character" int))
       (error "integer->ucs2" "integer out of range or " int)))

;*---------------------------------------------------------------------*/
;*    ucs2->integer ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2->integer::long ucs2::ucs2)
   (pragma::long "(long)($1)" ucs2))

;*---------------------------------------------------------------------*/
;*    char->ucs2 ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char->ucs2::ucs2 char::char)
   (pragma::ucs2 "(ucs2_t)($1)" char))

;*---------------------------------------------------------------------*/
;*    ucs2->char ...                                                   */
;*---------------------------------------------------------------------*/
(define (ucs2->char::char ucs2::ucs2)
   (let ((int (ucs2->integer ucs2)))
      (if (<fx int 256)
	  (pragma::char "(char)($1)" int)
	  (error "ucs2->char"
		 "UCS-2 character out of ISO-LATIN-1 range"
		 ucs2))))

 
