;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/type.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  8 08:52:32 1995                          */
;*    Last change :  Mon Jun 29 19:02:06 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type description                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __type
   
   (use
    (__error                   "Llib/error.scm")
    (__bigloo                  "Llib/bigloo.scm")
    (__tvector                 "Llib/tvector.scm")
    (__ucs2                    "Llib/ucs2.scm")
    (__unicode                 "Llib/unicode.scm")
    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
    (__r4_booleans_6_1         "Ieee/boolean.scm")
    (__r4_characters_6_6       "Ieee/char.scm")
    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
    (__r4_vectors_6_8          "Ieee/vector.scm")
    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
    (__r4_symbols_6_4          "Ieee/symbol.scm")
    (__r4_strings_6_7          "Ieee/string.scm")
    (__evenv                   "Eval/evenv.scm"))
	    
   (type
    ;; all type declaration

    (magic magic "obj_t" bigloo)
    (magic _     "_"     bigloo)
    
    ;; we start by the obj hierarchy
    (obj     "obj_t" bigloo)
    (cnst*   "obj_t" bigloo)
    
    (subtype procedure    "obj_t"           (obj))
    (subtype pair         "obj_t"           (obj))
    (subtype nil          "obj_t"           (obj))
    (subtype bint         "obj_t"           (obj))
    (subtype blong        "obj_t"           (obj))
    (subtype belong       "obj_t"           (obj))
    (subtype bllong       "obj_t"           (obj))
    (subtype bbool        "obj_t"           (obj))
    (subtype cnst         "obj_t"           (obj))
    (subtype bstring      "obj_t"           (obj))
    (subtype ucs2string   "obj_t"           (obj))
    (subtype bchar        "obj_t"           (obj))
    (subtype bucs2        "obj_t"           (obj))
    (subtype real         "obj_t"           (obj))
    (subtype vector       "obj_t"           (obj))
    (subtype tvector      "obj_t"           (obj))
    (subtype struct       "obj_t"           (obj))
    (subtype tstruct      "obj_t"           (obj))
    (subtype output-port  "obj_t"           (obj))
    (subtype input-port   "obj_t"           (obj))
    (subtype binary-port  "obj_t"           (obj))
    (subtype unspecified  "obj_t"           (obj))
    (subtype symbol       "obj_t"           (obj))
    (subtype keyword      "obj_t"           (obj))
    (subtype cell         "obj_t"           (obj))
    (subtype exit         "obj_t"           (obj))
    (subtype foreign      "obj_t"           (obj))
    (subtype process      "obj_t"           (obj))
    (subtype socket       "obj_t"           (obj))
    
    ;; we give now the foreign hierarchy
    (cobj "long" C)
    (subtype char         "char"            (cobj))
    (subtype ucs2         "ucs2_t"          (cobj))
    (subtype uchar        "unsigned char"   (cobj))
    (subtype schar        "signed char"     (cobj))
    (subtype short        "short"           (cobj))
    (subtype ushort       "unsigned short"  (cobj))
    (subtype int          "int"             (cobj))
    (subtype uint         "unsigned int"    (cobj))
    (subtype long         "long"            (cobj))
    (subtype llong        "long long"       (cobj))
    (subtype ulong        "unsigned long"   (cobj))
    (subtype bool         "bool_t"          (cobj))
    (subtype string       "char *"          (cobj))
    (subtype file         "FILE *"          (cobj))
    (subtype double       "double"          (cobj))
    (subtype float        "float"           (cobj))
    (subtype void         "void"            (cobj))
    (subtype void*        "void *"          (cobj))
    (subtype function     "(long *)()"      (cobj))

    ;; debugging traces (used by `the_failure')
    (trace "struct trace *" _)

    ;; obj -> magic
    (coerce obj magic          ()               ())

    ;; obj -> trace
    (coerce obj trace          ()               ())

    ;; first of all obj <-> cobj
    (coerce obj cobj           ()               (c-obj->cobj))
    (coerce cobj obj           ()               (cobj->obj))

    ;; unspecified <-> obj
    (coerce unspecified obj    ()               ())
    (coerce obj unspecified    ()               ((lambda (x) #unspecified)))

    ;; boolean types
    (coerce bbool obj          ()               ())
    (coerce obj bbool          (c-boolean?)     ())
    (coerce obj bool           ()               (obj->bool))
    
    (coerce cobj bool          ()               ())
    (coerce bool cobj          ()               ())
    
    (coerce bbool bool         ()               (obj->bool))
    (coerce bool bbool         ()               (bool->bbool))

    ;; character types
    (coerce bchar obj          ()               ())
    (coerce obj bchar          (c-char?)        ())
    
    (coerce char bool          ()               ((lambda (x::char) #t)))
    (coerce uchar bool         ()               ((lambda (x::uchar) #t)))
    
    (coerce cobj char          ()               ())
    (coerce char cobj          ()               ())
    (coerce cobj uchar         ()               ())
    (coerce uchar cobj         ()               ())
    
    (coerce bchar char         ()               (bchar->char))
    (coerce char bchar         ()               (char->bchar))
    (coerce bchar uchar        ()               (bchar->uchar))
    (coerce uchar bchar        ()               (uchar->bchar))
    (coerce uchar char         ()               (uchar->char))
    (coerce char uchar         ()               (char->uchar))

    ;; ucs2 types
    (coerce bucs2 obj          ()               ())
    (coerce obj bucs2          (c-ucs2?)        ())

    (coerce ucs2 bool          ()               ((lambda (x::char) #t)))
    
    (coerce cobj ucs2          ()               ())
    (coerce ucs2 cobj          ()               ())
    (coerce bucs2 ucs2         ()               (bucs2->ucs2))
    (coerce ucs2 bucs2         ()               (ucs2->bucs2))
	    
    ;; integer types
    (coerce bint obj           ()               ())
    (coerce obj bint           (c-fixnum?)      ())
    (coerce blong obj          ()               ())
    (coerce obj blong          (c-fixnum?)      ())

    (coerce belong obj         ()               ())
    (coerce obj belong         (c-elong?)       ())
    (coerce bllong obj         ()               ())
    (coerce obj bllong         (c-llong?)       ())

    (coerce cobj schar         ()               ())
    (coerce schar cobj         ()               ())
    (coerce cobj short         ()               ())
    (coerce short cobj         ()               ())
    (coerce cobj ushort        ()               ())
    (coerce ushort cobj        ()               ())
    (coerce cobj int           ()               ())
    (coerce int cobj           ()               ())
    (coerce cobj uint          ()               ())
    (coerce uint cobj          ()               ())
    (coerce cobj long          ()               ())
    (coerce long cobj          ()               ())
    (coerce cobj ulong         ()               ())
    (coerce ulong cobj         ()               ())

    (coerce cobj llong         ()               ())
    (coerce llong cobj         ()               ())
    (coerce long llong         ()               ())

    (coerce llong bllong       ()               (llong->bllong))
    (coerce bllong llong       ()               (bllong->llong))

    (coerce long magic         ()               (int->bint))

    (coerce schar bool         ()               ((lambda (x::schar) #t)))
    (coerce short bool         ()               ((lambda (x::short) #t)))
    (coerce ushort bool        ()               ((lambda (x::ushort) #t)))
    (coerce int bool           ()               ((lambda (x::int) #t)))
    (coerce uint bool          ()               ((lambda (x::uint) #t)))
    (coerce long bool          ()               ((lambda (x::long) #t)))
    (coerce ulong bool         ()               ((lambda (x::ulong) #t)))

    (coerce bint schar         ()               (bint->schar))
    (coerce bint short         ()               (bint->short))
    (coerce bint ushort        ()               (bint->ushort))
    (coerce bint int           ()               (bint->int))
    (coerce bint uint          ()               (bint->uint))
    (coerce bint long          ()               (bint->long))
    (coerce bint ulong         ()               (bint->ulong))

    (coerce blong schar        ()               (blong->schar))
    (coerce blong short        ()               (blong->short))
    (coerce blong ushort       ()               (blong->ushort))
    (coerce blong int          ()               (blong->int))
    (coerce blong uint         ()               (blong->uint))
    (coerce blong long         ()               (blong->long))

    (coerce schar bint         ()               (schar->bint))
    (coerce short bint         ()               (short->bint))
    (coerce ushort bint        ()               (ushort->bint))
    (coerce int bint           ()               (int->bint))
    (coerce uint bint          ()               (uint->bint))
    (coerce long bint          ()               (long->bint))
    (coerce ulong bint         ()               (ulong->bint))
    
    (coerce schar blong        ()               (schar->blong))
    (coerce short blong        ()               (short->blong))
    (coerce ushort blong       ()               (ushort->blong))
    (coerce int blong          ()               (int->blong))
    (coerce uint blong         ()               (uint->blong))
    (coerce long blong         ()               (long->blong))
    (coerce ulong blong        ()               (ulong->blong))
    
    (coerce schar short        ()               (schar->short))
    (coerce schar ushort       ()               (schar->ushort))
    (coerce schar int          ()               (schar->int))
    (coerce schar uint         ()               (schar->uint))
    (coerce schar long         ()               (schar->long))
    (coerce schar ulong        ()               (schar->ulong))
    
    (coerce short schar        ()               (short->schar))
    (coerce short ushort       ()               (short->ushort))
    (coerce short int          ()               (short->int))
    (coerce short uint         ()               (short->uint))
    (coerce short long         ()               (short->long))
    (coerce short ulong        ()               (short->ulong))
    
    (coerce ushort schar       ()               (ushort->schar))
    (coerce ushort short       ()               (ushort->short))
    (coerce ushort int         ()               (ushort->int))
    (coerce ushort uint        ()               (ushort->uint))
    (coerce ushort long        ()               (ushort->long))
    (coerce ushort ulong       ()               (ushort->ulong))
    
    (coerce int schar          ()               (int->schar))
    (coerce int short          ()               (int->short))
    (coerce int ushort         ()               (int->ushort))
    (coerce int uint           ()               (int->uint))
    (coerce int long           ()               (int->long))
    (coerce int ulong          ()               (int->ulong))
    
    (coerce uint schar         ()               (uint->schar))
    (coerce uint short         ()               (uint->short))
    (coerce uint ushort        ()               (uint->ushort))
    (coerce uint int           ()               (uint->int))
    (coerce uint long          ()               (uint->long))
    (coerce uint ulong         ()               (uint->ulong))
    
    (coerce long schar         ()               (long->schar))
    (coerce long short         ()               (long->short))
    (coerce long ushort        ()               (long->ushort))
    (coerce long int           ()               (long->int))
    (coerce long uint          ()               (long->uint))
    (coerce long ulong         ()               (long->ulong))
    
    (coerce ulong schar        ()               (ulong->schar))
    (coerce ulong short        ()               (ulong->short))
    (coerce ulong ushort       ()               (ulong->ushort))
    (coerce ulong int          ()               (ulong->int))
    (coerce ulong uint         ()               (ulong->uint))
    (coerce ulong long         ()               (ulong->long))
    
    ;; symbol <-> obj
    (coerce symbol obj         ()               ())
    (coerce obj symbol         (c-symbol?)      ())
    
    ;; keyword <-> obj
    (coerce keyword obj        ()               ())
    (coerce obj keyword        (c-keyword?)     ())
    
    ;; string -> cobj
    (coerce cobj string        ()               ())
    (coerce string cobj        ()               ())
    ;; bstring <-> obj
    (coerce string bool        ()               ((lambda (x::string) #t)))
    (coerce bstring obj        ()               ())
    (coerce obj bstring        (c-string?)      ())
    ;; bstring <-> string
    (coerce bstring string     ()               (bstring->string))
    (coerce string bstring     ()               (string->bstring))

    ;; ucs2string <-> obj
    (coerce ucs2string obj     ()               ())
    (coerce obj ucs2string     (c-ucs2-string?) ())

    ;; double -> cobj
    (coerce cobj double        ()               ())
    (coerce double cobj        ()               ())
    ;; real <-> obj
    (coerce double bool        ()               ((lambda (x::double) #t)))
    (coerce real obj           ()               ())
    (coerce obj real           (c-flonum?)      ())
    ;; real <-> double
    (coerce real double        ()               (real->double))
    (coerce double real        ()               (double->real))
    ;; float <-> double
    (coerce double float       ()               (double->float))
    (coerce float double       ()               (float->double))

    ;; real <-> obj
    (coerce float bool         ()               ((lambda (x::float) #t)))
    ;; float -> cobj
    (coerce cobj float         ()               ())
    (coerce float cobj         ()               ())
    ;; real <-> float
    (coerce real float         ()               (real->float))
    (coerce float real         ()               (float->real))

    ;; vector <-> obj
    (coerce vector obj         ()               ())
    (coerce obj vector         (c-vector?)      ())

    ;; tvector <-> obj
    (coerce tvector obj        ()               ())
    (coerce obj tvector        (c-tvector?)     ())

    ;; bool
    (coerce int bool           ()               ())
    
    ;; procedure <-> obj
    (coerce procedure obj      ()               ())
    (coerce obj procedure      (c-procedure?)   ())

    ;; struct <-> obj
    (coerce struct obj         ()               ())
    (coerce obj struct         (c-struct?)      ())

    ;; tstruct <-> obj
    (coerce tstruct obj        ()               ())
    (coerce obj tstruct        (c-tstruct?)     ())

    ;; pair <-> bool
    (coerce pair obj           ()               ())
    (coerce obj pair           (c-pair?)        ())

    ;; nil <-> bool
    (coerce nil obj            ()               ())
    (coerce obj nil            (c-null?)        ())

    ;; cell <-> bool
    (coerce cell obj           ()               ())
    (coerce obj cell           ()               ())

    ;; exit <-> bool
    (coerce exit obj           ()               ())
    (coerce obj exit           ()               ())

    ;; file <-> cobj
    (coerce file cobj          ()               ())
    (coerce cobj file          ()               ())
    
    ;; obj <-> input-port
    (coerce input-port obj     ()               ())
    (coerce obj input-port     (c-input-port?)  ())
    (coerce file input-port    ()               (file->input-port))
	    
    ;; obj <-> output-port
    (coerce output-port obj    ()               ())
    (coerce obj output-port    (c-output-port?) ())
    (coerce file output-port   ()               (file->output-port))
    (coerce output-port file   ()               (output-port->file))

    ;; obj <-> binary-port
    (coerce binary-port obj    ()               ())
    (coerce obj binary-port    (c-binary-port?) ())

    ;; void <-> cobj
    (coerce void cobj          ()               ())
    (coerce cobj void          ()               ())
    
    ;; void* <-> cobj
    (coerce void* cobj         ()               ())
    (coerce cobj void*         ()               ())
    
    ;; foreign <-> obj
    (coerce foreign obj        ()               ())
    (coerce obj foreign        (c-foreign?)     ())
    
    ;; process <-> obj
    (coerce process obj        ()               ())
    (coerce obj process        (c-process?)     ())
    
    ;; socket <-> obj
    (coerce socket obj         ()               ())
    (coerce obj socket         (c-socket?)      ())
    
    ;; bool (all Bigloo's type have to be explicitly coerce to bool)
    (coerce procedure    bool  ()             ((lambda (x) #t)))
    (coerce bint         bool  ()             ((lambda (x) #t)))
    (coerce pair         bool  ()             ((lambda (x) #t)))
    (coerce nil          bool  ()             ((lambda (x) #t)))
    (coerce cnst         bool  ()             ((lambda (x) #t)))
    (coerce bstring      bool  ()             ((lambda (x) #t)))
    (coerce ucs2string   bool  ()             ((lambda (x) #t)))
    (coerce real         bool  ()             ((lambda (x) #t)))
    (coerce tvector      bool  ()             ((lambda (x) #t)))
    (coerce vector       bool  ()             ((lambda (x) #t)))
    (coerce struct       bool  ()             ((lambda (x) #t)))
    (coerce tstruct      bool  ()             ((lambda (x) #t)))
    (coerce output-port  bool  ()             ((lambda (x) #t)))
    (coerce input-port   bool  ()             ((lambda (x) #t)))
    (coerce binary-port  bool  ()             ((lambda (x) #t)))
    (coerce symbol       bool  ()             ((lambda (x) #t)))
    (coerce keyword      bool  ()             ((lambda (x) #t)))
    (coerce cell         bool  ()             ((lambda (x) #t)))
    (coerce unspecified  bool  ()             ((lambda (x) #t)))
    (coerce bchar        bool  ()             ((lambda (x) #t)))
    (coerce bucs2        bool  ()             ((lambda (x) #t)))
    (coerce process      bool  ()             ((lambda (x) #t)))
    (coerce socket       bool  ()             ((lambda (x) #t))))
    
   (foreign
    (macro bbool   bool->bbool      (bool)    "BBOOL")
    (macro bool    obj->bool        (bbool)   "CBOOL")
    
    (macro bint    schar->bint      (schar)   "BINT")
    (macro bint    uchar->bint      (uchar)   "BINT")
    (macro bint    short->bint      (short)   "BINT")
    (macro bint    ushort->bint     (ushort)  "BINT")
    (macro bint    int->bint        (int)     "BINT")
    (macro bint    uint->bint       (uint)    "BINT")
    (macro bint    long->bint       (long)    "BINT")
    (macro bint    ulong->bint      (ulong)   "BINT")
    
    (macro blong   schar->blong     (schar)   "BINT")
    (macro blong   uchar->blong     (uchar)   "BINT")
    (macro blong   short->blong     (short)   "BINT")
    (macro blong   ushort->blong    (ushort)  "BINT")
    (macro blong   int->blong       (int)     "BINT")
    (macro blong   uint->blong      (uint)    "BINT")
    (macro blong   long->blong      (long)    "BINT")
    (macro blong   ulong->blong     (ulong)   "BINT")
    
    (macro schar   bint->schar      (bint)    "(signed char)CINT")
    (macro uchar   bint->uchar      (bint)    "(unsigned char)CINT")
    (macro short   bint->short      (bint)    "(short)CINT")
    (macro ushort  bint->ushort     (bint)    "(unsigned short)CINT")
    (macro int     bint->int        (bint)    "CINT")
    (macro uint    bint->uint       (bint)    "(unsigned int)CINT")
    (macro long    bint->long       (bint)    "(long)CINT")
    (macro ulong   bint->ulong      (bint)    "(unsigned long)CINT")

    (macro schar   blong->schar     (blong)   "(signed char)CINT")
    (macro uchar   blong->uchar     (blong)   "(unsigned char)CINT")
    (macro short   blong->short     (blong)   "(short)CINT")
    (macro ushort  blong->ushort    (blong)   "(unsigned short)CINT")
    (macro int     blong->int       (blong)   "CINT")
    (macro uint    blong->uint      (blong)   "(unsigned int)CINT")
    (macro long    blong->long      (blong)   "(long)CINT")
    (macro ulong   blong->ulong     (blong)   "(unsigned long)CINT")

    (macro short   uchar->short     (uchar)   "(short)")
    (macro ushort  uchar->ushort    (uchar)   "(unsigned short)")
    (macro int     uchar->int       (uchar)   "(int)")
    (macro uint    uchar->uint      (uchar)   "(unsigned int)")
    (macro long    uchar->long      (uchar)   "(long)")
    (macro ulong   uchar->ulong     (uchar)   "(unsigned long)")
    
    (macro short   schar->short     (schar)   "(short)")
    (macro ushort  schar->ushort    (schar)   "(unsigned short)")
    (macro int     schar->int       (schar)   "(int)")
    (macro uint    schar->uint      (schar)   "(unsigned int)")
    (macro long    schar->long      (schar)   "(long)")
    (macro ulong   schar->ulong     (schar)   "(unsigned long)")
    
    (macro schar   short->schar     (short)   "(signed char)")
    (macro ushort  short->ushort    (short)   "(unsigned short)")
    (macro int     short->int       (short)   "(int)")
    (macro uint    short->uint      (short)   "(unsigned int)")
    (macro long    short->long      (short)   "(long)")
    (macro ulong   short->ulong     (short)   "(unsigned long)")
    
    (macro schar   ushort->schar    (ushort)  "(signed char)")
    (macro short   ushort->short    (ushort)  "(short)")
    (macro int     ushort->int      (ushort)  "(int)")
    (macro uint    ushort->uint     (ushort)  "(unsigned int)")
    (macro long    ushort->long     (ushort)  "(long)")
    (macro ulong   ushort->ulong    (ushort)  "(unsigned long)")
    
    (macro schar   int->schar       (int)     "(signed char)")
    (macro short   int->short       (int)     "(short)")
    (macro ushort  int->ushort      (int)     "(unsigned short)")
    (macro uint    int->uint        (int)     "(unsigned int)")
    (macro long    int->long        (int)     "(long)")
    (macro ulong   int->ulong       (int)     "(unsigned long)")
    
    (macro schar   uint->schar      (uint)    "(signed char)")
    (macro short   uint->short      (uint)    "(short)")
    (macro ushort  uint->ushort     (uint)    "(unsigned short)")
    (macro uint    uint->int        (uint)    "(int)")
    (macro long    uint->long       (uint)    "(long)")
    (macro ulong   uint->ulong      (uint)    "(unsigned long)")
    
    (macro schar   long->schar      (long)    "(signed char)")
    (macro short   long->short      (long)    "(short)")
    (macro ushort  long->ushort     (long)    "(unsigned short)")
    (macro int     long->int        (long)    "(int)")
    (macro uint    long->uint       (long)    "(unsigned int)")
    (macro ulong   long->ulong      (long)    "(unsigned long)")
    
    (macro schar   ulong->schar     (ulong)   "(signed char)")
    (macro short   ulong->short     (ulong)   "(short)")
    (macro ushort  ulong->ushort    (ulong)   "(unsigned short)")
    (macro int     ulong->int       (ulong)   "(int)")
    (macro uint    ulong->uint      (ulong)   "(unsigned int)")
    (macro long    ulong->long      (ulong)   "(long)")
    
    (bstring       string->bstring   (string)   "string_to_bstring")
    (macro string   bstring->string   (bstring) "BSTRING_TO_STRING")
    
    (macro bchar   char->bchar      (char)    "BCHAR")
    (macro bchar   uchar->bchar     (uchar)   "BCHAR")
    (macro char    bchar->char      (bchar)   "CCHAR")
    (macro uchar   bchar->uchar     (bchar)   "(unsigned char)CCHAR")
    (real          double->real     (double)  "make_real")
    (macro double  real->double     (real)    "REAL_TO_DOUBLE")
    (macro real    float->real      (float)   "FLOAT_TO_REAL")
    (macro float   real->float      (real)    "REAL_TO_FLOAT")
    (macro float   double->float    (double)  "(float)")
    (macro double  float->double    (float)   "(double)")

    (macro bucs2   ucs2->bucs2      (ucs2)    "BUCS2")
    (macro ucs2    bucs2->ucs2      (bucs2)   "CUCS2")

    (macro file        output-port->file (output-port) "OUTPUT_PORT_TO_FILE")
    (macro output-port file->output-port (file)        "FILE_TO_OUTPUT_PORT")

    (input-port    file->input-port (file)    "file_to_input_port")

    (macro obj     cobj->obj        (cobj)    "(obj_t)")
    (macro cobj    c-obj->cobj      (obj)     "obj_to_cobj")
    
    (macro char    uchar->char      (uchar)   "(char)")
    (macro uchar   char->uchar      (char)    "(unsigned char)")

    (macro long    belong->long     (belong)  "BELONG_TO_LONG")
    (macro belong  long->belong     (long)    "LONG_TO_BELONG")
    (macro llong   bllong->llong    (bllong)  "BLLONG_TO_LLONG")
    (macro bllong  llong->bllong    (llong)   "LLONG_TO_BLLONG"))

   (pragma
    (bool->bbool side-effect-free)
    (obj->bool side-effect-free)
    (schar->bint side-effect-free)
    (uchar->bint side-effect-free)
    (short->bint side-effect-free)
    (ushort->bint side-effect-free)
    (int->bint side-effect-free)
    (uint->bint side-effect-free)
    (long->bint side-effect-free)
    (ulong->bint side-effect-free)
    (schar->blong side-effect-free)
    (uchar->blong side-effect-free)
    (short->blong side-effect-free)
    (ushort->blong side-effect-free)
    (int->blong side-effect-free)
    (uint->blong side-effect-free)
    (long->blong side-effect-free)
    (ulong->blong side-effect-free)
    (bint->schar side-effect-free)
    (bint->uchar side-effect-free)
    (bint->short side-effect-free)
    (bint->ushort side-effect-free)
    (bint->int side-effect-free)
    (bint->uint side-effect-free)
    (bint->long side-effect-free)
    (bint->ulong side-effect-free)
    (blong->schar side-effect-free)
    (blong->uchar side-effect-free)
    (blong->short side-effect-free)
    (blong->ushort side-effect-free)
    (blong->int side-effect-free)
    (blong->uint side-effect-free)
    (blong->long side-effect-free)
    (blong->ulong side-effect-free)
    (uchar->short side-effect-free)
    (uchar->ushort side-effect-free)
    (uchar->int side-effect-free)
    (uchar->uint side-effect-free)
    (uchar->long side-effect-free)
    (uchar->ulong side-effect-free)
    (schar->short side-effect-free)
    (schar->ushort side-effect-free)
    (schar->int side-effect-free)
    (schar->uint side-effect-free)
    (schar->long side-effect-free)
    (schar->ulong side-effect-free)
    (short->schar side-effect-free)
    (short->ushort side-effect-free)
    (short->int side-effect-free)
    (short->uint side-effect-free)
    (short->long side-effect-free)
    (short->ulong side-effect-free)
    (ushort->schar side-effect-free)
    (ushort->short side-effect-free)
    (ushort->int side-effect-free)
    (ushort->uint side-effect-free)
    (ushort->long side-effect-free)
    (ushort->ulong side-effect-free)
    (int->schar side-effect-free)
    (int->short side-effect-free)
    (int->ushort side-effect-free)
    (int->uint side-effect-free)
    (int->long side-effect-free)
    (int->ulong side-effect-free)
    (uint->schar side-effect-free)
    (uint->short side-effect-free)
    (uint->ushort side-effect-free)
    (uint->int side-effect-free)
    (uint->long side-effect-free)
    (uint->ulong side-effect-free)
    (long->schar side-effect-free)
    (long->short side-effect-free)
    (long->ushort side-effect-free)
    (long->int side-effect-free)
    (long->uint side-effect-free)
    (long->ulong side-effect-free)
    (ulong->schar side-effect-free)
    (ulong->short side-effect-free)
    (ulong->ushort side-effect-free)
    (ulong->int side-effect-free)
    (ulong->uint side-effect-free)
    (ulong->long side-effect-free)
    (bstring->string side-effect-free)
    (string->bstring side-effect-free)
    (char->bchar side-effect-free)
    (uchar->bchar side-effect-free)
    (bchar->char side-effect-free)
    (bchar->uchar side-effect-free)
    (ucs2->bucs2 side-effect-free)
    (bucs2->ucs2 side-effect-free)
    (double->real side-effect-free)
    (real->double side-effect-free)
    (double->float side-effect-free)
    (float->double side-effect-free)
    (float->real side-effect-free)
    (real->float side-effect-free)
    (cobj->obj side-effect-free)
    (c-obj->cobj side-effect-free)
    (uchar->char side-effect-free)
    (char->uchar side-effect-free)
    (long->belong side-effect-free)
    (belong->long side-effect-free)
    (llong->bllong side-effect-free)
    (bllong->llong side-effect-free)))
    

