;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9/Llib/struct.scm           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 13:02:29 1992                          */
;*    Last change :  Fri Jul 19 14:33:00 1996 (serrano)                */
;*                                                                     */
;*    Les structures (non r4)                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __structure

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro obj    c-struct-ref      (struct long)     "STRUCT_REF")
	    (macro obj    c-struct-set!     (struct long obj) "STRUCT_SET")
	    (macro obj    u-struct-ref      (obj long)        "STRUCT_REF")
	    (macro obj    u-struct-set!     (obj long obj)    "STRUCT_SET")
	    (macro symbol c-struct-key      (struct)         "STRUCT_KEY")
	    (macro obj    c-struct-key-set! (struct symbol)  "STRUCT_KEY_SET")
	    (macro bool   c-struct?         (obj)             "STRUCTP")
	    (macro long   c-struct-length   (struct)          "STRUCT_LENGTH")
	    (struct       c-make-struct     (symbol long obj) "make_struct")
	    (macro struct c-make-s-struct   (symbol long obj) "MAKE_S_STRUCT")
	    (struct       c-create-struct   (symbol long)   "create_struct")
	    (macro struct c-create-s-struct (symbol long)   "CREATE_S_STRUCT")
	    (macro obj    c-peek            (obj long)        "PEEK")
	    (macro obj    c-poke!           (obj long obj)    "POKE"))
   
   (export  (inline make-struct::struct    ::symbol ::long ::obj)
	    (inline struct?::bool          ::obj)
	    (inline struct-key::symbol     ::struct)
	    (inline struct-key-set!        ::struct ::symbol)
	    (inline struct-length::long    ::struct)
	    (inline struct-ref             ::struct ::long)
	    (inline struct-set!            ::struct ::long ::obj)
	    (struct-update!                ::struct ::struct)
	    (inline peek                   ::struct ::long)
	    (inline poke!                  ::struct ::long ::obj))

   (pragma  (c-struct? (predicate-of struct) no-cfa-top)
	    (struct? side-effect-free no-cfa-top)
	    (c-make-struct (stack-alloc c-make-s-struct) no-cfa-top)
	    (make-struct no-cfa-top)
	    (c-create-struct (stack-alloc c-create-s-struct))
	    (c-struct-length side-effect-free no-cfa-top)
	    (struct-length side-effect-free no-cfa-top)
	    (c-struct-ref side-effect-free no-cfa-top)
	    (struct-ref side-effect-free no-cfa-top)
	    (u-struct-ref side-effect-free no-cfa-top)
	    (c-struct-key side-effect-free no-cfa-top)
	    (struct-key side-effect-free no-cfa-top)))
	    
;*---------------------------------------------------------------------*/
;*    make-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (make-struct key len init)
   (c-make-struct key len init))

;*---------------------------------------------------------------------*/
;*    peek ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (peek struct offset)
   (c-peek struct offset))

;*---------------------------------------------------------------------*/
;*    poke! ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (poke! struct offset value)
   (c-poke! struct offset value))

;*---------------------------------------------------------------------*/
;*    struct? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (struct? o)
   (c-struct? o))

;*---------------------------------------------------------------------*/
;*    struct-key ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (struct-key s)
   (c-struct-key s))

;*---------------------------------------------------------------------*/
;*    struct-key-set! ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (struct-key-set! s k)
   (c-struct-key-set! s k))

;*---------------------------------------------------------------------*/
;*    struct-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (struct-length s)
   (c-struct-length s))
   
;*---------------------------------------------------------------------*/
;*    struct-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline  (struct-ref s k)
   (c-struct-ref s k))

;*---------------------------------------------------------------------*/
;*    struct-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (struct-set! s k o)
   (c-struct-set! s k o))

;*---------------------------------------------------------------------*/
;*    struct-update! ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-update! dst src)
   (if (and (eq? (struct-key dst) (struct-key src))
	    (=fx (struct-length dst) (struct-length src)))
       (let loop ((i (-fx (struct-length dst) 1)))
	  (if (=fx i -1)
	      dst
	      (begin
		 (struct-set! dst i (struct-ref src i))
		 (loop (-fx i 1)))))
       (error "struct-update!" "Incompatible structures" (list dst src))))

 
