;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/socket.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 29 18:45:17 1998                          */
;*    Last change :  Tue Jun 30 07:21:23 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Socket handling. This poart is mostly compatible with            */
;*    STk. This code is extracted from STk by Erick Gallesio.          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __socket

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__dsssl                   "Llib/dsssl.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")

	    (__evenv                   "Eval/evenv.scm"))
 
   (extern  (macro c-socket?::bool            (::obj)    "SOCKETP")
	    (macro c-socket-hostname::bstring (::socket) "SOCKET_HOSTNAME")
	    (macro c-socket-hostip::bstring   (::socket) "SOCKET_HOSTIP")
	    (macro c-socket-down?::bool       (::socket) "SOCKET_DOWNP")
	    (macro c-socket-port-number::int  (::socket) "SOCKET_PORT")
	    (macro c-socket-input::obj        (::socket) "SOCKET_INPUT")
	    (macro c-socket-output::obj       (::socket) "SOCKET_OUTPUT")
	    
	    (c-make-client-socket::socket    (::bstring ::int)
					     "make_client_socket")
	    (c-make-server-socket::socket    (::int)
					     "make_server_socket")
	    (c-socket-accept-connection::obj (::socket)
					     "socket_accept_connection")
	    (c-socket-local-addr::bstring    (::socket)
					     "socket_local_addr")
	    (c-socket-dup::socket            (::socket)
					     "socket_dup")
	    (c-socket-shutdown::obj          (::socket ::bool)
					     "socket_shutdown"))

   (export  (inline socket?::bool ::obj)
	    (inline socket-hostname::bstring ::socket)
	    (inline socket-host-address::bstring ::socket)
	    (inline socket-down?::bool ::socket)
	    (inline socket-port-number::bint ::socket)
	    (inline socket-input::obj ::socket)
	    (inline socket-output::obj ::socket)
	    (inline make-client-socket::socket ::bstring ::int)
	    (inline make-server-socket::socket . port-number)
	    (inline socket-accept-connection ::socket)
	    (inline socket-local-address ::socket)
	    (inline socket-dup::socket ::socket)
	    (inline socket-shutdown::obj ::socket . close)))

;*---------------------------------------------------------------------*/
;*    socket? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (socket? obj)
   (c-socket? obj))

;*---------------------------------------------------------------------*/
;*    socket-hostname ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (socket-hostname::bstring socket::socket)
   (c-socket-hostname socket))

;*---------------------------------------------------------------------*/
;*    socket-host-address ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (socket-host-address::bstring socket::socket)
   (c-socket-hostip socket))

;*---------------------------------------------------------------------*/
;*    socket-down? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (socket-down?::bool socket::socket)
   (c-socket-down? socket))

;*---------------------------------------------------------------------*/
;*    socket-port-number ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (socket-port-number::bint socket::socket)
   (c-socket-port-number socket))

;*---------------------------------------------------------------------*/
;*    socket-input ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (socket-input socket::socket)
   (c-socket-input socket))

;*---------------------------------------------------------------------*/
;*    socket-output ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (socket-output socket::socket)
   (c-socket-output socket))

;*---------------------------------------------------------------------*/
;*    make-client-socket ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (make-client-socket::socket hostname port-number)
   (c-make-client-socket hostname port-number))

;*---------------------------------------------------------------------*/
;*    make-server-socket ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (make-server-socket::socket . port-number)
   (c-make-server-socket (if (null? port-number) 0 (car port-number))))

;*---------------------------------------------------------------------*/
;*    socket-accept-connection ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (socket-accept-connection socket::socket)
   (c-socket-accept-connection socket))
	    
;*---------------------------------------------------------------------*/
;*    socket-local-address ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (socket-local-address socket::socket)
   (c-socket-local-addr socket))

;*---------------------------------------------------------------------*/
;*    socket-dup ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (socket-dup::socket socket::socket)
   (c-socket-dup socket))

;*---------------------------------------------------------------------*/
;*    socket-shutdown ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (socket-shutdown socket::socket . close)
   (c-socket-shutdown socket (if (pair? close) (car close)  #t)))
