;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/process.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Erick Gallesio                                    */
;*    Creation    :  Mon Jan 19 17:35:12 1998                          */
;*    Last change :  Fri Nov 20 13:32:21 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Process handling. This part is mostly compatible with            */
;*    STk. This code is extracted from STk by Erick Gallesio.          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __process

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__dsssl                   "Llib/dsssl.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (extern  (macro c-process?::bool               (::obj) "PROCESSP")
	    (macro c-process-pid::int         (::process) "PROCESS_PID")
	    (macro c-process-input-port::obj  (::process) "PROCESS_INPUT_PORT")
	    (macro c-process-output-port::obj (::process) "PROCESS_OUTPUT_PORT")
	    (macro c-process-error-port::obj  (::process) "PROCESS_ERROR_PORT")
	    (c-process-alive?::obj            (::process) "c_process_alivep")
	    (c-process-wait::obj              (::process) "c_process_wait")
	    (c-process-exit-status::obj       (::process) "c_process_xstatus")
	    (c-process-send-signal::obj (::process ::int) "c_process_send_signal")
	    (c-process-kill::obj              (::process) "c_process_kill")
	    (c-process-stop::obj              (::process) "c_process_stop")
	    (c-process-continue::obj          (::process) "c_process_continue")
	    (c-run-process::process (::obj ::obj ::obj ::obj ::obj ::obj ::bstring ::obj)
				                        "c_run_process")
	    (c-unregister-process::obj      (::process) "c_unregister_process")
	    (c-process-list::obj                     () "c_process_list"))
   
   (export  (inline process?::bool ::obj)
	    (inline process-pid::int ::process)
	    (inline process-output-port::obj ::process)
	    (inline process-input-port::obj ::process)
	    (inline process-error-port::obj  ::process)
	    (inline process-alive?::bool ::process)
	    (inline process-wait::bool ::process)
	    (inline process-exit-status::obj ::process)
	    (inline process-send-signal::obj ::process ::int)
	    (inline process-kill::obj ::process)
	    (inline process-stop::obj ::process)
	    (inline process-continue::obj ::process)
	    (inline process-list::obj)
	    (run-process::process ::bstring . rest)
	    (inline unregister-process ::process)))

;*---------------------------------------------------------------------*/
;*    process? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (process? obj)
   (c-process? obj))

;*---------------------------------------------------------------------*/
;*    process-pid ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (process-pid proc)
   (c-process-pid proc))

;*---------------------------------------------------------------------*/
;*    process-output-port ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (process-output-port proc)
   (c-process-output-port proc))

;*---------------------------------------------------------------------*/
;*    process-input-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (process-input-port proc)
   (c-process-input-port proc))

;*---------------------------------------------------------------------*/
;*    process-error-port ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (process-error-port proc)
   (c-process-error-port proc))

;*---------------------------------------------------------------------*/
;*    process-alive? ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (process-alive? proc)
   (c-process-alive? proc))

;*---------------------------------------------------------------------*/
;*    process-wait ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (process-wait proc)
   (c-process-wait proc))

;*---------------------------------------------------------------------*/
;*    process-exit-status ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (process-exit-status proc)
   (c-process-exit-status proc))

;*---------------------------------------------------------------------*/
;*    process-send-signal ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (process-send-signal proc signal)
   (c-process-send-signal proc signal))

;*---------------------------------------------------------------------*/
;*    process-kill ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (process-kill proc)
   (c-process-kill proc))

;*---------------------------------------------------------------------*/
;*    process-stop ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (process-stop proc)
   (c-process-stop proc))

;*---------------------------------------------------------------------*/
;*    process-continue ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (process-continue proc)
   (c-process-continue proc))

;*---------------------------------------------------------------------*/
;*    process-list ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (process-list)
   (c-process-list))

;*---------------------------------------------------------------------*/
;*    run-process ...                                                  */
;*    -------------------------------------------------------------    */
;*    This function accepts keyworded arguments. E.g.                  */
;*      (run-process "ls" "-l" "/bin" output: "/tmp/X" wait: #f        */
;*---------------------------------------------------------------------*/
(define (run-process command . rest)
   (let ((fork   #t)
	 (wait   #f)
	 (input  #unspecified)
	 (output #unspecified)
	 (error  #unspecified)
	 (host   #unspecified)
	 (args   '())
	 (arg-error (lambda (rest)
		       (error "run-process" "Illegal argument" rest))))
      (let loop ((rest rest))
	 (cond
	    ((null? rest)
	     (c-run-process host fork wait
			    input output error
			    command (reverse! args)))
	    ((and (keyword? (car rest)) (pair? (cdr rest)))
	     (let ((val (cadr rest)))
		(case (car rest)
		   ((wait:)
		    (if (boolean? val)
			(set! wait val)
			(arg-error rest)))
		   ((fork:)
		    (if (boolean? val)
			(set! fork val)
			(arg-error rest)))
		   ((input:)
		    (if (or (string? val) (eq? val 'pipe:))
			(set! input val)
			(arg-error rest)))
		   ((output:)
		    (if (or (string? val) (eq? val 'pipe:))
			(set! output val)
			(arg-error rest)))
		   ((error:)
		    (if (or (string? val) (eq? val 'pipe:))
			(set! error val)
			(arg-error rest)))
		   ((host:)
		    (if (string? val)
			(set! host val)
			(arg-error rest)))
		   (else
		    (arg-error rest)))
		(loop (cdr (cdr rest)))))
	    ((string? (car rest))
	     (set! args (cons (car rest) args))
	     (loop (cdr rest)))
	    (else
	     (arg-error rest))))))

;*---------------------------------------------------------------------*/
;*    unregister-process ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (unregister-process proc)
   (c-unregister-process proc))
   
