;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/os.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Tue Aug  5 10:57:59 1997                          */
;*    Last change :  Tue Jul  7 16:56:57 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Os dependant variables (setup by configure).                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __os


   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__foreign                 "Llib/foreign.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (obj          c-signal  (int procedure)  "c_signal")
	    (obj          c-get-signal-handler (int) "get_signal_handler")
	    (obj          *the-command-line*         "command_line")
	    (string       *the-executable-name*      "executable_name")
	    (macro bool   c-getenv? (string)         "(long)getenv")
	    (macro string c-getenv  (string)         "(char *)getenv")
	    (macro int    c-system  (string)         "system")
	    (string       c-date    ()               "c_date")
	    (macro int    c-chdir   (string)         "chdir")
	    (macro string c-getcwd  (string int)     "(char *)(long)getcwd"))

   (export  (signal                  num::int thunk::procedure)
	    (get-signal-handler::obj num::int)

	    (inline getenv           string::string)
	    (inline system           string::string)
	    (inline date::string)
	    (inline chdir            string::string)
	    (pwd)
	    (command-line)
	    (executable-name::string)
	    (basename::bstring                 ::bstring)
	    (dirname::bstring                  ::bstring)
	    (prefix::bstring                   ::bstring)
	    (suffix::bstring                   ::bstring)
	    (make-file-name::bstring           ::bstring ::bstring)
	    (make-static-library-name::bstring ::bstring)
	    (make-shared-library-name::bstring ::bstring)
	    os-class
            os-name
	    os-arch
	    os-version
	    os-tmp
	    file-separator
	    path-separator)

   (extern (macro _os-class::string              "OS_CLASS")
	   (macro _os-name::string               "OS_NAME")
	   (macro _os-arch::string               "OS_ARCH")
	   (macro _os-version::string            "OS_VERSION")
	   (macro _os-tmp::string                "OS_TMP")
	   (macro _file-separator::char          "FILE_SEPARATOR")
	   (macro _path-separator::char          "PATH_SEPARATOR")
	   (macro _static-library-suffix::string "STATIC_LIB_SUFFIX")
	   (macro _shared-library-suffix::string "SHARED_LIB_SUFFIX")))


;*---------------------------------------------------------------------*/
;*    Variables setup ...                                              */
;*---------------------------------------------------------------------*/
(define (os-class)       _os-class)
(define (os-name)        _os-name)
(define (os-arch)        _os-arch)
(define (os-version)     _os-version)
(define (os-tmp)         _os-tmp)
(define (file-separator) _file-separator)
(define (path-separator) _path-separator)

;*---------------------------------------------------------------------*/
;*    command-line ...                                                 */
;*---------------------------------------------------------------------*/
(define (command-line)
   *the-command-line*)

;*---------------------------------------------------------------------*/
;*    executable-name ...                                              */
;*---------------------------------------------------------------------*/
(define (executable-name)
   *the-executable-name*)

;*---------------------------------------------------------------------*/
;*    signal ...                                                       */
;*---------------------------------------------------------------------*/
(define (signal num proc)
   (cond
      ((not (=fx (procedure-arity proc) 1))
       (error "signal" "Wrong number of arguments" proc))
      ((or (<fx num 0) (>fx num 31))
       (error "signal" "Illegal signal" num))
      (else
       (c-signal num proc))))

;*---------------------------------------------------------------------*/
;*    get-signal-handler ...                                           */
;*---------------------------------------------------------------------*/
(define (get-signal-handler num)
   (c-get-signal-handler num))

;*---------------------------------------------------------------------*/
;*    getenv ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (getenv string)
   (if (c-getenv? string)
       (c-getenv string)
       #f))

;*---------------------------------------------------------------------*/
;*    system ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (system string)
   (c-system string))
   
;*---------------------------------------------------------------------*/
;*    date ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (date)
   (c-date))

;*---------------------------------------------------------------------*/
;*    chdir ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (chdir dirname)
   (c-chdir dirname))

;*---------------------------------------------------------------------*/
;*    pwd ...                                                          */
;*---------------------------------------------------------------------*/
(define (pwd)
   (let ((string (make-string 1021)))
      (c-getcwd string 1024)))
	  
;*---------------------------------------------------------------------*/
;*    basename ...                                                     */
;*---------------------------------------------------------------------*/
(define (basename string)
   (let loop ((index (-fx (string-length string) 1)))
      (cond
	 ((=fx index -1)
	  string)
	 ((char=? (string-ref string index) _file-separator)
	  (substring string (+fx index 1) (string-length string)))
	 (else
	  (loop (-fx index 1))))))

;*---------------------------------------------------------------------*/
;*    prefix ...                                                       */
;*---------------------------------------------------------------------*/
(define (prefix string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((e len)
                 (s len))
         (cond
            ((<=fx s 0)
             (substring string 0 (+fx 1 e)))
            (else
             (if (and (eq? (string-ref string s) #\.)
                      (=fx e len))
                 (loop (-fx s 1) (-fx s 1))
                 (loop e (-fx s 1))))))))

;*---------------------------------------------------------------------*/
;*    dirname ...                                                      */
;*---------------------------------------------------------------------*/
(define (dirname string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((read len))
	 (cond
	    ((<=fx read 0)
	     (if (char=? (string-ref string read) _file-separator)
		 (make-string 1 _file-separator)
		 "."))
	    ((char=? (string-ref string read) _file-separator)
	     (substring string 0 read))
	    (else
	     (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    suffix ...                                                       */
;*---------------------------------------------------------------------*/
(define (suffix string)
   (let* ((len (string-length string))
          (len-1 (-fx len 1)))
      (let loop ((read len-1))
         (cond
            ((<fx read 0)
             "")
            ((char=? (string-ref string read) _file-separator)
	     "")
            ((char=? (string-ref string read) #\.)
             (cond
                ((=fx read len-1)
                 "")
                (else
                 (substring string (+fx read 1) len))))
            (else
             (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    make-file-name ...                                               */
;*    -------------------------------------------------------------    */
;*    This function build a absolute file name from a path and a       */
;*    relative file-name.                                              */
;*---------------------------------------------------------------------*/
(define (make-file-name directory::bstring file::bstring)
   (let* ((ldir  (string-length directory))
	  (lfile (string-length file))
	  (len   (+fx ldir (+fx lfile 1)))
	  (str   (make-string len _file-separator)))
      (blit-string-ur! directory 0 str 0 ldir)
      (blit-string-ur! file 0 str (+fx 1 ldir) lfile)
      str))

;*---------------------------------------------------------------------*/
;*    make-static-library-name ...                                     */
;*    -------------------------------------------------------------    */
;*    This function, adds the proper static library extension.         */
;*---------------------------------------------------------------------*/
(define (make-static-library-name libname::bstring)
   (string-append libname "." _static-library-suffix))

;*---------------------------------------------------------------------*/
;*    make-shared-library-name ...                                     */
;*    -------------------------------------------------------------    */
;*    This function, adds the proper shared library extension.         */
;*---------------------------------------------------------------------*/
(define (make-shared-library-name libname::bstring)
   (string-append libname "." _shared-library-suffix))
