;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/object.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 25 14:20:42 1996                          */
;*    Last change :  Wed Feb 10 15:10:23 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `object' library                                             */
;*    -------------------------------------------------------------    */
;*    This module _cannot_ contain method definitions otherwise        */
;*    it cannot be initialized.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __object

   (use     (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__foreign                 "Llib/foreign.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
 	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro obj object-widening (object)          "OBJECT_WIDENING")
	    (macro obj object-widening-set! (object obj) "OBJECT_WIDENING_SET"))

   (export  (class object::object)
	    *classes*
	    (inline object?::bool                       ::obj)
	    (inline object-class-num::long              ::object)
	    (inline object-class-num-set!               ::obj ::long)
	    (inline object-class::obj                   ::object)
	    (inline class?::bool                        ::obj)
	    (class-super                                class)
	    (class-subclasses                           class)
	    (class-num::long                            class)
	    (class-name::symbol                         class)
	    (class-hash::long                           class)
	    (class-depth::long                          class)
	    (class-fields::obj                          class)
	    (class-constructor::obj                     class)
	    (inline class-fields?::bool                 fields)
	    (inline class-field-name::symbol            field)
	    (inline class-field-indexed?::bool          field)
	    (inline class-field-accessor::procedure     field)
	    (inline class-field-len-accessor::procedure field)
	    (inline class-field-mutable?::bool          field)
	    (inline class-field-mutator::procedure      field)
	    (next-class-num::long                       ::long)
	    (add-class!::obj                   o o ::procedure ::long o o)
	    (add-generic!::obj                 ::procedure ::obj)
	    (add-method!::procedure            ::procedure ::obj ::procedure)
	    (add-inlined-method!::long         ::procedure ::obj ::long)
	    (inline find-method                ::object ::procedure)
	    (inline find-inline-method         ::object ::procedure)
	    (find-method-from::pair            ::object ::procedure class)
	    (find-super-class-method           ::object ::procedure class)
	    (inline generic-default::procedure ::procedure)
	    (inline generic-method-array       ::procedure)
	    (inline method-array-ref           ::vector ::long)
	    (is-a?::bool                       ::obj class::obj)
	    (generic object-display            ::object . port)
	    (generic object-write              ::object . port)
	    (generic object->struct::struct        ::object)
	    (generic struct+object->object::object ::object ::struct)
	    (struct->object::object                ::struct)
	    (allocate-instance::object             ::symbol)
	    (inline wide-object?::bool             ::object)
	    (inline generic-pre-method::obj        ::procedure)
	    (inline generic-pre-method-set!::obj   ::procedure ::obj)
	    (object-equal?::bool                   ::object ::object))
	       
   (static  *nb-classes-max*
	    *nb-classes*::obj
	    *nb-generics-max*
	    *nb-generics*
	    (make-class                       ::symbol ::long ::long c o a
					      ::procedure ::long obj o)
	    (class-allocate::procedure        class)
	    (inline generic-default-set!      ::procedure ::procedure)
	    (inline generic-method-array-set! ::procedure ::vector))

   (pragma  (class? side-effect-free (predicate-of object) no-cfa-top)
	    (class-super side-effect-free no-cfa-top no-trace)
	    (class-subclasses side-effect-free no-cfa-top no-trace)
	    (class-constructor side-effect-free no-cfa-top no-trace)
	    (class-num side-effect-free no-cfa-top no-trace)
	    (class-name side-effect-free no-cfa-top no-trace)
	    (object-class side-effect-free no-cfa-top no-trace)
	    (class-depth side-effect-free no-cfa-top no-trace)
	    (next-class-num side-effect-free no-cfa-top no-trace)
	    (find-super-class-method side-effect-free no-cfa-top no-trace)
	    (method-array-ref side-effect-free no-cfa-top no-trace)
	    (is-a? side-effect-free no-cfa-top no-trace)
	    (struct->object no-cfa-top no-trace)
	    (struct+object->object no-cfa-top no-trace)
	    (object->struct side-effect-free no-cfa-top no-trace)
	    (wide-object? side-effect-free no-cfa-top no-trace)
	    (object-widening side-effect-free no-cfa-top)))
	     

;*---------------------------------------------------------------------*/
;*    make-class ...                                                   */
;*---------------------------------------------------------------------*/
(define (make-class name num depth super sub anc alloc ha fd constructor)
   (vector name num depth super sub anc alloc ha fd constructor))

;*---------------------------------------------------------------------*/
;*    class? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (class? obj)
   (and (vector? obj) (=fx (vector-length obj) 10)))

;*---------------------------------------------------------------------*/
;*    class-name ...                                                   */
;*---------------------------------------------------------------------*/
(define (class-name class)
   (vector-ref class 0))

;*---------------------------------------------------------------------*/
;*    class-num ...                                                    */
;*---------------------------------------------------------------------*/
(define (class-num class)
   (vector-ref-ur class 1))

;*---------------------------------------------------------------------*/
;*    class-depth ...                                                  */
;*---------------------------------------------------------------------*/
(define (class-depth class)
   (vector-ref-ur class 2))

;*---------------------------------------------------------------------*/
;*    class-fields ...                                                 */
;*---------------------------------------------------------------------*/
(define (class-fields class)
   (if (class? class)
       (vector-ref class 8)
       (error "class-fields"
	      (bigloo-type-error-msg "runtime type error"
				     "Class"
				     (find-runtime-type class))
	      class)))

;*---------------------------------------------------------------------*/
;*    class-fields? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (class-fields? fields)
   (or (pair? fields) (null? fields)))

;*---------------------------------------------------------------------*/
;*    class-field-name ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (class-field-name::symbol field)
   (vector-ref field 0))

;*---------------------------------------------------------------------*/
;*    class-field-indexed? ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (class-field-indexed?::bool field)
   (procedure? (vector-ref field 3)))

;*---------------------------------------------------------------------*/
;*    class-field-accessor ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (class-field-accessor::procedure field)
   (vector-ref field 1))

;*---------------------------------------------------------------------*/
;*    class-field-mutable? ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (class-field-mutable?::bool field)
   (procedure? (vector-ref field 2)))

;*---------------------------------------------------------------------*/
;*    class-field-mutator ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (class-field-mutator::procedure field)
   (vector-ref field 2))

;*---------------------------------------------------------------------*/
;*    class-field-len-accessor ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (class-field-len-accessor::procedure field)
   (vector-ref field 3))

;*---------------------------------------------------------------------*/
;*    class-super ...                                                  */
;*---------------------------------------------------------------------*/
(define (class-super class)
   (vector-ref class 3))
		     
;*---------------------------------------------------------------------*/
;*    class-subclasses ...                                             */
;*---------------------------------------------------------------------*/
(define (class-subclasses class)
   (vector-ref class 4))
		     
;*---------------------------------------------------------------------*/
;*    class-subclasses-set! ...                                        */
;*---------------------------------------------------------------------*/
(define (class-subclasses-set! class sub)
   (vector-set-ur! class 4 sub))

;*---------------------------------------------------------------------*/
;*    class-ancestors ...                                              */
;*---------------------------------------------------------------------*/
(define (class-ancestors class)
   (vector-ref-ur class 5))

;*---------------------------------------------------------------------*/
;*    class-allocate ...                                               */
;*---------------------------------------------------------------------*/
(define (class-allocate class)
   (vector-ref-ur class 6))

;*---------------------------------------------------------------------*/
;*    class-hash ...                                                   */
;*---------------------------------------------------------------------*/
(define (class-hash class)
   (vector-ref-ur class 7))

;*---------------------------------------------------------------------*/
;*    class-constructor ...                                            */
;*---------------------------------------------------------------------*/
(define (class-constructor class)
   (vector-ref class 9))

;*---------------------------------------------------------------------*/
;*    Classes                                                          */
;*    -------------------------------------------------------------    */
;*    See the initialize-objects! function to understand these         */
;*    stranges affections.                                             */
;*---------------------------------------------------------------------*/
(define *nb-classes-max*  *nb-classes-max*)  
(define *nb-classes*      *nb-classes*)
(define *classes*         *classes*)

;*---------------------------------------------------------------------*/
;*    Generics                                                         */
;*---------------------------------------------------------------------*/
(define *nb-generics-max* *nb-generics-max*)
(define *nb-generics*     *nb-generics*)
(define *generics*        *generics*)

;*---------------------------------------------------------------------*/
;*    initialized-objects? ...                                         */
;*---------------------------------------------------------------------*/
(define (initialized-objects?)
   (fixnum? *nb-classes*))

;*---------------------------------------------------------------------*/
;*    initialize-objects! ...                                          */
;*    -------------------------------------------------------------    */
;*    Due to some bootstrap pbm we have to suppose this module         */
;*    is unitialized before using it. This function makes the          */
;*    initialization.                                                  */
;*---------------------------------------------------------------------*/
(define (initialize-objects!)
   (if (initialized-objects?)
       'done
       (begin
	  (set! *nb-classes*         0)
	  (set! *nb-classes-max*     50)
	  (set! *classes*            (make-vector *nb-classes-max* #f))
	  (set! *nb-generics-max*    50)
	  (set! *nb-generics*        0)
	  (set! *generics*           (make-vector *nb-generics-max* #f)))))

;*---------------------------------------------------------------------*/
;*    extend-vector ...                                                */
;*---------------------------------------------------------------------*/
(define (extend-vector old-vec fill extend)
   (let* ((old-len (vector-length old-vec))
	  (new-len (+fx extend old-len))
	  (new-vec (make-vector new-len fill)))
      (let loop ((i 0))
	 (if (=fx i old-len)
	     new-vec
	     (begin
		(vector-set-ur! new-vec i (vector-ref-ur old-vec i))
		(loop (+fx i 1)))))))
      
;*---------------------------------------------------------------------*/
;*    double-vector ...                                                */
;*---------------------------------------------------------------------*/
(define (double-vector old-vec fill)
   (extend-vector old-vec fill (vector-length old-vec)))
      
;*---------------------------------------------------------------------*/
;*    double-nb-classes! ...                                           */
;*---------------------------------------------------------------------*/
(define (double-nb-classes!)
   (set! *nb-classes-max* (*fx 2 *nb-classes-max*))
   (set! *classes* (double-vector *classes* #f))
   (let loop ((i 0))
      (if (=fx i *nb-generics*)
	  'done
	  (let* ((generic          (vector-ref *generics* i))
		 (old-method-array (generic-method-array generic)))
	     (generic-method-array-set! generic
					(double-vector old-method-array #f))
	     (loop (+fx i 1))))))

;*---------------------------------------------------------------------*/
;*    double-nb-generics! ...                                          */
;*---------------------------------------------------------------------*/
(define (double-nb-generics!)
   (set! *nb-generics-max* (*fx 2 *nb-generics-max*))
   (set! *generics* (double-vector *generics* #f)))
   
;*---------------------------------------------------------------------*/
;*    object? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (object? obj)
   (pragma::bool "(POINTERP( $1 ) && (TYPE( $1 ) >= OBJECT_TYPE))" obj))

;*---------------------------------------------------------------------*/
;*    object-class-num ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (object-class-num obj)
   (pragma::long "TYPE( $1 )" obj))

;*---------------------------------------------------------------------*/
;*    object-class-num-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (object-class-num-set! obj num)
   (pragma "(((obj_t)CREF($1))->header = MAKE_HEADER( $2, 0 ), BUNSPEC)"
	   obj
	   num))

;*---------------------------------------------------------------------*/
;*    object-class ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (object-class object::object)
   (vector-ref-ur *classes* (-fx (object-class-num object)
				 (pragma::long "OBJECT_TYPE"))))

;*---------------------------------------------------------------------*/
;*    generic-default ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (generic-default generic)
   (procedure-ref generic 0))

;*---------------------------------------------------------------------*/
;*    generic-default-set! ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (generic-default-set! generic default)
   (procedure-set! generic 0 default))

;*---------------------------------------------------------------------*/
;*    generic-method-array ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (generic-method-array generic)
   (procedure-ref generic 1))

;*---------------------------------------------------------------------*/
;*    generic-method-array-set! ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (generic-method-array-set! generic method-array)
   (procedure-set! generic 1 method-array))

;*---------------------------------------------------------------------*/
;*    generic-pre-method ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (generic-pre-method generic)
   (procedure-ref generic 2))

;*---------------------------------------------------------------------*/
;*    generic-pre-method-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (generic-pre-method-set! generic pre-method)
   (procedure-set! generic 2 pre-method))

;*---------------------------------------------------------------------*/
;*    method-array-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (method-array-ref array offset)
   (vector-ref-ur array (-fx offset (pragma::long "OBJECT_TYPE"))))

;*---------------------------------------------------------------------*/
;*    method-array-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (method-array-set! array offset val)
   (vector-set-ur! array (-fx offset (pragma::long "OBJECT_TYPE")) val))
   
;*---------------------------------------------------------------------*/
;*    generics-add-class! ...                                          */
;*    -------------------------------------------------------------    */
;*    For each generic, we add the super class method to the class.    */
;*---------------------------------------------------------------------*/
(define (generics-add-class! class-num super-num)
   (let loop ((g 0))
      (if (=fx g *nb-generics*)
	  'done
	  (let* ((generic      (vector-ref *generics* g))
		 (method-array (generic-method-array generic)))
	     (method-array-set! method-array
				class-num
				(method-array-ref method-array super-num))
	     (loop (+fx g 1))))))

;*---------------------------------------------------------------------*/
;*    add-class! ...                                                   */
;*---------------------------------------------------------------------*/
(define (add-class! name super allocate hash def constructor)
   (initialize-objects!)
   (if (and super (not (class? super)))
       (error "add-class!"
	      "Illegal super class for class"
	      name))
   (if (=fx *nb-classes* *nb-classes-max*)
       (double-nb-classes!))
   (let* ((num       (+fx (pragma::long "OBJECT_TYPE") *nb-classes*))
	  (depth     (if (class? super)
			 (+fx (class-depth super) 1)
			 1))
	  (ancestors (if (class? super)
			 (extend-vector (class-ancestors super) super 1)
			 (vector super)))
	  (class     (make-class name
				 num
				 depth
				 super
				 '()
				 ancestors
				 allocate
				 hash
				 def
				 constructor)))
      ;; we set the sub field of the super class
      (if (class? super)
	  (class-subclasses-set! super (cons class (class-subclasses super))))
      ;; we add the class in the *classes* vector (we declare the class)
      (vector-set! *classes* *nb-classes* class)
      ;; we increment the global class number
      (set! *nb-classes* (+fx *nb-classes* 1))
      ;; and we ajust the method arrays of all generic functions
      (generics-add-class! num (if (class? super) (class-num super) num))
      class))

;*---------------------------------------------------------------------*/
;*    generic-added? ...                                               */
;*---------------------------------------------------------------------*/
(define (generic-added? generic::procedure)
   (vector? (generic-method-array generic)))

;*---------------------------------------------------------------------*/
;*    make-method-array ...                                            */
;*---------------------------------------------------------------------*/
(define (make-method-array)
   (make-vector *nb-classes-max* #f))

;*---------------------------------------------------------------------*/
;*    add-generic! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-generic! generic default)
   (if (not (generic-added? generic))
       (begin
	  (if (=fx *nb-generics* *nb-generics-max*)
	      (double-nb-generics!))
	  (vector-set! *generics* *nb-generics* generic)
	  (set! *nb-generics* (+fx *nb-generics* 1))
	  (generic-default-set!      generic (if (procedure? default)
						 default
						 (lambda l
						    (error
						     "generic"
						     "No default behaviour"
						     l))))
	  (generic-method-array-set! generic (make-method-array))
	  #unspecified)
       (begin
	  (if (procedure? default) (generic-default-set! generic default))
	  #unspecified)))

;*---------------------------------------------------------------------*/
;*    add-method/proc-or-num! ...                                      */
;*---------------------------------------------------------------------*/
(define (add-method/proc-or-num! generic class proc-or-num)
   (if (not (generic-added? generic))
       ;; we check the installation of the generic in order to
       ;; allow cycle in module graph.
       (add-generic! generic #f))
   (let* ((method-array (generic-method-array generic))
	  (previous     (method-array-ref method-array (class-num class))))
      (let loop ((class class))
	 (let* ((cnum    (class-num class))
		(current (method-array-ref method-array cnum)))
	    (if (or (not current) (eq? current previous))
		(begin
		   ;; we add the method
		   (method-array-set! method-array cnum proc-or-num)
		   ;; and we recursivly iterate on subclasses
		   (for-each loop (class-subclasses class)))))))
   proc-or-num)

;*---------------------------------------------------------------------*/
;*    add-method! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-method! generic class method)
   (cond
      ((not (class? class))
       (error "add-method!" "Illegal class" class))
      ((not (=fx (procedure-arity generic) (procedure-arity method)))
       (error "add-method!" "arity mismatch" (cons generic method)))
      (else
       (add-method/proc-or-num! generic class method))))

;*---------------------------------------------------------------------*/
;*    add-inlined-method! ...                                          */
;*---------------------------------------------------------------------*/
(define (add-inlined-method! generic class method-num)
   (add-method/proc-or-num! generic class method-num))
       
;*---------------------------------------------------------------------*/
;*    find-method ...                                                  */
;*    -------------------------------------------------------------    */
;*    This function returns the exact method of a generic              */
;*---------------------------------------------------------------------*/
(define-inline (find-method obj generic)
   (let ((obj-class-num (object-class-num obj)))
      (method-array-ref (generic-method-array generic) obj-class-num)))

;*---------------------------------------------------------------------*/
;*    find-inline-method ...                                           */
;*    -------------------------------------------------------------    */
;*    The same as `find-method' excepted that it first checks if we    */
;*    are entering the generic function from a `call-next-method'.     */
;*    This case is discovered by checking the `generic-pre-method'     */
;*    slot.                                                            */
;*---------------------------------------------------------------------*/
(define-inline (find-inline-method obj generic)
   (let ((pre-method (generic-pre-method generic)))
      (if (fixnum? pre-method)
	  (begin
	     (generic-pre-method-set! generic #unspecified)
	     pre-method)
	  (find-method obj generic))))

;*---------------------------------------------------------------------*/
;*    find-super-class-method ...                                      */
;*    -------------------------------------------------------------    */
;*    This function returns a method OR a default body.                */
;*---------------------------------------------------------------------*/
(define (find-super-class-method obj generic class)
   (let loop ((super (class-super class)))
      (if (not (class? super))
	  (generic-default generic)
	  (let ((obj-super-class-num (class-num super)))
	     (let ((method (method-array-ref (generic-method-array generic)
					     obj-super-class-num)))
		(if method
		    method
		    (let ((new-super (class-super super)))
		       (loop new-super))))))))

;*---------------------------------------------------------------------*/
;*    find-method-from ...                                             */
;*---------------------------------------------------------------------*/
(define (find-method-from obj generic class)
   (let loop ((class class))
      (if (not (class? class))
	  (cons #f #f)
	  (let ((obj-super-class-num (class-num class)))
	     (let ((method (method-array-ref (generic-method-array generic)
					     obj-super-class-num)))
		(if method
		    (cons class method)
		    (loop (class-super class))))))))
   
;*---------------------------------------------------------------------*/
;*    next-class-num ...                                               */
;*---------------------------------------------------------------------*/
(define (next-class-num::long num::long)
   (cond
      ((<fx num 0)
       -1)
      ((>=fx num *nb-classes*)
       -1)
      (else
       (let ((class (vector-ref-ur *classes* num)))
	  (class-num class)))))
   
;*---------------------------------------------------------------------*/
;*    is-a? ...                                                        */
;*    -------------------------------------------------------------    */
;*    The constant time implementation of is-a?                        */
;*---------------------------------------------------------------------*/
(define (is-a? obj class)
   (if (object? obj)
       (if (=fx (object-class-num obj) (class-num class))
	   #t
	   (let* ((direct-class (object-class obj))
		  (direct-depth (class-depth direct-class))
		  (depth        (class-depth class)))
	      (if (<fx depth direct-depth)
		  (eq? (vector-ref-ur (class-ancestors direct-class) depth)
		       class)
		  #f)))
       #f))

;*---------------------------------------------------------------------*/
;*    object-display ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (object-display obj::object . port)
   (let ((port (if (pair? port) (car port) (current-output-port))))
      (object-write/display obj port #t)))

;*---------------------------------------------------------------------*/
;*    object-write ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (object-write obj::object . port)
   (let ((port (if (pair? port) (car port) (current-output-port))))
      (object-write/display obj port #f)))

;*---------------------------------------------------------------------*/
;*    object->struct ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (object->struct::struct object::object)
   (error "object->struct" "This object can't be converted" object))

;*---------------------------------------------------------------------*/
;*    struct+object->object ...                                        */
;*    -------------------------------------------------------------    */
;*    Same remark as `object->struct'                                  */
;*---------------------------------------------------------------------*/
(define-generic (struct+object->object::object object::object struct::struct)
   (error "struct+object->object" "This structure can't be converted" struct))

;*---------------------------------------------------------------------*/
;*    struct->object ...                                               */
;*---------------------------------------------------------------------*/
(define (struct->object::object struct::struct)
   (struct+object->object (allocate-instance (struct-key struct)) struct))

;*---------------------------------------------------------------------*/
;*    allocate-instance ...                                            */
;*---------------------------------------------------------------------*/
(define (allocate-instance::object cname::symbol)
   (let loop ((i 0))
      (if (=fx i *nb-classes*)
	  (error "allocate-instance" "Can't find class" cname)
	  (let ((class (vector-ref-ur *classes* i)))
	     (if (eq? (class-name class) cname)
		 ((class-allocate class))
		 (loop (+fx i 1)))))))
      
;*---------------------------------------------------------------------*/
;*    wide-object? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (wide-object? object)
   (if (object-widening object) #t #f))
 
;*---------------------------------------------------------------------*/
;*    object-write/display ...                                         */
;*---------------------------------------------------------------------*/
(define (object-write/display obj::object port flag)
   (define (class-field-write/display field)
      (let* ((name      (class-field-name field))
	     (get-value (class-field-accessor field)))
	 (display " [" port)
	 (display name port)
	 (display #\: port)
	 ;; we now print its specific fields
	 (if (not (class-field-indexed? field))
	     ;; this is not an indexed field
	     (begin
		(display #\space port)
		(if flag
		    (display (get-value obj) port)
		    (write (get-value obj) port))
		(display #\] port))
	     ;; this is an indexed field
	     (let* ((get-len (class-field-len-accessor field))
		    (len     (get-len obj)))
		(let loop ((i 0))
		   (if (=fx i len)
		       (display #\] port)
		       (begin
			  (display #\space port)
			  (if flag
			      (display (get-value obj i) port)
			      (write (get-value obj i) port))
			  (loop (+fx i 1)))))))))
   (let* ((class      (object-class obj))
	  (class-name (class-name class))
	  (fields     (class-fields class)))
      (display "#|" port)
      (display class-name port)
      (if (class-fields? fields)
	  (let loop ((fields fields)
		     (class  class))
	     (cond
		((null? fields)
		 (let ((super (class-super class)))
		    (if (class? super)
			;; we have to print the super class fields
			(loop (class-fields super) super)
			(display #\| port))))
		((eq? fields #unspecified)
		 (display "..." port)
		 (loop '() class))
		(else
		 (class-field-write/display (car fields))
		 (loop (cdr fields) class))))
	  (display #\| port))))
      
;*---------------------------------------------------------------------*/
;*    object-equal? ...                                                */
;*---------------------------------------------------------------------*/
(define (object-equal?::bool obj1::object obj2::object)
   (define (class-field-equal? field)
      (let ((get-value (class-field-accessor field)))
	 (if (not (class-field-indexed? field))
	     ;; this is not an indexed field, some it is a simple check
	     (equal? (get-value obj1) (get-value obj2))
	     ;; this field is indexed, we have to check all its values
	     (let* ((get-len (class-field-len-accessor field))
		    (len1    (get-len obj1))
		    (len2    (get-len obj2)))
		(and (=fx len1 len2)
		     (let loop ((i 0))
			(cond
			   ((=fx i len1)
			    #t)
			   ((equal? (get-value obj1 i) (get-value obj2 i))
			    (loop (+fx i 1)))
			   (else
			    #f))))))))
   (let ((class1 (object-class obj1))
	 (class2 (object-class obj2)))
      (cond
	 ((not (eq? class1 class2))
	  #f)
	 (else
	  (let ((fields (class-fields class1)))
	     (if (not (class-fields? fields))
		 #f
		 (let loop ((fields fields)
			    (class  class1))
		    (cond
		       ((null? fields)
			(let ((super (class-super class)))
			   (if (class? super)
			       ;; we have now to check the super class fields
			       (let ((fields (class-fields super)))
				  (if (class-fields? fields)
				      (loop fields super)
				      #f))
			       ;; ok we are done with return value #t
			       #t)))
		       ((class-field-equal? (car fields))
			(loop (cdr fields) class))
		       (else
			#f)))))))))
