;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/make-lib.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  8 10:11:38 1995                          */
;*    Last change :  Fri Sep 18 17:12:03 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The construction of the library                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __make-lib
   
   (import  (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__error                   "Llib/error.scm")
	    (__os                      "Llib/os.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__structure               "Llib/struct.scm")
	    (__hash                    "Llib/hash.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bit                     "Llib/bit.scm")
	    (__binary                  "Llib/binary.scm")
	    (__intext                  "Llib/intext.scm")
	    (__foreign                 "Llib/foreign.scm")
	    (__object                  "Llib/object.scm")
	    (__dsssl                   "Llib/dsssl.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__unicode                 "Llib/unicode.scm")
	    (__process                 "Llib/process.scm")
	    (__socket                  "Llib/socket.scm")

	    (__reader                  "Read/reader.scm")

	    (__pp                      "Pp/pp.scm")

	    (__rgc                     "Rgc/rgc.scm")
	    (__rgc_expand              "Rgc/rgc-expand.scm")

	    (__macro                   "Eval/macro.scm")
            (__eval                    "Eval/eval.scm")
            (__evenv                   "Eval/evenv.scm")
            (__expand                  "Eval/expand.scm")

	    (__match_expand            "Match/mexpand.scm")
	    (match-define-structure!   __match_normalize "Match/normalize.scm")

	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r5_control_features_6_4 "Ieee/control5.scm")

	    (__r5_macro_4_3_init       "R5rs/init5.scm")
	    
	    (__lalr_driver             "Lalr/driver.scm")
	    (__lalr_expand             "Lalr/lalr.scm")))


