;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/foreign.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  5 16:50:26 1995                          */
;*    Last change :  Fri Feb  6 18:43:54 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The foreign object management.                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __foreign
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool   c-foreign?      (obj)       "FOREIGNP")
	    (macro bool   c-foreign-null? (obj)       "FOREIGN_NULLP")
	    (macro symbol foreign-id      (foreign)   "FOREIGN_ID"))

   (export  (inline foreign?::bool      ::obj)
	    (inline foreign-null?::bool ::obj)
	    (inline string-null?::bool  ::string)
	    (inline obj->cobj::cobj     ::obj))

   (pragma  (c-foreign? (predicate-of foreign) no-cfa-top)
	    (foreign? (predicate-of foreign) no-cfa-top)
	    (c-foreign-null? side-effect-free no-cfa-top)
	    (foreign-null? side-effect-free no-cfa-top)
	    (string-null? side-effect-free no-cfa-top)
	    (c-obj->cobj side-effect-free)
	    (obj->cobj side-effect-free)))
 
;*---------------------------------------------------------------------*/
;*    foreign? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (foreign? obj)
   (c-foreign? obj))

;*---------------------------------------------------------------------*/
;*    foreign-null? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (foreign-null? obj)
   (if (foreign? obj)
       (c-foreign-null? obj)
       (error "foreign-null?" "not a foreign object" obj)))

;*---------------------------------------------------------------------*/
;*    string-null? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-null? obj::string)
   (pragma::bool "($1 == 0L)" obj))
 
;*---------------------------------------------------------------------*/
;*    obj->cobj ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (obj->cobj obj)
   (c-obj->cobj obj))

