;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Llib/bit.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 11:06:41 1995                          */
;*    Last change :  Wed Jul 17 07:52:49 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Bit management                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bit

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (infix macro long c-bitor   (long long)    " | ")
	    (infix macro long c-bitand  (long long)    " & ")
	    (infix macro long c-bitxor  (long long)    " ^ ")
	    (macro long c-bitnot  (long)               "~")
	    (infix macro long c-bitrsh  (long long)    " >> ")
	    (infix macro ulong c-bitursh (ulong ulong) " >> ")
	    (infix macro long c-bitlsh  (long long)    " << "))
   
   (export  (inline bit-or::long    ::long ::long)
	    (inline bit-and::long   ::long ::long)
	    (inline bit-xor::long   ::long ::long)
	    (inline bit-not::long   ::long)
	    (inline bit-rsh::long   ::long ::long)
	    (inline bit-ursh::ulong ::ulong ::ulong)
	    (inline bit-lsh::long   ::long ::long))

   (pragma  (c-bitor side-effect-free no-cfa-top)
	    (c-bitand side-effect-free no-cfa-top)
	    (c-bitxor side-effect-free no-cfa-top)
	    (c-bitnot side-effect-free no-cfa-top)
	    (c-bitrsh side-effect-free no-cfa-top)
	    (c-bitursh side-effect-free no-cfa-top)
	    (c-bitlsh side-effect-free no-cfa-top)
	    (bit-or side-effect-free no-cfa-top)
	    (bit-and side-effect-free no-cfa-top)
	    (bit-xor side-effect-free no-cfa-top)
	    (bit-not side-effect-free no-cfa-top)
	    (bit-rsh side-effect-free no-cfa-top)
	    (bit-ursh side-effect-free no-cfa-top)
	    (bit-lsh side-effect-free no-cfa-top)))

;*---------------------------------------------------------------------*/
;*    bit-or ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (bit-or x y)
   (c-bitor x y))

;*---------------------------------------------------------------------*/
;*    bit-and ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-and x y)
   (c-bitand x y))

;*---------------------------------------------------------------------*/
;*    bit-xor ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-xor x y)
   (c-bitxor x y))

;*---------------------------------------------------------------------*/
;*    bit-not ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-not x)
   (c-bitnot x))
   
;*---------------------------------------------------------------------*/
;*    bit-rsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-rsh x y)
   (c-bitrsh x y))
       
;*---------------------------------------------------------------------*/
;*    bit-ursh ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (bit-ursh x y)
   (c-bitursh x y))
       
;*---------------------------------------------------------------------*/
;*    bit-lsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-lsh x y)
   (c-bitlsh x y))

