;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/binary.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  7 10:38:25 1994                          */
;*    Last change :  Fri Sep 18 17:38:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les entrees/sorties compactees des objets Scheme (eventuellement */
;*    circulaires).                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __binary

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool c-binary-port? (obj)
		   "BINARY_PORTP")
	    (macro obj beof
		   "BEOF")
	    (obj c-open-output-binary-file (bstring)
		 "open_output_binary_file")
	    (obj c-append-output-binary-file (bstring)
		 "append_output_binary_file")
	    (obj c-open-input-binary-file (bstring)
		 "open_input_binary_file")
	    (obj c-close-binary-port (binary-port)
		 "close_binary_port")
	    (obj c-input-obj  (binary-port)
		 "input_obj")
	    (obj c-output-obj (binary-port obj)
		 "output_obj"))
   
   (export  (inline binary-port?::bool             ::obj)
	    (inline open-output-binary-file::obj   ::bstring)
	    (inline append-output-binary-file::obj ::bstring)
	    (inline open-input-binary-file::obj    ::bstring)
	    (inline close-binary-port              ::binary-port)
	    (inline output-obj                     ::binary-port ::obj)
	    (inline input-obj                      ::binary-port)
	    (inline output-char                    ::binary-port ::char)
	    (inline input-char::obj                ::binary-port))
   
   (pragma  (c-binary-port? (predicate-of binary-port))
	    (binary-port? side-effect-free)))

;*---------------------------------------------------------------------*/
;*    binary-port? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (binary-port? obj)
   (c-binary-port? obj))

;*---------------------------------------------------------------------*/
;*    open-output-binary-file ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (open-output-binary-file str)
   (c-open-output-binary-file str))

;*---------------------------------------------------------------------*/
;*    append-output_binary-file ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (append-output-binary-file str)
   (c-append-output-binary-file str))

;*---------------------------------------------------------------------*/
;*    open-input-binary-file ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (open-input-binary-file str)
   (c-open-input-binary-file str))

;*---------------------------------------------------------------------*/
;*    close-binary-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (close-binary-port port)
   (c-close-binary-port port))

;*---------------------------------------------------------------------*/
;*    input-obj ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (input-obj port)
   (c-input-obj port))

;*---------------------------------------------------------------------*/
;*    output-obj ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (output-obj port obj)
   (c-output-obj port obj))
	    
;*---------------------------------------------------------------------*/
;*    output-char ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (output-char port char)
   (pragma "(fputc( $2, BINARY_PORT( $1 ).file ), BUNSPEC)" port char))

;*---------------------------------------------------------------------*/
;*    input-char ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (input-char port)
   (let ((char (pragma::int "(fgetc( BINARY_PORT( $1 ).file ))" port)))
      (if (=fx char (pragma::int "EOF"))
	  beof
	  (integer->char char))))
