;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/bigloo.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 08:24:40 1995                          */
;*    Last change :  Tue Jun  9 14:02:12 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bigloo runtime utility functions                             */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bigloo

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__tvector                 "Llib/tvector.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool c-procedure-light? (obj)       "PROCEDURE_LIGHTP")
	    (macro bool va-procedure?      (procedure) "VA_PROCEDUREP")
	    (macro obj  procedure-entry    (procedure) "PROCEDURE_ENTRY")
	    (macro obj  tprocedure-l-entry (procedure) "PROCEDURE_L_ENTRY")
	    
	    (macro long procedure-arity (PROCEDURE)
		   "PROCEDURE_ARITY")
	    (macro bool correct-arity?  (procedure long)
		   "PROCEDURE_CORRECT_ARITYP")
	    
	    (macro procedure make-fx-procedure   (obj long long)
		   "make_fx_procedure")		 
	    (macro procedure make-va-procedure   (obj long long)
		   "make_va_procedure")
	    
	    (macro procedure make-s-fx-procedure (obj long long)
		   "MAKE_S_FX_PROCEDURE")		 
	    (macro procedure make-s-va-procedure (obj long long)
		   "MAKE_S_VA_PROCEDURE")
	    
	    (macro procedure make-el-procedure   (long)
		   "MAKE_EL_PROCEDURE")	 
	    (macro procedure make-el-procedure-1 (long)
		   "MAKE_EL_PROCEDURE_1")	 
	    (macro procedure make-s-el-procedure (long)
		   "MAKE_S_EL_PROCEDURE")
	    
	    (macro procedure  make-l-procedure   (obj long)
		   "MAKE_L_PROCEDURE")		 
	    (macro procedure  make-s-l-procedure (obj long)
		   "MAKE_S_L_PROCEDURE")		 
	    					 
	    (macro obj procedure-set!            (procedure long obj)
		   "PROCEDURE_SET")			 
	    (macro obj procedure-ref             (procedure long)
		   "PROCEDURE_REF")			 

	    (macro obj procedure-l-set!          (obj long obj)
		   "PROCEDURE_L_SET")		  
	    (macro obj procedure-l-ref           (obj long)
		   "PROCEDURE_L_REF")
	    
	    (macro obj procedure-el-set!         (obj long obj)
		   "PROCEDURE_EL_SET")		 
	    (macro obj procedure-el-ref          (obj long)
		   "PROCEDURE_EL_REF")
	    
	    (macro obj procedure-1-el-set!       (obj long obj)
		   "PROCEDURE_1_EL_SET")		 
	    (macro obj procedure-1-el-ref        (obj long)
		   "PROCEDURE_1_EL_REF")
	    
	    (macro obj make-cell  (obj)              "MAKE_CELL")
	    (macro obj cell-set!  (obj obj)          "CELL_SET")
	    (macro obj cell-ref   (obj)              "CELL_REF")
	    (macro bool cell?     (obj)              "CELLP")
	    
	    (macro bool c-cnst?   (obj)              "CNSTP")
	    
	    (macro obj __unspec__                    "BUNSPEC")
	    (macro obj __eoa__                       "BEOA")
	    
	    (macro obj declare-cnst-table  (obj)      "DECLARE_CNST_TABLE")
	    (macro obj cnst-table-set!     (long obj) "CNST_TABLE_SET")
	    (macro obj cnst-table-ref      (long)     "CNST_TABLE_REF")

	    (macro bstring make-init-string  obj     "make_init_string")
	    (macro obj     close-init-string (obj)   "close_init_string")
	    
	    (macro obj var->root     (obj)           "(obj_t)&")
	    (macro obj GC-add-globv! (obj)           "GC_ADD_GLOBV")
	    (macro obj GC-add-roots! (obj obj)       "GC_ADD_ROOTS")

	    (macro obj bigloo-exit (obj)             "BIGLOO_EXIT"))

   (extern  (export *profile-port* "bprof_port"))
 
   (export  (check-version!                          ::obj ::string ::obj)
	    (inline cnst?::bool                      ::obj)
	    (inline closure-arity::long              ::procedure)
	    (inline unspecified::unspecified)
	    *profile-port*)

   (pragma  (make-fx-procedure (stack-alloc make-s-fx-procedure) no-cfa-top)
	    (make-va-procedure (stack-alloc make-s-va-procedure) no-cfa-top)
	    (make-el-procedure (stack-alloc make-s-el-procedure))
	    (make-l-procedure (stack-alloc make-s-l-procedure))
	    (procedure-set! no-cfa-top)
	    (procedure-ref no-cfa-top side-effect-free)
	    (cell? (predicate-of cell))
	    (c-cnst? (predicate-of cnst)))

   (option  (set! *unsafe-version* #t)))

;*---------------------------------------------------------------------*/
;*    check-version! ...                                               */
;*    -------------------------------------------------------------    */
;*    This function is in charge of the coherence of all module        */
;*    of an executable (i.e. does all module compiled by the           */
;*    same Bigloo's version).                                          */
;*---------------------------------------------------------------------*/
(define (check-version! module release level)
   (cond
      ((not (string? *release*))
       (set! *modules* (list module))
       (set! *release* release)
       (set! *level*   level))
      ((or (let ((min (-fx (minfx (string-length release)
				  (string-length *release*))
			   1)))
	      (not (string=? (substring release 0 min)
			     (substring *release* 0 min))))
	   (and (char? level) (char? *level*) (not (char=? *level* level))))
       (define (release-name release level)
	  (if (char? level)
	      (let ((s (string-copy " (level 0)")))
		 (string-set! s 8 level)
		 (string-append release s))
	      release))
       (error (string-append "Some modules have been compiled by: "
			     (release-name *release* *level*))
	      (string-append "and other by: "
			     (release-name release level))
	      (cons module *modules*)))
      (else
       (set! *modules* (cons module *modules*)))))

;*---------------------------------------------------------------------*/
;*    Some variables for check-version!                                */
;*---------------------------------------------------------------------*/
(define *release* #f)
(define *level*   #f)
(define *modules* '())
   
;*---------------------------------------------------------------------*/
;*    closure-arity ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (closure-arity proc)
   (procedure-arity proc))

;*---------------------------------------------------------------------*/
;*    unspecified ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (unspecified)
   __unspec__)

;*---------------------------------------------------------------------*/
;*    cnst? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cnst? obj)
   (c-cnst? obj))

;*---------------------------------------------------------------------*/
;*    *profile-port* ...                                               */
;*---------------------------------------------------------------------*/
(define *profile-port* #unspecified)
