;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/bexit.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 31 15:00:41 1995                          */
;*    Last change :  Tue Mar 10 07:12:57 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `bind-exit' manipulation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bexit

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (use     (__R4_OUTPUT_6_10_3 "Ieee/output.scm"))
   
   (extern  (macro push-exit!::obj (::exit ::bool) "PUSH_EXIT")
	    (macro pop-exit!::obj ()               "POP_EXIT")
	    (macro exitd->exit::exit (::obj)       "EXITD_TO_EXIT")
	    (macro exitd-user?::bool (::obj)       "EXITD_USERP")
	    (macro exitd-stamp::bint (::obj)       "EXITD_STAMP")
	    
	    (export *exitd-top*         "exitd_top")
	    (export *exitd-stamp*       "exitd_stamp")
	    (export unwind-stack-until! "unwind_stack_until")
	    (export unwind-stack-value? "unwind_stack_value_p"))

   (export  *exitd-top*
	    *exitd-stamp*
	    (val-from-exit?      ::obj)
	    (unwind-stack-value?::bool ::obj)
	    (unwind-until! exitd ::obj)
	    (unwind-stack-until! exitd ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    *exitd-top* ...                                                  */
;*---------------------------------------------------------------------*/
(define *exitd-top* #f)

;*---------------------------------------------------------------------*/
;*    The exitd counter.                                               */
;*---------------------------------------------------------------------*/
(define *exitd-stamp* 0)

;*---------------------------------------------------------------------*/
;*    *protected-val* ...                                              */
;*---------------------------------------------------------------------*/
(define *protected-val* (cons #unspecified #unspecified))

;*---------------------------------------------------------------------*/
;*    val-from-exit? ...                                               */
;*---------------------------------------------------------------------*/
(define (val-from-exit? val)
   (eq? val *protected-val*))

;*---------------------------------------------------------------------*/
;*    unwind-stack-value? ...                                          */
;*    -------------------------------------------------------------    */
;*    I have introduced this function just because it helps the        */
;*    bootstrap. val-from-exit? is used inside the compiler with       */
;*    the prototype obj->obj and I wanted to use this function         */
;*    inside callcc.c with the prototype obj->bool.                    */
;*---------------------------------------------------------------------*/
(define (unwind-stack-value? val)
   (val-from-exit? val))

;*---------------------------------------------------------------------*/
;*    unwind-until! ...                                                */
;*    -------------------------------------------------------------    */
;*    This function is used by unwind-protect and bind-exit. It just   */
;*    unwind a stack is must not be used by call/cc. The former should */
;*    directly use unwind-stack-until!                                 */
;*---------------------------------------------------------------------*/
(define (unwind-until! exitd val)
   (if (pair? exitd)
       (unwind-stack-until! (car exitd) #f val (cdr exitd))
       (unwind-stack-until! exitd #f val #f)))

;*---------------------------------------------------------------------*/
;*    unwind-stack-until! ...                                          */
;*    -------------------------------------------------------------    */
;*    This function unwind a stack until an exit is found or the       */
;*    stack bottom is reached. In such a case, the proc arg is called. */
;*    This function is used by unwind-until! (introduced by any        */
;*    unwind-protect) and by call/cc.                                  */
;*---------------------------------------------------------------------*/
(define (unwind-stack-until! exitd estamp val proc)
   (let loop ()
      (if (eq? *exitd-top* #f)
	  (if (procedure? proc)
	      (proc val)
	      (error "unwind-until!"
		     "exit out of dynamic scope"
		     #unspecified))
	  (let ((exit-top *exitd-top*))
	     (pop-exit!)
	     (cond  
		((and (eq? exit-top exitd) 
		      (or (not (fixnum? estamp))
			  (=fx (exitd-stamp exit-top) estamp)))
		 (jump-exit (exitd->exit exit-top) val))
		((not (exitd-user? exit-top))
		 (set-car! *protected-val* (cons exitd proc))
		 (set-cdr! *protected-val* val)
		 (jump-exit (exitd->exit exit-top) *protected-val*))
		(else
		 (loop)))))))

(define (dbg-unwind-stack-until! exitd estamp val proc)
   (print "==========================================")
   (print "unwind-stack-until!: estamp: " estamp " val: " val " proc: " proc)
   (let loop ()
      (if (eq? *exitd-top* #f)
	  (begin
	     (print "J'ai touche le fond: " val " proc: " proc)
	     (print "==========================================")
	  (if (procedure? proc)
	      (proc val)
	      (error "unwind-until!"
		     "exit out of dynamic scope"
		     #unspecified))
	  )
	  (let ((exit-top *exitd-top*))
	     (pop-exit!)
	     (cond  
		((and (eq? exit-top exitd) 
		      (or (not (fixnum? estamp))
			  (=fx (exitd-stamp exit-top) estamp)))
		 (print "unwind-stack-until: je l'ai val: " val " stamp: " (exitd-stamp exit-top))
		 (print "==========================================")
		 (jump-exit (exitd->exit exit-top) val))
		((not (exitd-user? exit-top))
		 (print "J'ai un system: " val)
		 (set-car! *protected-val* (cons exitd proc))
		 (set-cdr! *protected-val* val)
		 (jump-exit (exitd->exit exit-top) *protected-val*))
		(else
		 (loop)))))))
