;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;; ---------------------------------------------------------------------- ;;
;; FICHIER               : global.scm                                     ;;
;; DATE DE CREATION      : Mon Jul  3 14:09:45 1995                       ;;
;; DERNIERE MODIFICATION : Tue Jul  4 09:45:43 1995                       ;;
;; ---------------------------------------------------------------------- ;;
;; Copyright (c) 1995 Dominique Boucher                                   ;;
;; ---------------------------------------------------------------------- ;;
;; Les variables globales ...                                             ;;
;; ---------------------------------------------------------------------- ;;

(module __lalr_global
   
	(include "Lalr/lalr.sch")

	(import (__error                   "Llib/error.scm"))
	
	(use    (__type                    "Llib/type.scm")
		(__bigloo                  "Llib/bigloo.scm")
		(__tvector                 "Llib/tvector.scm")
		(__structure               "Llib/struct.scm")
		(__tvector                 "Llib/tvector.scm")

		(__r4_numbers_6_5          "Ieee/number.scm")
		(__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
		(__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
		(__r4_characters_6_6       "Ieee/char.scm")
		(__r4_equivalence_6_2      "Ieee/equiv.scm")
		(__r4_booleans_6_1         "Ieee/boolean.scm")
		(__r4_symbols_6_4          "Ieee/symbol.scm")
		(__r4_strings_6_7          "Ieee/string.scm")
		(__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
		(__r4_input_6_10_2         "Ieee/input.scm")
		(__r4_control_features_6_9 "Ieee/control.scm")
		(__r4_vectors_6_8          "Ieee/vector.scm")
		(__r4_ports_6_10_1         "Ieee/port.scm")
		(__r4_output_6_10_3        "Ieee/output.scm")
		(__evenv                   "Eval/evenv.scm"))

	(export  grammar
		 rrhs         
		 rlhs         
		 ritem        
		 nullable     
		 derives      
		 fderives     
		 firsts       
		 kernel-base  
		 kernel-end   
		 shift-symbol 
		 shift-set    
		 red-set      
		 state-table  
		 acces-symbol 
		 reduction-table 
		 shift-table  
		 consistent   
		 lookaheads   
		 LA           
		 LAruleno     
		 lookback     
		 goto-map     
		 from-state   
		 to-state     
		 includes     
		 F            
		 action-table 
		 nitems          
		 nrules          
		 nvars           
		 nterms          
		 nsyms           
		 nstates         
		 first-state     
		 last-state      
		 final-state     
		 first-shift     
		 last-shift      
		 first-reduction 
		 last-reduction  
		 nshifts         
		 maxrhs          
		 ngotos          
		 token-set-size
		 terminals
		 nonterminals
		 actions
		 STATE-TABLE-SIZE
		 (initialize-all)))

;; - Tableaux 
(define rrhs            #f)
(define rlhs            #f)
(define ritem           #f)
(define nullable        #f)
(define derives         #f)
(define fderives        #f)
(define firsts          #f)
(define kernel-base     #f)
(define kernel-end      #f)
(define shift-symbol    #f)
(define shift-set       #f)
(define red-set         #f)
(define state-table     #f)
(define acces-symbol    #f)
(define reduction-table #f)
(define shift-table     #f)
(define consistent      #f)
(define lookaheads      #f)
(define LA              #f)
(define LAruleno        #f)
(define lookback        #f)
(define goto-map        #f)
(define from-state      #f)
(define to-state        #f)
(define includes        #f)
(define F               #f)
(define action-table #f)

;; - Variables
(define nitems          #f)
(define nrules          #f)
(define nvars           #f)
(define nterms          #f)
(define nsyms           #f)
(define nstates         #f)
(define first-state     #f)
(define last-state      #f)
(define final-state     #f)
(define first-shift     #f)
(define last-shift      #f)
(define first-reduction #f)
(define last-reduction  #f)
(define nshifts         #f)
(define maxrhs          #f)
(define ngotos          #f)
(define token-set-size  #f)
(define grammar         #f)
(define terminals       #f)
(define nonterminals    #f)
(define actions         #f)

(define (initialize-all)
  (set! rrhs            #f)
  (set! rlhs            #f)
  (set! ritem           #f)
  (set! nullable        #f)
  (set! derives         #f)
  (set! fderives        #f)
  (set! firsts          #f)
  (set! kernel-base     #f)
  (set! kernel-end      #f)
  (set! shift-symbol    #f)
  (set! shift-set       #f)
  (set! red-set         #f)
  (set! state-table     (make-vector STATE-TABLE-SIZE '()))
  (set! acces-symbol    #f)
  (set! reduction-table #f)
  (set! shift-table     #f)
  (set! consistent      #f)
  (set! lookaheads      #f)
  (set! LA              #f)
  (set! LAruleno        #f)
  (set! lookback        #f)
  (set! goto-map        #f)
  (set! from-state      #f)
  (set! to-state        #f)
  (set! includes        #f)
  (set! F               #f)
  (set! action-table    #f)
  (set! nstates         #f)
  (set! first-state     #f)
  (set! last-state      #f)
  (set! final-state     #f)
  (set! first-shift     #f)
  (set! last-shift      #f)
  (set! first-reduction #f)
  (set! last-reduction  #f)
  (set! nshifts         #f)
  (set! maxrhs          #f)
  (set! ngotos          #f)
  (set! token-set-size  #f)
  (set! grammar         #f)
  (set! terminals       #f)
  (set! nonterminals    #f)
  (set! actions         #f))


;; - Constantes
(define STATE-TABLE-SIZE 1009)
