;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    .../serrano/prgm/project/bigloo/runtime/Ieee/symbol.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  4 15:05:26 1992                          */
;*    Last change :  Fri Oct 30 10:41:26 1998 ()                       */
;*    -------------------------------------------------------------    */
;*    6.4. Symbols (page 18, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_symbols_6_4

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (extern  (macro c-symbol?::bool            (::obj)       "SYMBOLP")
	    (c-string->symbol::symbol         (::string)    "string_to_symbol")
	    (macro c-symbol->string::bstring  (::obj)       "SYMBOL_TO_STRING")
	    (macro c-symbol-plist::obj        (::obj)       "GET_SYMBOL_PLIST")
	    (macro set-symbol-plist::obj      (::obj ::obj) "SET_SYMBOL_PLIST")
	    (macro symbol-exists?::bool       (::string)    "symbol_exists_p")
	    
            (macro c-keyword?::bool           (::obj)      "KEYWORDP")
	    (c-string->keyword::keyword       (::string)   "string_to_keyword")
	    (macro c-keyword->string::bstring (::keyword)  "KEYWORD_TO_STRING")
	    (macro cnst->integer::long        (::obj)      "CCNST"))
   
   (export  (inline symbol?::bool           ::obj)
	    (inline symbol->string::bstring ::symbol)
	    (inline string->symbol::symbol  ::bstring)
	    (symbol-append::symbol          . symbols)
	    (inline symbol-plist::obj       ::obj)
	    (getprop                        ::obj ::symbol)
	    (putprop!                       ::obj ::symbol ::obj)
	    (remprop!                       ::obj ::symbol)
	    gensym
	    (inline keyword?::bool           ::obj)
	    (inline keyword->string::bstring ::keyword)
	    (inline string->keyword::keyword ::bstring))
   
   (pragma  (c-symbol? (predicate-of symbol) no-cfa-top)
	    (symbol? side-effect-free)
	    (c-string->symbol no-cfa-top)
	    (string->symbol no-cfa-top)
	    (getprop side-effect-free)
	    (c-keyword? (predicate-of keyword) no-cfa-top)
	    (keyword? side-effect-free)
	    (c-string->keyword no-cfa-top)
	    (string->keyword no-cfa-top)))
 
;*---------------------------------------------------------------------*/
;*    symbol? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (symbol? obj)
   (c-symbol? obj))

;*---------------------------------------------------------------------*/
;*    symbol->string ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (symbol->string symbol)
   (c-symbol->string symbol))

;*---------------------------------------------------------------------*/
;*    string->symbol ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string->symbol string)
   (c-string->symbol string))

;*---------------------------------------------------------------------*/
;*    symbol-append ...                                                */
;*---------------------------------------------------------------------*/
(define (symbol-append . list)
   (string->symbol (if (null? list)
		       ""
		       (let loop ((list list))
			  (if (null? (cdr list))
			      (symbol->string (car list))
			      (c-string-append (symbol->string (car list))
					       (loop (cdr list))))))))

;*---------------------------------------------------------------------*/
;*    gensym ...                                                       */
;*---------------------------------------------------------------------*/
(define gensym
   (let ((counter 999))
      (lambda string
	 (let ((string (cond
			  ((null? string)
			   "g")
			  ((symbol? (car string))
			   (symbol->string (car string)))
			  ((string? (car string))
			   (car string))
			  (else
			   (error "gensym"
				  "Illegal argument"
				  (car string))))))
	    (let loop ()
	       (set! counter (+fx counter 1))
	       (let ((name (string-append string (integer->string counter))))
		  (if (not (symbol-exists? name))
		      (string->symbol name)
		      (loop))))))))

;*---------------------------------------------------------------------*/
;*    symbol-plist ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (symbol-plist symbol)
   (if (or (symbol? symbol) (keyword? symbol))
       (c-symbol-plist symbol)
       (error "symbol-plist"
	      "argument is neither a symbol nor a keyword"
	      symbol)))

;*---------------------------------------------------------------------*/
;*    getprop ...                                                      */
;*---------------------------------------------------------------------*/
(define (getprop symbol key)
   (if (or (symbol? symbol) (keyword? symbol))
       (let loop ((pl (symbol-plist symbol)))
	  (cond
	     ((null? pl)
	      #f)
	     ((eq? (car pl) key)
	      (cadr pl))
	     (else
	      (loop (cddr pl)))))
       (error "getprop" "argument is neither a symbol nor a keyword" key)))

;*---------------------------------------------------------------------*/
;*    putprop! ...                                                     */
;*---------------------------------------------------------------------*/
(define (putprop! symbol key val)
   (if (or (symbol? symbol) (keyword? symbol))
       (let loop ((pl (symbol-plist symbol)))
	  (cond
	     ((null? pl)
	      (let ((new (cons* key val (symbol-plist symbol))))
		 (set-symbol-plist symbol new)
		 new))
	     ((eq? (car pl) key)
	      (set-car! (cdr pl) val))
	     (else
	      (loop (cddr pl)))))
       (error "getprop" "argument is neither a symbol nor a keyword" key)))

;*---------------------------------------------------------------------*/
;*    remprop! ...                                                     */
;*---------------------------------------------------------------------*/
(define (remprop! symbol key)
   (if (or (symbol? symbol) (keyword? symbol))
       (let loop ((old '())
		  (l   (symbol-plist symbol)))
	  (cond
	     ((null? l)
	      #f)
	     ((eq? (car l) key)
	      (cond
		 ((pair? old)
		  (set-cdr! (cdr old) (cddr l)))
		 (else
		  (set-symbol-plist symbol (cddr l)))))
	     (else
	      (loop l (cddr l)))))
       (error "getprop" "argument is neither a symbol nor a keyword" key)))

;*---------------------------------------------------------------------*/
;*    keyword? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (keyword? obj)
   (c-keyword? obj))

;*---------------------------------------------------------------------*/
;*    keyword->string ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (keyword->string keyword)
   (c-keyword->string keyword))

;*---------------------------------------------------------------------*/
;*    string->keyword ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (string->keyword string)
   (c-string->keyword string))


