;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/output.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Fri Feb  6 16:55:20 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.3 Output (page 31, r4)                                      */
;*    -------------------------------------------------------------    */
;*    This module is able to display object even if it is not          */
;*    properly initailzed. This is very important because with this    */
;*    means, error during the initialization time will be correctly    */
;*    prompted. In particular, we must be very carefull not to launch  */
;*    unexpected errors.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3

   (import  (__error                   "Llib/error.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__object                  "Llib/object.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__unicode                 "Llib/unicode.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")

	    (__evenv                   "Eval/evenv.scm"))
     
   (extern  (macro output-string-port::bool (::obj)
            		                    "OUTPUT_STRING_PORTP")
	    (macro c-write-char::uchar      (::uchar ::output-port)
		                            "WRITE_CHAR")
	    (c-write_char::obj              (::bchar ::output-port)
					    "write_char")
	    (display-char::obj              (::bchar ::output-port)
					    "display_char")
	    (c-write_ucs2::obj              (::bucs2 ::output-port)
					    "write_ucs2")
	    (display-ucs2::obj              (::bucs2 ::output-port)
					    "display_ucs2")
	    (write-object::obj              (::obj ::output-port)
					    "write_object")
	    (write-string::obj              (::bstring ::output-port)
					    "write_string")
	    (display-string::obj            (::bstring ::output-port)
					    "display_string")
	    (display-fixnum::obj            (::blong ::output-port)
					    "display_fixnum")
	    (display-flonum::obj            (::real ::output-port)
					    "display_flonum")
	    (ill-char-rep::obj              (::uchar)
					    "ill_char_rep")
	    (write-utf8string::obj          (::bstring ::output-port)
					    "write_utf8string")
	    (display-ucs2string::obj        (::ucs2string ::output-port)
					    "display_ucs2string")
	    (export c-debugging-print "dprint"))
    
   (export  (set-write-length!        ::long)
	    (get-write-length::long)
	    (newline                  . port)
	    (write                    obj . port)
	    (display                  obj . port)  
	    (write-char               ::uchar . port)
	    (illegal-char-rep         ::uchar) 
	    (display*                 . obj)
	    (write*                   . obj)
	    (print                    . obj)
	    (fprint                   ::output-port . obj)
	    (set-printer!             ::procedure)
	    (native-printer::procedure)
	    (c-debugging-print        ::obj)))
   
;*---------------------------------------------------------------------*/
;*    *max-length-write* ...                                           */
;*    -------------------------------------------------------------    */
;*    Cette variable contient le nombre maximum d'appels recursifs     */
;*    toleres lors d'un write.                                         */
;*---------------------------------------------------------------------*/
(define *max-length-write* -1)

;*---------------------------------------------------------------------*/
;*    *displayed*                                                      */
;*---------------------------------------------------------------------*/
(define *displayed* 0)

;*---------------------------------------------------------------------*/
;*    set-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (set-write-length! length)
   (set! *max-length-write* length))

;*---------------------------------------------------------------------*/
;*    get-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (get-write-length)
   (if (not (integer? *max-length-write*))
       -1
       *max-length-write*))

;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (c-write-char #\Newline
		 (if (or (not (pair? port))
			 (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (set! *displayed* 0)
   (if (or (eq? *current-printer* native-display)
	   (not (procedure? *current-printer*)))
       (write/display obj
		      (if (or (not (pair? port))
			      (not (output-port? (car port))))
			  (current-output-port)
			  (car port))
		      #t)
       (try (*current-printer* obj
			       (if (or (not (pair? port))
				       (not (output-port? (car port))))
				   (current-output-port)
				   (car port)))
	    (lambda (esc proc mes obj)
	       (set-printer! (native-printer))
	       (error proc mes obj)))))

;*---------------------------------------------------------------------*/
;*    native-display ...                                               */
;*---------------------------------------------------------------------*/
(define (native-display obj . port)
   (set! *displayed* 0)
   (write/display obj
		  (if (or (not (pair? port)) (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  #t))

;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (set! *displayed* 0)
   (write/display obj
		  (if (or (not (pair? port))
			  (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  #f))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (c-write-char char
		 (if (or (not (pair? port))
			 (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (ill-char-rep char))

;*---------------------------------------------------------------------*/
;*    write/display ...                                                */
;*    -------------------------------------------------------------    */
;*    As we can't be sure that this module is initialized before       */
;*    used (for example when an error occurs during module             */
;*    intialization process), we can't use symbol to set               */
;*    flag. So is flag is equal to #t it means that                    */
;*    `write-display' is used to display and if flags is equal         */
;*    to #f it writes.                                                 */
;*---------------------------------------------------------------------*/
(define (write/display obj port flag)
   (set! *displayed* (+fx 1 *displayed*))
   (cond
      ((and (fixnum? *max-length-write*)
	    (>fx *max-length-write* 0)
	    (>=fx *displayed* *max-length-write*)) 
       (display-string "..." port))
      ((fixnum? obj)
       (display-fixnum obj port))
      ((char? obj)
       (if flag 
	   (display-char obj port)
	   (c-write_char obj port)))
      ((ucs2? obj)
       (if flag 
	   (display-ucs2 obj port)
	   (c-write_ucs2 obj port)))
      ((string? obj) 
       (if flag
	   (display-string obj port)
	   (write-string (string-for-read obj) port)))
      ((vector? obj)
       (write/display-vector obj port flag))
      ((pair? obj)
       (write/display-pair obj port flag))
      ((flonum? obj)
       (display-flonum obj port))
      ((cell? obj)
       (write/display-cell obj port flag))
      ((struct? obj)
       (write/display-structure obj port flag))
      ((tvector? obj)
       (write/display-tvector obj port flag))
      ((object? obj)
       (write/display-object obj port flag))
      ((ucs2-string? obj)
       (if flag
	   (display-ucs2string obj port) 
	   (write-utf8string (string-for-read (ucs2-string->utf8-string obj))
			     port)))
      (else
       (write-object obj port)))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    write/display-cell ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-cell obj port flag)
   (display-string "#<cell:" port)
   (write/display (cell-ref obj) port flag)
   (display-string ">" port))

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port flag)
   (c-write-char #\# port)
   (c-write-char #\{ port)
   (write-object (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       (c-write-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  (c-write-char #\space port)
	  (let loop ((i 0))
	     (cond
		((and (fixnum? *max-length-write*)
		      (>fx *max-length-write* 0)
		      (>fx *displayed* *max-length-write*))
		 (write-object "... }" port))
		((=fx i len)
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\} port))
		(else
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port flag)
   (c-write-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (write-object tag port)
		 (begin
		    (c-write-char #\0 port)
		    (if (>=fx tag 10)
			(write-object tag port)
			(begin
			   (c-write-char #\0 port)
			   (write-object tag port))))))))
   (c-write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (c-write-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (cond
		((and (fixnum? *max-length-write*)
		      (>fx *max-length-write* 0)
		      (>=fx *displayed* *max-length-write*))
		 (write-object "... )" port))
		((=fx i len)
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\) port))
		(else
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    write/display-tvector ...                                        */
;*---------------------------------------------------------------------*/
(define (write/display-tvector tvec port flag)
   (let ((tvector-ref (tvector-ref tvec))
	 (id          (tvector-id tvec)))
      (c-write-char #\# port)
      (write-object id port)
      (c-write-char #\( port)
      (if (not tvector-ref)
	  (begin
	     (write-object "...)" port)
	     tvec)
	  (begin
	     (if (=fx 0 (tvector-length tvec))
		 (c-write-char #\) port)
		 (let ((len (-fx (tvector-length tvec) 1)))
		    (let loop ((i 0))
		       (cond
			  ((and (fixnum? *max-length-write*)
				(>fx *max-length-write* 0)
				(>=fx *displayed* *max-length-write*))
			   (write-object "... )" port))
			  ((=fx i len)
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   (c-write-char #\) port))
			  (else
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   (c-write-char #\space port)
			   (loop (+fx 1 i)))))))))))

;*---------------------------------------------------------------------*/
;*    write/display-object ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-object obj port flag)
   (if flag
       (object-display obj port)
       (object-write obj port)))

;*---------------------------------------------------------------------*/
;*    write/display-pair ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-pair obj port flag)
   (c-write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (write/display (car l) port flag)
	  (c-write-char #\) port))
	 ((and (fixnum? *max-length-write*)
	       (>fx *max-length-write* 0)
	       (>=fx *displayed* *max-length-write*))
	  (write-object " . ... )" port))
	 ((not (pair? (cdr l)))
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (c-write-char #\. port)
	  (c-write-char #\space port)
	  (write/display (cdr l) port flag)
	  (c-write-char #\) port))
	 (else
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (loop (cdr l))))))
 
;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l   obj)
		 (res '()))
	 (if (null? l)
	     (begin
		(c-write-char #\Newline port)
		res)
	     (let ((v (car l)))
		(write/display v port #t)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(display (car l) port)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(write/display (car l) port #f)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (set! *displayed* 0)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     (c-write-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (write/display (car l) port #t)
	     (loop (cdr l) v)))))
  
;*---------------------------------------------------------------------*/
;*    *current-printer* ...                                            */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire l'affectation de `*current-printer*'      */
;*    en deux fois car sinon, a cause des optims, on n'aura pas        */
;*    eq? entre `native-printer' et `*current-printer*' !              */
;*---------------------------------------------------------------------*/
(define *current-printer* #unspecified)
(set! *current-printer* native-display)

;*---------------------------------------------------------------------*/
;*    set-printer! ...                                                 */
;*---------------------------------------------------------------------*/
(define (set-printer! f)
   (set! *current-printer* f))

;*---------------------------------------------------------------------*/
;*    native-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (native-printer)
   native-display)

;*---------------------------------------------------------------------*/
;*    c-debugging-print ...                                            */
;*---------------------------------------------------------------------*/
(define (c-debugging-print obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (write/display obj port #t)
      (c-write-char #\Newline port)
      obj))


