;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/input.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Thu Sep 24 06:37:16 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.2 Input (page 30, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2

   (import  (__error                   "Llib/error.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    
	    (__rgc                     "Rgc/rgc.scm")
	    
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (extern  (macro c-eof-object?::bool (::obj) "EOF_OBJECTP"))
    
   (export  (inline read/rp    ::procedure ::input-port)
	    (inline read/lalrp ::procedure ::procedure ::input-port . obj)
	    
	    (read-char                   . port)
	    (peek-char                   . port)
	    (inline eof-object?::bool    ::obj)
	    (char-ready?::bool           . port)
	    (read-line::obj              . input-port)
	    (read-of-strings::obj        . input-port)
	    *about-to-read*)

   (pragma  (eof-object? side-effect-free)
	    (char-ready? side-effect-free)))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (read/rp grammar port)
   (grammar port))

;*---------------------------------------------------------------------*/
;*    read/lalr ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (read/lalrp lalr rgc port . eof-fun?)
   (if (null? eof-fun?)
       (lalr rgc port eof-object?)
       (lalr rgc port (car eof-fun?))))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (string-ref (the-string) 0)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (peek-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (let ((c (string-ref (the-string) 0)))
			 (rgc-buffer-unget-char (the-port) (char->integer c))
			 c)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    char-ready? ...                                                  */
;*---------------------------------------------------------------------*/
(define (char-ready? . port)
   #t)

;*---------------------------------------------------------------------*/
;*    *read-line-grammar* ...                                          */
;*---------------------------------------------------------------------*/
(define *read-line-grammar*
   (regular-grammar ()
      ((: (+ all) #\Newline)
       (the-substring 0 (-fx (the-length) 1)))
      ((+ all)
       (the-string))
      (#\Newline
       "")
      (else
       (the-failure))))
 
;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-line . input-port)
   (let ((port (if (pair? input-port)
		   (car input-port)
		   (current-input-port))))
      (read/rp *read-line-grammar* port)))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define *read-of-strings-grammar*
   (regular-grammar ()
      ((+ (in #\space #\tab #\newline))
       (ignore))
      ((+ (out #\space #\tab #\newline))
       (the-string))))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define (read-of-strings . input-port)
   (let ((port (if (pair? input-port)
		   (car input-port)
		   (current-input-port))))
      (read/rp *read-of-strings-grammar* port)))

;*---------------------------------------------------------------------*/
;*    *about-to-read* ...                                              */
;*---------------------------------------------------------------------*/
(define *about-to-read* #unspecified)

