;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/boolean.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 08:34:45 1995                          */
;*    Last change :  Tue Aug 20 08:29:24 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.1. Booleans (page 13, r4)                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_booleans_6_1
   
   (use     (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))
   
   (foreign (macro bool c-boolean? (obj)  "BOOLEANP")
	    (macro bbool btrue            "BTRUE")
	    (macro bbool bfalse           "BFALSE"))
   
   (export  (inline not::bool      ::obj)
	    (inline boolean?::bool ::obj))
   
   (pragma  (not side-effect-free)
	    (c-boolean? (predicate-of bbool) no-cfa-top)
	    (boolean? no-cfa-top side-effect-free)))

;*---------------------------------------------------------------------*/
;*    not ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (not obj)
   (if obj #f #t))

;*---------------------------------------------------------------------*/
;*    boolean? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (boolean? obj)
   (c-boolean? obj))
   
