;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/progn.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 10:07:31 1994                          */
;*    Last change :  Fri Sep 18 17:59:58 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La normalisation des formes `begin'                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __progn
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (normalize-progn <expression>)
	    (normalize-body  <expression>)
	    (replace! p1 p2)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       (let ((res `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
						 (cdr body)
						 body)))
			       (if (null? body)
				   '()
				   (let ((expr (car body)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr) (loop (cdr body)))
					  (cons expr (loop (cdr body))))))))))
	  (cond
	     ((epair? body)
	      (replace! body res))
	     ((epair? (car body))
	      (econs (car res) (cdr res) (cer (car body))))
	     (else
	      res)))))) 

;*---------------------------------------------------------------------*/
;*    normalize-body ...                                               */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    This function behaves as normalize-progn but it uses a different */
;*    strategy for setting location. It does not consider the current  */
;*    location as the prioritary location.                             */
;*---------------------------------------------------------------------*/
(define (normalize-body body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       (let ((res `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
						 (cdr body)
						 body)))
			       (if (null? body)
				   '()
				   (let ((expr (car body)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr) (loop (cdr body)))
					  (cons expr (loop (cdr body))))))))))
	  (cond
	     ((epair? (car body))
	      (econs (car res) (cdr res) (cer (car body))))
	     (else
	      res)))))) 

;*---------------------------------------------------------------------*/
;*    replace! ...                                                     */
;*---------------------------------------------------------------------*/
(define (replace! p1 p2)
   (if (and (pair? p1) (pair? p2) (not (epair? p2)))
       (begin
	  (set-car! p1 (car p2))
	  (set-cdr! p1 (cdr p2))
	  p1)
       p2))

