;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/macro.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 08:59:04 1994                          */
;*    Last change :  Fri Sep 18 18:00:15 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation des macros (de l'interprete et du compilateur).  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __macro
   
   (export  (install-eval-expander     <keyword> <expander>)
	    (install-compiler-expander <keyword> <expander>)
	    (install-expander          <keyword> <expander>)
	    (get-eval-expander         <keyword>)
	    (get-compiler-expander     <keyword>))

   (import  (__error                   "Llib/error.scm")
	    (__hash                    "Llib/hash.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")

	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__evenv                   "Eval/evenv.scm")))

;*---------------------------------------------------------------------*/
;*    macro                                                            */
;*---------------------------------------------------------------------*/
(define-struct macros key eval-expander compiler-expander)

;*---------------------------------------------------------------------*/
;*    La table de hash commune aux deux espaces de macros.             */
;*---------------------------------------------------------------------*/
(define *macro-table*
   (make-hash-table 256
		    ;; la fonction de hashage utilise un petit cache.
		    (let ((old-key #f)
			  (old-num #f))
		       (lambda (x)
			  (if (eq? x old-key)
			      old-num
			      (begin
				 (set! old-key x)
				 (set! old-num
				       (string->0..255 (symbol->string x)))
				 old-num))))
		    macros-key
		    eq?))

;*---------------------------------------------------------------------*/
;*    install-eval-expander ...                                        */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour l'interprete seulement.               */
;*---------------------------------------------------------------------*/
(define (install-eval-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous l'interprete
	  (if (macros-eval-expander macro)
	      (warning "install-eval-expander"
		       "Redefinition of expander -- "
		       keyword))
	  (macros-eval-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    install-compiler-expander ...                                    */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour le compilateur seulement.             */
;*---------------------------------------------------------------------*/
(define (install-compiler-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous le compilo
	  (if (macros-compiler-expander macro)
	      (warning "install-compiler-expander"
		       "Redefinition of expander -- "
		       keyword))
	  (macros-compiler-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    install-expander ...                                             */
;*    -------------------------------------------------------------    */
;*    On installe une macro pour le compilateur *et* l'interprete.     */
;*---------------------------------------------------------------------*/
(define (install-expander keyword expander)
   (cond
      ((not (symbol? keyword))
       (error "install-eval-expander" "Illegal expander keyword" keyword))
      ((not (procedure? expander))
       (error "install-eval-expander" "Illegal expander expander" expander))
      (else
       (let ((macro (get-hash keyword *macro-table*)))
	  (if (not (macros? macro))
	      (begin
		 (set! macro (macros keyword #f #f))
		 (put-hash! macro *macro-table*)))
	  ;; on warn si la macro etait deja definie sous l'interprete
	  (if (macros-eval-expander macro)
	      (warning "install-eval-expander"
		       "Redefinition of expander -- "
		       keyword))
	  ;; on warn si la macro etait deja definie sous le compilo
	  (if (macros-compiler-expander macro)
	      (warning "install-compiler-expander"
		       "Redefinition of expander -- "
		       keyword))
	  ;; on affecte
	  (macros-eval-expander-set! macro expander)
	  (macros-compiler-expander-set! macro expander)))))

;*---------------------------------------------------------------------*/
;*    get-eval-expander ...                                            */
;*    -------------------------------------------------------------    */
;*    On recupere une macro pour l'interprete.                         */
;*---------------------------------------------------------------------*/
(define (get-eval-expander keyword)
   (let ((macro (get-hash keyword *macro-table*)))
      (if (not (macros? macro))
	  #f
	  (macros-eval-expander macro))))

;*---------------------------------------------------------------------*/
;*    get-compiler-expander ...                                        */
;*    -------------------------------------------------------------    */
;*    On recupere une macro pour le compilateur.                       */
;*---------------------------------------------------------------------*/
(define (get-compiler-expander keyword)
   (let ((macro (get-hash keyword *macro-table*)))
      (if (not (macros? macro))
	  #f
	  (macros-compiler-expander macro))))



