;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expd-struct.scm         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 11:48:02 1992                          */
;*    Last change :  Fri Sep 18 17:58:24 1998 (serrano)                */
;*                                                                     */
;*    L'expansion des des define-struct                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_struct
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__match_normalize         "Match/normalize.scm")
	     
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__progn                   "Eval/progn.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (expand-eval-define-struct x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-struct ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-struct x e)
   (match-case x
      ((?- ?name . ?slots)
       (match-define-structure! x)
       (let* ((len        (length slots))
	      (slots-name (map (lambda (s)
				  (match-case s
				     ((?name ?dv)
				      name)
				     ((? symbol?)
				      s)
				     (else
				      (error "define-struct"
					     "Illegal `define-struct' form"
					     x))))
			       slots))
	      (slots-val?  #f)
	      (slots-val   (map (lambda (s)
				   (match-case s
				      ((?- ?dv)
				       (set! slots-val? #t)
				       dv)
				      ((? symbol?)
				       ''())
				      (else
				       (error "define-struct"
					      "Illegal `define-struct' form"
					      x))))
				slots)))
          (cons
           'begin
           (cons
            ;; on genere l'inline make-???
            (e (epairify
		`(define-inline (,(symbol-append 'make- name) . init)
		    ,(if slots-val?
			 `(if (pair? init)
			      (if (not (null? (cdr init)))
				  (error ',(symbol-append 'make- name)
					 "Too many argument provided"
					 init)
				  (make-struct ',name ,len (car init)))
			      (,name ,@slots-val))
			 `(if (pair? init)
			      (if (not (null? (cdr init)))
				  (error ',(symbol-append 'make- name)
					 "Too many argument provided"
					 init)
				  (make-struct ',name ,len (car init)))
			      (make-struct ',name ,len '()))))
		x)
	       e)
            (cons
             (e (epairify
		 `(define-inline (,name ,@slots-name)
		     (let ((new (make-struct ',name ,len '())))
			,@(let loop ((slots slots-name)
				     (res   '()))
			     (if (null? slots)
				 res
				 (loop (cdr slots)
				       (cons `(,(symbol-append name
							       '-
							       (car slots)
							       '-set!)
					       new
					       ,(car slots))
					     res))))
			new))
		 x)
		e)
             (cons
              ;; on genere le predicat STRUCT?
              (e (epairify
		  `(define-inline (,(symbol-append name '?) o)
		      (if (struct? o)
			  (eq? (struct-key o) ',name)
			  #f))
		  x)
                 e)
              ;; on genere les fonctions d'access aux slots
              (let loop ((i     0)
                         (slots slots-name)
                         (res   '((unspecified))))
                 (if (=fx i len)
                     res
                     (let ((pr (car slots)))
                        (loop (+fx i 1)
                              (cdr slots)
                              (cons
                               ;; la lecture
                               (e (epairify
				   `(define-inline
				       (,(symbol-append name '- pr) s)
				       (if (,(symbol-append name '?) s)
					   (struct-ref s ,i)
					   (error
					    "struct-ref:not an instance of"
					    ,(symbol->string name)
					    s)))
				   x)
                                  e)
                               (cons
                                ;; l'ecriture
                                (e (epairify
				    `(define-inline
					(,(symbol-append name '- pr '-set!) s v)
					(if (,(symbol-append name '?) s)
					    (struct-set! s ,i v)
					    (error
					     "struct-set!:not an instance of"
					     ,(symbol->string name)
					     s)))
				    x)
                                   e)
                                res))))))))))))
      (else
       (error "define-struct" "Illegal `define-struct' form" x))))
 
       
;*---------------------------------------------------------------------*/
;*    epairify ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the struct definition was an extended pair (that is if we     */
;*    were tracking the source location of the structure), we          */
;*    propagate inside the generated function, the define-struct       */
;*    location.                                                        */
;*---------------------------------------------------------------------*/
(define (epairify pair epair)
   (if (epair? epair)
       (econs (car pair) (cdr pair) (cer epair))
       pair))
