;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expd-quote.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:53:05 1994                          */
;*    Last change :  Fri Sep 18 18:00:29 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'expansion des formes `',@                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_quote
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
    
   (export  (expand-quote      <expr> <expander>)
	    (quasiquotation    <integer> <expr>)))

;*---------------------------------------------------------------------*/
;*    expand-quote ...                                                 */
;*---------------------------------------------------------------------*/
(define (expand-quote x e)
   (match-case x
      ((?- . (?- . ()))
       x)
      ((?- ?value)
       (cond
	  ((real? value)
	   value)
	  ((integer? value)
	   value)
	  ((string? value)
	   value)
	  ((char? value)
	   value)
	  ((boolean? value)
	   value)
	  ((null? value)
	   x)
	  ((cnst? value)
	   value)
	  (else
	   x)))
      (else
       (error "quote" "Illegal `quote' form" x))))

;*---------------------------------------------------------------------*/
;*    quasiquotation ...                                               */
;*---------------------------------------------------------------------*/
(define (quasiquotation d exp)
    (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	(template d (cadr exp))
	(error "quasiquotation" "illegal form" exp)))

;*---------------------------------------------------------------------*/
;*    template ...                                                     */
;*---------------------------------------------------------------------*/
(define (template d exp)
   (cond ((=fx d 0)
	  exp)
	 ((and (pair? exp) (eq? (car exp) 'unquote))
	  (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	      (if (eq? d 1)
		  (template (-fx d 1) (cadr exp))
		  (list 'list ''unquote (template (-fx d 1) (cadr exp))))
	      (error "unquote" "Illegal form" (cadr exp))))
	 ((vector? exp)
	  (vector-template d exp))
	 ((pair? exp)
	  (list-template d exp))
	 ((null? exp)
	  (list 'quote exp))
	 ((or (char? exp) (integer? exp) (string? exp) (cnst? exp))
	  exp)
	 (else
	  (list 'quote exp))))

;*---------------------------------------------------------------------*/
;*    list-template ...                                                */
;*---------------------------------------------------------------------*/
(define (list-template d exp)
   (cond ((and (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	       (eq? (car exp) 'quote) (pair? (cadr exp))
	       (eq? (car (cadr exp)) 'quasiquote))
	  (quasiquotation d (cadr exp)))
	 ((eq? (car exp) 'quasiquote)
	  (if (eq? d 0)
	      (quasiquotation (+ d 1) exp)
	      (list 'list ''quasiquote (quasiquotation (+ d 1) exp))))
	 (else
	  (if (epair? exp)
	      (let ((er (cer exp)))
		 (econs 'cons* (template-or-splice-list d exp) er))
	      (cons 'cons* (template-or-splice-list d exp))))))

;*---------------------------------------------------------------------*/
;*    vector-template ...                                              */
;*---------------------------------------------------------------------*/
(define (vector-template d exp)
   (let ((tag-val (vector-tag exp))
	 (res-val (list 'list->vector
			(cons 'cons* (template-or-splice-list
				      d
				      (vector->list exp))))))
      (if (=fx tag-val 0)
	  res-val
	  (let ((res-var (gensym)))
	     `(let ((,res-var ,res-val))
		 (vector-tag-set! ,res-var ,tag-val)
		 ,res-var)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice-list ...                                      */
;*---------------------------------------------------------------------*/
(define (template-or-splice-list d exp)
    (cond ((null? exp) '('()))
	  ((pair? exp)
	   (cond ((eq? (car exp) 'unquote)
		  (list (template d exp)))
		 ((and (pair? (car exp)) (eq? (car (car exp))
					      'unquote-splicing))
		  (list (list 'append
			      (template-or-splice d (car exp))
			      (cons 'cons*
				    (template-or-splice-list d (cdr exp))))))
		 (else (cons (template-or-splice d (car exp))
			     (template-or-splice-list d (cdr exp))))))
	  (else (list (template-or-splice d exp)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice ...                                           */
;*---------------------------------------------------------------------*/
(define (template-or-splice d exp)
    (if (and (pair? exp) (eq? (car exp) 'unquote-splicing))
	(if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	    (if (eq? d 1)
		(template (-fx d 1) (cadr exp))
		(list 'list (list 'list ''unquote-splicing
				  (template (-fx d 1) (cadr exp)))))
	    (error "unquote-splicing" "Illegal form" exp))
	(template d exp)))


