;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expd-do.scm             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Sep 28 16:06:31 1992                          */
;*    Last change :  Fri Sep 18 17:57:56 1998 (serrano)                */
;*                                                                     */
;*    La macro `DO'                                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_do
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (expand-do <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    gen-doloop-name ...                                              */
;*---------------------------------------------------------------------*/
(define (gen-doloop-name)
   (gensym "do-loop--"))

;*---------------------------------------------------------------------*/
;*    expand-do ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-do exp e)
   (match-case exp
      ((?- ?bindings ?end . ?command)
       (let* ((let-bindings  bindings)
	      (vars 	   '())
	      (inits 	   '())
	      (steps 	   '())
 	      (loop	    (gen-doloop-name))
	      (test	    (if (pair? end)
		 		(car end)
				(error "do" "Illegal form" exp)))
	      (ending       (if (null? (cdr end))
				(list #f)
				(cdr end)))
	      (body         command))
	  (for-each
	   (lambda (var-init-step)
	      (if (and (>=fx (length var-init-step) 2)
		       (<=fx (length var-init-step) 3))
		  (let* ((var (car var-init-step))
			 (init (cadr var-init-step))
			 (step (if (not (null? (cddr var-init-step)))
				   (car (cddr var-init-step))
				   var)))
		     (set! vars  (cons var vars))
		     (set! steps (cons step steps))
		     (set! inits (cons init inits)))
		  (error 'do "Illegal form:" var-init-step)))
	   (reverse let-bindings))
	  (e `(letrec ((,loop (lambda ,vars
				 (if ,test
				     (begin ,@ending)
				     (begin ,@body
					    (,loop ,@steps))))))
		 (,loop ,@inits))
	     e)))
      (else
       (error 'do "Illegal form" 'exp))))

