;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expanders.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:58:05 1994                          */
;*    Last change :  Tue Nov 24 06:40:05 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'installation des expanseurs                                    */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __install_expanders

   (import  (__error                   "Llib/error.scm")
	    (__macro                   "Eval/macro.scm")
	    (__expander_quote          "Eval/expd-quote.scm")
	    (__expander_let            "Eval/expd-let.scm")
	    (__expander_bool           "Eval/expd-bool.scm")
	    (__expander_case           "Eval/expd-case.scm")
	    (__expander_define         "Eval/expd-define.scm")
	    (__expander_do             "Eval/expd-do.scm")
	    (__expander_try            "Eval/expd-try.scm")
	    (__expander_struct         "Eval/expd-struct.scm")
	    (__eval                    "Eval/eval.scm")
	    (__progn                   "Eval/progn.scm")
	    (__lalr_expand             "Lalr/lalr.scm")
	    (__rgc_expand              "Rgc/rgc-expand.scm")
	    (__match_expand            "Match/mexpand.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__os                      "Llib/os.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__r5_control_features_6_4 "Ieee/control5.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))
	    
   (export  (install-all-expanders!)))

;*---------------------------------------------------------------------*/
;*    expand-test ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-test x e)
   (if *nil*
       (e x e)
       `((lambda (test-aux-for-nil)
	    (if test-aux-for-nil
		(if (null? test-aux-for-nil)
		    #f
		    #t)
		#f))
	 ,(e x e)))) 

;*---------------------------------------------------------------------*/
;*    install-all-expanders! ...                                       */
;*    -------------------------------------------------------------    */
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Pour toutes les macros on definie dans ce module des fermetures  */
;*    pour ne pas avoir de pbm d'ordre d'initialisation.               */
;*---------------------------------------------------------------------*/
(define (install-all-expanders!)

;*---------------------------------------------------------------------*/
;*    Les expanseurs commun a l'interprete et au compilateur           */
;*---------------------------------------------------------------------*/
   ;; quote
   (install-expander 'quote (lambda (x e) (expand-quote x e)))

   ;; quasiquote
   (install-expander 'quasiquote (lambda (x e) (e (quasiquotation 1 x) e)))

   ;; define-macro  
   (install-expander 'define-macro (lambda (x e)
				      (expand-define-macro x e)))

   ;; define-hygien-macro  
   (install-expander 'define-hygien-macro (lambda (x e)
					      (expand-define-hygien-macro x e)))

   ;; define-expander
   (install-expander 'define-expander (lambda (x e)
					 (expand-define-expander x e)))


   ;; or
   (install-expander 'or (lambda (x e) (e (expand-or x) e)))

   ;; and
   (install-expander 'and (lambda (x e) (e (expand-and x) e)))

   ;; cond
   (install-expander 'cond (lambda (x e) (e (expand-cond x) e)))

   ;; do
   (install-expander 'do (lambda (x e) (expand-do x e)))

   ;; try
   (install-expander 'try (lambda (x e) (expand-try x e)))

   ;; match-case
   (install-expander 'match-case (lambda (x e) (e (expand-match-case x) e)))

   ;; match-lambda
   (install-expander 'match-lambda (lambda (x e)
				      (e (expand-match-lambda x) e)))

   ;; define-pattern
   (install-expander 'define-pattern (lambda (x e)
					(e (expand-define-pattern x) e)))

   ;; delay
   (install-expander 'delay (lambda (x e)
			       (match-case x
				  ((?- ?exp)
				   `(make-promise (lambda () ,(e exp e))))
				  (else
				   (error "delay"
					  "Illegal form"
					  x)))))
   ;; regular-grammar
   (install-expander 'regular-grammar expand-regular-grammar)

   ;; string-case
   (install-expander 'string-case expand-string-case)

   ;; lalr-grammar
   (install-expander 'lalr-grammar expand-lalr-grammar)
   
   ;; begin
   (install-expander 'begin (lambda (x e)
			       (match-case x
				  ((?- . ?body)
				   (let loop ((l body))
				      (cond
					 ((null? l)
					  (let ((new `(begin
							 ,@(map
							    (lambda (x)
							       (e x e))
							    body))))
					     (set-car! x (car new))
					     (set-cdr! x (cdr new))
					     x))
					 ((pair? l)
					  (loop (cdr l)))
					 (else
					  (error "begin" "Illegal form" x)))))
				  (else
				   (error "begin"
					  "Illegal form"
					  x)))))

   ;; failure
   (install-expander 'failure (lambda (x e)
				 (match-case x
				    ((?- ?proc ?msg ?obj)
				     `(failure ,(e proc e)
					       ,(e msg e)
					       ,(e obj e)))
				    (else
				     (error "failure"
					    "Illegal `failure' form"
					    x)))))

   ;; bind-exit
   (install-eval-expander 'bind-exit (lambda (x e)
					(match-case x
					   ((?- (?exit) . (and ?body (not ())))
					    `(bind-exit (,exit)
						,(e (normalize-progn body)
						    e)))
					   (else
		    			    (error "bind-exit"
						   "Illegal form"
						   x)))))

   ;; unwind-protect
   (install-eval-expander 'unwind-protect (lambda (x e)
					     (match-case x
						((?- ?body . ?exp)
						 `(unwind-protect
						   ,(e body e)
						   ,@(map (lambda (x)
							     (e x e))
							  exp)))
						(else
						 (error "unwind-protect"
							"Illegal form"
							x)))))

   ;; multiple-value-bind
   (install-expander 'multiple-value-bind
		     (lambda (x e)
			(match-case x
			   ((?- ?vars ?call . ?exprs)
			    (e `(call-with-values (lambda () ,call)
						  (lambda ,vars ,@exprs))
			       e))
			   (else
			    (error "multiple-value-bind"
				   "Illegal form"
				   x)))))
				 
;*---------------------------------------------------------------------*/
;*    Les macros de l'interprete                                       */
;*---------------------------------------------------------------------*/
   ;; module
   (install-eval-expander 'module (lambda (x e) x))

   ;; if
   (install-eval-expander 'if (lambda (x e)
				 (match-case x
				    ((if ?si ?alors ?sinon)
				     `(if ,(expand-test si e)
					  ,(e alors e)
					  ,(e sinon e)))
				    ((if ?si ?alors)
				     `(if ,(expand-test si e)
					  ,(e alors e)
					  #unspecified))
				    (else
				     (error "if" "Illegal form" x)))))
   
   ;; lambda
   (install-eval-expander 'lambda (lambda (x e) (expand-eval-lambda x e)))

   ;; let
   (install-eval-expander 'let (lambda (x e) (expand-eval-let x e)))

   ;; let*
   (install-eval-expander 'let* (lambda (x e) (expand-eval-let* x e)))

   ;; letrec
   (install-eval-expander 'letrec (lambda (x e) (expand-eval-letrec x e)))

   ;; labels
   (install-eval-expander 'labels (lambda (x e) (expand-eval-labels x e)))

   ;; define
   (install-eval-expander 'define (lambda (x e) (expand-eval-define x e)))

   ;; define-inline
   (install-eval-expander 'define-inline (lambda (x e)
					    (expand-eval-define-inline x e)))

   ;; define-struct
   (install-eval-expander 'define-struct (lambda (x e)
					    (expand-eval-define-struct x e)))

   ;; case
   (install-eval-expander 'case (lambda (x e) (expand-eval-case x e))))
