;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expand.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:57:39 1994                          */
;*    Last change :  Fri Sep 18 17:54:09 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La macro expansion de l'interprete                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expand
   
   (import  (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__os                      "Llib/os.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")

	    (__evenv                   "Eval/evenv.scm")
	    (__macro                   "Eval/macro.scm"))

   (export  (expand             <expression>)
	    (expand-once        <expression>)
	    (parse-formal-ident <expression>)))

;*---------------------------------------------------------------------*/
;*    expand ...                                                       */
;*---------------------------------------------------------------------*/
(define (expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    expand-once ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-eval-expander*)
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let ((id (car (parse-formal-ident (car x)))))
		    (let ((b (get-eval-expander id)))
		       (if b
			   b
			   *application-eval-expander*))))
		(else
		 *application-eval-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    *identifier-eval-expander* ...                                   */
;*---------------------------------------------------------------------*/
(define (*identifier-eval-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-eval-expander* ...                                  */
;*---------------------------------------------------------------------*/
(define (*application-eval-expander* x e)
   (let loop ((x x))
      (cond
	 ((null? x)
	  '())
	 ((not (pair? x))
	  (error "application" "Illegal form" x))
	 (else
	  (cons (e (car x) e) (loop (cdr x)))))))

;*---------------------------------------------------------------------*/
;*    parse-formal-ident ...                                           */
;*---------------------------------------------------------------------*/
(define (parse-formal-ident ident)
   (cond
      ((or (eq? ident #!optional)
	   (eq? ident #!rest)
	   (eq? ident #!key))
       (cons (gensym 'dsssl) '()))
      ((and (pair? ident) (symbol? (car ident)))
       (cons ident '()))
      ((not (symbol? ident))
       (error #f "Illegal formal identifier" ident))
      (else
       (let* ((string (symbol->string ident))
	      (len    (string-length string)))
	  (let loop ((walker     0)
		     (id-stop    0)
		     (type-start 0))
	     (cond
		((=fx walker len)
		 (cond
		    ((and (=fx id-stop 0)
			  (>fx type-start 0))
		     ;; this empty name variable can be usefull to declare
		     ;; prototype so it is legal.
		     (cons (string->symbol "")
			   (string->symbol (substring string type-start len))))
		    ((=fx id-stop 0)
		     (cons ident '()))
		    ((=fx type-start len)
		     ;; empty type are eroneous
		     (error #f "Illegal formal identifier" ident))
		    (else
		     (cons (string->symbol
			    (substring string 0 id-stop))
			   (string->symbol
			    (substring string type-start len))))))
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (if (>fx type-start 0)
		     (error #f "Illegal formal identifier" ident)
		     (loop (+fx walker 2)
			   walker
			   (+fx walker 2))))
		(else
		 (loop (+fx walker 1)
		       id-stop
		       type-start))))))))
