;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/evenv.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 28 18:54:38 1994                          */
;*    Last change :  Fri Sep 18 17:59:27 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation de l'environnement global de l'interprete        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evenv
   
   (import  (__r4_symbols_6_4          "Ieee/symbol.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__os                      "Llib/os.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))

   (extern  (macro __evmeaning_address::obj      (::obj)
		   "__EVMEANING_ADDRESS")
	    (macro __evmeaning_address-ref::obj  (::obj)
		   "__EVMEANING_ADDRESS_REF")
	    (macro __evmeaning_address-set!::obj (::obj ::obj)
		   "__EVMEANING_ADDRESS_SET"))
   
   (export  (init-the-global-environment!)
	    (inline eval-global?           exp)
	    (inline eval-global-value      exp)
	    (inline set-eval-global-value! exp exp)
	    (inline eval-global-tag        exp)
	    (inline eval-global-name       exp)
	    (bind-eval-global!             name var)
	    (eval-lookup                   exp)
	    (unbind-primop!                var)
	    (define-primop!                var val)
	    (define-primop-ref!            var addr)))

;*---------------------------------------------------------------------*/
;*    init-the-global-environment! ...                                 */
;*    -------------------------------------------------------------    */
;*    Il faut que cette fonction utilise le symbol `0000'              */
;*    pour etre sur qu'il est definit au moment ou on fait les         */
;*    `define-primop'.                                                 */
;*---------------------------------------------------------------------*/
(define (init-the-global-environment!)
   'nothing)
   
;*---------------------------------------------------------------------*/
;*    bind-eval-global! ...                                            */
;*---------------------------------------------------------------------*/
(define (bind-eval-global! name var)
   (putprop! name '_0000 var))

;*---------------------------------------------------------------------*/
;*    unbind-primop! ...                                               */
;*---------------------------------------------------------------------*/
(define (unbind-primop! name)
   (remprop! name '_0000))

;*---------------------------------------------------------------------*/
;*    define-primop! ...                                               */
;*---------------------------------------------------------------------*/
(define (define-primop! var val)
   (let ((cell (eval-lookup var)))
      (if (not (eval-global? cell))
	  (bind-eval-global! var (vector 0 var val))
	  (set-eval-global-value! cell val))))

;*---------------------------------------------------------------------*/
;*    define-primop-ref! ...                                           */
;*---------------------------------------------------------------------*/
(define (define-primop-ref! var addr)
   (if (not (eval-lookup var))
       (bind-eval-global! var (vector 1 var addr))))

;*---------------------------------------------------------------------*/
;*    eval-lookup ...                                                  */
;*---------------------------------------------------------------------*/
(define (eval-lookup var)
   (let ((prop (getprop var '_0000)))
      (if prop
	  prop
	  #f)))

;*---------------------------------------------------------------------*/
;*    eval-global? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (eval-global? variable)
   (if (vector? variable)
       (=fx (vector-length variable) 3)
       #f))

;*---------------------------------------------------------------------*/
;*    eval-global-tag ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-tag eval-global)
   (vector-ref-ur eval-global 0))

;*---------------------------------------------------------------------*/
;*    eval-global-name ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-name eval-global)
   (vector-ref-ur eval-global 1))

;*---------------------------------------------------------------------*/
;*    eval-global-value ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-value eval-global)
   (vector-ref-ur eval-global 2))

;*---------------------------------------------------------------------*/
;*    set-eval-global-value! ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (set-eval-global-value! eval-global value)
   (vector-set-ur! eval-global 2 value))
