;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/byte-code.sch        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 25 09:12:35 1994                          */
;*    Last change :  Fri Nov  3 09:46:05 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les macros utiles pour la compilation et l'interpretation du     */
;*    byte-code                                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    byte-code? ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (byte-code? exp)
   `(vector? ,exp))

;*---------------------------------------------------------------------*/
;*    make-byte-code ...                                               */
;*---------------------------------------------------------------------*/
(define-macro (make-byte-code code loc value)
   `(vector ,code ,loc ,value))

;*---------------------------------------------------------------------*/
;*    code-of-byte-code ...                                            */
;*---------------------------------------------------------------------*/
(define-macro (code-of-byte-code bcode)
   `(vector-ref ,bcode 0))

;*---------------------------------------------------------------------*/
;*    byte-code-code-set! ...                                          */
;*---------------------------------------------------------------------*/
(define-macro (byte-code-code-set! bcode code)
   `(vector-set! ,bcode 0 ,code))

;*---------------------------------------------------------------------*/
;*    pos-of-byte-code ...                                             */
;*---------------------------------------------------------------------*/
(define-macro (pos-of-byte-code bcode)
   `(vector-ref ,bcode 1))

;*---------------------------------------------------------------------*/
;*    value-of-byte-code ...                                           */
;*---------------------------------------------------------------------*/
(define-macro (value-of-byte-code bcode)
   `(vector-ref ,bcode 2))

;*---------------------------------------------------------------------*/
;*    byte-code-value-set! ...                                         */
;*---------------------------------------------------------------------*/
(define-macro (byte-code-value-set! bcode value)
   `(vector-set! ,bcode 2 ,value))
