/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/trace.c                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Mar 31 18:06:36 1995                          */
/*    Last change :  Sun Nov 29 19:15:00 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    We dump a execution trace                                        */
/*=====================================================================*/
#if( !defined( BIGLOO_DEBUG ) )
#   define BIGLOO_DEBUG
#endif

#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    Globals variables                                                */
/*---------------------------------------------------------------------*/
struct dframe *top_of_frame = 0L;
struct dframe frame;

/*---------------------------------------------------------------------*/
/*    dump_trace_stack ...                                             */
/*---------------------------------------------------------------------*/
obj_t
dump_trace_stack( obj_t port, long depth )
{
   long           level = 0L;
   struct dframe *runner = top_of_frame;
   obj_t          old = 0;
   int            recursion = 0;

   while( (level < depth) && runner && (runner != &frame) )
   {
      if( SYMBOLP( runner->symbol ) )
      {
	 if( EQP( runner->symbol, old ) )
	    recursion++, depth++;
	 else
	 {
	    if( recursion > 0 )
	       fprintf( OUTPUT_PORT( port ).file,
			" (%d times)\n",
			1 + recursion );
	    else
	    {
	       if( level > 0 )
		  fprintf( OUTPUT_PORT( port ).file, "\n" );
	    }
	    
	    fprintf( OUTPUT_PORT( port ).file,
		     "  %3ld. %s",
		     level,
		     BSTRING_TO_STRING( SYMBOL( runner->symbol ).string ) );
	    
	    recursion = 0;
	 }
	 old = runner->symbol;
			
	 level++; 
      }
      
      runner = runner->link;
   }
   fprintf( OUTPUT_PORT( port ).file, "\n" );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    cref ...                                                         */
/*---------------------------------------------------------------------*/
obj_t
cref( obj )
obj_t obj;
{
   return CREF( obj );
}

/*---------------------------------------------------------------------*/
/*    car ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
car( obj_t obj )
{
   return CAR( obj );
}

/*---------------------------------------------------------------------*/
/*    cdr ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
cdr( obj_t obj )
{
   return CDR( obj );
}

/*---------------------------------------------------------------------*/
/*    byteshow ...                                                     */
/*---------------------------------------------------------------------*/
static void
byteshow( unsigned char *addr )
{
#define PP_CHAR( c ) (((c) >= 33) && ((c) < 127)) ? c : '.'

   printf( "  %08x  :  %02x %02x %02x %02x  :  %c%c%c%c\n",
           (unsigned long)addr,
           addr[ 0 ],
           addr[ 1 ],
           addr[ 2 ],
           addr[ 3 ],
           PP_CHAR( addr[ 0 ] ),
           PP_CHAR( addr[ 1 ] ),
           PP_CHAR( addr[ 2 ] ),
           PP_CHAR( addr[ 3 ] ) );
}
             
/*---------------------------------------------------------------------*/
/*    memshow ...                                                      */
/*---------------------------------------------------------------------*/
void
memshow( char *from, char *to, long step )
{
   char *i;

   step *= 4;
      
   if( from > to )
      for( i = from; i > to; i -= step )
         byteshow( i );
   else
      for( i = from; i < to; i += step )
         byteshow( i );

   puts( "" );
   return ;
}
