/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/main.c                  */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:40:49 1992                          */
/*    Last change :  Tue Jun 30 12:56:52 1998 (serrano)                */
/*                                                                     */
/*    Le fichier de main de toute application. Comme je m'y prends     */
/*    plus intelligement que dans la version 0.8 (si, si :-), je       */
/*    peux compiler une fois pour toute ce fichier. Je ne suis plus    */
/*    oblige de le construire et le compiler pour chaque application.  */
/*---------------------------------------------------------------------*/
#include <bigloo2.0a.h>
#if( (defined( sun ) && !defined( __svr4__) && !defined( __SVR4 )) \
     || defined( sony_news ) )
#   include <machine/vmparam.h>
#else
#   if( defined( sun ) && (defined( __svr4__ ) || defined( __SVR4 )) )
#      include <sys/vmparam.h>
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Heap handling                                                    */
/*---------------------------------------------------------------------*/
#define MegToByte(x) ((x) * (1024 * 1024))
#define MegToKilo(x) ((x) * 1024)
#define MegTo4K(x)   ((x) * (1024 >> 2))

#define DEFAULT_HEAP_SIZE 4

/* The initial heap size (in mega byte) */
long heap_size = DEFAULT_HEAP_SIZE;

/*---------------------------------------------------------------------*/
/*    Des recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern void cref();
extern void memshow();
extern char *getenv();
extern void init_eval_cnst();
extern obj_t c_constant_string_to_string();
extern obj_t c_error();
extern void init_objects();
extern int bigloo_main();

/*---------------------------------------------------------------------*/
/*    Une variable pour memoriser le bas de la pile                    */
/*---------------------------------------------------------------------*/
char *stack_bottom;
long  glob_dummy;

obj_t command_line    = 0L;
char *executable_name = 0L;

/*---------------------------------------------------------------------*/
/*    bigloo_exit ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
bigloo_exit( obj_t val )
{
   FREE_ALLOCATION();
   exit( (long)INTEGERP( val ) ? (long)CINT( val ) : 0 );
}

/*---------------------------------------------------------------------*/
/*    bigloo_main ...                                                  */
/*    -------------------------------------------------------------    */
/*    Le vrai point d'entree d'une application `bigloo'. La fonction   */
/*    `main' qui est cree par le compilo ne sert a rien. Elle existe   */
/*    uniquement car je ne suis pas que tous les compilos supporte que */
/*    la fonction C `main' soit mise en librairie. Comme ca, je suis   */
/*    tranquile.                                                       */
/*---------------------------------------------------------------------*/
int
_bigloo_main( int argc, char *argv[] )
{
   long  mega_size;
   char *env_size;
   obj_t cons;
   long  i;

   /* on memorise l'adresse du bas de la pile */
   stack_bottom = (char *)&argc;
   
   /* on initialise le tas */
   if( !(env_size = getenv( "BIGLOOHEAP" )) )
      mega_size = heap_size;
   else
      mega_size = atoi( env_size );

#if( (THE_GC == BOEHM_GC) &&                                     \
     ( (!defined( BOEHM_GC_VERSION)) ||                          \
       (BOEHM_GC_VERSION == 2)       ||                          \
       (BOEHM_GC_VERSION == 3) ) )
   heap_size = MegTo4K( mega_size );
#else
   heap_size = MegToByte( mega_size );
#endif

   if( !INIT_ALLOCATION( heap_size ) )
   {
      char mes[ 600 ];

      sprintf( mes, "%ld Meg wanted", heap_size / (1024 * 1024) );
      c_error( "Can't allocate heap", mes, -10 );
   }
   else
   {
      /* on initialise les objects pre-alloues (les chars, bool, ...) */
      init_objects();

      /* on initialise les constantes du fichier `Clib/eval.c' */
      init_eval_cnst();
	 
      /* on construit la liste des argv */
      for( i = argc - 1, cons = BNIL; i >= 0; i-- )
         cons = MAKE_PAIR( c_constant_string_to_string( argv[ i ] ), cons );

      /* on sauve le nom de l'executable */
      executable_name = argv[ 0 ];
      
      /* on met a jour la variable `command-line' */
      command_line = cons;
		 
      /* on appelle le main de l'utilisateur */
      bigloo_main( cons );
   }

   return 0;
}


