/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/inline-alloc.c          */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Sat Dec 26 09:40:35 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/
#ifndef GC_PRIVATE_H
#  include <gc_private.h>
#endif
#undef abs

#include <bigloo2.0a.h>

#if( THE_GC == BOEHM_GC )
#   define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
#   define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )

/*---------------------------------------------------------------------*/
/*    alloc_make_pair ...                                              */
/*---------------------------------------------------------------------*/
static obj_t 
alloc_make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;

   pair = (obj_t)GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );


#if( !defined( TAG_PAIR ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car    = car;
   pair->pair_t.cdr    = cdr;
   
   return BPAIR( pair );
}   

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
   

   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_pair( car, cdr );
   }
   else
   {
      *opp = obj_link( op );
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();

      pair = (obj_t)op;

#if( !defined( TAG_PAIR ) )
      pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
      pair->pair_t.car    = car;
      pair->pair_t.cdr    = cdr;
   
      return BPAIR( pair );
   }
}

/*---------------------------------------------------------------------*/
/*    alloc_make_real ...                                              */
/*---------------------------------------------------------------------*/
static obj_t
alloc_make_real( double d )
{
   obj_t real;

   real = (obj_t)GC_generic_malloc_words_small(NUMBER_OF_FLOAT_WORDS, PTRFREE);
   
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   real->real_t.real   = d;

   return BREAL( real );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double d )
{
   obj_t real;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;

   opp =  &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_real( d );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();

      real = (obj_t)op;

#if( !defined( TAG_REAL ) )
      real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
      real->real_t.real   = d;

      return BREAL( real );
   }
}

#else

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double real )
{
   obj_t a_real;

   a_real = GC_MALLOC_ATOMIC( REAL_SIZE );
	
#if( !defined( TAG_REAL ) )
   a_real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   a_real->real_t.real = real;
	
   return BREAL( a_real );
}
#endif

