/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime/Clib/init-obj.c              */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:00:08 1992                          */
/*    Last change :  Fri Mar 20 09:11:42 1998 (serrano)                */
/*                                                                     */
/*    On initialise les objects vitaux                                 */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t  an_object, a_pair;

obj_t  quote;
obj_t *c_allocated_char;
obj_t  _exit_value_;

/*---------------------------------------------------------------------*/
/*    Importatations                                                   */
/*---------------------------------------------------------------------*/
extern obj_t string_to_obj();
extern obj_t string_to_symbol();

extern void init_symbol_table();
extern void init_keyword_table();
extern void init_io();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
void init_objects()
{
   /* l'initialisation des ports d'entree/sortie */
   init_io();

   /* l'initialisation des symbols */
   init_symbol_table();

   /* the dsssl keywords initialization */
   init_keyword_table();

   /* l'initialisation du symbol QUOTE (voir apply.c) */
   quote = string_to_symbol( "QUOTE" );
}
