/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/vector.c             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon May  8 14:16:24 1995                          */
/*    Last change :  Thu Jul 18 12:00:29 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    C vector managment                                               */
/*=====================================================================*/
#include <bigloo2.0a.h>

extern obj_t string_to_bstring();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    fill_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
fill_vector( bvector, len, init )
obj_t  bvector;
long   len;
obj_t  init;
{
   obj_t *walker;

   /* on fait la `strength reduction' a la main car ce code est  */
   /* critique donc on veut etre sur qu'il bombarde.             */
   for( walker = (obj_t *)(&VECTOR_REF( bvector, 0 )); len; len-- )
      *walker++ = init;

   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    create_vector ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_vector( len )
long len;
{
   obj_t vector;

   if( len & ~(VECTOR_LENGTH_MASK) )
      FAILURE( string_to_bstring( "create_vector" ),
	       string_to_bstring( "vector too large" ),
	       BINT( len ) );
   else
   {
      long byte_size;

      byte_size = VECTOR_SIZE + ( (len-1) * OBJ_SIZE );

      vector = GC_MALLOC( byte_size );

#if( !defined( TAG_VECTOR ) )
      vector->vector_t.header = MAKE_HEADER( VECTOR_TYPE, byte_size );
#endif		
      vector->vector_t.length = len;

      return BVECTOR( vector );
   }
}

/*---------------------------------------------------------------------*/
/*    make_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_vector( len, init )
long   len;
obj_t  init;
{
   obj_t vector;

   vector = BVECTOR( create_vector( len ) );
   fill_vector( vector, len, init );
	
   return vector;
}



