/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cstruct.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun 16 09:28:53 1992                          */
/*    Last change :  Fri Oct  2 09:43:18 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Structures constructions.                                        */
/*=====================================================================*/
#include <bigloo2.0a.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    set_struct ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
set_struct( obj_t heap, obj_t key, long len )
{
   obj_t structure = (obj_t)heap;
   
#if( !defined( TAG_STRUCTURE ) )
   structure->struct_t.header = MAKE_HEADER( STRUCT_TYPE, byte_size );
#endif	

   structure->struct_t.key    = key;
   structure->struct_t.length = len;
   
   return BSTRUCTURE( structure );
}
   
/*---------------------------------------------------------------------*/
/*    create_struct ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_struct( key, len )
obj_t key;
long  len;
{
   long  byte_size = STRUCT_SIZE + ( (len-1) * OBJ_SIZE );
   
   return set_struct( (obj_t)GC_MALLOC( byte_size ), key, len );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    fill_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
fill_struct( obj_t structure, long len, obj_t init )
{
   long i;
   
   for( i = 0; i < len; i++ )
      STRUCT_SET( structure, i, init );

   return structure;
}

/*---------------------------------------------------------------------*/
/*    make_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_struct( key, len, init )
obj_t key;
long  len;
obj_t init;
{
   obj_t structure;

   structure = create_struct( key, len );
   fill_struct( structure, len, init );
   
   return structure;
}

